package MOJO::Log::Clickthrough; 

use strict; 


use lib '../';
use MOJO::Config;
use MOJO::Guts;

use Fcntl qw(LOCK_SH);


sub new {

	my $class = shift;
	my $self = {};			
	bless $self, $class;

	$self->{list} = shift;
	$self->{is_redirect_on} = $self->redirect_config_test; 	
	
	return $self;
};





sub redirect_config_test { 
	my $self = shift; 	
	
	return 0 if (!$self->{list}) || ($self->{list} eq ""); 
	return 0 unless MOJO::Guts::check_if_list_exists(-List => $self->{list}) >= 1;
	
	my %list_info = MOJO::Guts::open_database(-List => $self->{list});
	
	return 0 if $list_info{clickthrough_tracking} != 1;
	return 1;
}





sub r_log { 
	my ($self, $mid, $url) = @_;
	if($self->{is_redirect_on} == 1){ 
	    chmod($FILE_CHMOD, $LOGS.'/'.$self->{list} . '-clickthrough.log'); 
		open(LOG, ">>$LOGS".'/'.$self->{list} . '-clickthrough.log') or warn $!;
		flock(LOG, LOCK_SH);
		print LOG scalar(localtime()) . "\t" . $mid . "\t" . $url . "\n";
		close (LOG);
		return 1; 
	}else{ 
		return 0;
	}
}



sub report_by_message_index { 
	my $self   = shift; 
	my $report = {}; 
	my $l;
	
	my %list_info = MOJO::Guts::open_database(-List => $self->{list});
	
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		my ($t, $mid, $url) = split("\t", $l); 
	    $report->{$mid}->{count}++;		
	}
	close(LOG); 
	require MOJO::Archive; 
	my $mja = MOJO::Archive->new(-List => \%list_info); 
	foreach(sort keys %$report){ 
		$report->{$_}->{message_subject} = $mja->get_archive_subject($_) || $_;
	}
	
	use Data::Dumper;
	warn Dumper($report);
	return $report; 
	
}



sub report_by_message { 
	my $self      = shift; 
	my $match_mid = shift; 
	
	my $report = {}; 
	my $l;
	my %list_info = MOJO::Guts::open_database(-List => $self->{list});
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		my ($t, $mid, $url) = split("\t", $l); 
		if($match_mid == $mid){ 
			$report->{$url}->{count}++;
		}
	}
	close(LOG); 
	return $report; 
}





sub report_by_url { 
	my $self      = shift; 
	my $match_mid = shift; 
	my $match_url = shift;
	
	my $report = []; 
	my $l;
	my %list_info = MOJO::Guts::open_database(-List => $self->{list});
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		my ($t, $mid, $url) = split("\t", $l); 
		if(($match_mid == $mid) && ($match_url eq $url)){ 
			push(@$report, $t);
		}
	}
	close(LOG); 
	return $report; 
}


sub print_raw_logs { 
	my $self = shift; 
	my $l; 
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		print $l . "\n";
	}
}



sub clickthrough_log_location { 
	my $self = shift; 
	return $LOGS . '/' . $self->{list} . '-clickthrough.log';
}



1;