=pod

=head1 NAME Config.pm 

=head1 DESCRIPTION 

Hello! Welcome to the Mojo Mail Config.pm File! Here, you'll be 
able to set up your entire mailing list system quickly and easily. 

Please look at the end of this file for copyright, license and
general information. Donations are always welcome.

Follow the instructions closely and this process should be pretty 
easy. A few things before we get started. This is a Perl program, 
so it follows certain programming  conventions. You just  can't 
put anything in this file and expect it to  work. First off: The
'#' (pound character) is used for commenting, any line starting 
with this  character is used to write  notes and  comments. It 
won't be seen to Perl as code and it is  safe to write whatever 
you want with, like this: 

	# This is a comment. yeee ha. 

Also, this file has documentation embedded in itself; if you're 
looking at this sentence in anything other than the Congig.pm file
itself, the documentation has been extracted and saved somewhere else. 
That's cool, just trust us. The documentation is called POD and 
looks like this: 

	=pod 
	
	I am pod and I am, OK
	
	=cut

Exciting stuff, we know

Lastly, words that start with a '$' (dollar sign) are variables, 
They're  Perl code that stand for something else. You'll need to 
change some variables (only 4) in this file to make Mojo Mail
work correctly. This will be the only file you'll need to change
out of the  whole bunch. To set up Mojo Mail,follow the  
instructions  exactly. This file is HEAVILY commented to help you 
along your way, be sure to  read all the notes! :)  Scroll down 
about 5  lines  until you see  the next group of comments to start 
setting up Mojo Mail. 

=cut

package MOJO::Config; 
require Exporter;  

@ISA = qw(Exporter); 

@EXPORT = qw($VER $MOJO_ROOT_PASSWORD $MAILPROG $FILES $MOJO_URL  $MAIL_SETTINGS $FIRST_SUB $SEC_SUB @C $SALT $FILE_CHMOD $MAKE_ALL_LIST_FILES  $FOOTER $HTML_FOOTER  $DEFAULT_LIST $SUBSCRIBED_MESSAGE $UNSUBSCRIBED_MESSAGE  $CONFIRMATION_MESSAGE  $HTML_CONFIRMATION_MESSAGE 
$HTML_UNSUB_CONFIRMATION_MESSAGE $HTML_SUBSCRIBED_MESSAGE $HTML_UNSUBSCRIBED_MESSAGE $ARCHIVES  $TEMPLATES $TMP $LOGS $SUBSCRIPTION_SUCCESSFUL_COPY $MAILlING_LIST_MESSAGE $MAILlING_LIST_MESSAGE_HTML $ADMIN_MENU $NOT_ALLOWED_TO_POST_MESSAGE $PIN_WORD $PIN_NUM @DOMAINS %SERVICES $SHOW_DOMAIN_TABLE $SHOW_SERVICES_TABLE $SHOW_EMAIL_LIST $GOOD_JOB_MESSAGE  $NO_ONE_SUBSCRIBED  $ALLOW_ROOT_LOGIN $SMTP_ADDRESS $SMTP_ERROR_LOG $SMTP_TRUSTING $UNSUB_CONFIRMATION_MESSAGE 
$DEFAULT_SUBMIT_STYLE %STYLE @CHARSETS @PRECEDENCES @CONTENT_TYPES %LIST_SETUP_DEFAULTS %LIST_SETUP_OVERRIDES @SERVICES $MOJO_SEND_PATH %PRIORITIES $ATTACHMENT_TEMPFILE %MIME_TYPES $DEFAULT_MIME_TYPE $TEXT_INVITE_MESSAGE $HTML_INVITE_MESSAGE $MIME_PARANOID $MIME_HUSH $NPH $MOJO_LOG $ROOT_PASS_IS_ENCRYPTED @ALLOWED_IP_ADDRESSES $SHOW_ADMIN_LINK %LOG $ADMIN_MENU $EMAIL_CASE @EMAIL_EXCEPTIONS  $LIST_IN_ORDER $ADMIN_TEMPLATE $USER_TEMPLATE $DB_TYPE %SQL_PARAMS $MOJO_ERROR_LOG $SHOW_HELP_LINKS $PROGRAM_NAME $FORK_SMTP_BULK_MAILINGS $PLAIN_TEXT_ENCODING $MOJO_CONFIG_FILE_DIR $OS $DEFAULT_ADMIN_SCREEN);
 
use vars qw(@EXPORT  $VER $MOJO_ROOT_PASSWORD $MAILPROG $FILES $MOJO_URL $MAIL_SETTINGS $FIRST_SUB $SEC_SUB @C $SALT $FILE_CHMOD $MAKE_ALL_LIST_FILES  $FOOTER $HTML_FOOTER  $DEFAULT_LIST $SUBSCRIBED_MESSAGE $UNSUBSCRIBED_MESSAGE  $CONFIRMATION_MESSAGE  $HTML_CONFIRMATION_MESSAGE 
$HTML_UNSUB_CONFIRMATION_MESSAGE $HTML_SUBSCRIBED_MESSAGE $HTML_UNSUBSCRIBED_MESSAGE $ARCHIVES  $TEMPLATES $TMP $LOGS $SUBSCRIPTION_SUCCESSFUL_COPY $MAILlING_LIST_MESSAGE $MAILlING_LIST_MESSAGE_HTML $ADMIN_MENU $NOT_ALLOWED_TO_POST_MESSAGE $PIN_WORD $PIN_NUM @DOMAINS %SERVICES $SHOW_DOMAIN_TABLE $SHOW_SERVICES_TABLE $SHOW_EMAIL_LIST $GOOD_JOB_MESSAGE  $NO_ONE_SUBSCRIBED  $ALLOW_ROOT_LOGIN $SMTP_ADDRESS $SMTP_ERROR_LOG $SMTP_TRUSTING $UNSUB_CONFIRMATION_MESSAGE 
$DEFAULT_SUBMIT_STYLE %STYLE  @CHARSETS @PRECEDENCES @CONTENT_TYPES %LIST_SETUP_DEFAULTS %LIST_SETUP_OVERRIDES @SERVICES $MOJO_SEND_PATH %PRIORITIES $ATTACHMENT_TEMPFILE %MIME_TYPES $DEFAULT_MIME_TYPE $TEXT_INVITE_MESSAGE $HTML_INVITE_MESSAGE $MIME_PARANOID $MIME_HUSH $NPH $MOJO_LOG $ROOT_PASS_IS_ENCRYPTED @ALLOWED_IP_ADDRESSES $SHOW_ADMIN_LINK %LOG $ADMIN_MENU $EMAIL_CASE @EMAIL_EXCEPTIONS $LIST_IN_ORDER $ADMIN_TEMPLATE $USER_TEMPLATE $DB_TYPE %SQL_PARAMS $MOJO_ERROR_LOG $SHOW_HELP_LINKS $PROGRAM_NAME $FORK_SMTP_BULK_MAILINGS $PLAIN_TEXT_ENCODING $MOJO_CONFIG_FILE_DIR $OS $DEFAULT_ADMIN_SCREEN); 
 
use strict; 
 
 
=pod

=head1 Mojo Mail Set Up Instructions

You'll need to change 4 variables to get Mojo Mail up and
running. We've numbered them and provided help on the way, so let's 
start! People who are upgrading from previous versions will be able 
to use most of the same variable values as they've done before. 


=head2 $MOJO_ROOT_PASSWORD

(1. Make a Mojo Mail Root Password. This is used to Create New Lists
Tip -> make this somewhat obscure, and do not use "mojo" or "root_password" 
or "god" or "money" or "mail" 

=cut

$MOJO_ROOT_PASSWORD = 'root_password';

=pod

Tip -> comment the above line like this:

	#$MOJO_ROOT_PASSWORD = 'root_password';

to totally disable new list creations. If you're not going to create 
new lists for a while, we suggest you comment that line, for security 
reasons. 


=head2 $FILES

(2. What is the Absolute Path the lists going to be stored in? 
Its a good idea to store this information somewhere 
OTHER than under your public_html  directory, to gaurantee that no 
list information can be seen via a web browser. You may have to 
chmod 777 this directory, or your cgi script 
won't be able to write new files to it. 777 is very open to outside
 eyes, if you can, always set this to the minimum permission needed! 

=cut

$FILES = '/home/youraccount/mojo_files';

=pod

=head2 $MAILPROG

(3. What is the Absolute Path of your mail program?
(type in "which sendmail" in a telnet session
if you don't have sendmail, this script will still work great,
You may  have to fiddle around with the "$MAIL_SETTINGS"
variable under the "additional settings, after the first four 
variables. Mojo Mail uses a Mail Program like Sendmail or Qmail to
send its messages and it needs to know where the Mail Program is 
to be able to use it. 

=cut

$MAILPROG = '/usr/lib/sendmail';  
 
=pod

=head2 $MOJO_URL

4. What is the URL  of the mojo.cgi script? 
This is the address of the mojo.cgi script, (not this file!) 
so when you're all done setting up the script, you'll have to go 
here to  make your first list. 

=cut

$MOJO_URL ='http://www.changetoyoursite.com/cgi-bin/mojo/mojo.cgi';

=pod

That's it, You're done! It's recommended that you set up at least 
one list to see if everything is working correctly and then fix 
(if any) problems  that you find. All other variables either don't 
need to be changed, or are advanced settings. Your error log is a 
great place to start figuring out  what went wrong. If you don't 
have access to an error log, scroll through this file to see how to
 create an error log just for Mojo Mail

Here's a check-off list to make sure you've installed everything 
correctly, this list is somewhat long and exhaustive, as it covers 
most  frequently asked questions that can be fixed in this file. 

=over

=item *

If you are upgrading from Mojo 2.x, it's well advised that you 
first test this version in a different directory and see if its
working. Lists made with previous versions of Mojo 2.x will 
work with this version and lists generated using this version 
will also be compatible with any previous 2.x versions. 

=item *

Upload the mojo.cgi script _and_ the MOJO folder (both as text,
NOT binary). If you are upgrading from a previous version of 
Mojo Mail 2.x, you'll need to replace the  entire MOJO folder. 
Make sure you upload everything that's in MOJO folder, even the
Mail and MIME folders

=item *

chmod 755 the mojo.cgi script. Nothing needs to be changed 
permissions-wise in the MOJO folder. Make sure you save the 
Config.pm file (this file!) and make sure that you put it back 
in the MOJO folder. 

=item *

Run Mojo Mail by going to the URL that you put in the 
'$MOJO_URL' variable. If you don't see anything, or get a 404, 
you're probably using the wrong address. Some hosting services
put the cgi-bin in a weird spot and you'll need a special 
address. 

=item *

If, when making a new list, everything seems to work but Mojo 
Mail isn't saving any information, make sure that there exists
a directory you've specified in the '$FILES' variable, and make
sure you can write to that directory. You may need to chmod 777
that directory. Usually setting this variable to be somewhere 
in your cgi-bin is  NOT A GOOD IDEA.  Sometimes you cannot 
write files into your cgi-bin anyways.      

=item *

If everything is working well except no mail is being sent, 
(not a good thing for a Mailing List Program!) you may have to
fiddle with the $MAIL_SETTINGS variable, located farther down
this file or make sure that you have the correct address in the
$MAILPROG variable.


=item *

All other variables below don't need to be changed to have 
Mojo Mail run incredibly. They're provided to allow you to 
tweak the program to your liking. We tried to make the program
a breeze to set up and to also make it customizable. Not an 
easy task. 

=back

Check out the support section on the Mojo Mail website: 

http://mojo.skazat.com/support 

If you have any more questions

B<One last note:> 

Always Always Always set up a test list. Mailing List Managers are 
almost always in a critical state, since who knows  how many 
thousands of people are interacting with your lists. Will this 
sending option work well? at all? Test. Test. Test. Test. You may 
want to read this entire file to get familiar with what Mojo Mail
does. Actually no. I really want you to read this entire file to 
get familiar with MOJO Mail. It may take you a minute, but it will 
save you time in the future. 

B<Another Last Note:>

This file is going to be your best friend. It's choke full of 
information, advice and ideas. Use it!

=cut




=pod

=head1 Additional Settings You may want/need to change.

It's well advised that you get familiar with this program and
go through it ENTIRELY before you change any of the below settings, 
From this point, it helps if you have some kind of Unix/Perl 
background, Or you've used previous versions of the script. 

=cut

$MOJO_CONFIG_FILE_DIR;

=head2 $DEFAULT_LIST

B<Set a Default List>

You can make Mojo Mail look like one of your lists if you change that 
list's Template.  This will transform Mojo Mail from its default look 
to practically anything you want!
Keep this variable blank if you don't want this to happen. At this 
point, only the actual look is used for a default. 

=cut

#------------------
#leave this alone | 
 _config_import();
#------------------

	$DEFAULT_LIST ||= ""; 



# (take the default list and replace spaces with underscores, 
# since, when looking for the list, we want to  look for the filename
# its  saved under)
$DEFAULT_LIST =~ s/ /_/g; # don't edit this

=pod

=head2 $DB_TYPE

B<$DB_TYPE> specifies what database you'd like to be using. The plain as 
grain one to use is 'PlainText', although others may be available and
you may be so inclined to make your own. B<MySQL> and B<PostgreSQL> should be 
included in the standard installation.

=cut

$DB_TYPE ||= 'PlainText'; 

=head2 %SQL_PARAMS

B<%SQL_PARAMS> are parameters passed to the SQL server. You need to fill these out
if you're using either MySQL or PostgreSQL (You also need to make a table for Mojo Mail 
to work with, explained later). They are as follows: 

=over

=item database

The name of the database you are using

=item dbserver 

The name of the database server itself. Example: I<sql.mydomain.com>

=item port 

The port that is used when connecting to the database server. You usually
only needs this for Postgres.

=item dbtype

set dbtype to 'mysql' for MySQL usage, 'Pg' for Postgres.

=item user

The SQL username

=item pass 

The SQL password

=back

Before trying to install Mojo Mail with an SQL backend, make sure you 
create the appropriate table. For MySQL users, make the table using this:

 CREATE TABLE mojo_subscribers (
 email_id					     int4 not null primary key auto_increment,
 email                            text,
 list                             text,
 list_type                        text,
 list_status                      char(1)
 ); 

For Postgres, use this: 

 CREATE TABLE mojo_subscribers (
 email_id                         serial,
 email                            text,
 list                             text,
 list_type                        text,
 list_status                      char(1)
 );


=cut

%SQL_PARAMS = ( 
database   => '',
dbserver   => '',   	   
port       => '',    	   
dbtype     => '',      
user       => '',          
pass       => '',
) unless keys %SQL_PARAMS; 


=pod

=head2 Security 

This section deals with Mojo Mail and security - both to tighten it
up, and lax it down. Depending on what you want to allow and what 
you can do. 

=over

=item $SHOW_ADMIN_LINK

Set $SHOW_ADMIN_LINK tp '0' to take off the 'Administration' link
that you see on the Mojo Mail default page. You can always get to 
the administration page by pointing your browser to an address 
like this: 

	http://mysite.com/cgi-bin/mojo/mojo.cgi?f=admin

This is a small security measure but may just stop people from 
snooping further. 

=cut

$SHOW_ADMIN_LINK ||= 1;

=pod

=item $ALLOW_ROOT_LOGIN

B<Allow the Root Password to Log in to ALL Lists>

Set the '$ALLOW_ROOT_LOGIN' variable to '1' to allow the Mojo Root
Administrator to use  the mojo root password to log into any list. 
This is handy when you have many many lists and need to tweak them 
but don't want to keep  track off all the list passwords. Setting 
this variable to 1 does make your lists less secure, as every list 
can be accessed with the same  password and that password is 
written plainly in this file, unless! you encrypt it (see below)

=cut

$ALLOW_ROOT_LOGIN ||= 1; 

=pod

=item $ROOT_PASS_IS_ENCRYPTED

You can store an encrypted version of the $MOJO_ROOT_PASSWORD, 
instead of the plain text version and here are the steps.

=over

=item 1

set up Mojo Mail so it's working, usually this means setting up 
the first four variables. 

=item 2

point your browser to wherever you have the mojo script at, and 
at the end of the url, append this: ?f=pass_gen so you'll have 
something that looks like this: 

	http://yoursite.com/cgi-bin/mojo/mojo.cgi?f=pass_gen

=item 3

You'll see a page in your browser that asks for a password to 
encrypt, type in the password you want to use, and press 'encrypt' 
An encrypted password will be outputted. 

=item 4

Copy that encrypted password and use it as the root password. 

=item 5

Set $ROOT_PASS_IS_ENCRYPTED (below) to '1';

=cut

$ROOT_PASS_IS_ENCRYPTED ||= 0;

=pod

=item 6 

=back 

eat a mango. they're REALLY good.

=item @ALLOWED_IP_ADDRESSES

You can block anyone from using any list control panel by 
specifying exactly what IP addresses are allowed. Leave the 
@ALLOWED_IP_ADDRESSES  blank - 

	@ALLOWED_IP_ADDRESSES = qw(); 

To disable this security measure. 
To add an address, just list it, like this: 
	
	@ALLOWED_IP_ADDRESSES = qw(123.456.67.678 
	                           215.234.56.9 
	                           783.456.9.2);

=cut

@ALLOWED_IP_ADDRESSES = qw() 
	unless scalar @ALLOWED_IP_ADDRESSES;

=pod

Please note that crafty people can spoof what IP address they're 
coming from and dial up accounts and connections using DHCP may
not have the same IP address per session.  

=back 

=head2 SMTP Sending

You can send email using an SMTP server instead of the sendmail 
program. If you can, we suggest you do. Mojo Mail uses the 
amazing Mail::Bulkmail module to do all SMTP sending. 

=over

=item $SMTP_ADDRESS

B<Specify a SMTP server address>

You MUST give a valid smtp  address,  and then select "send through 
smtp in the "Sending Options" of each list's control panel. We 
STRONGLY encourage you to use a SMTP server for big heafty lists. 
The best setting for big lists   is using an smtp server and *NOT* 
(I said not) using batches.  batches are used so you don't destroy 
sendmail with 1,000,000 emails  at once, but Mojo used the 
Mail::Bulkmail, which is lightning fast. 

=cut

$SMTP_ADDRESS ||= undef;

=pod

=item $SMTP_ERROR_LOG

SMTP can be a bit more tricky than regular mailings, you can 
specify an error log just for SMTP mailings. 

=cut

$SMTP_ERROR_LOG ||= '';

=pod

(from Mail::Bulkmail) - By default, Mail::Bulkmail will only 
allow  you to use valid e-mail, valid dates, valid timezones, and 
valid  precedences. Turn it on by setting it (in this case 
$SMTP_TRUSTING) to some non-zero value.  This will bypass all error
checking.  You should probabaly just leave  it off so you can check
for valid e-mails, dates, etc. note: this only refers to SMTP 
sending,  not the rest of Mojo Mail. We just thought you'd like the
option. 

=cut

$SMTP_TRUSTING ||= 1; 

=pod

=item $FORK_SMTP_BULK_MAILINGS

This is mostly for WinNT users, but you can send messages, without 
forking AS LONG AS you're using an SMTP server and YOU ARE NOT 
using batching. To do that, change this variable to '0';

=cut

$FORK_SMTP_BULK_MAILINGS ||= 1;

=pod

=item $MAIL_SETTINGS


"|$MAILPROG -t -odq" is great to use for very large lists as it 
queues up all messages, but may not be available in all situations
Since Mojo Mail 2.4, most optional flags aren't needed, as Mojo now 
handles the mailing of large lists well with its Batch Sending feature
and sending mail through SMTP. These settings are still useful if you 
are using something other than sendmail or qmail. 

See the man page for sendmail or whatever mail system 
your server uses for more info
some flags for sendmail you can use are

-io    -> not exit a line with only a dot is read

-t     -> read the headers of the message to decide whom to send it to 
          this is really good to have for qmail   

-odq   -> insert the message into a queue. 

-oem   ->  On error, mail back the message 
          attempting to deliver it immediently.  

an example of using all those flags in the variable looks like this: 


    $MAIL_SETTINGS = "|$MAILPROG -oi -t -odq -oem";

tip: change this to ">>filename.txt"; 

to make mojo send email to a file, instead of an email, for debugging.
here's something to look at: 
http://www.courier-mta.org/sendmail.html
if you want more 

=back 

=cut

$MAIL_SETTINGS ||= "|$MAILPROG -t";

=pod


=head2 $NPH

NPH stands for No Parse Headers, I don't know what that means either, 
but Microsoft Servers like it, and I've found that cookies don't get 
set correctly and you're left with a funky screen saying you did 
wrong. Set this varable to '1' if you're using a Windows server. 

=cut

$NPH ||= 0; 

=pod

It's also a good idea to rename mojo nph-mojo.cgi for windows servers


=head2 Logging

=over

=item $MOJO_LOG

The mojo log keeps track of mundane things, such as subscriptions, 
unsubscription, control panel logins... things like that. 
This can be pretty useful come debugging time, or something went 
south during a very important mailing - best to turn this on 
/before/ that big mailing. Turn logging on by specifying a absolute
 path to a  file you want to use for the log, example:

=cut

$MOJO_LOG ||= '';

=pod


=item %LOG 

What should be logged?

Change each value to '1' in the %LOG hash 
if you want these things logged, change 
the variable to a '0' if you don't 

=cut

# log subscriptions/unsubscriptions? 
$LOG{subscriptions} ||= 1; 

# log regular mailings? 
$LOG{mailings} ||= 0; 

# log mass mailings? 
$LOG{mass_mailings} ||= 1;

# log control panel login/logouts? 
$LOG{logins} ||= 1; 

# log new lists created/old lists destroyed?
$LOG{list_lives} ||= 1;

=item $MOJO_ERROR_LOG

Create your own error log file for fun and profit!
Many people either don't know where their error log is, or
aren't allowed to see it, which is pretty cruddy, but here's your
chance to make your own error log, and get a better picture of 
what's going wrong. 

=cut

BEGIN {

# Type in  the absolute path of the file you want to make as your 
# error log for Mojo Mail. You'll probably have to create this file
#  by hand and chmod  it to 777,  example: 

$MOJO_ERROR_LOG = '';


# keep this as it is, it's just opening the error file for writing. 
if($MOJO_ERROR_LOG){open (STDERR, ">>$MOJO_ERROR_LOG") || warn "Mojo Mail Error: Cannot redirect STDERR, it's possible that Mojo Mail does not have write permissions to this file ($MOJO_ERROR_LOG) or it doesn't exists! If Mojo Mail cannot make this file for you, create it yourself and give it enough permissions so it may write to it: $!";}} 

=back 

=pod

=head2 Templates 							

You can change the look and feel of Mojo globally by specifying a #
different template file to use, examples of what these templates 
look like are located in the 'extras' directory. 

=over 

=item $ADMIN_TEMPLATE

Path to the admin template. An example of this is in the 'extras' directory.

=cut

$ADMIN_TEMPLATE ||= ''; 

=pod 

=item $USER_TEMPLATE

Path to the default user template. An example of this is in the 'extras' directory.

=cut

$USER_TEMPLATE  ||= ''; 

=pod

=item $TEMPLATES

templates are b default, saved in the same directory as your lists. To make things cleaner and nice, 
you can move them into their own directory

=back 

=cut

$TEMPLATES ||= $FILES; 

=pod

=item  $TMP

sort of on the same lins, but not really, you can specify a different directory that Mojo 
should use for writing temporary files. These files my contain sensitive data, like a copy 
of an outgoing message, so keep that in mind. 

=cut

$TMP ||= $FILES;
 
 
 
$LOGS ||= $FILES;
 
=pod 

=head2 List Control Panel

=over 

=item $SHOW_HELP_LINKS						

There are links on the bottom of some of the List Control Panel
screens that go to helpful tutorials on the Mojo Mail support
site.  If you'd like these messages taken off, set this variable
to '0'

=cut

$SHOW_HELP_LINKS ||= 1;


=pod

=item $DEFAULT_ADMIN_SCREEN

By default, when you log into the administration area, you are shown
the "Send a List Message" Screen. You can specify a different URL to go to 
by changing the $DEFAULT_ADMIN_SCREEN variable.\

=cut


$DEFAULT_ADMIN_SCREEN = $MOJO_URL.'?flavor=send_email';


my $PLUGIN_URL            = $MOJO_URL; 
   $PLUGIN_URL            =~ s/mojo\.cgi$//;
   $PLUGIN_URL           .= 'plugins';

=pod 

=item $ADMIN_MENU

This generates the Admin Menu and various links and features can
be turned on and off via the control panel. You shouldn't fool
around  with $ADMIN_MENU itself unless you want to add a feature, like a plugin.

=cut



$ADMIN_MENU ||= [
      {-Title           => 'Send A List Message', 
	   -Title_URL       => "$MOJO_URL?flavor=send_email",
	   -Activated       => 1, 
	   -Submenu         => [{-Title     => 'Send a Web Page', 
	  					     -Title_URL  => "$MOJO_URL?flavor=send_url_email",
	  					     -Function   => 'send_url_email',
	  					     -Activated  => 1},
	  					    {-Title     => 'Send a List Invitation', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=list_invite",
	  					     -Function   => 'list_invite',
	  					     -Activated  => 1},
	  					  ]
	  }, 
	  {-Title           => 'Manage List', 
	   -Activated       => 1, 
	   -Submenu         => [{-Title      => 'Change List Information', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=change_info",
	  					     -Function   => 'change_info',
	  					     -Activated  => 1},
	  					    {-Title      => 'Change Your Password', 
	  					     -Title_URL  => "$MOJO_URL?flavor=change_password",
	  					     -Function   => 'change_password',
	  					     -Activated  => 1},
	  					   
	  					    {-Title      => 'Mailing List Options', 
	  					     -Title_URL  => "$MOJO_URL?flavor=list_options",
	  					     -Function   => 'list_options',
	  					     -Activated  => 1},	
	  					    {-Title      => 'Sending Options', 
	  					     -Title_URL  => "$MOJO_URL?flavor=sending_options",
	  					     -Function   => 'sending_options',
	  					     -Activated  => 1},	 
	  					    {-Title      => 'Group Options', 
	  					     -Title_URL  => "$MOJO_URL?flavor=mojo_send_options",
	  					     -Function   => 'mojo_send_options',
	  					     -Activated  => 1},	 
	  					    {-Title      => 'Delete This List', 
	  					     -Title_URL  => "$MOJO_URL?flavor=delete_list",
	  					     -Function   => 'delete_list',
	  					     -Activated  => 1},	   					     
	  					  ]
	  }, 
      {-Title           => 'Manage Subscribers', 
	   -Activated       => 1, 
	   -Submenu         => [{-Title     => 'View Subscribers', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=view_list",
	  					     -Function   => 'view_list',
	  					     -Activated  => 1},
	  					    {-Title     => 'Add Subscribers', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=add",
	  					     -Function   => 'add',
	  					     -Activated  => 1},
	  					    {-Title     => 'Remove Subscribers', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=delete_email",
	  					     -Function   => 'delete_email',
	  					     -Activated  => 1},	  	
	  					    {-Title     => 'Search Subscribers', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=search_email",
	  					     -Function   => 'search_email',
	  					     -Activated  => 1},	 
	  					    {-Title     => 'Black List Rules', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=black_list",
	  					     -Function   => 'black_list',
	  					     -Activated  => 1},	 	  					     				     
	  					  ]
	  }, 	  
	  {-Title           => 'Manage List Archive', 
	   -Activated       => 1, 
	   -Submenu         => [{-Title     => 'View Archive', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=view_archive",
	  					     -Function   => 'view_archive',
	  					     -Activated  => 1},
	  					    {-Title     => 'Archive Options', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=archive_options",
	  					     -Function   => 'archive_options',
	  					     -Activated  => 1},
	  					  ]
	  }, 
      {-Title           => 'Manage Copy', 
	   -Activated       => 1, 
	   -Submenu         => [
	  					    {-Title     => 'E-mail Messages', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=edit_type",
	  					     -Function   => 'edit_type',
	  					     -Activated  => 1},
	  					    {-Title     => 'HTML Messages', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=edit_html_type",
	  					     -Function   => 'edit_html_type',
	  					     -Activated  => 1},
	  					     {-Title     => 'Create a Back Link', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=back_link",
	  					     -Function   => 'back_link',
	  					     -Activated  => 1}, 	  					     
	  					  ]
	  },   
	  
	  {-Title           => 'Manage Appearance', 
	   -Activated       => 1, 
	   -Submenu         => [
	  					   {-Title     => 'Edit Template', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=edit_template",
	  					     -Function   => 'edit_template',
	  					     -Activated  => 1},
	  					   {-Title     => 'Get HTML Code', 
	  					     -Title_URL  =>  "$MOJO_URL?flavor=html_code",
	  					     -Function   => 'html_code',
	  					     -Activated  => 1},
	  					    				     
	  					  ]
	  },
      {-Title           => 'About Mojo Mail', 
	   -Title_URL       => "$MOJO_URL?flavor=manage_script",
	   -Function        => 'manage_script',
	   -Activated       => 0, 
	  },
      {-Title           => 'Logout', 
	   -Title_URL       => "$MOJO_URL?flavor=logout",
	   -Function        => 'logout',
	   -Activated       => 1, 
	  },
      {-Title           => 'Sign Into Another List', 
	   -Title_URL       => "$MOJO_URL?flavor=sign_in",
	   -Function        => 'sign_in',
	   -Activated       => 1, 
	  },
	  {-Title           => 'Customize Feature Set', 
	   -Title_URL       => "$MOJO_URL?flavor=feature_set",
	   -Function        => 'feature_set',
	   -Activated       => 0, 
	  },
	  
	  {-Title     => 'Plugins', 
	   -Activated => 1, 
	   -Submenu   => [

#	  	# These are plugins, make sure you install them 
#	  	# if you want to use them! 




#		 {-Title           => 'Boilder Plate Example', 
#		   -Title_URL      => $PLUGIN_URL."/boilerplate_plugin.cgi",
#		   -Function       => 'boilderplate',
#		   -Activated      => 1, 
#		  },



#     {-Title          => 'Clickthrough Tracking', 
#	  -Title_URL      => $PLUGIN_URL."/clickthrough_tracking.cgi",
#	  -Function       => 'clickthrough_tracking',
#	  -Activated      => 1, 
#	  },
	  
	  
#     {-Title       => 'mx lookup Verification', 
#       -Title_URL      => $PLUGIN_URL."/mx_lookup.cgi",
#       -Function       => 'mx_lookup',
#       -Activated      => 1, 
#     },
 
#       	 {-Title      => 'View List Settings', 
#	  	  -Title_URL  => $PLUGIN_URL."/view_list_settings.cgi",
#	      -Function   => 'view_list_settings',
#	      -Activated  => 1, 


#		 {-Title          => 'View Logs', 
#		  -Title_URL      => $PLUGIN_URL."/log_viewer.cgi",
#		  -Function       => 'log_viewer',
#		  -Activated      => 1, 
#		 },


#	{-Title           => 'Email All List Owners', 
#	   -Title_URL      => $PLUGIN_URL."/email_list_owners.cgi",
#	   -Function       => 'email_list_owners',
#	   -Activated      => 1, 
#	  },
	
	
	
	
	  
#	{-Title           => 'Export Archives', 
#	   -Title_URL      => $PLUGIN_URL."/export_archives.cgi",
#	   -Function       => 'export_archives',
#	   -Activated      => 1, 
#	  },
	
	
	
	
	  
#	{-Title           => 'Import Archives', 
#	   -Title_URL      =>  $PLUGIN_URL."/import_archives.cgi",
#	   -Function       => 'import_archives',
#	   -Activated      => 1, 
#	  },
	  
	
	
	  
#	  
#	  	{-Title           => 'Export List Settings', 
#	   -Title_URL      => $PLUGIN_URL."/export_list_settings.cgi",
#	   -Function       => 'export_list_settings',
#	   -Activated      => 1, 
#	  },
	  



#	  	 {-Title       => 'Import List Settings', 
#	   -Title_URL      => $PLUGIN_URL."/import_list_settings.cgi",
#	   -Function       => 'import_list_settings',
#	   -Activated      => 1, 
#	  },
	  
	
	  
#	  	 
#		 {-Title           => 'List Storage Options', 
#		   -Title_URL      => $PLUGIN_URL."/list_storage_options.cgi",
#		   -Function       => 'list_storage_options',
#		   -Activated      => 1, 
#		  },
#		  


  
	   ]
	   }             
]; 


=pod

=item $SHOW_EMAIL_LIST

Customize the "View List" Screen in the Administration Area
You can turn off and on many of the features in the "View List" 
administration area. If lists get really large, it may take some 
time  for this page to load, some people have reported that the 
screen won't load at all. The main reason for this is the scroll 
box that holds a list of all the  subscribed people. Not only does 
it take time to sort through the  list in alphabetical order and 
then print all the addresses out, it's also  a huge burden for the 
browser to render a select box that large. It's not  much help 
anyways to have a select box holding 10,000 email addresses.  You
 can stop this select box from being shown by editing the below 
variable to '0'

=cut

$SHOW_EMAIL_LIST ||= 1;

=pod

To turn it on again, change this variable to 1

=item $EMAIL_CASE

$EMAIL_CASE configures mojo to either lowercase ONLY the 'domain' part of 
an email, or lowercase the entire email address. lower casing the domain 
is the correct way, since the 'name' part of an email should be case
sensitive, but is almost never handled that way.
set this to 'lc_domain' to lowercase JUST the domain, or 
set this to 'lc_all' to lowercase the entire email address.

=cut

$EMAIL_CASE ||= 'lc_all'; 

=pod

=item @EMAIL_EXCEPTIONS

@EMAIL_EXCEPTIONS allows you to enter email addresses that wouldn't normally pass 
the email address validator. Good for testing offline when all you have is, 
say, root@localhost working

=cut


@EMAIL_EXCEPTIONS = qw() 
	unless scalar @EMAIL_EXCEPTIONS;
	
	
=pod


=item $LIST_IN_ORDER

$LIST_IN_ORDER controls whether your email list is handled in
alphabetical order. Having a list in alphabetical order makes
a list easier to work with, but BE WARNED, this will, 
especially when you're using a PlainText list, slow down things.
If you have small lists, then this should be too too much of a 
problem. Set this variable to '1' to have your list sorted, 0, 
to keep your list unsorted.

=cut

$LIST_IN_ORDER ||= 0; 

=pod

=item $SHOW_DOMAIN_TABLE

This variable tells Mojo Mail if you should show the 
"Top Level Domains" table. You might not be interested 
in this information, or your list is so large that your "View List" 
page is having trouble loading. Change this to 0 to stop the table 
from being shown

=cut

$SHOW_DOMAIN_TABLE ||= 1; 

=pod

=item  @DOMAINS

The Domain Table can also be customized,
You can put in, or take away any top level domain ending (like com 
or edu)  by changing this list. Just add to the list, or delete 
something out of it,  follow the pattern. Lots of top-level domain 
listings won't necessarily  slow down the "View List" page. 

=cut

@DOMAINS = qw(
biz
com
info
net
org
edu
gov
mil
nu
us
) unless scalar @DOMAINS;

=pod 

=item $SHOW_SERVICES_TABLE 

This variable tells Mojo Mail if it should show the 
"Services" table. You might not be interested 
in this information, or your list is so large that your "View List" 
page is having trouble loading. 

=cut

$SHOW_SERVICES_TABLE ||= 1; 

=item %SERVICES

The services Panel can also be customized,
You can put in, or take away any service that you want to track, 
add a record in between the parentheses, heres an example of what 
a new service would look like: 
            
	'Altavista'     => 'altavista.net',

Put the NAME of the service on the left, and the domain ending 
on the right that corresponds to that service. The domain 
ending for American Online is "aol.com"
Follow the pattern!

=cut

%SERVICES = ( 
'.Mac'          => 'mac.com',
'AOL'           => 'aol.com',
'Compuserve'    => 'compuserve.com', 
'Excite Mail'   => 'excite.com', 
'Hotmail'       => 'hotmail.com',
'MSN'           => 'msn.com',
'PO Box'        => 'pobox.com', 
'Prodigy'       => 'progidy.net',
'Yahoo!'        => 'yahoo.com',
) unless keys %SERVICES; 

# keep a list as a shorthand. 
@SERVICES = values %SERVICES; 

=item Artsy Buttons

these are buttons styles, if you find yourself well read in CSS,
go ahead and fool around with em,

=cut

#default (brown)  
$STYLE{default_submit} ||= 'font-size: 11px; font-family:verdana,arial, sans-serif; background-color: #CC9966; color: #000000; font-weight:bold; border: 1px solid black';
$STYLE{green_submit}   ||= 'font-size: 11px; font-family:verdana,arial, sans-serif; background-color: #99CC99; color: #000000; font-weight:bold;  border: 1px solid black';
$STYLE{red_submit}     ||= 'font-size: 11px; font-family:verdana,arial, sans-serif; background-color: #FF6666; color: #000000; font-weight:bold;  border: 1px solid black';
$STYLE{yellow_submit}  ||= 'font-size: 11px; font-family:verdana,arial, sans-serif; background-color: #FFFFCC; color: #000000; font-weight:bold;  border: 1px solid black';

=pod

=back 

=head2 $FILE_CHMOD

$FILE_CHMOD is a variable that sets what permission Mojo Mail sets 
files to when it initialy writes them, you can set it to a few things: 
0660 - probably all you need
0666 - allows anyone to read and write files in the $FILES directory
0755 - probably insecure
0777 - shooting yourself in the foot insecure
0600 - god awful paranoid about the whole thing - life in general, 
as secure as it gets

=cut

$FILE_CHMOD ||= 0666;

=pod

It's a good idea to figure out what works and leave this variable alone 
after your lists are set up, as you may not be able to access alist under
a different $FILE_CHMOD.

We've changed what the $FILE_CHMOD Mojo Mail is shipped (02/13/01) 
with from  0660 to 0666, note that this may be less secure than 0660,
 but may  solve some problems people are having. Change this back to 
0660 if  everything seems to have been running just fine.    

=cut


=pod

=head2 Email Messagess and Headers

=item  @CHARSETS

Charsets that Mojo Mail supports, they are the 
 most used, to add your own, would look like this: 

	'Description	charset',

There's a TAB between the Description and the actual charset, THIS 
 IS REALLY IMPORTANT. 

=cut


@CHARSETS = ( 
'Afrikaans (af)	 iso-8859-1','Afrikaans (af)	windows-1252','Albanian (sq)	 iso-8859-1',
'Albanian (sq)	 windows-1252','Arabic (ar)	iso-8859-6','Basque (eu)	iso-8859-1',
'Basque (eu)	windows-1252','Bulgarian (bg)	 iso-8859-5','Byelorussian (be)	 iso-8859-5',
'Catalan (ca)	iso-8859-1','Catalan (ca)	windows-1252','Croatian (hr)	 iso-8859-2',
'Czech (cs)	 iso-8859-2','Danish (da)	iso-8859-1','Danish (da)	windows-1252',
'Dutch (nl)	 iso-8859-1','Dutch (nl)	 windows-1252','English (en)	iso-8859-1',
'English (en)	windows-1252','Esperanto (eo)	 iso-8859-3','Estonian (et)	 iso-8859-15',
'Faroese (fo)	iso-8859-1','Faroese (fo)	windows-1252','Finnish (fi)	iso-8859-1',
'Finnish (fi)	windows-1252','French (fr)	iso-8859-1','French (fr)	windows-1252',
'Galician (gl)	 iso-8859-1','Galician (gl)	 windows-1252','German (de)	iso-8859-1',
'German (de)	windows-1252','Greek (el)	 iso-8859-7','Hebrew (iw)	iso-8859-8',
'Hungarian (hu)	 iso-8859-2','Icelandic (is)	 iso-8859-1','Icelandic (is)	 windows-1252',
'Inuit (Eskimo)	 iso-8859-10','Irish (ga)	 iso-8859-1','Irish (ga)	 windows-1252',
'Italian (it)	iso-8859-1','Italian (it)	windows-1252','Japanese (ja)	 shift_jis',
'Japanese (ja)	 iso-2022-jp','Japanese (ja)	 euc-jp','Lapp()	iso-8859-10',
'Latvian (lv)	iso-8859-13','Latvian (lv)	windows-1257','Lithuanian (lt)	iso-8859-13',
'Lithuanian (lt)	windows-1257','Macedonian (mk)	iso-8859-5','Maltese (mt)	iso-8859-3',
'Norwegian (no)	 iso-8859-1','Norwegian (no)	 windows-1252','Polish (pl)	iso-8859-2',
'Portuguese (pt)	iso-8859-1','Portuguese (pt)	windows-1252','Romanian (ro)	 iso-8859-2',
'Russian (ru)	koi-8-r','Russian (ru)	iso-8859-5','Scottish (gd)	 iso-8859-1',
'Scottish (gd)	 windows-1252','Serbian (sr)	iso-8859-5','Slovak (sk)	iso-8859-2',
'Slovenian (sl)	 iso-8859-2','Spanish (es)	iso-8859-1','Spanish (es)	windows-1252',
'Swedish (sv)	iso-8859-1','Swedish (sv)	windows-1252','Turkish (tr)	iso-8859-9',
'Turkish (tr)	windows-1254','Ukrainian (uk)	 iso-8859-5'
) unless scalar @CHARSETS;


=pod

=item @PRECEDENCES

This is the default group of Precedences used when sending Bulk 
Messages, be warned the SMTP sending may not  support any other
prededence value except the ones listed here. 

=cut

@PRECEDENCES = ('list','bulk','junk', undef) unless scalar @PRECEDENCES; 

=pod

=item @Content_type

These are the default content-types, add your own,  have fun

=cut

@CONTENT_TYPES = qw(
text/plain
text/html
) unless scalar @CONTENT_TYPES; 

=pod

=item %PRIORITIES

priorities of mailings. I find people that send me things with 
the highest priority telling me about credit cards  really 
don't garder my attention. 

=cut

%PRIORITIES = ( 
 5 => 'lowest',
 4 => 'low',
 3 => 'normal', 
 2 => 'high',
 1 => 'highest',
) unless keys %PRIORITIES;


=pod 

=item $PLAIN_TEXT_ENCODING

Sets how plain text messages are encoded, different things you can set this to: 

7bit, 8bit, quoted-printable, base64  

=cut                

$PLAIN_TEXT_ENCODING ||= '8bit'; 


=pod

=head2 Additional Settings You'll probably not need to change. 

(advanced hacker stuff)

=over

=item $MOJO_CONFIG_FILE_DIR

This is how you can set all the variables located in the Config.pm module 
outside of the module itself. Why would you want to do that? It makes Mojo 
more upgradable. Everytime you upgrade Mojo you don't have to tweak this 
file (or tweak it only slightly) you just throw up the new distro and away 
you go! Now, Mojo finds this external config file in a bunch of ways. 

You can implicitly set the B<directory> it lives in by changing the 
B<$MOJO_CONFIG_FILE_DIR> variable that lives inside the Config.pm module.
Wherever the external config file lives, it B<needs> to be called I<.mojo_config> 

If you don't change the B<$MOJO_CONFIG_FILE_DIR> variable in the Config.pm file, 
 Mojo will try to look in your home directory for the I<.mojo_config> file. 
It tries to find your  home directory in different places, one is the Environment 
Variable I<$ENV{'HOME'}> and by called the getpwuid() function as so: 

	getpwuid $> )[7]

The rub with these is that you usually can't get anything from the getpwuid() function 
unless you run the script as same user that created it, ie via suEXEC or by setting the 
setuid bit. 

So, knowing this, the easiest, most suprise-unfriendly way to set the .mojo_config file
directory location is to *sigh* set it in this here Config.pm module. I'll leave setting the 
setuid bit for scripts that use the Config.pm file decision up to you. 

If you don't set any of the above, Config.pm will use the same directory that it's in 
as the directory to find the .mojo_config file, which I guess ain't the worst way to go 
about things. 

Anyways, an example of a .mojo_config file would look like this: 


 $MOJO_ROOT_PASSWORD  = 'root_password';
 $FILES               = '/home/home_dir/mojo_lists_dir';
 $MAILPROG            = '/usr/lib/sendmail';  
 $MOJO_URL            = 'http://yoursite.com/cgi-bin/mojo/mojo.cgi';

Pretty much any variable, array or hash can be saved in the .mojo_config file, 
as long as it's not set inside a BEGIN{} block, whoich leaves out $MOJO_ERROR_LOG 
and @AnyDBM_File::ISA treat .mojo_config as a file that gets eval() right into 
Config.pm cause well, that's what happens. Because of this, great care should be 
made in where you put I<.mojo_config>

The B<$MOJO_CONFIG_FILE_DIR> is located at the top of the Config.pm file, right 
after the first 4 variables for easy getting-at and fumbling.


=item Operating System

Mojo tries to guess your Operating System using the $^O variable. If it's guessing wrong, you can set it yourself. 

=cut

$OS ||= $^O;

=pod

=item Seed random number generator

if this is taken off, the seed random number will be               
made from the time, or from something pretty random, depending on  
your version of Perl                                               

=cut

srand ( time() ^ ($$ + ($$ << 15)) );  

=pod

=item $FIRST_SUB, $SEC_SUB

Where is the salt number located in the encrypted password? its 
usually at substr(0,2) 
but may be different on different systems, 
some sytems are set to substring(3,2)
Actually, I've only had this problem on one system, Mine, :) 
which was a FreeBsd 4.0 distro. Under most cases, this is NOT going 
to be your problem!

=cut

$FIRST_SUB ||= 0;
$SEC_SUB   ||= 2;


=pod

=item $SALT

the salt number, change $SALT to
 
	 $SALT = "mj";

if all else fails. 

=cut

@C=('a'..'z', 'A'..'Z', '0'..'9','.','/');
$SALT=$C[rand(@C)].$C[rand(@C)];

=pod

=item $PIN_WORD $PIN_NUM 

A pin number is made when someone wants to subscribe to your
list. They will get a confirmation email with a special link
that includes their e-mail, and a pin thats generated from the email 
and the variables below using a mathematical equation. 
Its much  harder to guess a pin with these two variables changed:

=cut

# Pick a word. it really doesn't matter what the word is, a longer 
# word doesn't necessarily mean a better pin number 
# $PIN_WORD = "mojo"; 

# Pick a number. I would keep it between 1 and 9. 
$PIN_NUM   ||= "3";

=pod

=item $MAKE_ALL_LIST_FILES

When making new lists, make each file Mojo Mail needs 
Change this to "0" if, for some reason you don't want this done. 

=cut

$MAKE_ALL_LIST_FILES ||= 1; 

=pod

=item %LIST_SETUP_DEFAULTS

These defaults will be used when CREATING a new list. These defaults will 
also be used for existing lists if there isn't a variable already set. 
These values correspond to the values
created in the list databases, an example would be: 

	%LIST_SETUP_DEFAULTS = ( 
	                         black_list    => 1, 
	                         send_via_smtp => 1,
	                        );


this would setup all lists created now with black lists on, and mail
being sent using SMTP. 

=cut

%LIST_SETUP_DEFAULTS = (
	
	#general               
	hide_list                    => 0,
	
	#mailing list options 
	
	send_unsub_success_email    => 1,
	
	
	# smtp prefs
	use_pop_before_smtp          => 1,
	smtp_server                  => $SMTP_ADDRESS,
	
	# email headers
	precedence                   => 'list', 
	charset                      => 'English (en)	iso-8859-1',
	content_type                 => 'text/plain',
	priority                     => 3,
	print_list_headers           => 1,
	
	# archive prefs
	archive_messages             => 1,
	show_archives                => 1,
	archive_subscribe_form       => 1,
	archive_search_form          => 1,
	archive_send_link            => 0,
	archive_show_month           => 1,
	archive_show_day             => 1,
	archive_show_year            => 1,
	archive_index_count          => 10,
	sort_archives_in_reverse     => 1,
 	
	#blacklist 
	black_list                           => 0,
	add_unsubs_to_black_list             => 0,
	allow_blacklisted_to_subscribe       => 0,
	allow_admin_to_subscribe_blacklisted => 0,
	
	# group prefs
	group_list                   => 0, 
	allow_group_interpolation    => 0,
	only_allow_group_plain_text  => 0,
	add_reply_to                 => 1,
	mail_group_message_to_poster => 1,
	append_list_name_to_subject  => 1,
	
	#template prefs
	get_template_data            => 'from_template_file',
	url_template                 => '',
	
	#SQL stuff
	subscription_table           => 'mojo_subscribers',
	
) unless keys %LIST_SETUP_DEFAULTS;

=pod

=item %LIST_SETUP_OVERRIDES

%LIST_SETUP_OVERRIDES will override any setting that's in the 
%LIST_SETUP_DEFAULTS hash and whatever is set in the list preferences. 

=cut

%LIST_SETUP_OVERRIDES = () unless keys %LIST_SETUP_OVERRIDES;



=pod

=item @AnyDBM_File

Change what DB Mojo Mail will use. 
Mojo Mail can use various db packages to save each list's information,
it looks for the best one and uses the next package in the list
if it can't find it. 
if you get a software error (an error 500, not having no information changed
when creating a new list) you may have to change this to: 

	BEGIN { @AnyDBM_File::ISA = qw(SDBM_File) }

SDBM is the worst package to use, but it is always available with perl.
see the man page for the AnyDBM_File for more information

=cut

BEGIN { @AnyDBM_File::ISA = qw(DB_File GDBM_File NDBM_File ODBM_File SDBM_File) }

=pod

check the AnyDBM_File for more info (yo)


=item $ATTACHMENT_TEMPFILE

To add an attachment to a list message in Mojo Mail from the control panel, 
we have to upload it via the web browser. There's two ways we can do this, 
one is to save the information in the $FILES directory and then open it up, 
attach it, and then delete it, the other involves some magical qualities of
CGI.pm and MIME::Lite, probably coupled with your server's /tmp file, if 
you can use it. 
setting $ATTACHMENT_TEMPFILE to '1' uploads, saves, attaches and then deletes 
the file, setting it to '0' does it magicaly. I suggest 1, unless you want to 
play around with it. 

=cut

$ATTACHMENT_TEMPFILE ||= 1;

=item %MIME_TYPES

These are the MIME types Mojo Mail understands, the file ending is on 
the left, what MIME type it maps to is on the right. Feel free to add
your own. 

=cut

%MIME_TYPES = ( 
'.gif'  => 'images/gif', 
'.jpg'  => 'image/jpg',
'.png'  => 'image/png',
'.jpeg' => 'image/jpeg',

'.pdf'  => 'application/pdf',
'.psd'  => 'application/psd',

'.html' => 'text/html',
'.txt'  => 'text/plain',

'.doc'  => 'application/msword',
'.xls'  => 'application/x-msexcel',
'.ppt'  => 'application/x-mspowerpoint',

'.mp3'  => 'application/octet-stream',
'.mov'  => 'video/quicktime',




) unless keys %MIME_TYPES;


=pod

=item $DEFAULT_MIME_TYPE

In case nothing up there matches what someone is trying to upload, 
there's a default MIME type, for a last ditch guess. Some mail 
readers are  sophisticated enough to figure out what an attachment is 
without its MIME type, but don't count on it. 

=cut

$DEFAULT_MIME_TYPE ||= 'text/plain'; 

=pod

=item $MIME_PARANOID 

This is set for the $MIME::Lite::PARANOID	variable, set it to 1 
if you don't know if you have the MIME::Base64 or MIME::QuotedPrint
or you don't know what those are :) 

=cut

$MIME_PARANOID ||= 1;

=pod

=item $MIME_HUSH

set mime_hush to 1 to "suppress/unsuppress all warnings
coming from this module.			

=cut

$MIME_HUSH ||= 1;

######################################################################
# Variables you DON'T have to change. 
######################################################################
=pod

=item  $VER

This is the version of this  Mojo Mail Program. 
mostly its used to see if there's a new version out there to use
and to say that you've got the freshest tools on the web

=cut

$VER ||= "2.7.2";



# If your having problems with Mojo Mail PLEASE tell me what the version 
# of it is, Each new version of Mojo Mail is SOOOO different from each 
# other, If I put two different releases together, I'd have Mojo 4.0 by
# now.
######################################################################

=pod

=item $PROGRAM_NAME

This is the name of the program. I guess if this script has a mid-life 
crisis or something, it can change it's name, buy a really fast car 
start chasing guys half her age. 

=back


=cut

$PROGRAM_NAME ||= 'Mojo Mail';


######################################################################
# This is the default "subscription successful!" e-mail message. 
# This message can be customized for each list in the list's Control Panel.
$SUBSCRIBED_MESSAGE  ||= <<EOF 

Hello! Thanks for subscribing. 
Here's information  about [list_name] 
that was given by the list owner:

[list_info]

Private Policy:
[list_privacy_policy]


You might want to save this email for future reference. 
You can unsubscribe anytime from [list_name] by following this link:

[list_unsubscribe_link]


If you have questions regarding this mailing list,
you can contact the list owner at: 
[list_owner_email]


EOF
; 


######################################################################
# This is the default "unsubscription successful!" e-mail message. 
# This message can be customized for each list in the list's Control Panel.
$UNSUBSCRIBED_MESSAGE  ||= <<EOF  

Unsubscription from list: 

[list_name] 

is successful.

If you would like to subscribe to [list_name] 
in the future, just click this link: 

[list_subscribe_link]

- [list_owner_email]

EOF
; 





######################################################################
# This is the default "subscription confirmation" e-mail message. 
# This message can be customized for each list in the list's Control Panel.


$CONFIRMATION_MESSAGE ||= <<EOF   

Hello, 
This has been sent to you just to confirm that you 
want to be subscribed to:
 
[list_name]

to confirm, simply  follow the link below:

[list_subscribe_link]

(Click the link above or copy and paste the link into your browser)

You are sent this email for a couple of reasons:
We wanted  to make sure that the e-mail submitted is a real e-mail address
and also wanted to prevent people from subscribing to the list with 
an e-mail address other then their own. 

If for some reason, you received this e-mail without 
any idea why you did, simply ignore and sorry for the
inconvenience. 

- [list_owner_email]


EOF
; 




######################################################################
# This is the default "subscription confirmation" e-mail message. 
# This message can be customized for each list in the list's Control Panel.


$UNSUB_CONFIRMATION_MESSAGE ||= <<EOF   

Hello, 
This has been sent to you just to confirm that you 
want to be unsubscribed from:
 
[list_name]

to unsubscribe, simply  follow the link below:

[list_unsubscribe_link]

(Click the link above or copy and paste the link into your browser)

You were sent this email for a couple of reasons:
We wanted  to make sure that the e-mail submitted is a real e-mail address
and also wanted to prevent people from unsubscribing from the list with 
an e-mail address other then their own. 

If for some reason, you received this e-mail without 
any idea why you did, simply ignore it. We are sorry for the
inconvenience. 

- [list_owner_email]


EOF
; 




######################################################################
# This is the default "Mailing List!" e-mail message. 
# This message can be customized for each list in the list's Control Panel.

$MAILlING_LIST_MESSAGE ||= <<EOF  
[message_body]


--
To unsubscribe from: [list_name], just follow this link:

[list_unsubscribe_link]

Click this link, or copy and paste the address into your browser.

EOF
; 

$MAILlING_LIST_MESSAGE_HTML ||= <<EOF

[message_body]

<p>To unsubscribe from: [list_name], just follow this link:</p>

<p>
 <a href="[plain_list_unsubscribe_link]">
  [plain_list_unsubscribe_link]
 </a>
</p> 

<p>
 Click this link, or copy and paste the address into your browser.
</p>

EOF
; 

######################################################################
# This message is sent to someone who is not allowed to post to your list using the 
# mojo_send.pl script. If you do not use the mojo_send.pl script, this won't 
# be of any use to you! 
# This message can be customized for each list in the list's Control Panel.
$NOT_ALLOWED_TO_POST_MESSAGE ||= <<EOF  

Mojo Mail  Error: 
You're Not Allowed to send messages to this list. 

-Mojo Mail


EOF
; 



$HTML_CONFIRMATION_MESSAGE ||= <<EOF

<h3>Please confirm your subscription</h3>  


<p>An email has been sent to your address: [subscriber_email]  to confirm your subscription to [list_name]</p>


<P>Please follow the instructions in the confirmation email to finish the subscription process. 


<p>This is to protect people's private email addresses and to stop any abuse to the list that might happen.</p>


<p>If you have any questions, you can email the list owner owner at <a href=mailto:[list_owner_email]>[list_owner_email]</a></p>

EOF
; 


$HTML_UNSUB_CONFIRMATION_MESSAGE ||= <<EOF

<h3>Please confirm your unsubscription</h3>  


<p>An email has been sent to your address: [subscriber_email]  to confirm your unsubscription to [list_name]</p>


<P>Please follow the instructions in the confirmation email to finish the unsubscription process. 


<p>This is to protect people's private email addresses and to stop any abuse to the list that might happen.</p>


<p>If you have any questions, you can email the list owner owner at <a href=mailto:[list_owner_email]>[list_owner_email]</a></p>

EOF
; 


$HTML_SUBSCRIBED_MESSAGE ||= <<EOF 

<h3>You have been added to the list: [list_name]</h3>


<p>Your e-mail address, [subscriber_email] has been subscribed to [list_name]</p>


<p>A notification e-mail has been sent to your address: [subscriber_email]


 with a brief summary of the list and instructions on how to unsubscribe.</p>


EOF
; 


$HTML_UNSUBSCRIBED_MESSAGE ||= <<EOF  
<h3>You have been unsubscribed from the list: [list_name]</h3>

<p>[subscriber_email] is no longer a part of [list_name]. Thanks for subscribing.</p> 


EOF
;


$TEXT_INVITE_MESSAGE ||= <<EOF  

Hello! 

I wanted to tell you about my email list, [list_name]: 

[list_info] 

I thought you might be interested in subscribing to it. If you 
want to, just click this link: 

[plain_list_subscribe_link] 

This is a one-time mailing, you won't hear from us again, unless you 
 subscribe. 

- [list_owner_email]

EOF
;

$HTML_INVITE_MESSAGE ||= <<EOF  

<p><b>Hello!</b></p> 

<p>I wanted to tell you about my email list, [list_name]:</p> 

<blockquote> 

<p>[list_info]</p>

</blockquote> 

<p>I thought you might be interested in subscribing to it. If you 
want to, just click <b><a href="[plain_list_subscribe_link]" target=out>here</a></b></p> 
 

<p>This is a one-time mailing, you won't hear from us again, unless you 
 subscribe.</p> 

<p>- <a href='mailto:[list_owner_email]'>[list_owner_email]</a></p>

EOF
;






# Good Job! 
$GOOD_JOB_MESSAGE ||= "<p class=smallred><i>Your changes have been saved successfully</i></p>\n"; 

# No ones subscribed? 
$NO_ONE_SUBSCRIBED ||= "<p>No one is subscribed to your list at the moment</P>"; 

######################################################################
$ARCHIVES  ||= $FILES; 


######################################################################

######################################################################
# Ah, Here is where I pass tip jar around. I've sung song, played 
# my instrument and I ask if you enjoy the performance, that you put a few 
# in the bowl. Giving $50 to the Mojo Mail Project would be simply 
# wonderful. In fact, If you do, It would be pleasure to allow you to 
# make these two variables (below) blank. You can use the program indefinetly 
# without sending any donations, I only ask that if you found this program 
# AMAZING (and I believe you will) that you help out with the expenses 
# of the web site, the online documentation, the free support and 
# whatever else we provide. Like I said, I'm asking, not telling, you can 
# either keep these variables like this, or remove them and donate some
# money, either way, you'll be supporting the program. 
#
#
# Donations, etc can be sent to: 
#        
#                      Justin Simoni 
#                       PO BOX 369
#                     Boulder, COLORADO
#                          80306 
#
#
# Tell me if you like the program! I'll post testimonials on the Mojo 
# Mail Website. What I /really/ hope you get through this program is 
# an amazing tool to allow you to communicate-  your ideas, dreams, 
# hard work and struggle. *That* is why I made this program. 
#
#                     -Justin Simoni
#                            me@justinsimoni.com
#                                  justinsimoni.com
 
#this footer gets appended to most e-mails sent using Mojo Mail  
$FOOTER ||= " ";#"\n\nList management using Mojo Mail $VER\n";


#This footer gets appended to most HTML e-mails sent with Mojo Mail

# DO NOT REMOVE THIS LINK UNLESS YOU ARE WILLING TO PAY.
$HTML_FOOTER ||=  " ";# "\n\n<p style='font-size:10px;font-family:verdana,arial'>Powered by <a href= http://mojo.skazat.com target=out style='font-size:10px;font-family:verdana,arial'>Mojo Mail $VER</a><br />Copyright &copy; 1999-2003, <a href=\"http://justinsimoni.com\" target=\"_blank\"  style='font-size:10px;font-family:verdana,arial'>Justin Simoni</a>.</p>\n";






  

sub _config_import { 
	my $CONFIG_FILE_DIR;
	
	if(defined($OS) !~ m/^Win|^MSWin/i){ 
		my $getpwuid_call; 
		my $good_getpwuid;
		eval { $getpwuid_call = ( getpwuid $> )[7] };
		       $good_getpwuid = $getpwuid_call if !$@;
		
		$CONFIG_FILE_DIR = $MOJO_CONFIG_FILE_DIR || $ENV{'HOME'} || $good_getpwuid || '';
	}else{ 
		$CONFIG_FILE_DIR = $MOJO_CONFIG_FILE_DIR || $ENV{'HOME'} || '';		
	}
	my $CONFIG_FILE = $CONFIG_FILE_DIR.'/.mojo_config';
	
	# yes, shooting yourself in the foot, RTM
	$CONFIG_FILE =~ /(.*)/; 
	$CONFIG_FILE = $1;
	
	if(-e $CONFIG_FILE && -f $CONFIG_FILE && -s $CONFIG_FILE){ 
		open(CONFIG, "< $CONFIG_FILE"); 
			my $conf;
			{
				local $/ = undef; 
				$conf = <CONFIG>;    
			}
		# shooting again, 
		$conf =~ m/(.*)/ms;
		$conf = $1;	
		eval $conf;
	}
}

# Don't remove the '1', it lives here at the bottom. it likes it there.
1;

=head1 SUPPORT

If you need further support for this script, please do not email 
me directly, but use one of the following channels: 

=over

=item * Mojo Mail Support Site

http://mojo.skazat.com

=item * The Mojo Mailers Discussion List

http://knowledgematters.net

=item * Consultation for Mojo Mail

http://mojo.skazat.com/support/customize.html

=back


=head1 CONTACT

My name is Justin Simoni 

e.  - me@justinsimoni
ph. - 720.436.7701
w.  - http://justinsimoni.com

I am available for Installation, Customization and Consultation of the 
Mojo Mail program. I am also available for contract work, web design, 
Fine and Commercial Art. 

Please, get in touch.

=head1 COPYRIGHT 

Copyright (c) 1999 - 2003 Justin Simoni 
me@justinsimoni.com
http://justinsimoni.com 
All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


=head1 Last Words

B<"The sitting posture of Michelangelo's "Moses" is said to have been
necessitated by the compact form of the block of marble he had to
work with. Divine is always being presented with odd-shaped marbles 
that make her achieve masterpieces.">

I<-Genet, "Our Lady of the Flowers">

=cut
