#!/usr/local/bin/perl
# Filename: random_pict

# This script is intended to be called with additional
# path information specifying a directory containing
# some images to pick at random.  The HREF should
# look like this:

# <A HREF="/cgi-bin/random_pict/path/to/directory/">

# Where /path/to/directory/ is the partial URL of a
# directory containing some image files.  The script
# scans for image files (by looking at the suffixes)
# and picks a different one each time.  It's important
# for some servers that the /path/to/directory/ end
# with a slash.

# You can also use this script as the source of
# an inline image!
#   <IMG SRC="/cgi-bin/random_pict/path/to/directory/">

# To install: name this script random_pict, make it
# executable, and fix the path to perl at the top if
# necessary.  Then move it into your scripts directory.

# CONFIGURATION SECTION

# This constant defines a set of
# file suffixes that are acceptable for display.
# Change it to support other file types.
@OK = ('jpg','jpeg','jfif','gif','ps','pict','xbm');

## END OF CONFIGURATION (not much, eh?)
# Turn it into a pattern match
$OK = '\.(' . join("|",@OK) . ')$';

$IMAGE_DIR = $ENV{PATH_TRANSLATED};
$IMAGE_DIR || &exit(<<EOF);
This script must be called with extra path information
in the form random_pict/path/to/directory.
EOF

# Read the contents of the directory, and filter
# through the pattern matching.  We get rid of
# metacharacters before opening the directory to
# avoid unpleasant surprises!

$IMAGE_DIR=~tr#A-Za-z_/.-##cd;
opendir(DIR,$IMAGE_DIR) || &exit(<<EOF);
Sorry, $IMAGE_DIR is not a valid directory.
EOF
    ;

@names=grep(/$OK/oi,readdir(DIR));
@names || &exit("Sorry, no images to display.");

# Pick a random picture to display
srand;
$picture = $names[rand($#names)];

# print out the redirection
print "Location: $ENV{PATH_INFO}/$picture\n\n";

sub exit {
    local($message) = @_;
    print "Content-type: text/plain\n\n";
    print $message,"\n";
    exit 0;
}

