#!./perl

require "common.pl";

# Set the Constants

$datafile="data/datafile";
$sizelook="data/sizelook";
$htmlloc="/var/spool/news/htdocs/kimble/login/riviera/floorplans/";
$status=0;

# Get the info from the form

parse_form_data(*info);

$number = $info{'number'};
$type = $info{'type'};
$price = $info{'price'};
$fee = $info{'fee'};
$taxes = $info{'taxes'};

# Get the suite size from the file
dbmopen(%SIZELOOK, $sizelook, 0444) || not_valid;
	($size, $bedrooms) = split(/\t/, $SIZELOOK{$type});
dbmclose(SIZELOOK);

# Determine the floor number

$strlen = (length($number)-1);
if ($strlen = 3) {
	$floor = substr($number, 0, 1);
}
else {
	$floor = substr($number, 0, 2);
}


dbmopen(%DATAFILE, $datafile, 0666) || not_valid;
	$DATAFILE{$number} = "${floor}\t${number}\t${type}\t${bedrooms}\t${price}\t${size}\t${fee}\t${taxes}\t${status}\t${view}";
dbmclose(DATAFILE);

$smfloor = "smfloor".$floor;
$floorno = "floor".$floor;

# create the html files
# first the overall frame

$planname = "plan".$number.".html";
$filename = $number.".html";
$fileloc = $htmlloc.$filename;
open(FILENAME, ">$fileloc") || not_valid;
	print FILENAME <<END_CODE;
	<html>
	<head>
	<title>$filename</title>
	<frameset rows="80%, 20%">
		<frame src ="$planname">
		<frame src="/cgi-bin/getinfo.pl?suite=$number">
	</frameset>
	</html>
END_CODE
close(FILENAME);

# then the plan file
$fileloc = $htmlloc.$planname;
open(FILENAME, ">$fileloc") || not_valid;
	print FILENAME <<END_CODE;
	<html>
	<head>
	<title>Floor Plan for Suite $number</title>
	</head>
	<table>
	<tr align=center>
		<td rowspan=2 width="600"><img src="$type.gif"></td>
		<td width="200"><img src="bldgsm.gif"></td>
	</tr>
	<tr>
		<td><img src="$smfloor.gif"></td>
	</tr>
	</table>
	<br>
	<a href="$floorno.html" target="mainframe"
	OnClick="parent.parent.LoadFrames('bldgsm.html')">
	Return to Main Plan</a>
	</center>
	</body>
	</html>
END_CODE
close (FILENAME);

# Generate a response

&html_header("Data Entered");
print <<END_CODE;
$planname<br>
$filename<br>
$fileloc<br>
$size<br>
	Data has been entered into the database<p>
	<center>
	<a href="/landagents/dev/putinfo.html">Return to Data Entry Screen</a>
END_CODE


