#!/usr/bin/perl -w

# Sample code for INSTAbase 4 Web Ready
# You may distribute freely
# INSTAbase Copyright (C) 1999.

# Read in core INSTAbase variables
require "./instaadd.setup";

# Parsing the form, don't touch it unless you know what you doing.

&parse_form;

sub parse_form {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $cgi{$name} = $value;

      # Uncomment for debugging purposes
      # print "Setting $name to $value<P>";
   }
}


		open(FILE, "${database_file}") || die "Can't open $database_file!\n";
		while(<FILE>){
		
if (/\s*<param name\=table value\=([^<]+)\>/) { 
	($data_file1) = ($1); 
	}
	
if (/\s*<param name\=label value\=([^<]+)\>/) { 
	($data_file2) = ($1); 
	}
	
if (/\s*<param name\=dataname value\=([^<]+)\>/) { 
	($dataname) = ($1); 
	}

if (/\s*<param name\=color value\=([^<]+)>/) { 
	($bgcolor) = ($1); 
	}
	
if (/\s*<param name\=textcolor value\=([^<]+)\>/) { 
	($textcolor) = ($1); 
	}
	
if (/\s*<param name\=fieldnr value\=(\d+)/) { 
	($fieldnum) = ($1); 
	}
	
if (/\s*<param name\=imgcom value\=(\d+)/) { 
	($imgcom) = ($1); 
	}
	
if (/\s*<param name\=image value\=(\d+)/) { 
	($image) = ($1); 
	}
	
if (/\s*<param name\=comment value\=(\d+)/) { 
	($comment) = ($1); 
	}
	
if (/\s*<param name\=site value\=([^<]+)\>/) { 
	($site) = ($1); 
	}
		}
		close (FILE);
		
# get the full path to the data_file1.txt and data_file2.txt
# $num is the number of "/" to your directory

	$num = ($database_file =~ tr/\//\//);
	@data = split(/\//, $database_file);
	for ($i = 1; $i < $num; $i++) { $path = $path . "\/@data[$i]"; }
	$data_file1 = $path . "\/$data_file1";
	$data_file2 = $path . "\/$data_file2";

	
# open the file and calculate how many fields in your database! $max_num

	open(FILE, "$data_file2") || die "Can't open $data_file2!\n";
	$line = <FILE>;
	close(FILE);
	
	@line = split(/\|/, $line);
	$max_num = ($line =~ tr/\|/\|/);
	
	

if ($ENV{'CONTENT_LENGTH'} eq "") 
{
	
$line_num = 1;

print "Content-type: text/html\n\n";

&display_header($title);
print "<P>&nbsp;<P><center><H2>$title</H2></center>\n<HR width=70%>\n";
print "<form action=instaadd.cgi method=post>\n<center>\n";
print "<P><table bgcolor=\"\#$bgcolor\" border=5 cellspacing=0 cellpadding=0 WIDTH=600>\n";
print "<tr valign=top><td WIDTH=50%>$line[2]</td><td><input type=text size=32 name=line$line_num></td></tr>\n";

for ($i = 3; $i < $fieldnum; $i++) {
$line_num++;
print "<tr valign=top><td>$line[$i]</td><td><input type=text size=32 name=line$line_num></td></tr>\n";
}

if ($comment == 1) {
print "<tr valign=top><td>Comments:</td><td><TEXTAREA name=\"comment\" rows=\"10\" cols=\"30\" WRAP=VIRTUAL></TEXTAREA></td></tr>\n";
}

print "<tr><td colspan=2 align=center><input type=submit value=\"Add Record\"> <input type=reset value=\"Clear Contents\"></td></tr>\n";
print "</table>\n\n<P></center>\n</form>\n<p>&nbsp;<p>\n\n";

&footer;

	exit;
	
}else{
	
$current_date = &get_date;
	
for ($i = 1; $i < ($fieldnum - 1) ; $i++){
if (length($cgi{"line$i"}) < 1) { &myerror; }
}

# if file exists, calculate how many lines in the file.

$i=1;

if (-e "$data_file1") {
		open(THIS_FILE, "$data_file1");
		@lines = <THIS_FILE>;
		close (THIS_FILE);
		
		foreach $line (@lines){
		$line =~ s/[\n\r ]//g;
		if ($line ne "") { $i++; }
		}
}

# if $cgi{'comment'} equal to "" , no comments left, then we assign 0
# to the value of $comment_value, if there is a comment, value = 1.

if ($cgi{'comment'} eq ""){
	$comment_value = 0;
}else{
	$comment_value = 1;
      	open (NOTEFILE,"+>$path/notes${dataname}${i}.txt")|| die "Can't open $path/notes${dataname}${i}.txt!\n";
      	print NOTEFILE "$cgi{'comment'}";
      	close (NOTEFILE);
	chmod(0604, "$path/notes${dataname}${i}.txt");
}

# print the date and the number of the record to the file

open(LOGFILE, ">>${data_file1}");
print LOGFILE "$current_date|$i|";

# print all the other values to the file

for ($i = 1; $i < ($fieldnum - 1); $i++){
	print LOGFILE $cgi{"line$i"}, "|";
}

# if there are some unused fields in the file, print space between separators

for ($i = $fieldnum; $i < $max_num; $i++){
print LOGFILE " |";
}

# finally print the value of comment to the file

print LOGFILE "$comment_value|0|\n";

close(LOGFILE);

# display the HTML file to the user, make him feel good, and let him know
# that the submittion went fine.

print "Content-type: text/html\n\n";
	
&display_header("Thank You For Submitting the Form!");
print "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"7; URL=$url\">\n";
print "<font face=\"Arial, Helvetica, sans-serif\">\n";
print "<center><H2>Thank You For Using My Form on line!</H2><P>\n";
print "Your submission was <B>successful</B>.<P>\n";
print "Please wait for a couple of seconds, while I transfer you to my main page!</center>\n";
print "\n</font>\n<p>&nbsp;<p>\n\n";
&footer;
exit;
}

# if there is any error or missed field, display an error file.

sub myerror {

print "Content-type: text/html\n\n";

print <<EOF;
<html><head><title>Missing Field</title>\n</head>\n
<BODY BGCOLOR=\"$back_ground\" TEXT=\"$text_color\" BACKGROUND=\"$background\">
<center>\n<h1>Missing Field</h1>\n
<br>&nbsp;<br>
<font face=\"Arial\" size=\"2\" ><strong> Please make sure you fill in all fileds.<br>&nbsp;<br>If you wish to not enter any data inside a field please enter a dash -
<br>&nbsp;<br>You may close this window to return to the application form and complete all of the required information.<br>&nbsp;<br>Thank you.</font></strong>\n\n<form><BR>
\n\n<input type=button value=\"<< Go Back \" onClick=\"history.go(-1)\"></form>\n\n</center>\n\n<P>&nbsp;<P>\n

EOF
&footer;

        exit;
}

# funtion to get the date

sub get_date
  {
    
    local ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst,$date);   
    local (@days, @months);
    
    @days = ('Sunday','Monday','Tuesday','Wednesday','Thursday',
	     'Friday','Saturday');

    @months = ('Jan','Feb','Mar','Apr','May','Jun','Jul', 
	       'Aug','Sep','Oct','Nov','Dec');
    
    $time = time;
    
    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($time);
    
        if (( $date_format == 1 ) || ( $date_format == 3 )){
		# if the year was entered as two digits, we should convert it
		# to a 4 digit year.  Years from 51-99 are taken to be 1951 and
		# 1999.  Years from 00-50 are 2000 to 2050.
			   if ($year > 50 && $year < 1900) {
			       $year += 1900;
			   }
			   if ($year < 1900) {
			       $year += 2000;
		   }
	}
    
	if (($date_format == 2) ||  ($date_format == 3) || 
		($date_format == 4) || ($date_format == 5)){
 		if ($mday < 10 ){
				$mday = "0$mday";
			}
			if ($mon < 10 ){
				$mon = "0$mon";
			}
			if ($year < 10 ){
				$year = "0$year";
			}
		}
	
    $mon = ( $date_format == 5 ) ? $months[$mon] : ++$mon ;

    $date = (( $date_format == 1 ) || ( $date_format == 2 ) || ( $date_format == 3 )) ? "$mon\/$mday\/$year" : ( $date_format == 4 ) ? "$year\/$mon\/$mday" : ( $date_format == 5 ) ? "$mday\-$mon\-$year" : "$mon\/$mday\/$year" ;
    
    return $date;
  }

# display the end of the file.

sub footer
  {
	print qq~
<center>
<HR width=70%>
<p>
<font size=1>
<i>Copyright &copy; 1999 <a href=\"$siteurl\">$sitename</a>. All rights reserved.<br>
Please send your questions, comments, or bug reports to the 
<a href=\"mailto:$email_address\">$email_address</a>.</i></font></center>
</body>
</html>
~;

  }
  
  
# displays a header of the HTML file

sub display_header
  {
    local ($title) = @_;
	
	print qq~
	
<HTML>
<TITLE>$title</TITLE>
</HEAD>
<BODY BGCOLOR=\"$back_ground\" TEXT=\"$text_color\" BACKGROUND=\"$background\">
<p>\n
~;
  }