/* 
Filename:  formtest-3.c
(c) 1995 William E. Weinman
*/

#include <stdio.h>
#include <stdlib.h>
#include <cgiutils.h>  

/* this is the structure we use for the CGI variables */
struct {
    char name[128];
    char val[128];
} elements[16];

main(int argc, char ** argv)
{
char * ct; /* for content-type */
char * cl; /* for content-length */
int   icl; /* content-length */
char * qs; /* query string */
int rc;
int i;

/* send the MIME header first! */
printf("Content-type: text/plain\n\n");

printf("formtest-3.c\n");
printf("Form test report:\n\n");

/* grab the content-type and content-length 
   and check them for validity */

ct = getenv("CONTENT_TYPE");
cl = getenv("CONTENT_LENGTH");
if(cl == NULL)
  {
  printf("content-length is undefined!\n");
  exit(1);
  }
icl = atoi(cl);

/* do we have a valid query? */
if(strcmp(ct, "application/x-www-form-urlencoded"))
  {
  printf("I don't understand the content-type %s\n");
  exit(1);
  }
else if (icl == 0)
  {
  printf("content-length is zero\n");
  exit(1);
  }

/* allocate memory for the input stream */
if((qs = malloc(icl + 1)) == NULL)
  {
  printf("cannot allocate memory, contact the webmaster\n");
  exit(1);
  }

if((rc = fread(qs, icl, 1, stdin)) != 1)
  {
  printf("cannot read the input stream (%d)! Contact the webmaster\n", rc);
  exit(1);
  }
qs[icl] = '\0';

/* split out each of the parameters from the 
   query stream */
for(i = 0; qs[0] != '\0'; i++) 
  {
  /* first divide by '&' for each parameter */
  splitword(elements[i].val, qs, '&');
  /* convert the string for hex characters and pluses */
  unescape_url(elements[i].val);
  /* now split out the name and value */
  splitword(elements[i].name, elements[i].val, '=');
  }

printf("Variables:\n\n");

/* print 'em all out */
for(i = 0; elements[i].name[0]; i++)
  printf("%s=%s\n", elements[i].name, elements[i].val);
}



