#!/usr/bin/perl

# Buy & Sell CGI
# Copyright (c) 1996, M.A. Computers, All Rights Reserved.
# 
# Permission denied to use or modify this script, other then
# by M.A. Computers, or by written permission.
#
# Created by Mike Andras           Version 1.0.9
#
# Created on: 5/10/96      	   Last Modified: 6/10/96
#
# Licensed for Gemini Web Productions    License #: 9564
#
#############################################################################
# Set Variables > Category Specific

# Sysop Setting 1.2.2 + Only
$sysop = "mandras";
$password = "access";

# Set Your Options:
$date_command = "/bin/date";

$mail = 1;              # 1 = Yes 0 = No
$uselog = 1;            # 1 = Yes 0 = No
$linkmail = 1;          # 1 = Yes 0 = No
$separator = 1;         # 1 = <hr> 0 = <p>
$redirection = 0;       # 1 = Yes 0 = No
$entry_order = 1;       # 1 = Newest entries added first.
                        # 0 = Newest Entries added last.
$remote_mail = 1;       # 1 = Yes 0 = No
$allow_html = 1;        # 1 = Yes 0 = No
$line_breaks = 0;	# 1 = Yes 0 = No

# If you answered 1 to $mail or $remote_mail you will need to fill out 
# these variables below:
$mailprog = '/usr/bin/mail';
$recipient = 'skypro@ctoronto.com';

# Done, One more config on line 82
#############################################################################


# Get the Date for Entry
$date = `$date_command +"%A, %B %d, %Y at %T (%Z)"`; chop($date);
$shortdate = `$date_command +"%D %T %Z"`; chop($shortdate);

# Get the input
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

# Split the name-value pairs
@pairs = split(/&/, $buffer);

foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);

   # Un-Webify plus signs and %-encoding
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/<!--(.|\n)*-->//g;

   if ($allow_html != 1) {
      $value =~ s/<([^>]|\n)*>//g;
   }

   $FORM{$name} = $value;
}

############################
# More Configuration Options

$category = $FORM{'category'};

$buysellurl = "http://www.ctoronto.com/beta/buysell/$category.html";
$buysellreal = "/usr/local/etc/httpd/htdocs/ctoronto/beta/buysell/$category.html";
$buyselllog = "/usr/local/etc/httpd/htdocs/ctoronto/beta/buysell/buysell-log.html";

# End of Configuration Options
############################

# Print the Blank Response Subroutines
&no_fill unless $FORM{'short'};
&no_fill unless $FORM{'realname'};
&no_fill unless $FORM{'email'};
&no_fill unless $FORM{'city'};
&no_fill unless $FORM{'state'};
&no_fill unless $FORM{'country'};
&no_fill unless $FORM{'price'};

# Begin the Editing of the BuySell File
open (FILE,"$buysellreal") || die "Can't Open $buysellreal: $!\n";
@LINES=<FILE>;
close(FILE);
$SIZE=@LINES;

# Open Link File to Output
open (BUYSELL,">$buysellreal") || die "Can't Open $buysellreal: $!\n";

for ($i=0;$i<=$SIZE;$i++) {
   $_=$LINES[$i];
   if (/<!--begin-->/) { 

      if ($entry_order eq '1') {
         print BUYSELL "<!--begin-->\n";
      }
   
      if ($line_breaks == 1) {
         $FORM{'desc'} =~ s/\cM\n/<br>\n/g;
      }

      print BUYSELL "<TABLE BORDER=2 WIDTH=95%>\n";      
      print BUYSELL "<TR>\n";
      print BUYSELL "<TD ALIGN=CENTER COLSPAN=2><FONT SIZE=+2>$FORM{'short'} - $FORM{'price'}</FONT></TD>\n";
      print BUYSELL "</TR>\n";
      print BUYSELL "<TR>\n";
      print BUYSELL "<TD><B>Name</B></TD>\n";
      print BUYSELL "<TD>$FORM{'realname'}</TD>\n";
      print BUYSELL "</TR>\n";
      print BUYSELL "<TR>\n";

      if($FORM{'telephone'}) {
      print BUYSELL "<TR>\n<TD><B>Telephone</B></TD>\n";
      print BUYSELL "<TD>$FORM{'telephone'}</TD>\n";
      }

      print BUYSELL "<TR>\n<TD><B>Email</B></TD>\n";
      print BUYSELL "<TD><A HREF=\"mailto:$FORM{'email'}\">$FORM{'email'}</A></TD>\n";
      print BUYSELL "</TR>\n";
      print BUYSELL "<TR>\n<TD><B>City and Province</B></TD>\n";
      print BUYSELL "<TD>$FORM{'state'}, $FORM{'city'}</TD>\n";
      print BUYSELL "\n";
      print BUYSELL "</TR>\n";
      print BUYSELL "<TR>\n<TD><B>Country</B></TD>\n";
      print BUYSELL "<TD>$FORM{'country'}</A></TD>\n";
      print BUYSELL "</TR>\n";

      if($FORM{'desc'}) {
      print BUYSELL "<TR>\n<TD><B>Description</B></TD>\n";
      print BUYSELL "<TD>$FORM{'desc'}</TD\n";
      print BUYSELL "</TR>\n";
      }

      print BUYSELL "<TR>\n<TD><B>Date and Time</B></TD>\n";
      print BUYSELL "<TD>$date</TD>\n</TR>\n</TABLE>\n";
      print BUYSELL "<br>\n";

      if ($entry_order eq '0') {
         print BUYSELL "<!--begin-->\n";

      }
  
   }
   else {
      print BUYSELL $_;
   }
}

close (BUYSELL);

# Log The Entry

if ($uselog eq '1') {
   &log('entry');
}


#########
# Options

# Mail Option
if ($mail eq '1') {
   open (MAIL, "|$mailprog $recipient") || die "Can't open $mailprog!\n";

   print MAIL "Reply-to: $FORM{'email'} ($FORM{'realname'})\n";
   print MAIL "Subject: Entry to Advertisement\n\n";
   print MAIL "-----------------------------------------------------------------------\n";
   print MAIL "There is a new entry in the Buy&Sell in the $category category:\n\n";
   print MAIL "------------------------------------------------------------------------\n";
   print MAIL "Name: $FORM{'realname'}\n";
   print MAIL "Email: $FORM{'email'}\nTelephone: $FORM{'telephone'}\n";
   print MAIL "From: City: $FORM{'city'} Prov.: $FORM{'state'} Cou.: $FORM{'country'}\n";
   print MAIL "Price: $FORM{'price'}\nShort Desc.: $FORM{'short'}\n";
   print MAIL "Long Desc: $FORM{'desc'}\n";
   print MAIL "------------------------------------------------------------------------\n";
   print MAIL " $date\n";
   print MAIL "-------------------------------------------------------------------------\n";

   close (MAIL);
}

if ($remote_mail eq '1') {
   open (MAIL, "|$mailprog $FORM{'email'} -w") || die "Can't open $mailprog!\n";

   print MAIL "To: $FORM{'email'}\n";
   print MAIL "From: $recipient\n";
   print MAIL "Subject: Entry to Buy'Sell in category, $category\n";
   print MAIL "Your entry has been added.\n\n";
   print MAIL "Here is your entry : Please make sure it is correct\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "Your name:  $FORM{'realname'}\n";
   print MAIL "Your telephone #:  $FORM{'telephone'}\n";
   print MAIL "Your email : $FORM{'email'}\n";
   print MAIL "Your city : $FORM{'city'}\n";
   print MAIL "Your state : $FORM{'state'}\n";
   print MAIL "Your country : $FORM{'country'}\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "Your asking price : $FORM{'price'}\n";
   print MAIL "Your short description : $FORM{'short'}\n";
   print MAIL "Your long description : $FORM{'desc'}\n";
   print MAIL "------------------------------------------------------\n";

   print MAIL "\n";
   print MAIL "Date: $date\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "If an ERROR has been made please let us know so we can\n";
   print MAIL "correct it\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "Your advetisment will run for about 30 days, please let\n";
   print MAIL "us know if your advertisment needs to be removed.\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "Thanks,\n";
   print MAIL "Mike Andras, (mandras@interlog.com)\n";
   print MAIL "M.A. Computers\n";  
   print MAIL "http://www.interlog.com/~mandras/mandras.html\n";
 
close (MAIL);
}

# Print Out Initial Output Location Heading
if ($redirection eq '1') {
   print "Location: $buysellurl\n\n";
}
else { 
   &no_redirection;
}

#######################
# Subroutines

sub no_fill {
   print "Content-type: text/html\n\n";
   print "<html><head><title>One or more fields empty</title></head>\n";
   print "<body><hr><center><h1>All mandatory fields need to be completed</h1><hr>\n";
   print "<h1>Please correct your entry<hr></h1></center>\n";
   print "<h3>You didn't fill out the following mandatory fields:<\h3>\n";
   print "<p><center><hr><h4>\n";

  if ($FORM{'short'}) {}
  else {
     print "Short description<p>\n"; 
          }

  if ($FORM{'realname'}) {}
  else {
       print "Realname<p>\n";
        }

  if ($FORM{'email'}) {}
  else {
      print "Email address<p>\n";
       }

  if ($FORM{'city'}) {}
  else {
       print "City<p>\n";
       }

  if ($FORM{'state'}) {}
  else {
        print "Province<p>\n";
        }

  if ($FORM{'country'}) {}
  else {
        print "Country<p>\n";
       }

  if ($FORM{'price'}) {}
  else {
        print "Price<p>\n";
       }

   print "</center></h4><hr>\n";

   # Log The Error
   if ($uselog eq '1') {
      &log('no_fill');
   }

   exit;
}


# Log the Entry or Error
sub log {
   $log_type = $_[0];
   open (LOG, ">>$buyselllog");

   if ($log_type eq 'entry') {
      print LOG "$ENV{'REMOTE_HOST'} - [$shortdate] - OK: User successfully added page<br>\n";
      print LOG "In Category: $category\n<br>";
      print LOG "Using the following agent: $ENV{'HTTP_USER_AGENT'}\n<br>";
   }
   elsif ($log_type eq 'no_fill') {
      print LOG "$ENV{'REMOTE_HOST'} - [$shortdate] - ERR: One or more fields missing<br>\n";
      print LOG "In Category: $category\n<br>";
      print LOG "Using the following agent: $ENV{'HTTP_USER_AGENT'}\n<br>";
   }
}

# Redirection Option
sub no_redirection {

   # Print Beginning of HTML
   print "Content-Type: text/html\n\n";
   print "<html><head><title>Thank You for Addding an Ad</title></head>\n";
   print "<body><center><h1>Here is your advertisment</h1>\n";

   # Print Response
   print "Your entry has been added to the Buy'Sell, in the $category category.<center><hr>\n";
   print "<H4>Here is what you have submitted:</H4><p>\n";
   print "<TABLE BORDER=2 WIDTH=95%>\n";      
   print "<TR>\n";
   print "<TD ALIGN=CENTER COLSPAN=2><FONT SIZE=+2>$FORM{'short'} - $FORM{'price'}</FONT></TD>\n";
   print "</TR>\n";
   print "<TR>\n";
   print "<TD><B>Name</B></TD>\n";
   print "<TD>$FORM{'realname'}</TD>\n";
   print "</TR>\n";
   print "<TR>\n";

   if($FORM{'telephone'}) {
   print "<TR>\n<TD><B>Telephone</B></TD>\n";
   print "<TD>$FORM{'telephone'}</TD>\n";
   }

   print "<TR>\n<TD><B>Email</B></TD>\n";
   print "<TD><A HREF=\"mailto:$FORM{'email'}\">$FORM{'email'}</A></TD>\n";
   print "</TR>\n";
   print "<TR>\n<TD><B>City and Province</B></TD>\n";
   print "<TD>$FORM{'city'}, $FORM{'state'}</TD>\n";
   print "\n";
   print "</TR>\n";
   print "<TR>\n<TD><B>Country</B></TD>\n";
   print "<TD>$FORM{'country'}</A></TD>\n";
   print "</TR>\n";

   if($FORM{'desc'}) {
   print "<TR>\n<TD><B>Description</B></TD>\n";
   print "<TD>$FORM{'desc'}</TD\n";
   print "</TR>\n";
   }

   print "<TR>\n";
   print "<TD><B>Date and Time</B></TD>\n";
   print "<TD>$date</TD>\n";
   print "</TR>\n";
   print "</TABLE>\n";
   print "<br>\n";

   # Print End of HTML
   print "<hr>\n";
   print "<a href=\"$buysellurl\">Back to the Buysell</a>\n";         
   print "- You may need to reload it when you get there to see your\n";
   print "entry.\n";
   print "</body></html>\n";

   exit;
}
