#!/usr/bin/perl
#
# access2.cgi
#     by Matt Kruse (mkruse@saunix.sau.edu)
#     7/20/95
#
# USAGE:  access2.cgi > access.html
#
#     This script will create a very cool graphical display of your
# access_log records for your WWW site.  It MUST be viewed with 
# Netscape 1.1 or later, since it requires the HEIGHT and WIDTH tags in
# the images.
#     It is designed for NCSA httpd 1.4 running on Linux with perl 4.036.
# If you are running a different server, the access_log will probably be
# different, and it won't work.
# If you are on a different OS, the `date` function below might give a
# different result, and it won't work.
# If you are using perl 5.0, I don't know if it will work or not :)
#
# THINGS TO CHANGE:
# =================

  $LOG="/usr/local/etc/httpd/logs/gold.com-access_log";

# This tells the script what to count as an access.  Including .gifs in
# your count will give inflated results.

  $include=".html .cgi .shtml .txt";

# Do you want a table border around the hour and date charts?  I prefer
# one, but you can comment out this line if you don't.

  $border="BORDER=3";

# ==========
# THAT'S IT!

# Create the search pattern
# -------------------------
$include=~ s/ /|/g; $include =~ s/\./\\\./g;
$include= '/' . $include . '/i';

# Open the access_log and read it
# -------------------------------
open (LOG,"$LOG");
while (<LOG>) { if (eval $include) { push(@lines,$_);} print STDERR ".";  };
close(LOG);

# Extract the data from each line of the log
# ------------------------------------------
$i=0; $currentdate="";
foreach (@lines) {
($site,$junk,$junk,$when,$junk,$junk,$page,$number,$bytes) = split;
$page=~ s/%7E/~/gi;  #annoying!
($date,$hour,$minute,$second)=split(':',$when);
$hour=~ s/^0//;

if ($date eq $currentdate) { $counter[$i]++; }
else { $i++; $currentdate=$date; $counter[$i]++; }

$checkdate=$date; $checkdate=~s|/|-|g; $checkdate=~ s/\[//g;
($firstdate) || ($firstdate=$checkdate);
($date,$month,$year)=split('/',$date);
$date=~ s/\[//;   $date =~ s/^0//;
if ($checkdays{$checkdate}) { $day=$checkdays{$checkdate}; }
else { $day=`date --date $checkdate`; 
       $day=(split(' ',$day))[0]; 
       $checkdays{$checkdate}=$day;   }
$day=~s/Sun/Sunday/;   $day=~s/Mon/Monday/;   $day=~s/Tue/Tuesday/;
$day=~s/Wed/Wednesday/;$day=~s/Thu/Thursday/; $day=~s/Fri/Friday/;
$day=~s/Sat/Saturday/;
# wow..talk about a big mess, eh?  It works...don't complain...

# Increment the totals
$days{$day}++;
$dates{$date}++;
$hours{$hour}++;
#$pages{$page}++;  # I was gonna do these, but I decided
#$sites{$site}++;  # that I didnt want to!
$totalbytes+=$bytes;
$date2{$when}++;
}

# Start writing the output
# ------------------------
print <<EOF;
<HTML>
<HEAD>  <TITLE>Access Log Statistics</TITLE>  </HEAD>
<BODY>
<H1 ALIGN=CENTER>Access Log Statistics</H1>

<H2>General Stats</H2>
<B>First access:</B> $firstdate <BR>
<B>Total Number of records:</B> $#lines <BR>
<B>Total Bytes transferred:</B> $totalbytes <BR>
<P><HR><P>
EOF

# Calculate Stats by Day
# ----------------------
# do not learn anything from the following.  it sucks! (but it works...)
$highest=0;
foreach $key (keys %days) {
 if ($days{$key} > $highest) { $highest=$days{$key}; }    }
foreach $key (keys %days) {
 $barsize{$key} = int(($days{$key} * 400) / $highest);     }
print "<H2>Stats by Day</H2>\n";
print "<TABLE>\n";
foreach $key (Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday) {
 print<<EOF;
<TR>
<TH ALIGN=RIGHT>$key:</TD>
<TD ALIGN=LEFT>
<IMG SRC="dot1.gif" HEIGHT=10 WIDTH=$barsize{$key}>
<I>$days{$key}</I>
</TD>
</TR>
EOF
 }
print "</TABLE>\n";
print "<P><HR><P>\n";

# Calculate stats by hour
# -----------------------
# cut n paste is wonderful...
$highest=0;
foreach $key (keys %hours) {
 if ($hours{$key} > $highest) { $highest=$hours{$key}; }    }
foreach $key (keys %hours) {
 $barsize{$key} = int(($hours{$key} * 250) / $highest);     }
print "<H2>Stats by Hour</H2>\n";
print "<TABLE $border>\n<TR>";
foreach $key (0..23) {
 ($barsize{$key} < 2) && ($barsize{$key}=2);
 print <<EOF;
<TD ALIGN=CENTER VALIGN=BOTTOM>
<I>$hours{$key}</I><BR>
<IMG SRC="dot2.gif" HEIGHT=$barsize{$key} WIDTH=10>
</TD>
EOF
 }
print "</TR>\n<TR>\n";
foreach $key (0..23) {
 print "<TH ALIGN=CENTER>$key</TH>\n"; }
print "</TR>\n</TABLE>\n <P><HR><P>\n";

# Calculate stats by Date
# -----------------------
$highest=0;
undef %barsize;
foreach $key (keys %dates) {
 if ($dates{$key} > $highest) { $highest=$dates{$key}; }    }
foreach $key (keys %dates) {
 $barsize{$key} = int(($dates{$key} * 250) / $highest);     }
print "<H2>Stats by Days of the Month</H2>\n";
print "<TABLE $border>\n<TR>";
foreach $key (1..31) {
 ($barsize{$key} < 2) && ($barsize{$key}=2);
 print <<EOF;
<TD ALIGN=CENTER VALIGN=BOTTOM>
<IMG SRC="dot3.gif" HEIGHT=$barsize{$key} WIDTH=10>
</TD>
EOF
 }
print "</TR>\n<TR>\n";
foreach $key (1..31) {
 print "<TH ALIGN=CENTER>$key</TH>\n"; }
print "</TR>\n</TABLE>\n <P><HR><P>\n";

# Calculate continuous stats
# --------------------------
# mom, are we almost done?
print <<EOF;
<H2>Continuous Stats</H2>
<I>(Accesses for each day as time goes by)</I><P>
EOF

$highest=0;
undef %barsize;
foreach (1..$#counter) { 
 ($counter[$_]>$highest) && ($highest=$counter[$_]); }
foreach (1..$#counter) {
 $barsize{$_} = int(($counter[$_] * 500) / $highest);     }
foreach (1..$#counter) {
 print<<EOF;
<IMG SRC="dot4.gif" WIDTH=$barsize{$_} HEIGHT=3><BR>
EOF
 }

# Print out my "give me credit" crap
# ----------------------------------
print <<EOF;
<P>
<HR>
<P ALIGN=CENTER><I>This output was generated by a script written by 
Matt Kruse<BR> 
(
<A HREF="mailto:mkruse@saunix.sau.edu">mkruse@saunix.sau.edu</A> - 
<A HREF="http://web.sau.edu/~mkruse/">http://web.sau.edu/~mkruse/</A> 
)<BR>
It is free, but please give credit where credit is due.<BR>
</I></P>
<HR WIDTH=85%>
<HR WIDTH=50%>
EOF

