#!/usr/local/bin/perl
############################################################################
#
#   Copyright 1999-2000 Phone.com, Inc.  All rights reserved.
#
#   Subject to the terms and conditions of the SDK License Agreement, 
#   Phone.com, Inc. hereby grants you the right to use the UP.SDK 
#   software and its related documentation.
#
#   The Phone.com name and logo and the family of terms carrying the "UP."
#   prefix are trademarks of Phone.com, Inc. All other brands and product 
#   names may be trademarks of the respective companies with which they 
#   are associated.
#
############################################################################

######################################################################
#
# Who am I
#
# The application reports all UP.Link related information
# available to an application through HTTP headers
#
# Key concepts illustrated include:
#	- Parsing HTTP header variables to read UP.Link information
# 
######################################################################

######################################################################
#
# SDK SAMPLE APPLICATION CONFIGURATION
#
# To configure this application to run on your system:
#
# 1. On Unix, change the first line of the file to use the 
#    path for the Perl interpreter on your system
#
# 2. On NT, verify that the .cgi file extension is mapped to
#    the Perl interpreter on your system or rename the file
#    extension to the default extension that is mapped to the
#    Perl interpreter on your system (e.g. .pl)
#
######################################################################

######################################################################
# AppUtils Loading and Configuration
######################################################################
push (@INC, "../apputils");

require 'DeckUtils.pl';

######################################################################
# State definitions
#
# main uses these definitions to determine next state
######################################################################
# Static states {state, deck}
%StaticStateArray = (
			 );

# Dynamic states {state, routine}
%DynamicStateArray = (
	"HOME", "whoami",
	"FAX", "faxInfo",
	"HTTP", "httpInfo",
	"PREFS", "prefsInfo"
	);


#Call the main function to begin execution
&main;

######################################################################
#
# main Function
#
# When a URL request is received, the application checks the value of
# NEXT to determine the next action. The next action may be to display
# a static WML deck or to execute a function to generate dynamic WML.
# This function implements this logic
#
# This function also reads the CGI variables into %cgiVars for the
# rest of the application to use
#
######################################################################
sub main
{
	# Parse the HTTP CGI variables into the associative array %cgiVars
	%cgiVars = &AppUtils::ParseCGIVars();

	# Get the next state and look it up
	$nextState = $cgiVars{"NEXT"};
	if( !defined($nextState) )	{
		$nextState = "HOME";
	}

	# Transition to the next state
	$deck = $StaticStateArray{$nextState};
	if( $deck ne "" ) {
		#Found a static deck to return for the NEXT state, just return it
		&AppUtils::OutputDeck($deck);
	}
	else {
		$subRoutine = $DynamicStateArray{$nextState};
		if ($subRoutine ne undef) {
			# Found a function to execute for the NEXT state, execute it
			# to generate dynamic WML
			&$subRoutine();
		}
		else {
			#Invalid NEXT state, return Error deck
			&AppUtils::ErrorExit("Invalid URL", "");
		}
	}
}

######################################################################
# whoami
#
# This function builds a deck with user, UP.Link and Device information
#
######################################################################
sub whoami
{

# Parse the User Agent string, it is usually of the form:
# User-Agent: UPG1 UP/4.0.4g
#
($upDevice, $upBrowserVersion) = split(/ /, $ENV{'HTTP_USER_AGENT'});
#($upBrowser, $upBrowserVersion) = split(/\//, $agentPart1);

#Retrieve the list of WML versions accepted
@accepts = split(/\,/, $ENV{'HTTP_ACCEPT'});
$hdmlVersion = "";
foreach (@accepts) {
	if (m/text\/x-hdml;version=(.*)/) {
		if ($hdmlVersion == "") {
			$hdmlVersion = $1;		
		} else {
			$hdmlVersion = $hdmlVersion . "," . $1;
		}
	}
}

$prefsURL = &AppUtils::HTTPEscapeString("whoami.cgi?NEXT=PREFS");

#Create a display card with the retrieved information
$DECK = 
'<wml>
	<card>
		<p>
		<select title="Who am I">
			<option onpick="#u">UP.Link</option>
			<option onpick="#d">Device</option>
			<option onpick="?NEXT=FAX">UP.Fax</option>
			<option>
			  <onevent type="onpick">
				<spawn href="device:home/pref?get=TZ;Alert" 
					 onexit="?NEXT=PREFS&amp;TZ=$(tz)&amp;ALERT=$(alert)">
				  <receive/>
				  <receive name="tz"/>
				  <receive name="alert"/>
				</spawn>
			  </onevent>
			  Prefs
			</option>
			<option onpick="?NEXT=HTTP">HTTP</option>
		</select>
		</p>
	</card>'
 .
	"<card id=\"u\" title=\"UP.Link Info\">
		<p mode=\"nowrap\">SubNo: $ENV{'HTTP_X_UP_SUBNO'}</p>
		<p mode=\"nowrap\">UP.Link: $ENV{'HTTP_X_UP_UPLINK'}</p>
	</card>
	<card id=\"d\" title=\"Device Info\">
		<p mode=\"nowrap\">SubNo: $ENV{'HTTP_X_UP_SUBNO'}</p>
		<p mode=\"nowrap\">Device: $upDevice</p>
		<p mode=\"nowrap\">Browser ver: $upBrowserVersion</p>
		<p mode=\"wrap\">Screen Chars(x,y): $ENV{'HTTP_X_UP_DEVCAP_SCREEN_CHARS'}</p>
		<p mode=\"wrap\">Screen Pixels(x,y): $ENV{'HTTP_X_UP_DEVCAP_SCREEN_PIXELS'}</p>
		<p mode=\"wrap\">Screen Depth: $ENV{'HTTP_X_UP_DEVCAP_SCREEN_DEPTH'}</p>
		<p mode=\"wrap\">M-Size: $ENV{'HTTP_X_UP_DEVCAP_EM_SIZE'}</p>
		<p mode=\"wrap\">Has Color: $ENV{'HTTP_X_UP_DEVCAP_HAS_COLOR'}</p>
		<p mode=\"wrap\">Soft keys: $ENV{'HTTP_X_UP_DEVCAP_NUM_SOFTKEYS'}</p>
		<p mode=\"wrap\">Softkey label size: $ENV{'HTTP_X_UP_DEVCAP_SOFTKEY_SIZE'}</p>
		<p mode=\"wrap\">Max Digest Size: $ENV{'HTTP_X_UP_DEVCAP_MAX_PDU'}</p>
		<p mode=\"wrap\">Immediate Alert Support: $ENV{'HTTP_X_UP_DEVCAP_IMMED_ALERT'}</p>
	</card>
</wml>";

&AppUtils::OutputDeck($DECK);

}


######################################################################
# faxInfo
#
# This function builds a deck to display the UP.Link's fax capabilities
#
######################################################################
sub faxInfo
{

$DECK = 
"<wml>
	
	<card id=\"f\" title=\"UP.Fax Info\">
		<p mode=\"nowrap\">Fax Limit: $ENV{'HTTP_X_UP_FAX_LIMIT'}</p>
		<p mode=\"wrap\">Fax accepts: $ENV{'HTTP_X_UP_FAX_ACCEPTS'}</p>
		<p mode=\"wrap\">Fax encodings: $ENV{'HTTP_X_UP_FAX_ENCODINGS'}</p>
	</card>
</wml>";

&AppUtils::OutputDeck($DECK);

}

######################################################################
# httpInfo
#
# This function builds a deck to display the UP.Link's HTTP related parameters
#
######################################################################
sub httpInfo
{

$DECK = 
"<wml>
	<card id=\"h\" title=\"HTTP Info\">
		<do type=\"accept\"><prev/></do>
		<p mode=\"wrap\">Accepts: $ENV{'HTTP_ACCEPT'}</p>
		<p mode=\"wrap\">Charset: $ENV{'HTTP_ACCEPT_CHARSET'}</p>
		<p mode=\"wrap\">Encoding: $ENV{'HTTP_ACCEPT_ENCODING'}</p>
		<p mode=\"wrap\">Language: $ENV{'HTTP_ACCEPT_LANGUAGE'}</p>
		<p mode=\"wrap\">Referer: $ENV{'HTTP_REFERER'}</p>
	</card>
</wml>";

&AppUtils::OutputDeck($DECK);

}

######################################################################
# prefsInfo
#
# This function displays the user's preferences saved in the UP.Link
#
######################################################################
sub prefsInfo
{

$PREFS_DECK = 
	"<wml>
	<card>
		<p mode=\"wrap\">Prefs:</p>
		<p mode=\"nowrap\">TZ:%s</p>
		<p mode=\"nowrap\">ALERT:%s</p>
	</card>
	</wml>";

&AppUtils::OutputDeck(sprintf($PREFS_DECK,$cgiVars{"TZ"},$cgiVars{"ALERT"}));

}

