#!/usr/local/bin/perl -w
#
# NCSA's htpasswd implemented in perl - extensions added to make it
#  smarter, do file-locking, ensure uniqueness, and others.
#
# TODO - add DBM functionality.
#
# File: htpasswd.pl
#
# Author: Nem W Schlecht
# Last Modification: $Date: 1996/05/09 18:00:29 $
#
# $Id: htpasswd.pl,v 1.1 1996/05/09 18:00:29 nem Exp nem $
# $Log: htpasswd.pl,v $
# Revision 1.1  1996/05/09 18:00:29  nem
# Initial revision
#
#

my($me)=(split(/\//,$0))[-1];	    # grab our name
$0="htpasswd";			    # hide ourself (in case password on c.l.)

require 5.002;
use Getopt::Long;
use POSIX;

GetOptions(qw(dir:s userid:s passwd:s twice debug noecho htaccess:s writeover
	      help));

my($auth_file,$grp_file,$already_here);
usage() if (!$opt_userid);
$opt_dir = $opt_dir||".";
$opt_htaccess = $opt_htaccess||".htaccess";
my($junk);

#
# Set up terminal if necessary
if (!($opt_passwd) && $opt_noecho) {
    $t = POSIX::Termios->new();
    $t->getattr();
    $term_orig = $t->getlflag();
}

print "AccessF: $opt_dir/$opt_htaccess\n" if ($opt_debug);
open(HTA_F, "$opt_dir/$opt_htaccess");
read_lock('HTA_F');
while (<HTA_F>) {
    chomp;
    ($junk,$auth_file)=split(' ',$_) if (/^AuthUserFile/o);
    ($junk,$grp_file)=split(' ',$_) if (/^AuthGroupFile/o);
}
clr_lock('HTA_F');
close(HTA_F);

print "AuthF: $auth_file\n" if ($opt_debug);
print "GroupF: $grp_file\n" if ($opt_debug);

#
# Read in password file
my(%users);
open(AC_FILE, "$auth_file");
read_lock('AC_FILE');
while (<AC_FILE>) {
    chomp;
    my(@info)=split(/:/,$_);
    $users{$info[0]}=$info[1];
    print "adding $info[0]\n" if ($opt_debug);
}
clr_lock('AC_FILE');
close(AC_FILE);

if ($users{$opt_userid}) {
    if (!$opt_writeover) {
	print "No overwrites allowed\n";
	exit(-1);
    } else {
	$already_here = 1;
        print STDERR "WARNING - User $opt_userid already existed (overwritten)!\n";
    }
}

# random seed
srand($$^time&$ENV{RANDOM});
#srand($$^time);

my($pass,$pass2);

# prompt for password and read in
if (!$opt_passwd) {
    echo_off() if ($opt_noecho);
    print "Enter passwd: ";
    chop($pass=<STDIN>);
    #  If you want to make sure, promt again
    if ($opt_twice) {
	print "\nEnter again: ";
	chop ($pass2=<STDIN>);
	if ($pass ne $pass2) {
	    print "\nPassword mismatch!\n";
	    exit(-2);
	}
    }
    if ($opt_noecho) {
	echo_on();
	print "\n";
    }
} else {
    $pass=$opt_passwd;
}

my($salt) = seedchar().seedchar();
print "Salt: $salt\n" if ($opt_debug);
print "Pass: $pass\n" if ($opt_debug);
$users{$opt_userid}=crypt($pass,$salt);
print "Auth: $opt_userid:", $users{$opt_userid}, "\n" if ($opt_debug);

#
# Add user to auth file
my($user,$passwd);
open(AC_FILE, ">$auth_file");
write_lock('AC_FILE');
while (($user,$passwd)=each(%users)) {
    print AC_FILE "$user:$passwd\n";
    print "re-writing $user:$passwd\n" if ($opt_debug);
}
clr_lock('AC_FILE');
close(AC_FILE);

#
# Add user to group file
if (!$already_here) {
    open(GP_FILE, "+<$grp_file");	    # better than >>
    write_lock('GP_FILE');
    seek(GP_FILE,-1,2);		    # back up before newline
    print GP_FILE " $opt_userid\n";	    # print it
    print "Group: $opt_userid\n" if ($opt_debug);
    clr_lock('GP_FILE');
    close(GP_FILE);
}

# usage and help
sub usage {
    print "usage $me: --userid USERID [OPTION]\n";
    print "\t--dir directory        the current directory is used by default\n";
    print "\t--passwd password      pass password on command line (insecure)\n";
    print "\t--twice                ask for the password twice\n";
    print "\t--noecho               don't echo characters to the screen\n";
    print "\t--htaccess file        the htaccess file, .htaccess by default\n";
    print "\t--writeover            overwrite entries that are already there\n";
    print "\t--debug                print out some debugging information\n";
    print "\t--help                 this message :-)\n";
    exit();
}
    
#
# File locking defines
sub LOCK_SH { 1; }
sub LOCK_EX { 2; }
sub LOCK_NB { 4; }
sub LOCK_UN { 8; }

#
# Shared lock on a file - flock() should be okay everywhere (see perlfunc)
sub read_lock {
    my($fh)=shift;
    my($rc);
    print "  SH_LOCKing $fh\n" if ($opt_debug);
    $rc = flock($fh, LOCK_SH());
    print STDERR "  read_lock flock failed - $rc\n" if ($opt_debug && !$rc);
    return $rc;
}

sub write_lock {
    my($fh)=shift;
    my($rc);
    print "  EX_LOCKing $fh\n" if ($opt_debug);
    $rc = flock($fh, LOCK_EX());
    print STDERR "  write_lock flock failed - $rc\n" if ($opt_debug && !$rc);
    return $rc;
}

sub clr_lock {
    my($fh)=shift;
    my($rc);
    print "  UN_LOCKing $fh\n" if ($opt_debug);
    $rc = flock($fh, LOCK_UN());
    print STDERR "  clr_lock flock failed - $rc\n" if ($opt_debug && !$rc);
    return $rc;
}

sub seedchar {  # from Randal Schwarz
    ('a'..'z','A'..'Z','0'..'9','.','/')[rand(64)];
}

sub END {
    echo_on() if (!($opt_passwd) && $opt_noecho);
    print "Goodbye\n" if ($opt_debug);
}

sub echo_off {
    my($echo) = (&POSIX::ECHO|&POSIX::ECHOK);
    $no_echo = $term_orig;
    $no_echo &= ~$echo;
    $t->setlflag( $no_echo );
    $t->setattr( 0, &TCSANOW);
}

sub echo_on {
    $t->setlflag( $term_orig );
    $t->setattr( 0, &TCSANOW);
}
