#!/bin/sh
#
# BIG BROTHER WEB BASED HISTORY STATUS LOG DISPLAY SCRIPT
# Robert-Andre Croteau
# Version 1.4
# Mar 05th, 2000
#
# This program is Copyright (c) 1997-2000
# The MacLawran Group Inc.
# All Rights Reserved
#
# Bits also from Nick Metrowsky <nmetro@colorado.edu>, thanks Nick !
#

# BBHOME IS THE ROOT DIRECTORY OF BIG BROTHER!!!
# YOU MUST SET THE NEXT LINE TO WHERE BB LIVES
BBHOME="/export/home/bb/bb"
export BBHOME

if [ "$BBHOME" = "" -o ! -d "$BBHOME" ]
then
        echo "Content-type: text/html


                <HTML><BODY>
                <H1>ERROR!<BR>BBHOME IS NOT SET IN bb-histlog.sh</H1></BODY>
                </HTML>"
        exit 1
fi

. $BBHOME/etc/bbdef.sh

# Are we called from a web page ?
if [ "$QUERY_STRING" != "" ]
then

    HISTFILE="HISTFILE_NOT_DEFINED"
    set `echo $QUERY_STRING | $SED 's/[&=]/\ /g' | $SED 's/%2C/,/g'`
    while [ "$#" -ne 0 ]
    do
	# echo "$# $*" >> /tmp/YYY
        case $1 in
	TIMEBUF )
		TIMEBUF=$2
		shiftnum=2
		;;
	HOST )
		HOST=$2
		shiftnum=2
		;;

	SERVICE )
		SERVICE=$2			
		shiftnum=2
		;;
	*)
		shiftnum=1
		;;
	esac
	if [ "$#" -lt "$shiftnum" ]
	then
		shift
	else
		shift $shiftnum
	fi
    done

    HOST=`echo "$HOST" | $SED 's/\.\.//g'`
    SERVICE=`echo "$SERVICE" | $SED 's/\.\.//g'`
    if [ "$HOST" = "" -o "$SERVICE" = "" -o "$TIMEBUF" = "" ]
    then
    	echo "Content-type: text/html

		
		<HTML><BODY>
		<H1>ERROR!<BR>bb-histlog.sh called with invalid arguments</H1>"

	echo "HOST: [$HOST] - SERVICE: [$SERVICE] - TIMEBUF: [$TIMEBUF]<BR>"
        echo "</BODY></HTML>"   
	exit 1
    fi
fi

# Take the basename only !!!
# Make sure nobody's playing games
OLDIFS=$IFS
IFS='/'
set $HOST
HOST=$1
set $SERVICE
SERVICE=$1
IFS=$OLDIFS

HOSTDOTS=$HOST
HOSTCOMMAS=`echo "$HOST" | $SED 's/\./,/g'`
HOST=`echo "$HOST" | $SED 's/\./_/g'`
FNAME="$TIMEBUF"
LOGTIME=`echo "$TIMEBUF" | $SED 's/_/ /g'`
export LOGTIME

FILENM=${HOSTCOMMAS}.${SERVICE}
TMPFILE=/tmp/$FILENM

if [ "$BBHOME/www/histlogs/$HOST/$SERVICE" = "$BBHOME/www/histlogs//" -o ! -d "$BBHOME/www/histlogs/$HOST/$SERVICE" -o ! -r "$BBHOME/www/histlogs/$HOST/$SERVICE/$FNAME" ]
then
	echo "red `date` <BR><CENTER>Historical status log not available</CENTER>" > $TMPFILE
else
	$CP -p "$BBHOME/www/histlogs/$HOST/$SERVICE/$FNAME" $TMPFILE
fi

cd /tmp

echo "Content-type: text/html

"

$BBHOME/bin/dumphostsvc $FILENM histlog

$RM -f $TMPFILE

exit 0
