#!/usr/local/etc/stronghold/python/bin/python

#
# We are just a 'front-end' for the confserver. Get the query string
# from the cgi module, then make a 'GET' request to the server for
# whatever they wanted. Ship the response back....
#
__version__ = "$Revision: 1.1.1.2 $"
# $Source: /export/cvs/sh-uk/confsrvr/cgi-bin/config.py,v $

import httplib
import cgi
import binascii
import string
import os
import sys

sys.stderr = sys.stdout  # redirect errors to the browser...

# run options first so we don't have to wait just to know that our command line
# is invalid.

from regsub import gsub

relLibPath = 'confsrvr/lib'  # path from stronghold root to the lib directory

if __name__=='__main__':
    #
    # If the library is not on PYTHONPATH (which it might not be for NT, MacOS, ...)
    # we need to check the command line/user respectively...
    #
    # first try the command line....
    #
    for i in range(1,len(sys.argv)):  # scan sys.argv for '-s'
	item = sys.argv[i]
	if item[:2] == '-s' or item[:3] == '--s':
	    #
	    # we have a potential root stronghold path
	    #
	    if len(sys.argv) > (i+1):
		item = sys.arv[i+1]
		if item[-1] != os.sep:     # check for trailing separator
		    item = item + os.sep
		#
		# OK... put in the os dep. separator and include the
		# lib dir in the python path....
		#
		sys.path.insert(0,item + gsub('/',os.sep,relLibPath))

    if os.environ.has_key('SIOUX_STRONGHOLDROOT'):  # check environ...
	item = os.environ['SIOUX_STRONGHOLDROOT']
	sys.path.insert(0,item + gsub('/',os.sep,relLibPath))

    import SiouxOptions   

    so = SiouxOptions.SiouxOptions()
    so.getopt(sys.argv)

so = SiouxOptions.SiouxOptions()
so.getopt(sys.argv)

f = open(so.localAuth,so)
localAuthList = f.readlines()
f.close()

localAuth = string.strip(localAuthList[0])

if os.environ.has_key('REQUEST_METHOD'):
    form = cgi.FormContentDict()
    qs = os.environ['QUERY_STRING']
    qs = string.strip(qs)
else:
    qs = ""

h = httplib.HTTP('localhost',string.atoi(so.netPort))
h.putrequest('GET','/cgi-bin/config.py?' + qs)
h.putheader('Content-Length',`len(qs)`)
h.putheader('Accept','text/html')
h.putheader('Authorization','Basic ' + binascii.b2a_base64(localAuth))
h.endheaders()
errcode, errmsg, headers = h.getreply()

if errcode == 200:
    f = h.getfile()
    print f.read()
else:
    print "Content-Type: text/html\n"
    print "<H1> Error talking to ConfServer </H1>"
    print "<br> Errorcode = ",errcode," <br> "
    print "<pre> Message = ", message ,". </pre>"
    
