#include <stdio.h>
#include <stdlib.h>
#include <utmp.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include "latool.h"

/*
 * AUTHOR: Charles C. Bundy IV
 * VERS  : $Id$
 *
 * Takes a given Unix user name and the unix login 
 * accounting file (which cooresponds to 'wtmp' 
 * format) and builds a complete record of login/
 * logouts including accumulated time statistics.  
 * A 'logout' is considered a usual blank wtmp 
 * entry for the corresponding ptty, OR a shutdown 
 * entry.
 */

int check (loginID, LogFile)
char *loginID, *LogFile;
{
FILE *fp;
struct utmp record[NUMREC];
time_t *clock;
time_t OnTime, AccTime;
int i,j,k;
char *ID;

   fp = fopen(LogFile, "r");

   if (fp == NULL)
   {
      printf("<b>\n*\n*");
      printf(" ERROR: couldn't open \"%s\" for read",
               LogFile);
      printf("\n*\n</b>");
      return -1;
   }
   
   i = 0;
   while ((!feof(fp)) && (i < NUMREC))
   {
      fread((char *)&record[i], 
            sizeof(record[0]), 1, fp);
      if (strlen(record[i].ut_host) > 18)
         record[i].ut_host[17] = '\0';
      i++;
   }
   fclose(fp);

   if (i >= NUMREC)
   {
      printf("<b>*\n* WARNING: Only read %d", NUMREC);
      printf(" records for log file %s.\n", LogFile);
      printf("*\n</b>\n");
   }
      
   AccTime = 0;

   printf("Login/Logout Statistics for: <b>%s</b><hr>", 
          loginID);

   for (j=0; j<i; j++)
   {
      if (strcmp(loginID,record[j].ut_name) == 0)
      {
         clock = &(record[j].ut_time);
         printf("%10s :%10s :%18s :%s", 
                 record[j].ut_line, record[j].ut_name,
                 record[j].ut_host, ctime(clock));

         for (k=j+1; k<i; k++)
            if ((strcmp(record[j].ut_line, 
                        record[k].ut_line) == 0) ||
                (strcmp("~", record[k].ut_line) == 0))
            {
               clock = &(record[k].ut_time);
               printf("%10s :%10s :%18s :%s", 
                           record[k].ut_line, 
                           record[k].ut_name, 
                           record[k].ut_host,
                           ctime(clock));
               OnTime = record[k].ut_time - 
                        record[j].ut_time;
               AccTime = AccTime + OnTime;
               printf("OnTime: %ld hours", OnTime/3600);
               printf(" %ld minutes", (OnTime%3600)/60);
               printf(" %ld seconds.\n", OnTime%60);
               break;
            }
      }
   }
   printf("<HR>");
   printf("Total Time Online: %ld hours",AccTime/3600);
   printf(" %ld minutes", (AccTime%3600)/60);
   printf(" %ld seconds.\n", AccTime%60);

   ID = "$Id$";
   return 0;
}
