#!./perl

require "common.pl";

$datafile = "data/datafile";
$prefix = "/login/riviera/floorplans";
parse_form_data(*info);

$stype = $info{'type'};
$sbedrooms = $info{'bedrooms'};
$shigh = $info{'high'};
$slow = $info{'low'};

chomp $shigh;

# Process the high and low values

if ($shigh =~ /No/) {
	$shigh = 1000000;
}
if ($slow =~ /No/) {
	$slow = 0;
}
$shigh =~ s/[\$,]//g;
$slow =~ s/[\$,]//g;

if ($sbedrooms eq "Bachelor") {
	$uroom = 0;
}
elsif ($sbedrooms eq "One") {
	$uroom = 1;
}
elsif ($sbedrooms eq "One+Den") {
	$uroom = 2;
}
elsif ($sbedrooms eq 'Two') {
	$uroom = 3;
}
elsif ($sbedrooms eq 'Two+Den') {
	$uroom = 4;
}
else {
	$uroom = -1;
}

if ($stype eq "Any") {
	$utype = -1;
}
html_pragma("Search Results");
print "<hr><table border=0><tr><th>Suite</th><th>Type</th><th>Price</th>";
$item=0;
dbmopen (%DATAFILE, $datafile, 0444) || not_valid;
	for $number (sort keys %DATAFILE) {
		$match = 1;
		($floor, $suite, $type, $bedrooms, $price, $size, $fee, $taxes, $status, $view)
			=split(/\t/, $DATAFILE{$number});
		if ($utype != -1) {
			if ($stype eq $type) {
				$match = 1;
			}
			else { $match = 0; }
		}
		if ($uroom != -1) {
			if ($uroom == $bedrooms) {
				$match = 1;
			}
			else { $match = 0; }
		}
		if ($slow ne "") {
			if (($slow <= $price)&&($match == 1)) {
				$match = 1;
			}
			else { $match = 0; }
		}
		if ($shigh ne "") {
			if (($shigh >= $price)&&($match == 1)) {
				$match = 1;
			}
			else { $match = 0; }
		}
		if (($match == 1)&&($status != 1)) {
			if ($item == 0) {
				print "</tr><tr bgcolor=\"#a0a0a0\">\n";
			}
			else {
				print "</tr><tr bgcolor=\"#f0f0f0\">\n";
				$item = -1;
			}
			$putsmfloor = $prefix."/smfloor".$floor.".html";
			$putsuites = $prefix."/suites".$floor.".html";
			print "<td><a href=\"$prefix/$number.html\""; 
			print " OnClick=\"mainwindow=window.open('','mainwindow')\;mainwindow.focus();mainwindow.LoadFromMain('$putsmfloor','$putsuites')\" target=\"mainframe\">\n";
			print "$number</td>";
			print "<td>$type</td>";
			print "<td>$price</td>";
			$match = 0;
			$item++;
		}
	}
	print "</tr></table>";
dbmclose(DATAFILE);
print "<br><center><a href=\"javascript:history.back()\">Return to Search</a>\n";
html_trailer;


