#!./perl

require "common.pl";

# Set the constants

$datafile = "data/datafile";
$prefix = "/login/riviera/floorplans";

# Get the info and parse

parse_form_data(*info);

$suite = $info{'suite'};

# open the database and get data for suite

dbmopen (%DATAFILE, $datafile, 0444) || not_valid;
	($floor, $number, $type, $bedrooms, $price, $size, $fee, $taxes, $status, $view)
		=split(/\t/, $DATAFILE{$suite});
dbmclose (%DATAFILE);

# Generate the html
$suitetype = gentype($type);
$availcheck = "";
$soldcheck = "";
$ysoldcheck = "";

if ($status == 0) {
	$availcheck = "checked";
}
elsif ($status == 1) {
	$soldcheck = "checked";
}
else {
	$ysoldcheck = "checked";
}


html_pragma ("Modify Suite $suite");
print <<END_CODE;
<hr>
<form method="post" action="domodinfo.pl">
<table>
<tr>
	<td><b>Type</b></td>
	<td>$suitetype</td>
</tr>
<tr>
	<td><b>Price</b></td>
	<td><input tyep="text" name="price" value="$price"></td>
</tr>
<tr>
	<td><b>Size</b></td>
	<td><input type="text" name="size" value="$size"></td>
</tr>
<tr>
	<td><b>Com Exp</b></td>
	<td><input type="text" name="fee" value="$fee"></td>
</tr>
<tr>
	<td><b>Taxes</b></td>
	<td><input type="text" name="taxes" value="$taxes"></td>
</tr>
<tr>
	<td><b>Status</b></td>
	<td><input type="radio" name="status" value=0 $availcheck>
	<img src="$prefix/avail.gif">
	<input type="radio" name="status" value=1 $soldcheck>
	<img src="$prefix/sold.gif">
	<input type="radio" name="status" value=2 $ysoldcheck>
	<img src="$prefix/ysold.gif">
	</td>
</tr>
</table>
<center>
<input type="hidden" name="floor" value="$floor">
<input type="hidden" name="number" value="$number">
<input type="hidden" name="bedrooms" value="$bedrooms">
<input type="hidden" name="itype" value="$type">
<input type="hidden" name="view" value="$view">
<input type="submit" value="Make the Changes">
</center>
</form>
END_CODE
html_trailer;

