#!/usr/bin/perl

require "common.pl";
# Constants

$datafile="/data/datafile";
$prefix="/landagents/dev";

parse_form_data(*info);

$suite = $info{'suite'};

# Get the data from file

dbmopen (%DATAFILE, $datafile, 0666) || not_valid;
	$record = $DATAFILE{$suite};
	($floor, $number, $type, $price, $size, $fee, $taxes, $status)
		= split (/\t/, $record);
dbmclose(DATAFILE);
$perfoot = $price/$size;

if ($status == 1) {
	$price="<img src=\"$prefix/sold.gif\">";
	$perfoot = "N/A";
}
elsif ($status != 0) {
	$price="<img src=\"$prefix/ysold.gif\">";
	$perfoot = "N/A";
}

html_output("Price Info");
print <<END_CODE;
<table>
<tr bgcolor="#f0f0f0">
	<td>Suite</td>
	<td>Model</td>
	<td>Price</td>
	<td>Size</td>
	<td>Fee</td>
	<td>Taxes</td>
	<td>\$/sf</td>
</tr>
<tr bgcolor="#a0a0a0">
	<td>$number</td>
	<td>$type</td>
	<td>$price</td>
	<td>$size</td>
	<td>$fee</td>
	<td>$taxes</td>
END_CODE
if ($perfoot ne 'N/A') {
	printf "<td>%4.2f</td>", $perfoot;
}
else {
	print "<td>$perfoot</td>";
}
print <<END_CODE;
</tr>
</table>
END_CODE
html_trailer;


