#!/usr/bin/perl
# handle user entered comments on a web page
# (c) 1996 David Macfarlane
# 1.0 generalized to have file refs in the .html file
# 1.1 edit out html code in comments, and limit the
#     number of comments on a page
require "cgi-lib.pl";
require "ctime.pl";

&ReadParse(*cgi);

$results = &PrintVariables(%cgi);
$filecur = $cgi{'file1'};
$filenew = $cgi{'file2'};
$myurl = $cgi{'myurl'};

# maximum number of entries to bring from previous html page
# note that there will be $maxentries + 1 entries on the
# final page
$maxentries = 5;

# Test here for no comment.  You can either test for the
# existance of a string you put in the form and want the
# user to delete, or you can leave the field empty in the
# form and test to see if there is anything in the string.
# The latter is what we do here.

if(length($cgi{'comments'}) < 1){
        # -- send reply back to user
        printf("%s", &PrintHeader);
        print <<EOF;
<H2>You didn't put in a comment</H2>
<P>You didn't put any comment in the comment field.
<p>
Use the "Back" button or command in your Web browser to
go back to that page and type your comments.
When you have finished typing and editing
your comments, hit the
'CHAT' button.</P>
<hr>
EOF
        exit(0);
}

printf("%s", &PrintHeader);

# -- open the files
open(NEW, ">$filenew")||
        die "<H1>Can't create new file ($filenew)</H1>\n";
open(OLD, "<$filecur") ||
        die "<H1>Can't open old file ($filecur)</H1>\n";

# -- read old file up to the start of the comments
while(<OLD>){
        if(!m#<DL#){
                printf(NEW "%s", $_);
        } else {
                printf(NEW "%s", $_);
                last;
        }
}

# -- read old file up to the end of the comments
$date = "no date";
while(<OLD>){
        if(!m#/DL#){            # this is the last line we want now
                $line = $_;     # so we are explicit about what we
                                # are operating on
                # clean out all html that is not an anchor
                # by substituting the < and > for the escaped versions
                if($line =~ /<p><dt>/io){
                        $i++;
                        if($i > $maxentries){
                                $wrapped = 1;
                                $i = 1;		# $i == 0 not used
                        }
                        $body[$i] = $line;
                } else {
                        $body[$i] .= $line;
                }
        } else {
                last;
        }
}

# -- put out the last $maxentries comments

if(!$wrapped){
        for($j = 1; $j <= $i; $j++){
                printf(NEW "%s", $body[$j]);
        }
} else {
        for($j = $i + 1; $j <= $maxentries; $j++){
                printf(NEW "%s", $body[$j]);
        }
        for($j = 1; $j <= $i; $j++){
                printf(NEW "%s", $body[$j]);
        }
}

# -- figure out date
$Date = &ctime(time);
# --- insert new comments
printf(NEW "<P><DT>$Date --- $cgi{'subject'}");
if($cgi{'name'}){
        printf(NEW "  ($cgi{'name'})\n");
}

# -- take out all html code except <a ...> and </a>
# note that a syntax error in a <a ...> (like typing
# <a href="something>) will screw up the rest of the page
# If you don't want any html, comment out the two
# lines below that put back </a> and <a ...>

# take them all out
$cgi{'comments'} =~ s/<([^>]*?)>/&lt;$1&gt;/g;
# put back </a>
$cgi{'comments'} =~ s/&lt;\/a&gt;/<\/a>/g;
# put back <a ...>
$cgi{'comments'} =~ s/&lt;a([^&]*?)&gt;/<a$1>/g;

printf(NEW "<DD><i>$cgi{'comments'}</i>\n");
printf(NEW "</DL>\n");
# -- drop in rest of old file
while(<OLD>){
        printf(NEW "%s", $_);
}
# -- clean up
close(OLD);
close(NEW);
rename("$filenew", "$filecur");
chmod 0666, $filecur;

# -- send reply back to user
printf("<H2>Thank you.</H2>");
printf("<P>Your comments have been added to the discussion.</P>\n");
printf("<A HREF=\"$myurl\">\n");
printf("<IMG SRC=\"http://www.tlcplus.com/tlc_small.jpg\">");
printf("Back to previous page</A>\n");
printf("<HR>\n");

exit 0;
