#include <stdio.h>
#include <sys/utsname.h>
#include <sys/types.h>
#include "latool.h"

/*
 * AUTHOR: Charles C. Bundy IV
 * VERS  : $Id$
 *
 * fillitForm() 
 * This guy gets called the first time the CGI program 
 * "latool" is called.  It builds the html user 
 * interface which allows the "latool" user to select 
 * a login name.  "latool" is specified as the FORM 
 * ACTION so the way it differentiates between inital 
 * instantiation and POST is to check for the CGI 
 * environment variable CONTENT_LENGTH in 'main()'.
 */

void fillitForm(LogFile)
char *LogFile;
{
struct utsname buf;
char *RCSID;
       
   uname(&buf);

   printf("<html>\n");
   printf("<head>\n");
   printf("<title>Unix SysAdmin Tool</title>\n");
   printf("</head>\n");
   printf("<body background=\"%s\">\n", BACK_URL);
   printf("<h1><img src=\"%s\"></h1>\n", LOGO_URL);

   printf("<hr>\n");
   printf("This little gem lets you easily track ");
   printf("login and logout activity of your users\n");
   printf("for accounting purposes.  Selecting a ");
   printf("user name and clicking on the submit\n");
   printf("button will return an activity list for "); 
   printf("the entire audit file.<p>\n");
   printf("<FORM ACTION=\"%s\" METHOD=POST>\n",ACTION_URL);
   printf("<pre>\n");
   printf("<b>Machine          Log File             ");
   printf("Login ID</b>\n");
   printf("%-15s  %-20s ", buf.nodename, LogFile);
   seluser("/etc/passwd");
   printf("  <INPUT TYPE=\"submit\"");
   printf(" VALUE=\"Submit\">\n");
   printf("</pre>");
   printf("</FORM>\n");
   printf("<HR>\n");
   printf("<em><b>Author:</b> Charles C. Bundy IV");
   printf(" ccb8m@virginia.edu</em>\n");
   printf("</body>\n");
   printf("</html>\n");

   RCSID = "$Id$";
}
