#!/usr/local/bin/perl -w

######################################################################
# AppUtils Loading and Configuration
######################################################################
# Include the apputils directory which has all the SDK utilities
BEGIN { push (@INC, "../apputils");	} # Path to SDK apputils

# Load required application utilities
require 'DeckUtils.pl'; # Just for parsing of HTTP QUERY_STRING

######################################################################
# Cookie Retrieval
######################################################################

# Split each cookie pair out of the header string
#
@nvpairs=split(/[,;] */, $ENV{'HTTP_COOKIE'});

# To extract the value from a specific cookie:
#
foreach $pair (@nvpairs) {
   ($name, $value) = split(/=/, $pair);
   $cookie{$name} = $value;
}


#
# Parse the CGI Vaiables
#
%cgiVars = &AppUtils::ParseCGIVars();

#
# WML DECKS FOLLLOW
#
#
# The XML Prologue and WML DTD
#
$header= '<? xml version="1.0" ?>
<!DOCTYPE wml PUBLIC "-//PHONE.COM//DTD WML 1.1//EN" "http://www.uplanet.com/DTD/wml.xml">
';

#
# This deck resets the name variable when loaded.
# It takes user input and passes it back to this script via QUERY_STRING
#
$deckOne= '
<wml>
  <card>
  <onevent type="onenterforward">
   <refresh>
    <setvar name="name" value=""/>
   </refresh>
  </onevent>
  <do type="accept" label="go">
   <go href="?NEXT=two&amp;name=$name"/>
  </do>
  <p>
   Enter name:
   <input name="name"/>
  </p>  
 </card>
</wml>';


#
#
# This deck gets sent when the cookie is set as a confirmation
#
$two='
<wml>
 <card>
  <do type="accept" label="yep">
    <go href="?NEXT=three&amp;name="/>
  </do>
  <p>
   I am cookie-ing you as '.$cgiVars{"name"}.'
   </p>  
</card>
</wml>';


#
# The cookie is retrieved and displayed with this deck. TTL is 0 on this deck, so it
# is never reloaded from the chache. If it is loaded from chache, it might
# display a value that is different than the current cookie
#
$three='
<wml>
 <head>
  <meta http-equiv="Cache-Control" forua="true" content="max-age=0"/>
 </head>
 <card>
  <do type="accept" label="AGAIN">
   <go href="?name="/>
  </do>
  <p>
  I picked up the cookie you as '. $cookie{"you"} .'
  </p> 
</card>
</wml>';


#
#
# Decide which deck to serve depending on the vaule of 'NEXT'
#
if ($cgiVars{"NEXT"} eq "two"){
    $deck=$two;
    }
elsif ($cgiVars{"NEXT"} eq "three"){
    $deck=$three;
}
else{
    $deck=$deckOne;
    
}
&deckDump;

#######################################
#
# Output a deck, Including cookie info
#
######################################
sub deckDump

{
    # Output the content type
    print "Content-type: text/vnd.wap.wml \n";
    
    # Check to see if name was passed in, if so cookie it, as 'you'
    # otherwise, don't cookie
    if ($cgiVars{"name"} ne ""){
	print "Set-Cookie: you=".$cgiVars{"name"}."\n";
	}
    # Output the data
    print "\n";
    print $header; # Print out the xml prologue and DTD 
    print $deck;        # Print out the deck
}












