#!/usr/local/bin/perl
############################################################################
#
#   Copyright 1999-2000 Phone.com, Inc.  All rights reserved.
#
#   Subject to the terms and conditions of the SDK License Agreement, 
#   Phone.com, Inc. hereby grants you the right to use the UP.SDK 
#   software and its related documentation.
#
#   The Phone.com name and logo and the family of terms carrying the "UP."
#   prefix are trademarks of Phone.com, Inc. All other brands and product 
#   names may be trademarks of the respective companies with which they 
#   are associated.
#
############################################################################

######################################################################
#
# fetch.cgi - notification URL example
#
#     - This script implements the companion "prefetch URL" for the 
#	  sendalert.cgi sample WML application.  This script is called
#	  by the UP.Link Messenger service when it receives the prefetch
#	  notification request from the sendalert.cgi script, per the
#	  URL that is passed as an argument with the prefetch operation.
#
#       Append ?NEXT=<value> to the URL when calling this script to 
#	  indicate what kind of alert to send.  These are the possible
#	  values for the NEXT variable:
#
#		DISPATCH:	Truck dispatch update
#		MEETING:	Schedule reminder
#		STOCK:	Stock quote
#
# Key concepts illustrated include:
#
#     - Creating an 'alert' digest for delivery as a pre-fetch
#	  notification. 
#
######################################################################

######################################################################
# AppUtils Loading and Configuration
######################################################################
# Include the apputils directory which has all the SDK utilities
BEGIN { push (@INC, "../apputils"); } 	# Path to SDK apputils

# Load required application utilities
require 'DeckUtils.pl';
require Digest;

######################################################################
# Constants
######################################################################

# The WML Content
#
$ALERTDECK=
'<wml>
  %s
  <card id="time">d
  <p>
    Fetched:
    <p align="center"/>%s</p>
	</p>
  </card>
</wml>';
 
$MEETINGCARD = 
'	<card>
	  <do type="options" label="Time">
	    <go href="#time"/>
   	  </do>
	  <p>
	  Staff meeting in 10 minutes! 
	  >/p>
	</card>';

$STOCKCARD = 
'	<card>
	  <do type="options" label="Time">
	    <go href="#time"/>
   	  </do>
	  <p>
 	  Symbol  UPLN
	  </p>
	  <p mode="nowrap"/>Last 52 1/4 </p>
	  <p mode="nowrap"/>Chg +4 </p>
	  <p mode="nowrap"/>Vol 2,505,900</p>
	</card>';

$DISPATCHCARD = 
'	<card>
	  <do type="options" label="Time">
	    <go href="#time"/>
   	  </do>
	  <do type="accept" label="Where">
	    <go href="#details"/>
   	  </do>
	  <p>
	  Dispatch:
 	  <select name="addr">
		<option value="445 Geary">1:00p Svc - SF Downtown</option>
		<option value="2389 Mission">2:00p Maint - SF South</option>
		<option value="329 Lombard">3:00p Svc - SF North</option>
		<option value="857 La Playa">4:00p Maint - SF West</option>
	  </select>
	  </p>
	</card>
	<card id="details">
          <do type="accept" label="Call">
            <go href="wtai://wp/mc;4155552222"/>
          </DO>
		<p mode="nowrap"/>$(addr)</p>
		<p mode="nowrap"/>San Francisco</p>
		<p mode="nowrap"/>415-555-2222</p>
	</card>';

$INFODECK = 
'<wml>
  <card>
  <p>
    Call this script using:
    <p mode="nowrap"/>fetch.cgi?NEXT=DemoType </p>
  </p>  
  </card>
</wml>';

#
# Lookup tables for demo decks and alert messages
#
%CARD = ( "MEETING", $MEETINGCARD,
	"STOCK", $STOCKCARD,
	"DISPATCH", $DISPATCHCARD);

%MSG =  ( "MEETING", "Meeting Reminder",
	"STOCK", "Stock Update",
	"DISPATCH", "Dispatch Notice");

######################################################################
#
# Main routine 
#
###################################################################### 

# Get the demo CGI variable.
#
%cgiVars = &AppUtils::ParseCGIVars();
$demo    = $cgiVars{"NEXT"};
$refetch = $cgiVars{"REFETCH"};
 
if (!defined($demo))
{
    # Display the generic error deck
    &AppUtils::OutputDeck($INFODECK);
}
elsif (defined($refetch))
{
    # Return the demo deck only 
    &AppUtils::OutputDeck(sprintf($ALERTDECK,$CARD{$demo},&getLocalTime));
}
else
{
    # Return the deck + alert in a digest
    &fetchAlert($demo);
}


######################################################################
#
# fetchAlert
#
# This function will create a digest with an alert and the prefetched
# deck that is associated with the alert.
#
######################################################################
sub fetchAlert
{
    local($demo) = @_;

    my $digest = new Digest;

    # NOTE: The REFETCH variable is set as the deck URL so that
    #       only the deck (and not the alert) will be fetched if
    #	      the deck is re-requested by the user from the phone
    #	      (via the alert status UI).  This would happen if the
    #	      deck's TTL expired before the user visited the alert.

    # Add the deck the alert points to
    $digest->addDeck("?NEXT=".$demo."&REFETCH=YES", 
	sprintf($ALERTDECK,$CARD{$demo},&getLocalTime));

    # Add the alert
    $digest->addAlert("?NEXT=".$demo."&REFETCH=YES", "DEFAULT,SOUND1,VISUAL1", $MSG{$demo});

    &AppUtils::OutputDigest($digest->asString());
}

######################################################################
#
# getLocalTime
#
######################################################################
sub getLocalTime
{
        my $time = localtime(time);
        return $time;
}

