#!/usr/local/bin/perl
############################################################################
#
#   Copyright 1999-2000 Phone.com, Inc.  All rights reserved.
#
#   Subject to the terms and conditions of the SDK License Agreement, 
#   Phone.com, Inc. hereby grants you the right to use the UP.SDK 
#   software and its related documentation.
#
#   The Phone.com name and logo and the family of terms carrying the "UP."
#   prefix are trademarks of Phone.com, Inc. All other brands and product 
#   names may be trademarks of the respective companies with which they 
#   are associated.
#
############################################################################

######################################################################
#
# cacheop.cgi - Cache management example
#
#     - This script demonstrates how to use cache operations
#	  and cache-control meta elements to override the default 
#       caching behavior of the UP.Browser.
#
# Key concepts illustrated include:
#
#     - Adding a cache operation to a digest.  In this app, we use
#	the 'invalidate URL' cache operation to invalidate a single
#	deck.  Applications can also use the 'invalidate service' 
#	cache operation to invalidate several decks in the cache 
#	at once.
#
#     - Using a Cache-control meta element to set a deck's TTL
#     (time-to live) in the cache to 0 (i.e. invalidate the deck
#     immediately) via the "no-cache" option.  
#
#     - Using a Cache-control meta element to force a deck's
#     TTL to be revalidated, even if the user navigates to it in
#     the backward direction via the "must-revalidate" option.  
#
######################################################################

######################################################################
# AppUtils Loading and Configuration
######################################################################
# Include the apputils directory which has all the SDK utilities
BEGIN { push (@INC, "../apputils"); } 	# Path to SDK apputils

# Load required application utilities
require 'DeckUtils.pl';
require Digest;

######################################################################
# Constants
######################################################################

# The WML Decks
#
$HOMEDECK=
'<wml>
  <card>
    <p>
      Cache Management
      <select>
        <option onpick="?DEMO=CACHEOP">Cache operation</option>
        <option onpick="?DEMO=CONTROL">Cache control</option>
      </select>
    </p>
  </card>
</wml>';

$DECK1=
'<wml>
  <card>
    <do type="accept" label="Yes">
     <go href="?DEMO=CACHEOP&amp;NEXT=YES"/>
    </do>
    <p>
      Invalidate this deck with a cache operation? 
      <br/>%s
    </p>
  </card>
</wml>';
 
$DECK2=
'<wml>
  <head>
    <meta forua="true" http-equiv="Cache-Control" content="no-cache"/>
  </head>
  <card>
    <p>
      %s
    </p>
  </card>
</wml>';
 
$DECK3=
'<wml>
  <head>
    <meta forua="true" http-equiv="Cache-Control" content="no-cache"/>
    <meta forua="true" http-equiv="Cache-Control" content="must-revalidate"/>
  </head>
  <card>
    <do type="accept" label="Yes">
     <go href="?DEMO=CONTROL&amp;NEXT=YES"/>
    </do>
    <p>
      This deck has cache control meta tags.  
      Force the browser to revalidate?
      <br/>%s
    </p>
  </card>
</wml>';


######################################################################
#
# Main routine 
#
###################################################################### 

# Get the CGI variables
#
%cgiVars = &AppUtils::ParseCGIVars();
$demo = $cgiVars{"DEMO"};
$next = $cgiVars{"NEXT"};

if ($demo eq "CACHEOP")
{
    # Demonstrate cache operations.

    if (!defined($next))
    {
        # Return the initial cache-op demo deck.

        &AppUtils::OutputDeck(sprintf($DECK1, &getLocalTime));
    }
    else
    {
        # Return the next deck and invalidate the previous deck
        # in the cache.  Use a relative URL to identify the deck 
        # to be invalidated.

        my $digest;
        $digest = new Digest;
        $digest->addCacheOp($Digest::InvalURL, "?DEMO=CACHEOP");

        $deck = sprintf($DECK2, 
            "Previous deck was invalidated and will be reloaded from server.");
        $digest->addDeck("", $deck);
        &AppUtils::OutputDigest($digest->asString());
    } 
} 
elsif ($demo eq "CONTROL")
{
    # Demonstrate cache control.

    if (!defined($next))
    {
        # Return the initial cache-control demo deck.

        &AppUtils::OutputDeck(sprintf($DECK3, &getLocalTime));
    }
    else 
    {
        $deck = sprintf($DECK2, 
            "Previous deck will be revalidated and reloaded from server.");
        &AppUtils::OutputDeck($deck);
    }
}
else
{
    # Return the home deck (main menu).

    &AppUtils::OutputDeck(sprintf($HOMEDECK));
}

######################################################################
#
# getLocalTime
#
######################################################################
sub getLocalTime
{
        my $time = localtime(time);
        return $time;
}
