#!/usr/local/bin/perl 
#file: upload.pl

######################################################################
#Copyright 1998 David Turley (dturley@pobox.com>                                    
#Last Modified April 30, 1998                                                         
#This script may not be resold or distributed without the author's
#express written permission.
#The current version of the script is available at
#http://www.pobox.com/~dturley/script.html
######################################################################

#####################    DESCRIPTION    ##############################
#This script allows users to upload files to a predetermined 
#directory on your server. After a successful upload, email is
#sent to the adminstrator informing of an uploaded file.
#
#You must have the CGI.pm module installed. This module is distributed
#with recent Perl distributions. Info on the module can be found at:
# http://www.genome.wi.mit.edu/ftp/pub/software/WWW/cgi_docs.html

########################    SETUP    #################################
# Enter the correct values for these variables below:
#
# $mailTo -- This is the email address to which email notification of
# an upload will be sent.
#
# $upload_dir -- The directory where uploaded files will be saved.
#
# You may use either sendmail or the Net::SMTP module to send email:
# To use sendmail, set $use_sendmail = "yes",
# To use Net::SMTP module, set $use_sendmail = "no".
# $mail_path -- The path to your sendmail program.
#       OR
# $mail_server -- Use this variable if you aren't using sendmail.
# Note: you can comment out the unused mail variable.
#
# %PASSWORDS -- Set names and paswords for valid users here. Be sure
# to follow proper syntax.
# 
#
#Upload the script and set proper permissions for your server. There
#is no separate HTML form to upload. All forms are generated by this 
#script. To access the upload form, enter the URL for the script in
#your web browser.

######################## BEGIN SETUP #################################
use CGI qw/:standard :html3/;
#use Net::SMTP;     ##comment out if not using

$mailTo = 'edward@ezenet.com';

$upload_dir = '/export/home/edward/';

$use_sendmail = "yes";

$mail_path = '/usr/sbin/sendmail';  #for send_email1()

## OR ##           ##you may comment out unused variable

$mail_server = 'pop.ezenet.net';    #for send_email2()

%PASSWORDS = 
    ('edward' => 'pass',
    'guest' => 'guest',
); 

######################## END  SETUP ##################################
print header,
start_html(-title=>'Upload File',-bgcolor=>'white'),

h1({-align=>CENTER},'File Upload Form');


if (param) {
    #check_password();
    upload_file(); 
    if ($use_sendmail1 = "yes") { send_email(); }
    else {send_email2();}
}

else {
    print_form();
}

print hr;
print  'Upload script by ',
    a({-href=>'http://207.107.181.115/'},'Edward Malahov');
print end_html;
exit(0);

################SUBROUTINES#################################
sub print_form {

    print start_multipart_form(),
        table(
            TR({-align=>LEFT},
                th('Enter Your Name: '),
                td(textfield(-name=>'user',-size=>30))
            ),
         #   TR({-align=>LEFT},
         #       th('Enter Your Password: '),
         #       td(textfield(-name=>'password',-size=>30))
         #   ),
            TR({-align=>LEFT},
                th('Enter a File to Upload: '),
                td(filefield(-name=>'upload',-size=>50))
            ),
            TR({-align=>LEFT},
            	th({-valign=>TOP},'Enter a Brief Description of the File: '),
            	td(textarea(-name=>'comment',-rows=>10,-cols=>50,-wrap=>physical))
            ),
            TR({-align=>LEFT},
                td({-colspan=>2,-align=>center},submit(-label=>'Upload File'))
            )
            
        ),
       end_form;
}

sub upload_file {
    my $length;
    my $size;
    my $file = param('upload');
    $file =~ m!([^/:\\]*)$!; #capture file name
	my $short_name = $1;
    
    if (!$file) {
        print p({-align=>center},'You did not enter a file to upload.');

		print p({-align=>center},a({-href=>url},'Go back and try again.'));
        print end_html;
        exit(0);
    }
    
    if (-e "$upload_dir/$short_name") {
    	print p({-align=>center},'The file name ',b($short_name), 'has already been used.', 
    	    'Please change the name of your local file and try again.');

		print p({-align=>center},a({-href=>url},'Try Again.'));
		print end_html;
		exit(0);
	}
    
    
    open (SAVE,">$upload_dir/$short_name") || die $!;
    while ($size = read($file,$data,1024)) {
        print SAVE $data;
        $total_size += $size;
    }
    close SAVE;
    
    if ($total_size > 0) { #file was transferred
        print p('Your file has been uploaded. Here is the relevant information:');
        print p(b('File Name: '),$file,br,b('File Size: '),$total_size);
    
        print p(a({-href=>url},'Upload Another File'));
    }
    
    else {  #nothing was uploaded
        print p({-align=>center},'No file was transferred. ',
            'Please be sure you entered a valid file name.');

		print p({-align=>center},a({-href=>url},'Try Again.'));
		print end_html;
		unlink "$upload_dir/$short_name"; #get rid of file created by open
		exit(0);
	}
        

}    
        

sub send_email1 {
    my $user = param('user');
    my $file = param('upload');
    $file =~ m!([^/:\\]*)$!; #capture file name
	my $short_name = $1;
    my $comments = param('comment');
    
    open (SENDMAIL, "| $mail_path -t") || die $!;
	print SENDMAIL "Subject: File Upload\n";
	print SENDMAIL "From: $mailTo\n";
	print SENDMAIL "To: $mailTo\n\n";
	print SENDMAIL "A file has been uploaded to $upload_dir.\n";
	print SENDMAIL "New Filename: $short_name\n";
	print SENDMAIL "Size: $total_size\n";
	print SENDMAIL "Uploaded by: $user\n";
	print SENDMAIL "Comments:\n";
	print SENDMAIL "$comments\n";
    close (SENDMAIL);
}

sub send_email2 {
    my $user = param('user');
    my $file = param('upload');
    $file =~ m!([^/:\\]*)$!; #capture file name
	my $short_name = $1;
    my $comments = param('comment');
    
    $smtp = Net::SMTP->new($mail_server);
    $smtp->mail($ENV{USER});
    $smtp->to($mailTo);
    
    $smtp->data();
	$smtp->datasend("Subject: File Upload\n");
	$smtp->datasend("From: $mailTo\n");
	$smtp->datasend("To: $mailTo\n");
	$smtp->datasend("\n");
	$smtp->datasend("A file has been uploaded to $upload_dir.\n");
	$smtp->datasend("New Filename: $short_name\n");
	$smtp->datasend("Size: $total_size\n");
	$smtp->datasend("Uploaded by: $user\n");
	$smtp->datasend("Comments:\n");
	$smtp->datasend("$comments\n");
    $smtp->dataend();
    $smtp->quit;
}
    

sub check_password {
    my $user = param('user');
    my $pass = param('password');
    my $okay = 0;
    
    foreach $key (keys %PASSWORDS) {
		
			if (($key eq $user) && ($PASSWORDS{$key} eq $pass)) {
			    $okay = 1;
			    last;
			}
	}
	
    if ($okay != 1) {
        print p({-align=>center},'You must enter a valid name and password to use this script.');
        print p({-align=>center},a({-href=>url},'Go back and try again.'));
 	print p({-align=>center},'$key $user $PASSWORDS{$key} $pass');
        print end_html;
        exit(0);
   }
}


    


