#!/usr/local/bin/perl -w


########################################################################
#                     Application Information                          #
########################################################################


# Ezenet Copyright (C) 2000
#
# Application Name: SERVICE.CGI
# Author: Edward Malahov
# Version: 1.0
# Last Modified: 14 JUNE 2000
#
#
#
# Description:
#
#   Simple application for users to submit the problems on there
#   site, for programmers to pick up information the users submiting
#   and fix the problem, for administrator to manage users and programmers.
#
# Special Notes:
#
#   This script uses the authentication library and also
#   sets up variables for the auth library.  The
#   authentication variables are described as part of the
#   comments for that library.
#
# Basic Usage:
#
#    1. The file should have read access but need not have write access
#       nor execute access.
#
########################################################################



########################################################################
#                     Application Code                                 #
########################################################################


# CGI library, never touch this one!
use CGI qw(:standard);


##########################################################################
#               The variables are defined below.                         #
##########################################################################


# Wait until the filehandle can be locked exclusively
$LOCK_EX = 2;

# Unlock filehandle
$LOCK_UN = 8;

# $siteurl is the variable for the user to get to your main web page
# on your web site.
$siteurl = 'http://www.ezenet.net';

# Name of your web site.
$siteurl_name = 'Ezenet Inc';

# $refresh shouid be set up to the web page where you would like your users
# to go to after they qiut cgi script.
$refresh_page = 'http://www.ezenet.com';

# the path to this CGI script
$script_URL = '/cgi-bin/ezenetdown.cgi';

# email address for users to email to support/webmaster
# to report all the bugs/mistakes.
$master_admin_email_address = 'support@ezenet.com';

# Enter the eamil of the person you want to email messages
# when someone submites new records or programmer updates a record.
$customer_service_email = 'tluu@ezenet.com';

#$customer_service_email = 'edward@ezenet.com';

# Enter the name of the person you want to email messages
# when someone submites new records or programmer updates a record.
$customer_service_name = 'Thanh Binh Luu';

# full path to sendmail - email program
$mailprog = '/usr/lib/sendmail';

# full path to the backup file
$back_up_file = '/usr/local/apache/htdocs/secureme/data/ezenetservice.xls';

# URL Address of back up file
$URL_back_up = 'http://www.secureme.net/data/ezenetservice.xls';

# full path to the file with the passwords and all other user information.
$passwd_file = '/usr/local/apache/htdocs/secureme/data/ezenetlogin.txt';

# full path to the file with all database information the user submiting problems.
$user_file = '/usr/local/apache/htdocs/secureme/data/ezenetuser.txt';

# log file
$log_file = '/usr/local/apache/htdocs/secureme/data/ezenetlog.txt';

# clients information
$client_file = '/usr/local/apache/htdocs/secureme/data/ezenetclients.txt';

# log files if someone would not be able to login
$error_log_file = '/usr/local/apache/htdocs/secureme/data/ezeneterrorlog.txt';




if (!param())
{

	&welcome_page;


}else{

	open(FILE, "$user_file") || display_error("Can't open $user_file, please contact R & D!","Can't open $user_file");
	@data = <FILE>;
	close(FILE);

	open(BACKFILE, "+>$back_up_file") || display_error("Can't open $back_up_file, please contact R & D!","Can't open $back_up_file");
	flock(BACKFILE, $LOCK_EX);

	$num = 0;

	if (param('Submit') eq "Download Backup File")
	{
		foreach $line (@data)
		{
			$num++;

			@main = split(/\|/, $line);
			#foreach $field (@main)
			#{

				#$field =~ s/\t+//g;
				#$field =~ s/ +/ /g;
				#$field =~ s/\r//g;
				#$field =~ s/<BR>//g;
				#$field =~ s/&quot;/\"/g;
				#if ($field eq " ")
				#{
				#	$field = "";
				#}

				#print BACKFILE "$field\t" if ($field ne "\n");
				if ($num != 1)
				{
					$main[12] =~ s/th//g;
					$main[12] =~ s/rd//g;
					$main[12] =~ s/nd//g;
					$main[12] =~ s/st//g;
					$main[12] =~ s/Augu/August/g;

					print BACKFILE "$main[2]\t";
					print BACKFILE "$main[3]\t";
					print BACKFILE "$main[0]\t";
					print BACKFILE "$main[9]\t";
					print BACKFILE "$main[1]\t\t";
					print BACKFILE "$main[4]\t\t";
					print BACKFILE "$main[8]\t\t";
					print BACKFILE "$main[13]\t\t";
					print BACKFILE "$main[12]\n";
				}

			#}
			#print BACKFILE "\n";

		}
	}else
	{
		foreach $line (@data)
		{
			$num++;

			@main = split(/\|/, $line);
			if ($num != 1)
			{
				$main[12] =~ s/th//g;
				$main[12] =~ s/rd//g;
				$main[12] =~ s/nd//g;
				$main[12] =~ s/st//g;
				$main[12] =~ s/Augu/August/g;

				for ($i = 0; $i < 24; $i++)
				{
				#foreach $field (@main)
				#{
					$main[$i] =~ s/<BR>//g;
					$main[$i] =~ s/\n//g;
					$main[$i] =~ s/\r//g;
					$main[$i] =~ s/\t//g;

					print BACKFILE "$main[$i]\t";
				}
			print BACKFILE "\n";
			}
		}

	}
	flock(BACKFILE, $LOCK_UN);
	close(BACKFILE);

	print "Location: $URL_back_up\n\n\n\n";

	#display_header("DONE!");

	#print "<center><H1>DONE!</H1></center>\n<P>\n";

	#&footer;
}


sub welcome_page
{
	display_header("WELCOME!");

	print qq~
		<P>
		<font face="Arial, Helvetica, sans-serif">\n
	      <center><h1>WELCOME to download page!</h1></center></font>
	      <P>&nbsp;<P>
	      <center>

	<form method="post" action="$script_URL">
	<input type="SUBMIT" name="Submit" value="Download Backup File"></form>

	<P>&nbsp;<P>
	<form method="post" action="$script_URL">
	<input type="SUBMIT" name="Submit" value="Download The Whole File"></form>


	<P>
	~;
	&footer;
}



################################################################################
#
# Function: footer
# Displays the bottom part of HTML file, after which CGI exits right away.
# i.e. nothing else will execute after displaing the footer.
#
################################################################################


sub footer
  {
	print qq~
<center>
<p>
<font size=1>
<i>Copyright &copy; 2000 <a href=\"$siteurl\" TARGET=\"_blank\">$siteurl_name</a>. All rights reserved.<br>
Please send your questions, comments, or bug reports to the
<a href=\"mailto:$master_admin_email_address\">$master_admin_email_address</a>.</i></font></center>
</body>
</html>\n~;
exit;
}

###############################################################################
#
# Function: display_error
# Displays an error message pased from any other places in this script.
#
###############################################################################


sub display_error
  {
	local ($message, $title) = ($_[0], $_[1]);


	&display_header($title);

    print qq~

	<font face="Arial, Helvetica, sans-serif">\n
      <center><h1>$title</h1></center></font>
	<center>
	<TABLE width="70%" BORDER="0" CELLPADDING="1">
	<tr>
	<td bgcolor="#9999FF">
	<font face="Arial, Helvetica, sans-serif" size="3" color="#FFFFFF"><B>
	<center>
	$message
	</center>
	</B></font>
	</td>
	</tr>
	</table>
	</center>
	<P>&nbsp;<p>
	<form>
	  <center>
	      <input type=button value="<< Go Back " onClick="history.go(-1)"></form></center>\n
	<P>&nbsp;<p>\n
		~;
	&footer;

  }


#############################################################################
#
# Function: display_header
# Displays header of HTML file.
#
#############################################################################


sub display_header
  {
    ($title) = @_;

	print header;
	print qq~

<HTML>
<HEAD>
<TITLE>$title</TITLE>
</HEAD>

<BODY TEXT="000000" BGCOLOR="FFFFFF" BACKGROUND="/images/ezenet.gif">
~;
}


