#!/usr/local/bin/perl
#
# BIG BROTHER WEB BASED HISTORY DISPLAY SCRIPT
#      
# Nick Metrowsky
# nmetro@colorado.edu
# University of Colorado (JILA)
# 23 June, 2000
#
# Version: 2.2
#
#------------------------------------------------------------------------------------   
#
# Inspired by the bb-hist.sh script written by:
#
# Robert-Andre Croteau
# Version 1.3
# Nov 7th, 1999
#
######################################################################################
#   
# This program is not part of the original Big Brother Distribution, but is
# considered a plug-in replacement for the distributed bb-hist.sh. As author,
# I give permission for anyone to use this program to enhance their use of
# Big Brother. This program can be modified or improved, as desired. If someone
# feels that a universal change is needed (to fix a bug or add a feature), please
# post those changes to the Big Brother mailing list (bb@bb4.com). 
#
# As with the rest of Big Brother, this code cannot be sold or used for commercial gain.
#
# Copyright 1999, 2000
# The University of Colorado
# All Rights Reserved
#
######################################################################################
#
# Change History:
#
# 2.2  23 June, 2000	 Repackaged bb-hist.pl and bb-rep.pl into two separate kits.
#
# 2.1e 12 June, 2000	 Minor cosmetic changes.
#
# 2.1d 25 May, 2000	 Changed references in checking color "clear", to also check
#			 for "white" for data calculations. Fixed getting definition
#			 for BBSKIN. Thanks to Andrew Laden (aladen@plusfunds.com) for
#			 reporting these problems.
#
# 2.1c 24 May, 2000	 Replaced "/cgi-bin" with "$BBWEBCGI" in statements related
#			 to displaying the BB History Log. Thanks to Jim Tollefson
#			 (tollefsj@immunex.com) for this change.
#			 Added "Availability Report" link with bb-rep.pl.
#			 History Event Log now shows Event start and end times.
#			 Intergrated functionality with bb-rep.pl.
#			 Minor embellishments, including $TITLE_BKG_COLOR flag.
#
# 2.1b 13 March, 2000	 Fixed a bug in reagrds to using the log file creation as
#			 the base time. Thought this was fixed as part of 2.1a, but
#			 wasn't.
#
# 2.1a 13 March, 2000	 Better fix to deal with the "BSKIN" variable now part of the
#                        hist_header and hist_footer included with BB V1.4; thanks to
#                        Kirk Tarou (Kirk.Tarou@Notes.airtouch.com) for this change.
#                        Compensated for "ENTRIES" parameter for releases prior to
#                        BB V1.4; thanks to Rob Allan (rallan@ca.oracle.com for     
#                        reporting the problem. Fixed "Content-type" lines for error
#                        generation; thanks to John Horne (jhorne@plymouth.ac.uk) for fix.
#			 Added support for new blue status. Fixed a bug which sometimes
#			 generated an incorrect sized graphic legend.
#
# 2.1	6 March, 2000	 Due to changes in BB V1.4, made updates to routines that read
#			 in hist_header and hist_footer. Added code to display background
#			 color of latest status, to make it consistent with the rest
#			 of BB. Added display of some history records or all history records
#			 via html. Added BBWEBCGI to run this script and MAXENT variable
#			 for selected history records to display.
# 
# 2.0a 11 November, 1999 Corrected an error in Big Brother icon web links.          
#
# 2.0	7 November, 1999 Modified script to support the Big Brother V1.3 redesign. Also,
#			 this version allows for customization of fonts and colors.
#			 Included new hist_header and hist_footer files for BB V1.3;
#			 emulated hist_header and hist_footer to allow bb-hist.pl
#			 to run with pre-BBV1.3 versions.
#		
# 1.7a	20 August, 1999	Corrected a problem with displaying the current month in the
#			 12 month legend. The the "$mon" variable should have been
#			 used in place of the "$month_ary[$w]" variable.
#
# 1.7	12 August, 1999	Added graphical numbers and letters for graph legends. Gave users
#			 the option to use graphical legends or text legends.
#			Added a few more comments; cleaned up some code.
#
# 1.6	28 July, 1999	Consolidated Summary and Graph Calculation Routines to improve
#			 performance.  Only one array is used for the history file summary.
#			Accounted for minute pixel sizes to aid in filling in the graph.
#			 Before this change, pixels > n.0 and < n.5 were dropped, due to
#			 rounding, they are now being added to the next data point, on
#			 the graph, to help with alignment.
#			Some more comment and code clean up.
#
# 1.5	21 July, 1999	If bb-hist can't get current date from log file, use the
#			 current time of day in its' place.
#			Minor change to splitting history records using regexp; now
#			 it doesn't care how many spaces are between each field.
#			  (Thanks to Adam Goryachev for the two previous ideas).
#			Automatically get Big Brother Release Version and Date from
#			 $BBHOME/etc/bbinc.sh.
#			Changed graph calculations to allow for splitting between
#			 data periods. Uses the same algorithms as the summary
#			 calculations.
#
# 1.4	15 July, 1999	Eliminated external call to touchtime and used perl's time
#			 function instead (performance change).
#			Code and comment cleanup pertaining to graphing, for better
#			 readability.
#			To save memory, cut down of the number of arrays required for
#			 producing the graphs (one array instead of four). 
#			Allowed for extra space between color and timestamp as the
#			 result of a change in bbd.c V1.2b.
#
# 1.3	28 June, 1999	Added bar graphs for week, 4 week and 52 week time periods.
#			All bar graphs are generated in pixels, for better accuracy.
#			Added jpg files for green, yellow, red, purple, clear and black.
#			Bar graphs adjust scales based upon base date. 
#			More code clean up.
#
# 1.2	17 June, 1999	To eliminate time shift, used the creation time of a service
#			log file for base time, instead of using actual current time.
#			Took out pipe command to touchtime and used perl POSIX
#			library for time conversion and perl stat function to get
#			file creation date/time. More fixes to 24 hour graph.
#			Cleaned up some "ugly" code.
#
# 1.1	16 June, 1999	Fixed 24 hour Bar Graph to display hour ticks correctly.
#
# 1.0	09 June, 1999	First Release
#      			Major Changes from original bb-hist.sh:
#   
#			1. Converted script to perl.
#			2. Added status display tables for 1 week, 4 week and
#			   52 week time periods.
#			3. Added provisions to allow a status to split between
#			   time periods. That is, if a status started before a
#			   time period and ended during the time period, then
#			   the part of the status within the time period is now
#			   included.
#			4. Major improvements to performance. What took the shell
#			   script to do in over 2 minutes, this new script does in
#			   about 2 seconds or less.
#
######################################################################################

# ************* NOTICE!!! ************
# BBWEB MUST BE SET CORRECTLY FOR THIS TO WORK
#   
$BBWEB="http://fmfc.ezenet.com/bb";	# Location of Big Brother Web Server
$BBWEBCGI="http://fmfc.ezenet.com/cgi-bin"; # Location of Big Brother Web Server cgi-scripts

# BBHOME IS THE ROOT DIRECTORY OF BIG BROTHER!!!
# YOU MUST SET THE NEXT LINE TO WHERE BB LIVES

$BBHOME="/export/home/bb/bb";		# Location of Big Brother Directory
$BBINC="$BBHOME/etc/bbinc.sh";		# Location of Big Brother Include File
$BBHIST="$BBHOME/www/hist";		# Location of Big Brother History Files
$BBLOGS="$BBHOME/www/logs";		# Location of Big Brother Log Files
$BBHEADER="$BBHOME/web";		# Location of Big Brother Header/Footer Files

# Set Fonts and Colors

$TEXT_COLOR="silver";			# Color for Big Brother Text
$TEXT_FONT="Tahoma, Arial, Helvetica";	# Font for Big Brother Text
$HEADER_COLOR="cyan";			# Color for Big Brother Header/Notes
$HEADER_FONT="Tahoma, Arial, Helvetica"; # Font for Big Brother Header/Notes
$DATA_BKG_COLOR="#333333";		# Background Color for Data Text
$DATA_FONT="Tahoma, Arial, Helvetica";	# Font for Data Text
$GRAPH_BKG_COLOR="#000077";		# Background Color for Graph Header Text
$GRAPH_FONT="Tahoma, Arial, Helvetica";	# Font for Graph Header Text
$HIST_BKG_COLOR="#333333";		# Background Color for History Records
$TITLE_BKG_COLOR="#000033";		# Background Color for Titles

# Set Flags

$BB_TYPE="NEW";				# Set to "NEW" for BB V1.3 or later. Set
					#  to "OLD" for BB prior to BB V1.3.

$BLUE_FLAG="TRUE";			# Set to "TRUE", if you want an incomplete
					#  time period to put data in the blue
					#  column. Set to "FALSE", if you do not
					#  want this behavior.

$TIME_FLAG="TRUE";			# Set to "TRUE", if you want to use time of 
					# the log file creation, as the base time.
					# Set to "FALSE", to current time of day as 
					# the base time.
					# NOTE: By setting this "FALSE", there will
					#       be a slight shift in all graph
					#       displays. The longer time between
					#       BB cycles, the more the shift will
					#       be.

$GRAPHIC_LEGEND="TRUE";			# Set to "TRUE", if you want graphic legends,
					# else, set to "FALSE".
					# NOTE: By setting this to "FALSE", the text
					#	based legends will not display in
					#	correct proportions to each other.
					#	This is most noticeable in Netscape.
					#	However, on slow web servers, it is
					#	suggested to set this flag to "FALSE".

$PIXELS=960;				# Pixel width to use (day, year)
					# NOTE: This number should be divisible by 12

$PIXELSW=952;				# Pixel width to use (week, 4 weeks)
					# NOTE: This number should be divisible by 7

$NODATA="black";			# Color to display when there is not enough data to
					#  display an entire graph. 

$MAXENT="50";				# Maximum History records to display

# No User changes are required beyond this point

######################################################################################

# Exit out if $BBHOME is not defined

if ($BBHOME eq "") {
        print "Content-type: text/html\n\n";
	print "<HTML><BODY>";
	print "<H1>ERROR!<BR>BBHOME IS NOT SET IN bb-hist.pl</H1></BODY></HTML>";
        exit 1
}

######################################################################################

# Exit out if $BBWEB is not defined

if ($BBWEB eq "") {
        print "Content-type: text/html\n\n";
	print "<HTML><BODY>";
	print "<H1>ERROR!<BR>BBWEB IS NOT SET IN bb-hist.pl</H1></BODY></HTML>";
        exit 1
}

######################################################################################

# Get Big Brother Release Version and Date from $BBHOME/etc/bbinc.sh

	open BBINC, "grep \"^BBREL=\" $BBINC |";		# Get Big Brother Release Version
	while (<BBINC>) { $vers_in=$_; }
	close BBINC;

	open BBINC, "grep \"^BBRELDATE=\" $BBINC |";	# Get Big Brother Release Date
	while (<BBINC>) { $reldate_in=$_; }
	close BBINC;

	open BBINC, "grep \"^BBSKIN=\" $BBINC |";	# Get Big Brother Skin Directory
	while (<BBINC>) { $skin_in=$_; }
	close BBINC;

	(undef,$vers,undef) = split(/\"/,$vers_in);	  # Extract Version
	(undef,$reldate,undef) = split(/\"/,$reldate_in); # Extract Release Date
	(undef,$skin,undef) = split(/\"/,$skin_in);   # Extract Skin Directory

$BBREL=$vers;			# Current Big Brother Version
$BBRELDATE=$reldate;		# Current Big Brother Release Date
$BBSKIN="$BBWEB/$skin";		# Current Big Brother Skin Directory

######################################################################################

# Start of bb-hist cgi script

{
	use CGI;					# Call perl CGI library
	use POSIX;					# Call perl POSIX Library
	$query = new CGI;				# Initialize CGI

	$| = 1;						# Parameter passing

	$raw_histfile = $query->param('HISTFILE');	# Obtain History file Name from URL
	$raw_histfile =~ y/a-zA-Z0-9,._\-//cd;		# Limit the characters that can be in there

	$HISTFILE = $raw_histfile;			# Get the history file name passed
        $HISTFILE =~ /\\([^\s\\]+)$/;			# Make sure there is no bad things in there
        ($HOSTNAME,$SERVICE) = split(/\./,$HISTFILE);	# Get the hostname and service name

	$ENTRIES = $query->param('ENTRIES');		# Obtain Number of History Records to display
	$ENTRIES =~ y/a-zA-Z0-9,._\-//cd;		# Limit the characters that can be in there
	if ($ENTRIES eq "") { $ENTRIES=$MAXENT; }	# BB before V1.4 did not use the "ENTRIES"
							#  parameter, this line should take care of it.

	$HOSTDOTS=$HOSTNAME;				# Read the hostname
	$HOSTDOTS=~s/,/./g;				# Convert "," to "."
	$HOSTUDL=$HOSTNAME;				# Read the hostname
	$HOSTUDL=~s/,/_/g;				# Convert "." to "_"

######################################################################################
#
# The following will base all the graphs and times at the time of the creation of the last log
# file. In this way, there will be no time shift of data between reporting periods. For example,
# if the log file was created at 8:20 am, then the display will reflect the status at 8:20 am and
# not at the time the display is being viewed. We look at the corresponding log file for a
# particular history file, because log files are usually generated after each cycle and they
# both share the same format in file name, e. g. host,locality1,locality2,..,domain.service.
# $TIME_FLAG should be set to "TRUE" for this purpose.

if ($TIME_FLAG eq "TRUE") {
	$filename = "$BBLOGS/$HISTFILE";		# Set up name of target log file
	(undef,undef,undef,undef,undef,undef,undef,undef,$atime,$mtime,$ctime,undef,undef) = stat $filename;
	if (($ctime == 0) || ($ctime eq "")) {
		$now = time();				# If File creation time is not available, use current time
	} else {
		$now = $ctime;				# Use the creation time obtained above
	}
}

if ($TIME_FLAG eq "FALSE") {
	$now = time();					# Current time in seconds
}

######################################################################################

# The following calculates seconds for a day, week, 4 weeks and 52 weeks

	$day = (60 * 60) * 24;
	$week = $day * 7;
	$week4 = $week * 4;
	$week52 = $week * 52;

# The following calculates the time period for a day, week 4 weeks and 52 weeks

	$this_day = $now - $day;
	$this_week = $now - $week;
	$this_week4 = $now - $week4;
	$this_week52 = $now - $week52;

# The following formats the time in Day of Week Month Day Hour:Minute:Second Year ASCII Format

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($now);
	$alpha_now = strftime("%a %b %d %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($this_day);
	$alpha_yesterday = strftime("%a %b %e %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($this_week);
	$alpha_week = strftime("%a %b %e %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($this_week4);
	$alpha_week4 = strftime("%a %b %e %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($this_week52);
	$alpha_week52 = strftime("%a %b %e %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

######################################################################################

# The following initializes variables for holding totals for each color within each time period

	$green_daysec=0;		# green status variables
	$green_weeksec=0;
	$green_week4sec=0;
	$green_week52sec=0;

	$yellow_daysec=0;		# yellow status variables
	$yellow_weeksec=0;
	$yellow_week4sec=0;
	$yellow_week52sec=0;

	$red_daysec=0;			# red status variables
	$red_weeksec=0;
	$red_week4sec=0;
	$red_week52sec=0;

	$purple_daysec=0;		# purple status variables
	$purple_weeksec=0;
	$purple_week4sec=0;
	$purple_week52sec=0;

	$clear_daysec=0;		# clear status variables
	$clear_weeksec=0;
	$clear_week4sec=0;
	$clear_week52sec=0;

	$blue_daysec=0;			# blue status variables
	$blue_weeksec=0;
	$blue_week4sec=0;
	$blue_week52sec=0;

# Variables needed to create graphs

	$bar_rec_day="";		# 24 Hour Bar Image
	$bar_rec_week="";		# 1 week Bar Image
	$bar_rec_week4="";		# 4 week Bar Image
	$bar_rec_week52="";		# 52 week Bar Image

	$pix_count_day=0;		# Number of day pixels generated
	$pix_count_week=0;		# Number of 1 week pixels generated
	$pix_count_week4=0;		# Number of 4 week pixels generated
	$pix_count_week52=0;		# Number of 52 week pixels generated

	$pix_unused_day=0;		# Number of pixels < .5 for 24 Hour Graph
	$pix_unused_week=0;		# Number of pixels < .5 for 1 Week Graph
	$pix_unused_week4=0;		# Number of pixels < .5 for 4 Week Graph
	$pix_unused_week52=0;		# Number of pixels < .5 for 52 Week Graph

	$pix_unused_day_flag="FALSE";	# Number of pixels < .5 for 24 Hour Graph Flag
	$pix_unused_week_flag="FALSE";	# Number of pixels < .5 for 1 Week Graph Flag
	$pix_unused_week4_flag="FALSE";	# Number of pixels < .5 for 4 Week Graph Flag
	$pix_unused_week52_flag="FALSE"; # Number of pixels < .5 for 52 Week Graph Flag

######################################################################################

# The following sets flags for various calculation routines

	$only_day_rec = "FALSE";
	$only_week_rec = "FALSE";
	$only_week4_rec = "FALSE";
	$only_week52_rec = "FALSE";

	$multirec_day = "FALSE";
	$multirec_week = "FALSE";
	$multirec_week4 = "FALSE";
	$multirec_week52 = "FALSE";

######################################################################################

# Process the history file to compute percentages required for summaries, create an
#  array to be used to generate the graphs and put the history file into an array for
#  displaying the history records.

	open HISTFILE, " $BBHIST/$HISTFILE";
	$hist_count=0;

	while (<HISTFILE>) {
		push(@$hist_array,$_);			# Save history record for displaying history file records 
		$hist_count++;				# Save Number of history records

		$hist_rec=substr($_,25,60);		# State, timestamp and seconds - status data

		($color,$timestamp,$seconds)=split(/\s+/,$hist_rec);	# Formatted History Record

		if ($color eq "clear") { $color="white" };

		$BKG=$color;				# Hold on to the color for the background

######################################################################################

# The following section takes care of instances when there is only one record in the history file.

		if (($only_day_rec eq "FALSE") && ($multirec_day eq "FALSE") && ($seconds eq "")) {
			$only_day_rec = "TRUE";
			$datacycle = $now - $timestamp;
			if ($datacycle > $day) {
				$period_day_secs = $day;
			} else {
				$period_day_secs = $datacycle;
				$blue_daysec = $blue_daysec + ($day - $period_day_secs);
			}
			if ($period_day_secs >= 0) {
				if ($color eq "green") { $green_daysec = $green_daysec + $period_day_secs };
				if ($color eq "yellow") { $yellow_daysec = $yellow_daysec + $period_day_secs };
				if ($color eq "red") { $red_daysec = $red_daysec + $period_day_secs };
				if ($color eq "purple") { $purple_daysec = $purple_daysec + $period_day_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_daysec = $clear_daysec + $period_day_secs };
				if ($color eq "blue") { $blue_daysec = $blue_daysec + $period_day_secs };
			}
			if ($period_day_secs > 0) {
				$perc=($period_day_secs / $day);
				$raw_pix=$perc * $PIXELS;
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_day=$pix_count_day + $pix;
				if ($pix > 0) {
					$bar_rec_day=$bar_rec_day."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}

		if (($only_week_rec eq "FALSE") && ($multirec_week eq "FALSE") && ($seconds eq "")) {
			$only_week_rec = "TRUE";
			$datacycle = $now - $timestamp;
			if ($datacycle > $week) {
				$period_week_secs = $week;
			} else {
				$period_week_secs = $datacycle;
				$blue_weeksec = $blue_weeksec + ($week - $period_week_secs);
			}
			if ($period_week_secs >= 0) {
				if ($color eq "green") { $green_weeksec = $green_weeksec + $period_week_secs };
				if ($color eq "yellow") { $yellow_weeksec = $yellow_weeksec + $period_week_secs };
				if ($color eq "red") { $red_weeksec = $red_weeksec + $period_week_secs };
				if ($color eq "purple") { $purple_weeksec = $purple_weeksec + $period_week_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_weeksec = $clear_weeksec + $period_week_secs };
				if ($color eq "blue") { $blue_weeksec = $blue_weeksec + $period_week_secs };
			}
			if ($period_week_secs > 0 ) {
				$perc=($period_week_secs / $week);
				$raw_pix=$perc * $PIXELSW;
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_week=$pix_count_week + $pix;
				if ($pix > 0) {
					$bar_rec_week=$bar_rec_week."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}

		if (($only_week4_rec eq "FALSE") && ($multirec_week4 eq "FALSE") && ($seconds eq "")) {
			$only_week4_rec = "TRUE";
			$datacycle = $now - $timestamp;
			if ($datacycle > $week4) {
				$period_week4_secs = $week4;
			} else {
				$period_week4_secs = $datacycle;
				$blue_week4sec = $blue_week4sec + ($week4 - $period_week4_secs);
			}
			if ($period_week4_secs >= 0) {
				if ($color eq "green") { $green_week4sec = $green_week4sec + $period_week4_secs };
				if ($color eq "yellow") { $yellow_week4sec = $yellow_week4sec + $period_week4_secs };
				if ($color eq "red") { $red_week4sec = $red_week4sec + $period_week4_secs };
				if ($color eq "purple") { $purple_week4sec = $purple_week4sec + $period_week4_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_week4sec = $clear_week4sec + $period_week4_secs };
				if ($color eq "blue") { $blue_week4sec = $blue_week4sec + $period_week4_secs };
			}
			if ($period_week4_secs > 0 ) {
				$perc=($period_week4_secs / $week4);
				$raw_pix=$perc * $PIXELSW;
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_week4=$pix_count_week4 + $pix;
				if ($pix > 0) {
					$bar_rec_week4=$bar_rec_week4."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}

		if (($only_week52_rec eq "FALSE") && ($multirec_week52 eq "FALSE") && ($seconds eq "")) {
			$only_week52_rec = "TRUE";
			$datacycle = $now - $timestamp;
			if ($datacycle > $week52) {
				$period_week52_secs = $week52;
			} else {
				$period_week52_secs = $datacycle;
				$blue_week52sec = $blue_week52sec + ($week52 - $period_week52_secs);
			}
			if ($period_week52_secs >= 0) {
				if ($color eq "green") { $green_week52sec = $green_week52sec + $period_week52_secs };
				if ($color eq "yellow") { $yellow_week52sec = $yellow_week52sec + $period_week52_secs };
				if ($color eq "red") { $red_week52sec = $red_week52sec + $period_week52_secs };
				if ($color eq "purple") { $purple_week52sec = $purple_week52sec + $period_week52_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_week52sec = $clear_week52sec + $period_week52_secs };
				if ($color eq "blue") { $blue_week52sec = $blue_week52sec + $period_week52_secs };
			}
			if ($period_week52_secs > 0) {
				$perc=($period_week52_secs / $week52);
				$raw_pix=$perc * $PIXELS;
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_week52=$pix_count_week52 + $pix;
				if ($pix > 0) {
					$bar_rec_week52=$bar_rec_week52."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}

######################################################################################

# The following section takes care of instances when there are multiple records in the history file.

		if ($only_day_rec eq "FALSE") {
			$multirec_day = "TRUE";
			if ($timestamp >= $this_day) {
				if ($seconds ne "") {
					$period_day_secs = $seconds;
				} else {
					$period_day_secs = $now - $timestamp;
				}
			} else {
				if ($seconds ne "") {
					$now_cycle = $now - $timestamp;
					$this_day_cycle = $now - $this_day; 
					$data_day_cycle = $this_day_cycle - $now_cycle;
					$period_day_secs = $data_day_cycle + $seconds;
				}				
				if ($seconds eq "") {
					$data_day_cycle = $now - $timestamp;
					if ($data_day_cycle > $day) {
						$period_day_secs = $day;
					} else {
						$period_day_secs = $data_day_cycle;
					}
				}
			}
			if ($period_day_secs >= 0) {
				if ($color eq "green") { $green_daysec = $green_daysec + $period_day_secs };
				if ($color eq "yellow") { $yellow_daysec = $yellow_daysec + $period_day_secs };
				if ($color eq "red") { $red_daysec = $red_daysec + $period_day_secs };
				if ($color eq "purple") { $purple_daysec = $purple_daysec + $period_day_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_daysec = $clear_daysec + $period_day_secs };
				if ($color eq "blue") { $blue_daysec = $blue_daysec + $period_day_secs };
			}
			if ($period_day_secs > 0) {
				$perc=($period_day_secs / $day);
				$raw_pix=$perc * $PIXELS;
				$loc = index($raw_pix,".");
				$float = substr($raw_pix,$loc,14);
				if ((($float > 0) && ($float < .5)) && ($pix_unused_day_flag eq "FALSE")) { 
					$pix_unused_day_flag = "TRUE";
				}
				if ((($float > 0) && ($float < .5)) && ($pix_unused_day_flag eq "TRUE")) { 
					$pix_unused_day = $pix_unused_day + $float;
				}
				if ($pix_unused_day_flag eq "ACTIVE") {
					$loc = index($raw_pix,".");
					$float = substr($raw_pix,$loc,14);
					if ($float >= .5) {
						$raw_pix = $raw_pix + $pix_unused_day;
						$loc = index($raw_pix,".");
						$float = substr($raw_pix,$loc,14);
						if ($float >= .5) {
							$pix_unused_day = 0;
							$pix_unused_day_flag = "FALSE";
						} else {
							$pix_unused_day = $float;
						}
					} else {
						$pix_unused_day = $pix_unused_day + $float;
					}
				}
				if ($pix_unused_day_flag eq "TRUE") { $pix_unused_day_flag = "ACTIVE" };
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_day=$pix_count_day + $pix;
				if ($pix > 0) {
					$bar_rec_day=$bar_rec_day."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}

		if ($only_week_rec eq "FALSE") {
			$multirec_week = "TRUE";
			if ($timestamp >= $this_week) {
				if ($seconds ne "") {
					$period_week_secs = $seconds;
				} else {
					$period_week_secs = $now - $timestamp;
				}
			} else {
				if ($seconds ne "") {
					$now_cycle = $now - $timestamp;
					$this_week_cycle = $now - $this_week; 
					$data_week_cycle = $this_week_cycle - $now_cycle;
					$period_week_secs = $data_week_cycle + $seconds;
				}				
				if ($seconds eq "") {
					$data_week_cycle = $now - $timestamp;
					if ($data_week_cycle > $week) {
						$period_week_secs = $week;
					} else {
						$period_week_secs = $data_week_cycle;
					}
				}
			}
			if ($period_week_secs >= 0) {
				if ($color eq "green") { $green_weeksec = $green_weeksec + $period_week_secs };
				if ($color eq "yellow") { $yellow_weeksec = $yellow_weeksec + $period_week_secs };
				if ($color eq "red") { $red_weeksec = $red_weeksec + $period_week_secs };
				if ($color eq "purple") { $purple_weeksec = $purple_weeksec + $period_week_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_weeksec = $clear_weeksec + $period_week_secs };
				if ($color eq "blue") { $blue_weeksec = $blue_weeksec + $period_week_secs };
			}
			if ($period_week_secs > 0) {
				$perc=($period_week_secs / $week);
				$raw_pix=$perc * $PIXELSW;
				$loc = index($raw_pix,".");
				$float = substr($raw_pix,$loc,14);
				if ((($float > 0) && ($float < .5)) && ($pix_unused_week_flag eq "FALSE")) { 
					$pix_unused_week_flag = "TRUE";
				}
				if ((($float > 0) && ($float< .5)) && ($pix_unused_week_flag eq "TRUE")) { 
					$pix_unused_week = $pix_unused_week + $float;
				}
				if ($pix_unused_week_flag eq "ACTIVE") {
					$loc = index($raw_pix,".");
					$float = substr($raw_pix,$loc,14);
					if ($float >= .5) {
						$raw_pix = $raw_pix + $pix_unused_week;
						$pix_unused_week = 0;
						$loc = index($raw_pix,".");
						$float = substr($raw_pix,$loc,14);
						if ($float >= .5) {
							$pix_unused_week = 0;
							$pix_unused_week_flag = "FALSE";
						} else {
							$pix_unused_week = $float;
						}
					} else {
						$pix_unused_week = $pix_unused_week + $float;
					}
				}
				if ($pix_unused_week_flag eq "TRUE") { $pix_unused_week_flag = "ACTIVE" };
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_week=$pix_count_week + $pix;
				if ($pix > 0) {
					$bar_rec_week=$bar_rec_week."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}

		if ($only_week4_rec eq "FALSE") {
			$multirec_week4 = "TRUE";
			if ($timestamp >= $this_week4) {
				if ($seconds ne "") {
					$period_week4_secs = $seconds;
				} else {
					$period_week4_secs = $now - $timestamp;
				}
			} else {
				if ($seconds ne "") {
					$now_cycle = $now - $timestamp;
					$this_week4_cycle = $now - $this_week4; 
					$data_week4_cycle = $this_week4_cycle - $now_cycle;
					$period_week4_secs = $data_week4_cycle + $seconds;
				}				
				if ($seconds eq "") {
					$data_week4_cycle = $now - $timestamp;
					if ($data_week4_cycle > $week4) {
						$period_week4_secs = $week4;
					} else {
						$period_week4_secs = $data_week4_cycle;
					}
				}
			}
			if ($period_week4_secs >= 0) {
				if ($color eq "green") { $green_week4sec = $green_week4sec + $period_week4_secs };
				if ($color eq "yellow") { $yellow_week4sec = $yellow_week4sec + $period_week4_secs };
				if ($color eq "red") { $red_week4sec = $red_week4sec + $period_week4_secs };
				if ($color eq "purple") { $purple_week4sec = $purple_week4sec + $period_week4_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_week4sec = $clear_week4sec + $period_week4_secs };
				if ($color eq "blue") { $blue_week4sec = $blue_week4sec + $period_week4_secs };
			}
			if ($period_week4_secs > 0) {
				$perc=($period_week4_secs / $week4);
				$raw_pix=$perc * $PIXELSW;
				$loc = index($raw_pix,".");
				$float = substr($raw_pix,$loc,14);
				if ((($float > 0) && ($float < .5)) && ($pix_unused_week4_flag eq "FALSE")) { 
					$pix_unused_week4_flag = "TRUE";
				}
				if ((($float > 0) && ($float < .5)) && ($pix_unused_week4_flag eq "TRUE")) { 
					$pix_unused_week4 = $pix_unused_week4 + $float;
				}
				if ($pix_unused_week4_flag eq "ACTIVE") {
					$loc = index($raw_pix,".");
					$float = substr($raw_pix,$loc,14);
					if ($float >= .5) {
						$raw_pix = $raw_pix + $pix_unused_week4;
						$loc = index($raw_pix,".");
						$float = substr($raw_pix,$loc,14);
						if ($float >= .5) {
							$pix_unused_week4 = 0;
							$pix_unused_week4_flag = "FALSE";
						} else {
							$pix_unused_week4 = $float;
						}
					} else {
						$pix_unused_week4 = $pix_unused_week4 + $float;
					}
				}
				if ($pix_unused_week4_flag eq "TRUE") { $pix_unused_week4_flag = "ACTIVE" };
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_week4=$pix_count_week4 + $pix;
				if ($pix > 0) {
					$bar_rec_week4=$bar_rec_week4."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}

		if ($only_week52_rec eq "FALSE") {
			$multirec_week52 = "TRUE";
			if ($timestamp >= $this_week52) {
				if ($seconds ne "") {
					$period_week52_secs = $seconds;
				} else {
					$period_week52_secs = $now - $timestamp;
				}
			} else {
				if ($seconds ne "") {
					$now_cycle = $now - $timestamp;
					$this_week52_cycle = $now - $this_week52; 
					$data_week52_cycle = $this_week52_cycle - $now_cycle;
					$period_week52_secs = $data_week52_cycle + $seconds;
				}				
				if ($seconds eq "") {
					$data_week52_cycle = $now - $timestamp;
					if ($data_week52_cycle > $week52) {
						$period_week52_secs = $week52;
					} else {
						$period_week52_secs = $data_week52_cycle;
					}
				}
			}
			if ($period_week52_secs >= 0) {
				if ($color eq "green") { $green_week52sec = $green_week52sec + $period_week52_secs };
				if ($color eq "yellow") { $yellow_week52sec = $yellow_week52sec + $period_week52_secs };
				if ($color eq "red") { $red_week52sec = $red_week52sec + $period_week52_secs };
				if ($color eq "purple") { $purple_week52sec = $purple_week52sec + $period_week52_secs };
				if (($color eq "clear") || ($color eq "white")) { $clear_week52sec = $clear_week52sec + $period_week52_secs };
				if ($color eq "blue") { $blue_week52sec = $blue_week52sec + $period_week52_secs };
			}
			if ($period_week52_secs > 0) {
				$perc=($period_week52_secs / $week52);
				$raw_pix=$perc * $PIXELS;
				$loc = index($raw_pix,".");
				$float = substr($raw_pix,$loc,14);
				if ((($float > 0) && ($float < .5)) && ($pix_unused_week52_flag eq "FALSE")) { 
					$pix_unused_week52_flag = "TRUE";
				}
				if ((($float > 0) && ($float < .5)) && ($pix_unused_week52_flag eq "TRUE")) { 
					$pix_unused_week52 = $pix_unused_week52 + $float;
				}
				if ($pix_unused_week52_flag eq "ACTIVE") {
					$loc = index($raw_pix,".");
					$float = substr($raw_pix,$loc,14);
					if ($float >= .5) {
						$raw_pix = $raw_pix + $pix_unused_week52;
						$loc = index($raw_pix,".");
						$float = substr($raw_pix,$loc,14);
						if ($float >= .5) {
							$pix_unused_week52 = 0;
							$pix_unused_week52_flag = "FALSE";
						} else {
							$pix_unused_week52 = $float;
						}
					} else {
						$pix_unused_week52 = $pix_unused_week52 + $float;
					}
				}
				if ($pix_unused_week52_flag eq "TRUE") { $pix_unused_week52_flag = "ACTIVE" };
				$fmt_pix=sprintf "%3.0f", $raw_pix;
				$pix=$fmt_pix * 1;
				$pix_count_week52=$pix_count_week52 + $pix;
				if ($pix > 0) {
					$bar_rec_week52=$bar_rec_week52."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
				}
			}
		}
	}

	close HISTFILE;

######################################################################################

# The following calculates percentages for the various data periods

	$green_dayper = ($green_daysec / $day) * 100.00;
	$yellow_dayper = ($yellow_daysec / $day) * 100.00;
	$red_dayper = ($red_daysec / $day) * 100.00;
	$purple_dayper = ($purple_daysec / $day) * 100.00;
	$clear_dayper = ($clear_daysec / $day) * 100.00;
	$blue_dayper = ($blue_daysec / $day) * 100.00;
	$total_dayper = ($green_dayper + $yellow_dayper + $red_dayper + $purple_dayper + $clear_dayper + $blue_dayper);
	if ($BLUE_FLAG eq "TRUE") {
		if ($total_dayper < 100) {
			$blue_dayper = $blue_dayper + (100 - $total_dayper);
		}
	}

	$green_weekper = ($green_weeksec / $week) * 100.00;
	$yellow_weekper = ($yellow_weeksec / $week) * 100.00;
	$red_weekper = ($red_weeksec / $week) * 100.00;
	$purple_weekper = ($purple_weeksec / $week) * 100.00;
	$clear_weekper = ($clear_weeksec / $week) * 100.00;
	$blue_weekper = ($blue_weeksec / $week) * 100.00;
	$total_weekper = ($green_weekper + $yellow_weekper + $red_weekper + $purple_weekper + $clear_weekper + $blue_weekper);
	if ($BLUE_FLAG eq "TRUE") {
		if ($total_weekper < 100) {
			$blue_weekper = $blue_weekper + (100 - $total_weekper);
		}
	}

	$green_week4per = ($green_week4sec / $week4) * 100.00;
	$yellow_week4per = ($yellow_week4sec / $week4) * 100.00;
	$red_week4per = ($red_week4sec / $week4) * 100.00;
	$purple_week4per = ($purple_week4sec / $week4) * 100.00;
	$clear_week4per = ($clear_week4sec / $week4) * 100.00;
	$blue_week4per = ($blue_week4sec / $week4) * 100.00;
	$total_week4per = ($green_week4per + $yellow_week4per + $red_week4per + $purple_week4per + $clear_week4per + $blue_week4per);
	if ($BLUE_FLAG eq "TRUE") {
		if ($total_week4per < 100) {
			$blue_week4per = $blue_week4per + (100 - $total_week4per);
		}
	}

	$green_week52per = ($green_week52sec / $week52) * 100.00;
	$yellow_week52per = ($yellow_week52sec / $week52) * 100.00;
	$red_week52per = ($red_week52sec / $week52) * 100.00;
	$purple_week52per = ($purple_week52sec / $week52) * 100.00;
	$clear_week52per = ($clear_week52sec / $week52) * 100.00;
	$blue_week52per = ($blue_week52sec / $week52) * 100.00;
	$total_week52per = ($green_week52per + $yellow_week52per + $red_week52per + $purple_week52per + $clear_week52per + $blue_week52per);
	if ($BLUE_FLAG eq "TRUE") {
		if ($total_week52per < 100) {
			$blue_week52per = $blue_week52per + (100 - $total_week52per);
		}
	}

######################################################################################

# If there is not enough data to fill the graph, then insert spacing to correctly align the data

	if ($pix_count_day < $PIXELS) {
		if ($pix_unused_day > 1) {
			$fmt_pix=sprintf "%3.0f", $pix_unused_day;
			$pix=$fmt_pix * 1;
			$pix_count_day=$pix_count_day + $pix;
			if ($pix > 0) {
				$bar_rec_day=$bar_rec_day."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
			}
		}
		$pix = $PIXELS - $pix_count_day;
		if ($pix > 0) {
			$pix_count_day = $pix_count_day + $pix;
			$bar_rec_day="<IMG SRC=\"$BBWEB/gifs/$NODATA.jpg\" width=\"$pix\" height=\"25\">".$bar_rec_day;
		}
	}

	if ($pix_count_week < $PIXELSW) {
		if ($pix_unused_week > 1) {
			$fmt_pix=sprintf "%3.0f", $pix_unused_week;
			$pix=$fmt_pix * 1;
			$pix_count_week=$pix_count_week + $pix;
			if ($pix > 0) {
				$bar_rec_week=$bar_rec_week."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
			}
		}
		$pix = $PIXELSW - $pix_count_week;
		if ($pix > 0) {
			$pix_count_week = $pix_count_week + $pix;
			$bar_rec_week="<IMG SRC=\"$BBWEB/gifs/$NODATA.jpg\" width=\"$pix\" height=\"25\">".$bar_rec_week;
		}
	}

	if ($pix_count_week4 < $PIXELSW) {
		if ($pix_unused_week4 > 1) {
			$fmt_pix=sprintf "%3.0f", $pix_unused_week4;
			$pix=$fmt_pix * 1;
			$pix_count_week4=$pix_count_week4 + $pix;
			if ($pix > 0) {
				$bar_rec_week4=$bar_rec_week4."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
			}
		}
		$pix = $PIXELSW - $pix_count_week4;
		if ($pix > 0) {
			$pix_count_week4 = $pix_count_week4 + $pix;
			$bar_rec_week4="<IMG SRC=\"$BBWEB/gifs/$NODATA.jpg\" width=\"$pix\" height=\"25\">".$bar_rec_week4;
		}
	}

	if ($pix_count_week52 < $PIXELS) {
		if ($pix_unused_week52 > 1) {
			$fmt_pix=sprintf "%3.0f", $pix_unused_week52;
			$pix=$fmt_pix * 1;
			$pix_count_week52=$pix_count_week52 + $pix;
			if ($pix > 0) {
				$bar_rec_week52=$bar_rec_week52."<IMG SRC=\"$BBWEB/gifs/$color.jpg\" width=\"$pix\" height=\"25\">";
			}
		}
		$pix = $PIXELS - $pix_count_week52;
		if ($pix > 0) {
			$pix_count_week52 = $pix_count_week52 + $pix;
			$bar_rec_week52="<IMG SRC=\"$BBWEB/gifs/$NODATA.jpg\" width=\"$pix\" height=\"25\">".$bar_rec_week52;
		}
	}

######################################################################################

# Display graphs and summaries

# Start with the page headings

	if ($BB_TYPE eq "NEW") {
		print $query->header;		# Required by perl CGI library
		$head_count = 0;
		open HEADER_FILE," $BBHEADER/hist_header"; 
		while (<HEADER_FILE>) {
			$head_count++;
			$_=~s/gifs\//$BBWEB\/gifs\//g;
			$_=~s/help\//$BBWEB\/help\//g;
			$_=~s/bb2.html/$BBWEB\/bb2.html/g;
			$_=~s/&BBRELDATE/$BBRELDATE/g;
			$_=~s/&BBREL/$BBREL/g;
	       		$_=~s/&BBDATE/$alpha_now/g;
			$_=~s/&BBBACKGROUND/$BBWEB\/gifs\/bkg-$BKG.gif/g;
        		$_=~s/&BBHOST/$HOSTDOTS/g;
			$_=~s/&BBSVC/$SERVICE/g;
        		$_=~s/&BBWEB/$BBWEB/g;
                        $_=~s/&BBSKIN/$BBSKIN/g;

		# The first record of hist_header causes problems for the perl CGI
		#  library; therefore, the following will skip the first record.
		#  The "print $query->header" line above is all that is needed.

			if ($head_count > 1) {
				print "$_";
			}
		}
		close HEADER_FILE; 
	} else {
		print $query->header;
		print $query->start_html("Big Brother History Graph: $HOSTDOTS - $SERVICE");
		print "<STYLE TYPE=\"text/css\"><!-- A:link {text-decoration: none}A:visited{text-decoration:none}A:active{text-decoration:none}--></STYLE>";
		print "</HEAD><BODY bgcolor=\"#000000\" background=\"$BBWEB/gifs/bkg-$BKG.gif\" link=\"#00FFAA\" vlink=\"#FFFF44\" text=\"$TEXT_COLOR\">";

		print "<CENTER>";
		print "<TABLE SUMMARY=\"Navigation\" WIDTH=100%><TR><TD VALIGN=TOP ALIGN=LEFT>";
		print "<A HREF=\"http://bb4.com\"><IMG SRC=\"$BBWEB/gifs/bb.gif\" ALT=\"Get Big Brother\""; 
		print " BORDER=0></A><BR><TD>";
		print "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE=\"$TEXT_FONT\" SIZE=+1 COLOR=\"$TEXT_COLOR\">";
		print "<B>history</B><BR>";
		print "<B>$alpha_now</B></TD></TR></TABLE><BR>";

		print "</CENTER>";
		print "<BR><BR CLEAR=ALL></P>";
	}
	print "<FONT SIZE=+1 COLOR=\"$TEXT_COLOR\" FACE=\"$TEXT_FONT\"><CENTER><H2>$HOSTDOTS - $SERVICE</H2></CENTER><CENTER>";

# This section will display all the graphs generated earlier.

# The following displays the 24 hour bar graph time stamps, legends and data.

	$legend_rec="";					# Bar Legend
	$pix_count=$pix_count_day;			# Pixels for day

	$tmp_pix = $pix_count / 2;			# Half of pixel width
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_50 = $fmt_pix * 1;
	$tmp_pix = $pix_count / 24;			# 1/24th of pixel width
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_24 = $fmt_pix * 1;
	$tmp_pix = $pix_count_24 * ($min / 60);		# Percent of pixels used in day
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$adj_pix = $fmt_pix * 1;
	$pix_hour1 = $pix_count_24 - $adj_pix;		# Number of pixels to adjust on display

	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000000\">";
	print "<TR><TD>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count\" ALIGN=CENTER><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>24 Hour Period</B></TD>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$GRAPH_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=LEFT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_yesterday</B></TD>";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=RIGHT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_now</B></TD></TR>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}

	$hour = substr($alpha_now,11,2);
	$hours = $hour * 1;

	$w=0;
	print "<TR>";
	if ($w == 0) {
		if ($hours <= 9) {
			$hours_str = "0".$hours;
		} else {
			$hours_str = $hours;
		}
		if ($pix_hour1 >= 34) {
			if ($GRAPHIC_LEGEND eq "TRUE") {
				$tmp_filler = ($pix_hour1 - 34) / 2;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$hours_str.gif\" width=\"32\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$pix_hour1\" ALIGN=LEFT><B>$hours_str</B></TD>";
			}
		} else {
			if ($pix_hour1 > 0) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$pix_hour1_adj = $pix_hour1 - 1;
					if ($pix_hour1_adj > 0) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$pix_hour1_adj\" height=\"20\"></TD>";
					}
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				} else {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_hour1\" height=\"20\"></TD>";
				}
			}
		}
		$w++;
	}
	while (($w >= 1) && ($w <= 23)) {
		$hours++;
		if ($hours > 23) { $hours = 0 };
		if ($hours <= 9) {
			$hours_str = "0".$hours;
		} else {
			$hours_str = $hours;
		}
		if ($GRAPHIC_LEGEND eq "TRUE") {
			$tmp_filler = ($pix_count_24 - 34) / 2;
			$filler=sprintf "%3.0f", $tmp_filler;
			if ($filler < 0) { $filler = 0 };
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			if ($filler >= 1) {
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
			}
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$hours_str.gif\" width=\"32\" height=\"20\"></TD>";
			if ($filler >= 1) {
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
			}
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
		} else {				
			$legend_rec=$legend_rec."<TD WIDTH=\"$pix_count_24\" ALIGN=LEFT><B>$hours_str</B></TD>";
		}
		$w++;
	}
	
	if ($adj_pix > 0) {
		$hours++;
		if ($hours > 23) { $hours = 0 };
		if ($hours <= 9) { 
			$hours_str = "0".$hours;
		} else {
			$hours_str = $hours;
		}
		if ($adj_pix >= 34) {
			if ($GRAPHIC_LEGEND eq "TRUE") {
				$tmp_filler = ($adj_pix - 34) / 2;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$hours_str.gif\" width=\"32\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$adj_pix\" ALIGN=LEFT><B>$hours_str</B></TD>";
			}
		} else {
			if ($adj_pix > 0) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$adj_pix_adj = $adj_pix - 1;
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
					if ($adj_pix_adj > 0) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$adj_pix-adj\" height=\"20\"></TD>";
					}
				} else {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$adj_pix\" height=\"20\"></TD>";
				}
			}
		}
	}

	print "$legend_rec";
	print "</TR>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
		print "<TR>";
		print "<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_count\" height=\"2\"></TD>";
		print "</TR>";
		print "</TABLE>";
	}
	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	print "<TR>";
	print "<TD WIDTH=\"$pix_count\"NOWRAP>$bar_rec_day</TD>";
	print "</TR>";
	print "</TABLE>";

	print "</TD></TR></TABLE>";

# The following displays the 7 x 24 hour bar graph time stamps, legends and data.

	$legend_rec="";					# Bar Legend
	$pix_count=$pix_count_week;			# Pixels for week

	$tmp_pix = $pix_count / 2;			# Half of pixel width
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_50 = $fmt_pix * 1;
	$tmp_pix = $pix_count / 7;			# 1/7th of pixel width
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_7 = $fmt_pix * 1;
	$hour = substr($alpha_now,11,2);
	$tmp_pix = $pix_count_7 * ($hour / 24);		# Percent of pixels used in day
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$adj_pix = $fmt_pix * 1;
	$pix_day1 = $pix_count_7 - $adj_pix;		# Number of pixels to adjust on display

	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000000\">";
	print "<TR><TD>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count\" ALIGN=CENTER><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>1 Week Period</B></TD>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$GRAPH_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=LEFT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_week</B></TD>";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=RIGHT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_now</B></TD></TR>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}

	$wday = substr($alpha_now,0,3);
	if ($wday eq "Sun") { @week_ary = ("Sun","Mon","Tue","Wed","Thu","Fri","Sat"); };
	if ($wday eq "Mon") { @week_ary = ("Mon","Tue","Wed","Thu","Fri","Sat","Sun"); };
	if ($wday eq "Tue") { @week_ary = ("Tue","Wed","Thu","Fri","Sat","Sun","Mon"); };
	if ($wday eq "Wed") { @week_ary = ("Wed","Thu","Fri","Sat","Sun","Mon","Tue"); };
	if ($wday eq "Thu") { @week_ary = ("Thu","Fri","Sat","Sun","Mon","Tue","Wed"); };
	if ($wday eq "Fri") { @week_ary = ("Fri","Sat","Sun","Mon","Tue","Wed","Thu"); };
	if ($wday eq "Sat") { @week_ary = ("Sat","Sun","Mon","Tue","Wed","Thu","Fri"); };

	$w=0;
	print "<TR>";
	if ($w == 0) {
		if ($pix_day1 >= 50) {
			if ($GRAPHIC_LEGEND eq "TRUE") {
				$day_1 = uc (substr($week_ary[$w],0,1));
				$day_2 = uc (substr($week_ary[$w],1,1));
				$day_3 = uc (substr($week_ary[$w],2,1));
				$day_str = $day_1.$day_2.$day_3;
				$tmp_filler = ($pix_day1 - 50) / 2;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$day_str.gif\" width=\"48\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$pix_day1\" ALIGN=LEFT><B>$week_ary[$w]</B></TD>";
			}
		} else {
			if ($pix_day1 > 0) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$pix_day1_adj = $pix_day1 - 1;
					if ($pix_day1_adj > 0) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$pix_day1_adj\" height=\"20\"></TD>";
					}
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				} else {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_day1\" height=\"20\"></TD>";
				}
			}
		}
		$w++;
	}
	while (($w >= 1) && ($w <= 6)) {
		if ($GRAPHIC_LEGEND eq "TRUE") {
			$day_1 = uc (substr($week_ary[$w],0,1));
			$day_2 = uc (substr($week_ary[$w],1,1));
			$day_3 = uc (substr($week_ary[$w],2,1));
			$day_str = $day_1.$day_2.$day_3;
			$tmp_filler = ($pix_count_7 - 50) / 2;
			$filler=sprintf "%3.0f", $tmp_filler;
			if ($filler < 0) { $filler = 0 };
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			if ($filler >= 1) {
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
			}
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$day_str.gif\" width=\"48\" height=\"20\"></TD>";
			if ($filler >= 1) {
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
			}
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
		} else {				
			$legend_rec=$legend_rec."<TD WIDTH=\"$pix_count_7\" ALIGN=LEFT><B>$week_ary[$w]</B></TD>";
		}
		$w++;
	}
	if ($adj_pix > 0) {
		if ($adj_pix >= 50) {
			if ($GRAPHIC_LEGEND eq "TRUE") {
				$day_1 = uc (substr($wday,0,1));
				$day_2 = uc (substr($wday,1,1));
				$day_3 = uc (substr($wday,2,1));
				$tmp_filler = ($adj_pix - 50) / 2;
				$day_str = $day_1.$day_2.$day_3;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$day_str.gif\" width=\"48\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$adj_pix\" ALIGN=LEFT><B>$wday</B></TD>";
			}
		} else {
			if ($adj_pix > 0) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$adj_pix_adj = $adj_pix - 1;
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
					if ($adj_pix_adj > 0) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$adj_pix_adj\" height=\"20\"></TD>";
					}
				} else {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$adj_pix\" height=\"20\"></TD>";
				}
			}
		}
	}

	print "$legend_rec";
	print "</TR>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
		print "<TR>";
		print "<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_count\" height=\"2\"></TD>";
		print "</TR>";
		print "</TABLE>";
	}
	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	print "<TR>";
	print "<TD WIDTH=\"$pix_count\"NOWRAP>$bar_rec_week</TD>";
	print "</TR>";
	print "</TABLE>";

	print "</TD></TR></TABLE>";

# The following displays the 4 x 7 x 24 hour bar graph time stamps, legends and data.

	$legend_rec="";					# Bar Legend
	$pix_count=$pix_count_week4;			# Pixels for 4 weeks

	$tmp_pix = $pix_count / 2;			# Half of pixel width 
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_50 = $fmt_pix * 1;
	$tmp_pix = $pix_count / 28;			# 1/28th of pixel width
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_28 = $fmt_pix * 1;

	$hour = substr($alpha_week4,11,2);		# Start Hour (4 weeks ago)
	$mon = substr($alpha_week4,4,3);		# Start Month (4 weeks ago)
	$mday = substr($alpha_week4,8,2);		# Start Day (4 weeks ago)
	$wday = substr($alpha_week4,0,3);		# Start weekday (4 weeks ago)

	if ($mon eq "Jan") { $days = "31" };		# Length of month in days
	if ($mon eq "Feb") {
		$days = "28";
		$year = substr($alpha_now,20,4);
		$ychk = $year % 4;
		if ($ychk == 0) { $days = "29" };
	}
	if ($mon eq "Mar") { $days = "31" };
	if ($mon eq "Apr") { $days = "30" };
	if ($mon eq "May") { $days = "31" };
	if ($mon eq "Jun") { $days = "30" };
	if ($mon eq "Jul") { $days = "31" };
	if ($mon eq "Aug") { $days = "31" };
	if ($mon eq "Sep") { $days = "30" };
	if ($mon eq "Oct") { $days = "31" };
	if ($mon eq "Nov") { $days = "30" };
	if ($mon eq "Dec") { $days = "31" };

	$tmp_pix = $pix_count_28 * ($hour / 24);	# Percent of pixels used in a day
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$adj_pix = $fmt_pix * 1;
	$pix_week1 = $pix_count_28 - $adj_pix;		# Number of pixels to adjust on display

	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000000\">";
	print "<TR><TD>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count\" ALIGN=CENTER><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>4 Week Period</B></TD>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$GRAPH_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=LEFT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_week4</B></TD>";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=RIGHT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_now</B></TD></TR>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}

	$dom=$mday * 1;
	$w=0;
	print "<TR>";
	while ($w <= 27) {
		if ($dom <= 9) {
			$doms="0".substr($dom,0,1);
		} else {
			$doms=$dom;
		}
		if ($w == 0) {
			if ($pix_week1 >= 34) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$tmp_filler = ($pix_week1 - 34) / 2;
					$filler=sprintf "%3.0f", $tmp_filler;
					if ($filler < 0) { $filler = 0 };
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
					if ($filler >= 1) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
					}
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$doms.gif\" width=\"32\" height=\"20\"></TD>";
					if ($filler >= 1) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
					}
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				} else {				
					$legend_rec=$legend_rec."<TD WIDTH=\"$pix_week1\" ALIGN=LEFT><FONT SIZE=-1><B>$doms</B></FONT></TD>";
				}
			} else {
				if ($pix_week1 > 0) {
					if ($GRAPHIC_LEGEND eq "TRUE") {
						$pix_week1_adj = $pix_week1 - 1;
						if ($pix_week1_adj > 0) {
							$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$pix_week1_adj\" height=\"20\"></TD>";
						}
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
					} else {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_week1\" height=\"20\"></TD>";
					}
				}
			}
		}
		if ($w >= 1) {
			if ($GRAPHIC_LEGEND eq "TRUE") {	
				$tmp_filler = ($pix_count_28 - 34) / 2;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$doms.gif\" width=\"32\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$pix_count_28\" ALIGN=LEFT><FONT SIZE=-1><B>$doms</B></FONT></TD>";
			}
		}
		$w++;
		$dom++;
		if ($dom > $days) { $dom=1 };
	}
	if ($dom > $days) { $dom=1 };
	if ($dom <= 9) {
		$doms="0".substr($dom,0,1);
	} else {
		$doms=$dom;
	}
	if ($adj_pix > 0) {
		if ($adj_pix >= 34) {
			if ($GRAPHIC_LEGEND eq "TRUE") {
				$tmp_filler = ($adj_pix - 34) / 2;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$doms.gif\" width=\"32\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$adj_pix\" ALIGN=LEFT><FONT SIZE=-1><B>$doms</B></FONT></TD>";
			}
		} else {
			if ($adj_pix > 0) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$adj_pix_adj = $adj_pix - 1;
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
					if ($adj_pix_adj > 0) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$adj_pix_adj\" height=\"20\"></TD>";
					}
				} else {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$adj_pix\" height=\"20\"></TD>";
				}
			}
		}
	}

	print "$legend_rec";
	print "</TR></FONT>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
		print "<TR>";
		print "<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_count\" height=\"2\"></TD>";
		print "</TR>";
		print "</TABLE>";
	}
	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	print "<TR>";
	print "<TD WIDTH=\"$pix_count\"NOWRAP>$bar_rec_week4</TD>";
	print "</TR>";
	print "</TABLE>";
	print "</TD></TR></TABLE>";

# The following displays the 52 x 7 x 24 hour bar graph time stamps, legends and data.

	$legend_rec="";					# Bar Legend
	$pix_count=$pix_count_week52;			# Pixels for 52 weeks

	$tmp_pix = $pix_count / 2;			# Half of pixel width
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_50 = $fmt_pix * 1;
	$tmp_pix = $pix_count / 12;			# 1/12th of pixel width
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$pix_count_12 = $fmt_pix * 1;

	$mon = substr($alpha_now,4,3);			# Current month
	$dom = substr($alpha_now,8,2);			# Current day of the month

	if ($mon eq "Jan") { $days = "31" };		# Length of month in days
	if ($mon eq "Feb") {
		$days = "28";
		$year = substr($alpha_now,20,4);
		$ychk = $year % 4;
		if ($ychk == 0) { $days = "29" };
	}
	if ($mon eq "Mar") { $days = "31" };
	if ($mon eq "Apr") { $days = "30" };
	if ($mon eq "May") { $days = "31" };
	if ($mon eq "Jun") { $days = "30" };
	if ($mon eq "Jul") { $days = "31" };
	if ($mon eq "Aug") { $days = "31" };
	if ($mon eq "Sep") { $days = "30" };
	if ($mon eq "Oct") { $days = "31" };
	if ($mon eq "Nov") { $days = "30" };
	if ($mon eq "Dec") { $days = "31" };

	$tmp_pix = $pix_count_12 * ($dom / $days);	# Percentage of pixels used in month
	$fmt_pix=sprintf "%3.0f", $tmp_pix;
	$adj_pix = $fmt_pix * 1;
	$pix_month1 = $pix_count_12 - $adj_pix;		# Number of pixels to adjust in display

	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000000\">";
	print "<TR><TD>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count\" ALIGN=CENTER><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>52 Week Period</B></TD>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 SPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}
	print "<TR BGCOLOR=\"$GRAPH_BKG_COLOR\">";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=LEFT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_week52</B></TD>";
	print "<TD WIDTH=\"$pix_count_50\" ALIGN=RIGHT><FONT FACE=\"$GRAPH_FONT\"><B>$alpha_now</B></TD></TR>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	} else {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 BGCOLOR=\"#000033\">";
	}

	if ($mon eq "Jan") { @month_ary = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"); };
	if ($mon eq "Feb") { @month_ary = ("Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","Jan"); };
	if ($mon eq "Mar") { @month_ary = ("Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","Jan","Feb"); };
	if ($mon eq "Apr") { @month_ary = ("Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","Jan","Feb","Mar"); };
	if ($mon eq "May") { @month_ary = ("May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","Jan","Feb","Mar","Apr"); };
	if ($mon eq "Jun") { @month_ary = ("Jun","Jul","Aug","Sep","Oct","Nov","Dec","Jan","Feb","Mar","Apr","May"); };
	if ($mon eq "Jul") { @month_ary = ("Jul","Aug","Sep","Oct","Nov","Dec","Jan","Feb","Mar","Apr","May","Jun"); };
	if ($mon eq "Aug") { @month_ary = ("Aug","Sep","Oct","Nov","Dec","Jan","Feb","Mar","Apr","May","Jun","Jul"); };
	if ($mon eq "Sep") { @month_ary = ("Sep","Oct","Nov","Dec","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug"); };
	if ($mon eq "Oct") { @month_ary = ("Oct","Nov","Dec","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep"); };
	if ($mon eq "Nov") { @month_ary = ("Nov","Dec","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct"); };
	if ($mon eq "Dec") { @month_ary = ("Dec","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov"); };

	$w=0;
	print "<TR>";
	if ($w == 0) {
		if ($pix_month1 >= 50) {
			if ($GRAPHIC_LEGEND eq "TRUE") {
				$day_1 = uc (substr($month_ary[$w],0,1));
				$day_2 = uc (substr($month_ary[$w],1,1));
				$day_3 = uc (substr($month_ary[$w],2,1));
				$day_str = $day_1.$day_2.$day_3;
				$tmp_filler = ($pix_month1 - 50) / 2;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$day_str.gif\" width=\"48\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$pix_month1\" ALIGN=LEFT><B>$month_ary[$w]</B></TD>";
			}
		} else {
			if ($pix_month1 > 0) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$pix_month1_adj = $pix_month1 - 1;
					if ($pix_month1_adj > 0) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$pix_month1_adj\" height=\"20\"></TD>";
					}
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				} else {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_month1\" height=\"25\"></TD>";
				}
			}
		}
		$w++;
	}
	while (($w > 0) && ($w <= 11)) {
		if ($GRAPHIC_LEGEND eq "TRUE") {
			$day_1 = uc (substr($month_ary[$w],0,1));
			$day_2 = uc (substr($month_ary[$w],1,1));
			$day_3 = uc (substr($month_ary[$w],2,1));
			$day_str = $day_1.$day_2.$day_3;
			$tmp_filler = ($pix_count_12 - 50) / 2;
			$filler=sprintf "%3.0f", $tmp_filler;
			if ($filler < 0) { $filler = 0 };
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			if ($filler >= 1) {
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
			}
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$day_str.gif\" width=\"48\" height=\"20\"></TD>";
			if ($filler >= 1) {
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
			}
			$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
		} else {				
			$legend_rec=$legend_rec."<TD WIDTH=\"$pix_count_12\" ALIGN=LEFT><B>$month_ary[$w]</B></TD>";
		}
		$w++;
	}

	if ($adj_pix > 0) {
		if ($adj_pix >= 50) {
			if ($GRAPHIC_LEGEND eq "TRUE") {
				$day_1 = uc (substr($mon,0,1));
				$day_2 = uc (substr($mon,1,1));
				$day_3 = uc (substr($mon,2,1));
				$day_str = $day_1.$day_2.$day_3;
				$tmp_filler = ($adj_pix - 50) / 2;
				$filler=sprintf "%3.0f", $tmp_filler;
				if ($filler < 0) { $filler = 0 };
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/$day_str.gif\" width=\"48\" height=\"20\"></TD>";
				if ($filler >= 1) {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$filler\" height=\"20\"></TD>";
				}
				$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
			} else {				
				$legend_rec=$legend_rec."<TD WIDTH=\"$adj_pix\" ALIGN=LEFT><B>$mon</B></TD>";
			}
		} else {
			if ($adj_pix > 0) {
				if ($GRAPHIC_LEGEND eq "TRUE") {
					$adj_pix_adj = $adj_pix - 1;
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"1\" height=\"20\"></TD>";
					if ($adj_pix_adj > 0) {
						$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/white.jpg\" width=\"$adj_pix_adj\" height=\"20\"></TD>";
					}
				} else {
					$legend_rec=$legend_rec."<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$adj_pix\" height=\"25\"></TD>";
				}
			}
		}
	}

	print "$legend_rec";
	print "</TR>";
	print "</TABLE>";
	if ($GRAPHIC_LEGEND eq "TRUE") {
		print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
		print "<TR>";
		print "<TD><IMG SRC=\"$BBWEB/gifs/black.jpg\" width=\"$pix_count\" height=\"2\"></TD>";
		print "</TR>";
		print "</TABLE>";
	}
	print "<TABLE WIDTH=\"$pix_count\" BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"#000033\">";
	print "<TR>";
	print "<TD WIDTH=\"$pix_count\"NOWRAP>$bar_rec_week52</TD>";
	print "</TR>";
	print "</TABLE>";
	print "</TD></TR></TABLE>";

######################################################################################

# The following section displays summaries for 1 day, 1 week, 4 weeks and 52 weeks

	print "<BR></FONT>";
	print "<TABLE BORDER=0 BGCOLOR=\"#000000\" CELLSPACING=3>";
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD ALIGN=CENTER COLSPAN=6><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>24 Hour Summary</B></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/green.gif\" ALT=\"green\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/yellow.gif\" ALT=\"yellow\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/red.gif\" ALT=\"red\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/purple.gif\" ALT=\"purple\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/clear.gif\" ALT=\"clear\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/blue.gif\" ALT=\"blue\" HEIGHT=16 WIDTH=16 BORDER=0></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${green_dayper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${yellow_dayper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${red_dayper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${purple_dayper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${clear_dayper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${blue_dayper};
	print "%</B></TD></TR>";
	print "<TR BGCOLOR=\"#000000\">";
	print "<TD COLSPAN=5 ALIGN=CENTER><FONT COLOR=\"#000000\" SIZE=-1><B>.</B></TD> </TR></TABLE>";
	print "</TD></TR></TABLE>";

	print "<TABLE BORDER=0 BGCOLOR=\"#000000\" CELLSPACING=3>";
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD ALIGN=CENTER COLSPAN=6><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>1 Week Summary</B></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/green.gif\" ALT=\"green\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/yellow.gif\" ALT=\"yellow\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/red.gif\" ALT=\"red\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/purple.gif\" ALT=\"purple\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/clear.gif\" ALT=\"clear\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/blue.gif\" ALT=\"blue\" HEIGHT=16 WIDTH=16 BORDER=0></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${green_weekper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${yellow_weekper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${red_weekper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${purple_weekper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${clear_weekper};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${blue_weekper};
	print "%</B></TD></TR>";
	print "<TR BGCOLOR=\"#000000\">";
	print "<TD COLSPAN=6 ALIGN=CENTER><FONT COLOR=\"#000000\" SIZE=-1><B>.</B></TD> </TR></TABLE>";
	print "</TD></TR></TABLE>";

	print "<TABLE BORDER=0 BGCOLOR=\"#000000\" CELLSPACING=3>";
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD ALIGN=CENTER COLSPAN=6><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>4 Week Summary</B></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/green.gif\" ALT=\"green\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/yellow.gif\" ALT=\"yellow\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/red.gif\" ALT=\"red\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/purple.gif\" ALT=\"purple\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/clear.gif\" ALT=\"clear\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/blue.gif\" ALT=\"blue\" HEIGHT=16 WIDTH=16 BORDER=0></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${green_week4per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${yellow_week4per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${red_week4per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${purple_week4per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${clear_week4per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${blue_week4per};
	print "%</B></TD></TR>";
	print "<TR BGCOLOR=\"#000000\">";
	print "<TD COLSPAN=6 ALIGN=CENTER><FONT COLOR=\"#000000\" SIZE=-1><B>.</B></TD> </TR></TABLE>";
	print "</TD></TR></TABLE>";

	print "<TABLE BORDER=0 BGCOLOR=\"#000000\" CELLSPACING=3>";
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\">";
	print "<TD ALIGN=CENTER COLSPAN=6><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"><B>52 Week Summary</B></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/green.gif\" ALT=\"green\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/yellow.gif\" ALT=\"yellow\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/red.gif\" ALT=\"red\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/purple.gif\" ALT=\"purple\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/clear.gif\" ALT=\"clear\" HEIGHT=16 WIDTH=16 BORDER=0></TD>";
	print "<TD ALIGN=CENTER><IMG SRC=\"$BBWEB/gifs/blue.gif\" ALT=\"blue\" HEIGHT=16 WIDTH=16 BORDER=0></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${green_week52per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${yellow_week52per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${red_week52per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${purple_week52per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${clear_week52per};
	print "%</B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$GRAPH_FONT\"><B>";
	printf "%7.4f", ${blue_week52per};
	print "%</B></TD></TR>";
	print "<TR BGCOLOR=\"#000000\">";
	print "<TD COLSPAN=6 ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>[Percentages may not total 100%]</B></TD></TR></TABLE>";
	print "</TD></TR></TABLE>";

######################################################################################

# The following section displays records in the history file

	if ($ENTRIES eq "$MAXENT") { &hist_last_entries(); } 
	if ($ENTRIES eq "all") { &hist_all(); }

	print "<P><CENTER><A HREF=\"$BBWEBCGI/bb-rep.sh\">Service Availability Report Generation</A></CENTER>";

	if ($BB_TYPE eq "NEW") {
		open FOOTER_FILE," $BBHEADER/hist_footer"; 
		while (<FOOTER_FILE>) {
			$_=~s/gifs\//$BBWEB\/gifs\//g;
			$_=~s/help\//$BBWEB\/help\//g;
			$_=~s/&BBREL/$BBREL/g;
                        $_=~s/&BBSKIN/$BBSKIN/g;
			print "$_";
		}
		close FOOTER_FILE; 
	} else {
		print "<!-- Footer for pages by bb-hist.sh, lives in $BBHOME/web/hist_footer -->";

		print "<CENTER><BR><BR><HR WIDTH=\"80%\">";
		print "<TABLE WIDTH=\"80%\" BORDER=0><TR>";
		print "<TD ALIGN=\"center\" WIDTH=\"16%\">";
		print "<FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\">";
		print "<IMG SRC=\"$BBWEB/gifs/green.gif\" WIDTH=\"16\" HEIGHT=\"16\" BORDER=\"0\"";
		print "ALIGN=\"middle\" ALT=\"green\"></A>ok</TD>";
		print "<TD ALIGN=\"center\" WIDTH=\"16%\">";
		print "<FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\">";
		print "<IMG SRC=\"$BBWEB/gifs/yellow.gif\" WIDTH=\"16\" HEIGHT=\"16\" BORDER=\"0\"";
		print "ALIGN=\"middle\" ALT=\"yellow\"></A>attention</TD>";
		print "<TD ALIGN=\"center\" WIDTH=\"16%\">";
		print "<FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\">";
		print "<IMG SRC=\"$BBWEB/gifs/red.gif\" WIDTH=\"16\" HEIGHT=\"16\" BORDER=\"0\"";
		print "ALIGN=\"middle\" ALT=\"red\"></A>trouble</TD>";
		print "<TD ALIGN=\"center\" WIDTH=\"16%\">";
		print "<FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\">";
		print "<IMG SRC=\"$BBWEB/gifs/purple.gif\" WIDTH=\"16\" HEIGHT=\"16\" BORDER=\"0\"";
		print "ALIGN=\"middle\" ALT=\"purple\"></A>no report</TD>";
		print "<TD ALIGN=\"center\" WIDTH=\"16%\">";
		print "<FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\">";
		print "<IMG SRC=\"$BBWEB/gifs/clear.gif\" WIDTH=\"16\" HEIGHT=\"16\" BORDER=\"0\"";
		print "ALIGN=\"middle\" ALT=\"clear\"></A>unavailable</TD>";
		print "<TD ALIGN=\"center\" WIDTH=\"16%\">";
		print "<FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\">";
		print "<IMG SRC=\"$BBWEB/gifs/blue.gif\" WIDTH=\"16\" HEIGHT=\"16\" BORDER=\"0\"";
		print "ALIGN=\"middle\" ALT=\"blue\"></A>offline</TD>";
		print "</TR></TABLE>";
		print "</CENTER>";
		print "<HR WIDTH=\"80%\">";
		print "<BR><BR>";
		print "<CENTER>";
		print "<H6>";
		print "<!-- The license agreement requires a link back to the BB main site -->";
		print "<FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\">";
		print "<A HREF=\"http://bb4.com\">";
		print "Big Brother Systems &amp; Network Monitor $vers</A><BR>";
		print "Copyright &copy; 1997-2000 The MacLawran Group Inc<BR>";
		print "All Rights Reserved";
		print "</FONT></H6></CENTER>";
	}
	print "</BODY></HTML>";
}

sub hist_last_entries {
	print "<BR><BR><CENTER>";
	print "<TABLE BORDER=0 BGCOLOR=\"#000033\" CELLSPACING=4>";
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\"><TD ALIGN=CENTER COLSPAN=4><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"<B>Last $MAXENT log entries</B><A HREF=\"$BBWEB/hist/$HISTFILE\"> (Full text log)</A><A HREF=\"$BBWEBCGI/bb-hist.sh?HISTFILE=$HISTFILE&ENTRIES=all\"> (Full HTML log)</A></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Event Start<B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Event End<B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Status<B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Seconds<B></TD>";

	while ($tablesize < $MAXENT) {				# Get # of records to display
		$_=pop(@$hist_array);				# Reads Record from array
		chop($_);

		$hist_rec=substr($_,25,60);			# History Data
		$hist_date=substr($_,0,25);			# Alpha Date
		($hdow,$hmon,$hday,$htime,$hyear) = split(/\s+/,$hist_date);    # Split up Alpha Date
		$hist_date_udl=$hdow."_".$hmon."_".$hday."_".$htime."_".$hyear; #  and place "_" between fields.

		($color,$timestamp,$seconds)=split(/\s+/,$hist_rec);	# Formatted History Record

		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($timestamp);
		$alpha_start = strftime("%a %b %d %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

		if ($seconds eq "") {
			$alpha_end = $alpha_now;
		} else {
			$new_timestamp = $timestamp + $seconds;

			($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($new_timestamp);
			$alpha_end = strftime("%a %b %d %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
		}

		if ($color ne "") {
			print "<TR BGCOLOR=\"$HIST_BKG_COLOR\"><TD ALIGN=LEFT><FONT FACE=\"$DATA_FONT\">$alpha_start</TD><TD ALIGN=CENTER>";
			print "<FONT FACE=\"$DATA_FONT\">$alpha_end</TD><TD ALIGN=CENTER>";
			if ($BB_TYPE eq "NEW") {
				print "<A HREF=\"$BBWEBCGI/bb-histlog.sh?HOST=$HOSTUDL&SERVICE=$SERVICE&TIMEBUF=$hist_date_udl\">";
			}
			print "<IMG SRC=\"$BBWEB/gifs/$color.gif\" BORDER=0 HEIGHT=16 WIDTH=16 ALT=\"$color\"></TD><TD ALIGN=CENTER><FONT FACE=\"$DATA_FONT\">$seconds</TD></TR>";
		}
		$tablesize++;
	}
	print "</TABLE><BR></CENTER>";
}

sub hist_all {
	print "<BR><BR><CENTER>";
	print "<TABLE BORDER=0 BGCOLOR=\"#000033\" CELLSPACING=3>";
	print "<TR BGCOLOR=\"$TITLE_BKG_COLOR\"><TD ALIGN=CENTER COLSPAN=4><FONT FACE=\"$TEXT_FONT\" COLOR=\"$TEXT_COLOR\"<B>All log entries</B><A HREF=\"$BBWEB/hist/$HISTFILE\"> (Full text log)</A><A HREF=\"$BBWEBCGI/bb-hist.sh?HISTFILE=$HISTFILE&ENTRIES=$MAXENT\"> (Last $MAXENT Records HTML log)</A></TD></TR>";
	print "<TR BGCOLOR=\"$DATA_BKG_COLOR\">";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Event Start<B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Event End<B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Status<B></TD>";
	print "<TD ALIGN=CENTER><FONT FACE=\"$HEADER_FONT\" COLOR=\"$HEADER_COLOR\" SIZE=-1><B>Seconds<B></TD>";

	while ($hist_count >= 0) {				# History records to display counter
		$_=pop(@$hist_array);				# Reads Record from array
		chop($_);

		$hist_rec=substr($_,25,60);			# History Data
		$hist_date=substr($_,0,25);			# Alpha Date
		($hdow,$hmon,$hday,$htime,$hyear) = split(/\s+/,$hist_date);    # Split up Alpha Date
		$hist_date_udl=$hdow."_".$hmon."_".$hday."_".$htime."_".$hyear; #  and place "_" between fields.

		($color,$timestamp,$seconds)=split(/\s+/,$hist_rec);	# Formatted History Record

		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($timestamp);
		$alpha_start = strftime("%a %b %d %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

		if ($seconds eq "") {
			$alpha_end = $alpha_now;
		} else {
			$new_timestamp = $timestamp + $seconds;

			($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($new_timestamp);
			$alpha_end = strftime("%a %b %d %H:%M:%S %Y",$sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
		}

		if ($color ne "") {
			print "<TR BGCOLOR=\"$HIST_BKG_COLOR\"><TD ALIGN=LEFT><FONT FACE=\"$DATA_FONT\">$alpha_start</TD><TD ALIGN=CENTER>";
			print "<FONT FACE=\"$DATA_FONT\">$alpha_end</TD><TD ALIGN=CENTER>";
			if ($BB_TYPE eq "NEW") {
				print "<A HREF=\"$BBWEBCGI/bb-histlog.sh?HOST=$HOSTUDL&SERVICE=$SERVICE&TIMEBUF=$hist_date_udl\">";
			}
			print "<IMG SRC=\"$BBWEB/gifs/$color.gif\" BORDER=0 HEIGHT=16 WIDTH=16 ALT=\"$color\"></TD><TD ALIGN=CENTER><FONT FACE=\"$DATA_FONT\">$seconds</TD></TR>";
		}
		$hist_count--;
	}
	print "</TABLE><BR></CENTER>";
}
