#!/usr/bin/perl -w
use strict; 

# make sure the MOJO lib is in the lib paths!
use lib qw(./ ./MOJO ../ ../MOJO); 

# use some of those Modules
use MOJO::Config;
use MOJO::HTML; 
use MOJO::Guts;

# we need this for cookie things
use CGI; 
my $q = new CGI; 

# this is how we find what list we're working on
my %login          = $q->cookie(-name => 'login'); 

my $admin_list     = $login{admin_list}               || undef; 
my $admin_password = $login{admin_password}           || undef; 


# This will take care of all out security woes
my $root_login = check_list_security(-Admin_List      => $admin_list, 
                                     -Admin_Password  => $admin_password, 
                                     -IP_Address      => $ENV{REMOTE_ADDR},
                                     -Function        => 'email_list_owners');
my $list = $admin_list; 

#---------------------------------------------------------------------#

my @list_owners = find_list_owners(); 




# get the list information
my %list_info = open_database(-List => $list); 
                              
# header     
print(admin_html_header(-Title      => "Send a message to all list owners",
		                -List       => $list_info{list},
		                -Form       => 0,
		                -Root_Login => $root_login));
	               
if(!$q->param('process')){ 
	print $q->start_form()								     .
		  $q->table({-cellpadding => 5, -border => 0}, 
		  $q->Tr(
		  $q->td({-valign => 'top'}, [
		  ($q->p("A plain text message will be sent from 
				  $list_info{mojo_email} to every other 
				  list owner")), 
		  ($q->p({-align => 'center'}, $q->b('List Owners:'), 
		   $q->br, 
		   $q->popup_menu( -size    => 5, 
						  '-values' => [@list_owners])))
		  ])))                                               .
		  $q->p($q->b('Subject: ', 
				$q->textfield(-name  => 'Subject',
							  -size  => 49)))                .
		  $q->p(
		  $q->textarea(-name => 'Body', 
					   -cols => 70, 
					   -rows => 15));
	print qq{
	
	<table align=right border=0>
	 <tr>
	  <td>
	   <input type="submit" style='$STYLE{yellow_submit}'  name=process value="Send Test Message">  
	  </td>
	  <td> 
	   <input type="submit" style='$STYLE{green_submit}'  name=process value="Send Message"> 
	  </td>
	 </tr>
	</table> 
	 <p>&nbsp;</p>
	};
	  	  
}else{ 
	require MOJO::Mail;
	my $mh = MOJO::Mail->new(\%list_info);
	foreach my $owner(@list_owners){ 
		$mh->send(
	 		To      => $owner, 
			From    => $list_info{mojo_email},
			Subject => $q->param('Subject'),
			Body    => $q->param('Body')
		);
	}
	print $q->p($q->b('Your message has been sent to all list owners')); 
}

#footer
print admin_html_footer(-Form => 0); 

sub find_list_owners {  
	my %lt;
	foreach(available_lists()){ 
		my %li = open_database(-List => $_); 
		$lt{$li{mojo_email}} = 1;
	}
	return keys %lt;
}


#---------------------------------------------------------------------#


=pod

=head1 Plugin: email_list_owners.cgi - Email All List Owners

This plugin allows any list owner to email every other list owner. 

=head2 Installation

Upload email_list_owners.cgi into your cgi-bin. We suggest you create 
a 'plugins' directory in the same directory that the mojo.cgi script 
is in. For example. If mojo.cgi is at: 

 /home/account/cgi-bin/mojo/mojo.cgi 

create a directory called plugins at: 

  /home/account/cgi-bin/mojo/plugins

and upload this script into that directory:

 /home/account/cgi-bin/mojo/plugins/email_list_owners.cgi

Once uploaded in plain text or ASCII mode, chmod the script to 755.   

Add this entry to the $ADMIN_MENU array ref:

	 {-Title           => 'Email All List Owners', 
	   -Title_URL      => $PLUGIN_URL."/email_list_owners.cgi",
	   -Function       => 'email_list_owners',
	   -Activated      => 1, 
	  },

It's possible that this has already been added to $ADMIN_MENU and all
you would need to do is uncomment this entry.

=head1 COPYRIGHT 

Copyright (c) 1999 - 2003 
Justin Simoni
me@justinsimoni.com http://justinsimoni.com

All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


=cut


