#!/usr/bin/perl -w
use strict; 

# make sure the MOJO lib is in the lib paths!
use lib qw(./ ./MOJO ../ ../MOJO); 

# use some of those Modules
use MOJO::Config;
use MOJO::HTML; 
use MOJO::Guts;

# we need this for cookies things
use CGI; 
my $q = new CGI; 

# this is how we find what list we're working on
my %login          = $q->cookie(-name => 'login'); 

my $admin_list     = $login{admin_list}               || undef; 
my $admin_password = $login{admin_password}           || undef; 


# This will take care of all out security woes
my $root_login = check_list_security(-Admin_List      => $admin_list, 
                                     -Admin_Password  => $admin_password, 
                                     -IP_Address      => $ENV{REMOTE_ADDR},
                                     -Function        => 'clickthrough_tracking');
my $list = $admin_list; 

# get the list information
my %list_info = open_database(-List => $list); 


use MOJO::Log::Clickthrough; 
my $rd = MOJO::Log::Clickthrough->new($list);
use MOJO::Archive; 
my $mja = MOJO::Archive->new(-List => \%list_info); 



my $f = $q->param('f'); 

my %Mode = ( 
'default'  => \&default, 
'm'        => \&message_report, 
'url'      => \&url_report, 
'activate' => \&activate,
'raw'      => \&raw, 
'purge'    => \&purge, 

); 
if(exists($Mode{$f})) { 
	$Mode{$f}->();  #call the correct subroutine 
}else{
	&default;
}
                              
# header     
sub default { 
print(admin_html_header(-Title      => "Clickthrough Tracking",
		                -List       => $list_info{list},
		                -Form       => 0,
		                -Root_Login => $root_login));


if($list_info{clickthrough_tracking} != 1){ 
	print $q->p('Clickthrough Tracking is ' . $q->b('off') . '<nobr />' . 
		$q->start_form . 
		$q->hidden('f', 'activate') . 
		$q->hidden('clickthrough_tracking', 1) . 
		$q->submit(-name => 'activate', -style=> $STYLE{green_submit}) . 
		$q->end_form
	);  
}else{ 
	print $q->p('Clickthrough Tracking is ' . $q->b('on') . '<nobr />' . 
		$q->start_form . 
		$q->hidden('f', 'activate') . 
		$q->hidden('clickthrough_tracking', 0) . 
		$q->submit(-name => 'deactivate', -style=> $STYLE{yellow_submit}) . 
		$q->end_form
	); 
}

print $q->hr;


print $q->p($q->b('Clickthrough Message Summaries:')); 
my $m_report = $rd->report_by_message_index;


print $q->start_table({-cellpadding => 5}); 
print $q->Tr($q->td([($q->p($q->b('Message'))),($q->p($q->b('Sent'))),($q->p($q->b('Clickthroughs'))),($q->p($q->b('View')))]));

foreach(sort { $a <=> $b  } keys %$m_report){ 
	print $q->Tr(
	      $q->td([
	      		  ($q->p($q->b($q->a({-href=>$q->url.'?f=m&mid='.$_},$m_report->{$_}->{message_subject})))),
	              ($q->p(MOJO::Guts::date_this(-Packed_Date => $_))),
		          ($q->p($m_report->{$_}->{count})),
	              ($q->p($q->a({-href=> $MOJO_URL.'?f=view_archive&id='.$_},'view message...'))),
	             ]));
}

print $q->end_table;

print $q->hr; 

print $q->p({-align => 'center'}, $q->start_form(-target => 'raw') . 
      $q->hidden('f', 'raw') . 
      $q->submit(-name   => 'View Raw Clickthrough Logs', 
                 -style  => $STYLE{green_submit}) .
      $q->end_form());


print $q->p({-align => 'center'}, $q->start_form . 
      $q->hidden('f', 'purge') . 
      $q->submit(-name   => 'Purge Clickthrough Logs', 
                 -style  => $STYLE{red_submit}) .
      $q->end_form());
      
      
print admin_html_footer(-Form    => 0,
                        -List    => $list_info{list},); 

} 

sub raw { 

print $q->header('text/plain'); 
      $rd->print_raw_logs; 
} 


sub purge { 
	unlink($rd->clickthrough_log_location);
	print $q->redirect(-uri => $q->url); 
}





sub activate { 
	my $clickthrough_tracking = $q->param('clickthrough_tracking') || 0; 
	MOJO::Guts::setup_list({
			list              => $list, 
			clickthrough_tracking => $clickthrough_tracking, 
						   }); 
	print $q->redirect(-uri => $q->url); 
} 



sub message_report { 
print(admin_html_header(-Title      => "Clickthrough Tracking - Message Report",
		                -List       => $list_info{list},
		                -Form       => 0,
		                -Root_Login => $root_login));
		                

print $q->p($q->b('Clickthrough Message Summary for: ' . find_message_subject($q->param('mid')))); 

my $m_report = $rd->report_by_message($q->param('mid')); 

print $q->start_table({-cellpadding => 5}); 
foreach(sort keys %$m_report){ 
	print $q->Tr(
	      $q->td([
	      		  ($q->p(
	               $q->b(
	               $q->a({-href=>$q->url.'?f=url&mid='.$q->param('mid').'&url='. MOJO::Guts::uriescape($_)}, $_
	               )))),
	              ($m_report->{$_}->{count}),
	
				 ]));
}

print $q->end_table;

print admin_html_footer(-Form    => 0,
                        -List    => $list_info{list},); 
} 


sub url_report { 
print(admin_html_header(-Title      => "Clickthrough Tracking - URL Report",
		                -List       => $list_info{list},
		                -Form       => 0,
		                -Root_Login => $root_login));
		                
print $q->p($q->b('Clickthrough Message Summary for: ' . find_message_subject($q->param('mid')) . ', for URL: ' . $q->param('url'))); 

my $m_report = $rd->report_by_url($q->param('mid'), $q->param('url')); 

print $q->p($q->b('Clickthrough Time:')) . $q->hr; 

print $q->start_table({-cellpadding => 5}); 
foreach(sort { $a <=> $b } @$m_report){ 
	print $q->Tr(
	      $q->td(
	      $q->p($q->b($_))
	      ));
}

print $q->end_table;

print admin_html_footer(-Form    => 0,
                        -List    => $list_info{list},); 
} 


sub find_message_subject { 
	my $mid = shift; 
	return  $mja->get_archive_subject($mid) || '#' . $mid;
}


=pod

=head1 Clickthrough Tracking - clickthrough_tracking.cgi

clickthrough_tracking.cgi gives you the ability to keep track on how many times
certain urls are clicked on in your list messages. 

=head1 Installing clickthrough_tracking.cgi

clickthrough_tracking.cgi should be installed into your mojo/plugins directory. Upload the script and change it's permissions to 755. 

Add this entry to the $ADMIN_MENU array ref:

	 {-Title          => 'Clickthrough Tracking', 
	  -Title_URL      => $PLUGIN_URL."/clickthrough_tracking.cgi",
	  -Function       => 'clickthrough_tracking',
	  -Activated      => 1, 
	  },

It's possible that this has already been added to $ADMIN_MENU and all
you would need to do is uncomment this entry.


=head1 Using clickthrough_tracking.cgi

Clickthrough tracking works by passing the URL you want to track to a script that keeps track of what URL gets clicked when, then redirecting the user to the real URL. 

To use the clickthrough tracking capabilities, first visit clickthrough_tracking.cgi in your web browser and B<activate clickthrough tracking> 

When you write a list message use the special [redirect] tag, instead of just a URL: 

B<Instead of:>

	http://yahoo.com

B<Write:>

    [redirect=http://yahoo.com]

If you're are writing an HTML message, 

B<Instead of:>

	<a href="http://yahoo.com">http://yahoo.com</a>

B<Write:>

	<a href="[redirect=http://yahoo.com]">http://yahoo.com</a>

Make sure: 

=over

=item * You do not put quotes around the URL in the [redirect] tag: 

B<NO!>

 [redirect="http://yahoo.com"]

B<Yes!>

 [redirect=http://yahoo.com]

=item You do not forget the I<http://> part of the URL:

B<NO!>

 [redirect=yahoo.com]

B<Yes!> 

  [redirect=http://yahoo.com]

If you want, you can use any protocal you want, be it http, ftp, ical, etc.
  
=back

=head1 Viewing Clickthrough Information

After a mailing list message is sent out with clickthrough redirects in them, the reports can be viewed by visiting clickthrough_tracking.cgi in your browser. 

=head1 FAQ

=over

=item * Does the clickthrough log save which subscriber (email address) clicks on which link?

B<No.> Email addresses aren't saved in the clickthrough logs. The clickthrough tracking is not meant to track individual users, but to get a general idea on what, if any, links people follow from email messages. 

Although the power of being able to track individual subscribers is great, it's also important to remember about people's privacy.

=item * Why are some of my message subjects in the reports a string of numbers? 

If you have deleted the archive entry associated with the message, or don't have archiving turned on, The tracking reports will use the message id associated with the mailing list message you're looking at. 

=item * Where are the clickthrough logs being written? 

Clickthrough logs are named B<listshortname-clickthrough.log>, where I<listshortnamt> is the list's shortname. 

These files are written in whatever directory you set the $LOGS variable to. If you haven't set the $LOGS variable, they'll get written wherever the $FILES variable is set to. 

=item * What else can I do with the logs? 

You can also fetch the raw clickthrough logs and open them up in a spreadsheet application, such as Excel and create your own reports from them. The format is as follows: 

 Date	Message-ID	URL

These three fields are tab-delimited. 

=back


=head1 COPYRIGHT 

Copyright (c) 1999 - 2003 
Justin Simoni
me@justinsimoni.com http://justinsimoni.com

All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=cut


