use kdb;

create temporary table `filter_tbl` type=MyISAM select ev.rec_id from `db_ext_values` as ev
left join `db_values` as v0 on v0.db_id = ev.db_id and v0.rec_id = ev.rec_id and v0.field_id = 1 and v0.value like '%r7%'
left join `db_values` as v1 on v1.db_id = ev.db_id and v1.rec_id = ev.rec_id and v1.field_id = 2 and v1.value like '%r7%'
where ev.db_id='1' and (v0.rec_id is not null and v1.rec_id is not null);

create unique index idx1 on `filter_tbl` (rec_id);
#
#select * from `filter_tbl`;

explain select ev.rec_id, ev.date_time, ev.note, ev.image, v1.value as field1, v2.value as field2, v3.value as field3
from `db_ext_values` as ev, `filter_tbl` as f
       left join `db_values` as v1 on v1.db_id = '1' and ev.rec_id = v1.rec_id and v1.field_id = 1
       left join `db_values` as v2 on v2.db_id = '1' and ev.rec_id = v2.rec_id and v2.field_id = 2
       left join `db_values` as v3 on v3.db_id = '1' and ev.rec_id = v3.rec_id and v3.field_id = 3
where ev.db_id='1' and ev.rec_id=f.rec_id
order by v1.value desc, v2.value desc\G