drop database if exists kdb;
create database if not exists kdb;

use kdb;

drop table if exists `users`;
create table `users` (
  `id` int not null auto_increment,
  `name` varchar(50) not null,
  `password` varchar(50) binary not null,
  `email` varchar(150) not null,
  `full_name` varchar(100) not null default '',
  `global_right` int not null default 0,
  `active` int(1) not null default 0,
  `registration_date` date not null,
  `expiration_date` date not null,
  `max_db_count` int not null default 3,
  primary key (`id`),
  unique key name_idx (`name`),
  unique key email_idx (`email`),
) type=InnoDB;

insert into `users`
  (`name`, `password`, `email`, `full_name`, `global_right`, `active`, `registration_date`, `expiration_date`, `max_db_count`)
values
  ('admin', '123123', 'admin@i-vortex.com', 'Administrator', 99, 1, now(), date_add(now(), interval 99 year), 999999),
  ('user1', '123123', 'test1@i-vortex.com', 'user number 1',  0, 1, now(), date_add(now(), interval 3 month), 3),
  ('user2', '123123', 'test2@i-vortex.com', 'user number 2',  0, 1, now(), date_add(now(), interval 3 month), 3);

drop table if exists `databases`;
create table `databases` (
  `id` int not null auto_increment,
  `owner` int not null,
  `name` varchar(255) not null,
  `description` varchar(255) not null default '',
  `last_rec_id` int not null default 0,
  `default_right` int not null default 0,
  `color_bg` varchar(20) not null default '#FFFFFF',
  `color_text` varchar(20) not null default '#000000',
  `color_border` varchar(20) not null default '#808080',
  `color_th_bg` varchar(20) not null default '#D0D0D0',
  `color_th_text` varchar(20) not null default '#000000',
  `color_link` varchar(20) not null default '#0000FF',
  `data_view` int(1) not null default 0,
  `note_view` int(1) not null default 1,
  `image_view` int(1) not null default 1,
  primary key (`id`),
  unique key owner_name_idx (`owner`, `name`)
) type=InnoDB;

insert into `databases` (`id`, `owner`, `name`, `description`, `color_bg`, `color_text`, `color_border`, `color_link`, `color_th_bg`, `color_th_text`, `default_right`)
       values (0, 2, 'user1-db1', 'none', '#CFFFCF', '#000000', '#40C040', '#C000FF', '#B0E0B0', '#0000B0', 40);

drop table if exists `db_fields`;
create table `db_fields` (
  `id` int not null auto_increment,
  `db_id` int not null,
  `position` int not null,
  `visible` int(1) not null default 1,
  `name` varchar(255) not null,
  primary key (`id`),
  index db_id_idx (`db_id`, `id`),
  unique key name_idx (`db_id`, `name`)
) type=InnoDB;

insert into `db_fields`
  (`db_id`, `position`, `name`)
values
  (1,  1, 'Field #1'),
  (1,  2, 'Field #2'),
  (1,  3, 'Field #3'),
  (1,  4, 'Field #4'),
  (1,  5, 'Field #5'),
  (1,  6, 'Field #6'),
  (1,  7, 'Field #7'),
  (1,  8, 'Field #8'),
  (1,  9, 'Field #9'),
  (1, 10, 'Field #10');

drop table if exists `db_ext_values`;
create table `db_ext_values` (
  `db_id` int not null,
  `rec_id` int not null,
  `date_time` timestamp,
  `note` mediumtext default null,
  `image` varchar(255) default null,
  primary key (`db_id`, `rec_id`)
) type=InnoDB;

drop table if exists `db_values`;
create table `db_values` (
  `db_id` int not null,
  `rec_id` int not null,
  `field_id` int not null,
  `value` tinytext default '',
  primary key (`db_id`, `rec_id`, `field_id`)
) type=InnoDB;

#insert into `db_ext_values` (db_id, rec_id, note) values (1, 1, 'None None None R1');
#insert into `db_values` values (1, 1, 1, 'Value F1R1');
#insert into `db_values` values (1, 1, 2, 'Value F2R1');
#insert into `db_values` values (1, 1, 3, 'Value F3R1');

#insert into `db_ext_values` (db_id, rec_id)       values (1, 2);
#insert into `db_values` values (1, 2, 1, 'Value F1R2');
#insert into `db_values` values (1, 2, 2, 'Value F2R2');
#insert into `db_values` values (1, 2, 3, 'Value F3R2');

#insert into `db_ext_values` (db_id, rec_id, note) values (1, 3, 'None None Note R3');
#insert into `db_values` values (1, 3, 1, 'Value F1R3');
#insert into `db_values` values (1, 3, 2, 'Value F2R3');
#insert into `db_values` values (1, 3, 3, 'Value F3R3');

#update `databases` set last_rec_id = 3 where id = 1;

drop table if exists `rights`;
create table `rights` (
  `id` int not null,
  `name` varchar(10) not null,
  `description` varchar(50) default '',
  primary key (`id`),
  unique key name_idx (`name`)
) type=InnoDB;

insert into `rights`
  (`id`, `name`, `description`)
values
  (0,  'NONE',   'None'),
#  (10, 'LIST',   'List'),
  (20, 'READ',   'Read'),
  (30, 'WRITE',  'Read/Write'),
  (40, 'MANAGE', 'Read/Write/Manage'),
  (99, 'ADMIN',  'Administrate application');

drop table if exists `db_user_rights`;
create table `db_user_rights` (
  `db_id` int not null,
  `user_id` int not null,
  `right_id` int default 0,
  primary key (`db_id`, `user_id`)
) type=InnoDB;

insert into `db_user_rights` (`db_id`, `user_id`, `right_id`) values (1, 2, 40);
