<?php
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  define("A_SUBMIT", "submit");

  $db_id = db_id() or redirect("dblist.php");
  check_WRITE($db_id) or redirect("dbview.php");

  if (isset($_REQUEST["rec_id"]))
    $rec_id = &$_REQUEST["rec_id"];
  elseif (isset($_SESSION["rec_id_$db_id"]))
    $rec_id = &$_SESSION["rec_id_$db_id"];
  else
    redirect("dbview.php");

  $head = get_db_header($db_id);
  $db_info =  get_db_info($db_id);
  $values = array();
  $is_image_attached = false;

  if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
    if ($action == A_SUBMIT) {
      foreach($head as $f_id => $f_name) {
        $values[$f_id] = $_REQUEST["field".$f_id];
      }
      $note = $_REQUEST["note"];
      $date_time = $_REQUEST["date_time"];
      $is_image_attached = $_REQUEST["is_image_attached"];
      $img = false;
      if (isset($_FILES["user_image"]["tmp_name"]) && file_exists($_FILES["user_image"]["tmp_name"]) && (filesize($_FILES["user_image"]["tmp_name"]) > 0)) {
        $img = getimagesize($_FILES["user_image"]["tmp_name"]);
        if (!$img) {
          add_error("Unknown image format");
        }
      }
      if (!has_error()) {
        foreach($head as $f_id => $f_name) {
          $sql = "select count(*) from `db_values` where db_id = $db_id and rec_id = $rec_id and field_id = '$f_id'";
          $row = db_fetch_row(db_query($sql));
          if ($row[0] == 0) {
            $sql = "insert into `db_values` (db_id, field_id, rec_id, value) values ($db_id, $f_id, $rec_id, '".
                   escape_sql_str($values[$f_id])."')";
          } else {
            $sql = "update `db_values` ".
                   "set    value = '".escape_sql_str($values[$f_id])."' ".
                   "where  db_id = $db_id and rec_id = $rec_id and field_id = $f_id";
          }
          db_query($sql);
        }
        if (strlen(trim($note)) > 0) {
          $sql = "update `db_ext_values` ".
                 "set    note = '".escape_sql_str($note)."' ".
                 "where  db_id = $db_id and rec_id = $rec_id";
        } else {
          $sql = "update `db_ext_values` ".
                 "set    note = NULL ".
                 "where  db_id = $db_id and rec_id = $rec_id";
        }
        db_query($sql);
        if (isset($_REQUEST["remove_image"])) {
          remove_image($db_id, $rec_id);
        } elseif ($img) {
          $inf = pathinfo($_FILES["user_image"]["name"]);
          $dst_name = $db_id."-".$rec_id.".".$inf["extension"];
          if (move_uploaded_file($_FILES["user_image"]["tmp_name"], IMAGE_PATH.$dst_name)) {
            set_image_name($db_id, $rec_id, $dst_name);
          }
        }
        redirect("dbview.php?db_id=$db_id");
      }
    }
  } else {
    $rec = get_db_record($db_id, $rec_id);
    foreach($head as $f_id => $f_name) {
        $values[$f_id] = $rec["field$f_id"];
    }
    $rec_id = $rec["rec_id"];
    $image = $rec["image"];
    $note =  $rec["note"];
    $date_time = $rec["date_time"];
    if (isset($rec["image"]))
      $is_image_attached = TRUE;
    else
      $is_image_attached = FALSE;
  }

  require_once("header.php");
  require_once("menu.php");

  show_error();

?>
<script language='JavaScript'>
  function doCancel() {
    window.location.href = "dbview.php?db_id=<?echo $db_id?>";
  }

  function doSubmit() {
    document.editForm.action.value = '<?echo A_SUBMIT?>';
    document.editForm.submit();
  }

  function toggleNewImg() {
    e = document.getElementById('newImg');
    if (document.editForm.remove_image.checked)
      e.style.visibility = 'hidden';
    else
      e.style.visibility = 'visible';
  }
</script>

<b><?echo $db_info["db_name"]?></b><br>
<?echo $db_info["description"]?><br><br>

<table border='0' cellpadding='0' cellspacing='0'>
<tr>
<td valign='top'>
<form name='editForm' method='post' enctype='multipart/form-data'>
<input type='hidden' name='db_id' value='<?echo $db_id?>'>
<input type='hidden' name='rec_id' value='<?echo $rec_id?>'>
<input type='hidden' name='date_time' value='<?echo $date_time?>'>
<input type='hidden' name='is_image_attached' value='<?echo $is_image_attached?>'>
<input type='hidden' name='action'>
<!--
<input type='button' class='btn' value=' |<< ' title='First record' disabled>
<input type='button' class='btn' value='  <  ' title='Previous record' disabled>
<input type='button' class='btn' value='  &#9679;  ' title='Previous record' disabled>
<input type='button' class='btn' value='  >  ' title='Next record' disabled>
<input type='button' class='btn' value=' >>| ' title='Last record' disabled>
&nbsp;&nbsp;&nbsp;&nbsp;
-->
<input type='button' class='btn' value='Submit' title='Submit new record' onclick='doSubmit()'>
<input type='button' class='btn' value='Cancel' title='Cancel new record' onclick='doCancel()'>
<br><br>
<b>Record ID:</b>  <?echo $rec_id?>
&nbsp;&nbsp;&nbsp;&nbsp;
<b>Created:</b> <?echo date("d-M-Y H:i", timestamp2date($date_time))?>
<br><br>
<table class='border'>
<?
  $focus = NULL;
  foreach ($head as $f_id => $f_name) {
    if (!isset($focus)) $focus = $f_id;
    echo "<tr class='border'>";
    echo "<th class='border' style='text-align:left'>$f_name</b></th>";
    echo "<td class='border'><input name='field$f_id' value='".$values[$f_id]."' style='width:300px'></td>";
    echo "</tr>\r";
  }
?>
</table>
</td>
<td width='20'>&nbsp;</td>
<td valign='top'>
<div>
<b>Image:</b><br>
<?
  if ($is_image_attached) {
    $sz = get_image_size($db_id, $rec["rec_id"], 200, 200);
    echo "<image src='user_images/".$rec["image"]."' width='".$sz["width"]."' height='".$sz["height"]."'>";
?>
</div>
<input type='checkbox' name='remove_image' onclick='toggleNewImg()'> Remove image
<? } ?>
<div id='newImg'><input type='file' name='user_image' style='width:400px;'></div>
<br>
<b>Note:</b><br>
<textarea name='note' style='font-family:monospace; width:400px; height:200px; white-space:pre;'><?echo $note?></textarea>
<br>
</td>
</tr>
</table>
</form>
<script language='JavaScript'>
  document.editForm.field<?echo $focus?>.focus();
</script>
<?
  require_once("footer.php");
?>