<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db.inc.php");

  define("A_UPDATE", "Update profile");

  deny_guest();

  $is_admin = check_ADMIN();

  if (isset($_REQUEST["user_id"]) && $is_admin) {
    $user_id = $_REQUEST["user_id"];
  } else {
    $user_id = uid();
  }

  $user = get_user_info($user_id);
  if ((!$user) && ($is_admin)) redirect("userlist.php");

  $rights = get_rights_array(TRUE);

  $global_right = NULL;
  $active = NULL;
  $expiration_date =  NULL;
  $max_db_count = NULL;

  $updated = FALSE;

  if (isset($_REQUEST["action"]) && ($_REQUEST["action"] == A_UPDATE)) {
    $password = FALSE;
    if (($_REQUEST["password1"] || $_REQUEST["password2"])) {
      if ($_REQUEST["password1"] == $_REQUEST["password2"])
        $password = $_REQUEST["password1"];
      else
        add_error("Incorrect password confirmation");
    }
    $full_name = $_REQUEST["full_name"];
    $email = $_REQUEST["email"];
    if ($is_admin) {
      $global_right = $_REQUEST["global_right"];
      $active = $_REQUEST["active"];
      $expiration_date = $_REQUEST["exp_year"]."-".$_REQUEST["exp_month"]."-".$_REQUEST["exp_day"];
      $max_db_count = $_REQUEST["max_db_count"];
    }
    if (!has_error()) {
      if ($is_admin)
        $updated = update_user($user_id, $password, $full_name, $email, $active, $global_right, $expiration_date, $max_db_count);
      else
        $updated = update_user($user_id, $password, $full_name, $email);
    }
  } else {
    $full_name = $user["full_name"];
    $email = $user["email"];
    $expiration_date = $user["expiration_date"];
    $max_db_count = $user["max_db_count"];
    if ($is_admin) {
      $global_right = $user["global_right"];
      $active = $user["active"];
    }
  }

  require_once("header.php");
  require_once("menu.php");

  show_error();
  if ($updated && !has_error()) echo "<br><b>Profile updated</b><br>\r";
?>
<br>
<form method='post'>
<table class='border'>
<tr>
  <th class='border' style='text-align:left'>ID:</th>
  <td class='border'><?echo $user["id"]?></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Login name:</th>
  <td class='border'><?echo $user["name"]?></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Password:</th>
  <td class='border'><input type='password' name='password1'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Confirm password:</th>
  <td class='border'><input type='password' name='password2'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Full name:</th>
  <td class='border'><input type='text' name='full_name' value='<?echo $full_name?>'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>e-Mail:</th>
  <td class='border'><input type='text' name='email' value='<?echo $email?>'></td>
</tr>
<? if ($is_admin) { ?>
<tr>
  <th class='border' style='text-align:left'>Global access right:</th>
  <td class='border'>
<select name='global_right'>
<?
  foreach($rights as $key => $value) {
    echo "<option value='".$key."'";
    if ($key == $global_right) echo " selected";
    echo ">".$value["description"]."</option>";
  }
?>
  </select></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Is active:</th>
  <td class='border'>
    <select name='active'>
    <option value='1'<?if ($active) echo " selected"?>>Yes</option>
    <option value='0'<?if (!$active) echo " selected"?>>No</option>
    </select>
  </td>
</tr>
<? } ?>
<tr>
  <th class='border' style='text-align:left'>Registration date:</th>
  <td class='border'><?echo sqldate2str($user["registration_date"])?></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Expiration date:</th>
  <td class='border'>
<?
  if ($is_admin) {
    echo date_input("exp", $expiration_date);
  } else {
    echo sqldate2str($user["expiration_date"]);
  }
?>
  </td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Max. DB count:</th>
  <td class='border'>
<?
  if ($is_admin) {
    echo "<input type='text' name='max_db_count' value='$max_db_count' style='width:5em;'>";
  } else {
    echo $max_db_count;
  }
?>
  </td>
</tr>
</table>
<br><input type='submit' class='btn' name='action' value='<?echo A_UPDATE?>'>
</form>
<? require_once("footer.php"); ?>
