<?php
  define("STATUS", "action_status=");
  header("Content-type: text/plain");

  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  function error_handler($errno, $errstr, $errfile, $errline) {
    echo STATUS."ERROR: ($errno) $errstr\r\n";
    flush();
    exit;
  }

  function do_login() {
    if (!login(get_param("name"), get_param("password")))
      trigger_error("Invalid user name or password");
  }

  function do_logout() {
    logout();
  }

  function do_ping_host() {
    return;
  }

  function do_get_db_list() {
    $dba = get_db_array();
    echo "count=".count($dba)."\r\n";
    $i = 0;
    foreach ($dba as $db_id => $db) {
      echo "db${i}_id=".$db["db_id"]."\r\n";
      echo "db${i}_name=".$db["db_name"]."\r\n";
      echo "db${i}_description=".$db["description"]."\r\n";
      $i++;
    }
  }

  function do_is_db_exists() {
    $db_name = get_param("name");
    $sql = "select count(*) from `databases` where owher = '".uid()."' and name = '".escape_sql_str($name)."'";
    $row = db_fetch_row(db_query($sql));
    echo "result=".(($row[0] > 0) ? "true" : "false")."\r\n";
  }

  function do_drop_db() {
    $db_id = get_param("db_id", -1);
    if(!check_MANAGE($db_id)) {
      trigger_error("Could not drop databases. Access denied.");
    }
    drop_db($db_id);
  }

  function do_create_db() {
    $db_name = get_param("name");
    $description = get_param("description");
    $fields_count = get_param("fields_count", 0);
    $fields = array();
    for ($i = 0; $i < $fields_count; $i++) {
      $fields[$i] = get_param("field$i");
    }
    $db_id = create_db($db_name, $description, 0, $fields);
    if (has_error()) {
      global $ERROR;
      unset($e);
      foreach ($ERROR as $key => $val) {
        if (isset($e) > 0)
          $e .= "; ".$val;
        else
          $e = $val;
      }
      trigger_error($e);
    }
    echo "db_id=".$db_id."\r\n";
  }

  function do_add_record() {
    $db_id = get_param("db_id", -1);
    $fields_count = get_param("fields_count", 0);
    $values = array();
    for ($i = 0; $i < $fields_count; $i++) {
      $values[$i] = get_param("field$i");
    }
    $note = get_param("@@@_note");
    $rec_id = db_add_record($db_id, $values, $note);
    $image_data = get_param("@@@_image_data");
    if ($image_data) {
      $fn = tempnam(chr(1), "kdb");
      $f = fopen($fn, "w+");
      fwrite($f, $image_data);
      fclose($f);
      $img_info = getimagesize($fn);
      if ($img_info) {
        $inf = pathinfo(get_param("@@@_image_name"));
        $dst_name = $db_id."-".$rec_id.".".$inf["extension"];
        log_msg("dst file `$dst_name`");
        rename($fn, IMAGE_PATH.$dst_name);
        set_image_name($db_id, $rec_id, $dst_name);
      }
    }
  }

  function get_param($name, $default = "") {
    if (!isset($_REQUEST[$name]))
      return $default;
    else
      return base64_decode($_REQUEST[$name]);
  }

  echo "//KDB-Response v.1.0\r\n";
  $method = "do_".get_param("action");
  echo "//method: $method\r\n";
  error_reporting(0);
  set_error_handler("error_handler");
  if (!function_exists($method)) {
    trigger_error("Method '$method' does not exists");
  }
  $method();
  echo STATUS."OK";
  flush();
  exit;
?>