<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  $db_id = db_id() or redirect("dblist.php");

  check_MANAGE($db_id) or need_login();

  define("A_UPDATE_DB", "Update");
  define("A_DROP_DB", "Drop Database");

  $db_info = get_db_info($db_id);
  if (!$db_info) redirect("dblist.php");
  $updated = FALSE;
  if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
    $db_info["db_name"] = $_REQUEST["db_name"];
    $db_info["description"] = $_REQUEST["description"];
    $db_info["default_right"] = $_REQUEST["right_id"];
    if ($action == A_UPDATE_DB) {
      $updated = db_update_info($db_info);
      $db_info = get_db_info($db_id);
    } elseif ($action == A_DROP_DB) {
      drop_db($db_id);
      unset($_SESSION["db_id"]);
      redirect("dblist.php");
    }
  }

  $fields = get_db_header($db_id);
  $rights = get_rights_array();

  require_once("header.php");
  require_once("menu.php");
  require_once("manage_menu.php");

  show_error();
  if ($updated) echo "<b>Information updated</b><br><br>";
?>
<script language='JavaScript'>
  function updateDatabase() {
    document.database_form.action.value = '<?echo A_UPDATE_DB?>';
    document.database_form.submit();
  }
  function dropDatabase() {
    if (confirm('Are you sure you want to drop the database?')) {
      document.database_form.action.value = '<?echo A_DROP_DB?>';
      document.database_form.submit();
    }
  }
</script>
<form method='post' name='database_form'>
<input type='hidden' name='field_id'>
<input type='hidden' name='action'>
<br>
<br>
<? require_once("footer.php"); ?>
