<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  $db_id = db_id() or redirect("dblist.php");

  check_MANAGE($db_id) or need_login();

  define("A_ADD_FIELD", "Add");
  define("A_RENAME_FIELD", "Rename");
  define("A_DROP_FIELD", "Drop");
  define("A_UPDATE_DB", "Update");
  define("A_MOVE_UP", "Up");
  define("A_MOVE_DN", "Down");
  define("A_TOGGLE_VISIBLE", "show_hide");

  $updated = FALSE;
  if (isset($_REQUEST["new_field_name"]))
    $new_field = $_REQUEST["new_field_name"];
  else
    $new_field = "";
  if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
    if ($action == A_ADD_FIELD) {
      add_db_field($db_id, $new_field);
    } elseif ($action == A_RENAME_FIELD) {
      $field_id = $_REQUEST["field_id"];
      db_rename_field($db_id, $field_id, $_REQUEST["field_".$field_id]);
    } elseif ($action == A_DROP_FIELD) {
      drop_db_field($db_id, $_REQUEST["field_id"]);
    } elseif ($action == A_MOVE_UP) {
      db_move_field_up($db_id, $_REQUEST["field_id"]);
    } elseif ($action == A_MOVE_DN) {
      db_move_field_dn($db_id, $_REQUEST["field_id"]);
    } elseif ($action == A_TOGGLE_VISIBLE) {
      db_toggle_visible($db_id, $_REQUEST["field_id"]);
    }
  }

  $fields = get_db_header($db_id, FALSE);
  $vfields = get_db_header($db_id, TRUE);

  require_once("header.php");
  require_once("menu.php");
  require_once("manage_menu.php");

  show_error();
  if ($updated) echo "<b>Information updated</b><br><br>";
?>
<script language='JavaScript'>

  function updateDatabase() {
    document.database_form.action.value = '<?echo A_UPDATE_DB?>';
    document.database_form.submit();
  }

  function dropField(id) {
    if (confirm("Would You like to drop field?")) {
      document.database_form.action.value = '<?echo A_DROP_FIELD?>';
      document.database_form.field_id.value = id;
      document.database_form.submit();
    }
  }

  function renameField(id) {
    document.database_form.action.value = '<?echo A_RENAME_FIELD?>';
    document.database_form.field_id.value = id;
    document.database_form.submit();
  }

  function addField(id) {
    document.database_form.action.value = '<?echo A_ADD_FIELD?>';
    document.database_form.submit();
  }

  function moveUp(id) {
    document.database_form.action.value = '<?echo A_MOVE_UP?>';
    document.database_form.field_id.value = id;
    document.database_form.submit();
  }

  function moveDown(id) {
    document.database_form.action.value = '<?echo A_MOVE_DN?>';
    document.database_form.field_id.value = id;
    document.database_form.submit();
  }

  function toggleVisible(id) {
    document.database_form.action.value = '<?echo A_TOGGLE_VISIBLE?>';
    document.database_form.field_id.value = id;
    document.database_form.submit();
  }

</script>

<form method='post' name='database_form'>
<input type='hidden' name='field_id'>
<input type='hidden' name='action'>
<table class='noborder'>
<tr>
  <th class='border' astyle='text-align:left;'>Field name</th>
  <th class='border' style='text-align:left;'>Visible</th>
  <th class='border' style='text-align:center;'>Position</th>
  <th class='noborder' colspan='2' style='text-align:left;'>&nbsp;</th>
</tr>
<? foreach ($fields as $key => $value) { $visible = isset($vfields[$key]); ?>
<tr>
  <td class='border'><input type='text' name='field_<?echo $key?>' value='<?echo $value?>' style='width:300px'></td>
  <td class='border' align='center'><input type='checkbox'<? if ($visible) echo " checked";?> onclick='toggleVisible(<?echo $key?>)'></td>
  <td class='border'>
    <input type="button" class='btn' value='<?echo A_MOVE_UP?>' onclick='moveUp(<?echo $key?>)'>
    <input type="button" class='btn' value='<?echo A_MOVE_DN?>' onclick='moveDown(<?echo $key?>)'>
  </td>
  <td class='border'><input type="button" class='btn' value='<?echo A_RENAME_FIELD?>' onclick='renameField(<?echo $key?>)'></td>
  <td class='border'><input type="button" class='btn' value='<?echo A_DROP_FIELD?>' onclick='dropField(<?echo $key?>)'></td>
</tr>
<? } ?>
<tr>
  <td class='border' colspan='5'>
    <b>New field name:</b> <input type='text' style='width:300px' name='new_field_name' value='<?echo $new_field?>'>
    <input type='button' class='btn' value='<?echo A_ADD_FIELD?>' onclick='addField()'>
  </td>
</tr>
</table>
</form>
<? require_once("footer.php"); ?>
