<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  define("A_UPDATE", "Update");

  $db_id = db_id() or redirect("dblist.php");

  check_MANAGE($db_id) or need_login();

  $updated = FALSE;

  if (isset($_REQUEST["action"]) && ($_REQUEST["action"] == A_UPDATE)) {
    $db_right = $_REQUEST["db_right"];
    $new_rights = array();
    $ra = explode(";", $_REQUEST["rights"]);
    foreach ($ra as $key => $value) {
      $r = explode("=", $value);
      if (count($r) == 2) $new_rights[$r[0]] = $r[1];
    }
    $updated = db_update_users_rights($db_id, $db_right, $new_rights);
  }

  $db_info = get_db_info($db_id) or redirect("dblist.php");
  $db_right = $db_info["default_right"];
  $ul = get_db_users_array($db_id);
  $rights = get_rights_array();

  require_once("header.php");
  require_once("menu.php");
  require_once("manage_menu.php");

  show_error();
  if ($updated) echo "<b>Information updated</b><br><br>";
?>
<script language='JavaScript'>
  var rights = new Array();

  function changeRights(uID, rID) {
    rights[uID] = rID;
  }

  function updateRights() {
    s = "";
    for (i = 0; i < rights.length; i++) {
      if (!isNaN(rights[i])) {
        if (s != "") s += ";";
        s += i + "=" + rights[i];
      }
    }
    document.rightForm.rights.value = s;
    document.rightForm.action.value = '<?echo A_UPDATE?>';
    document.rightForm.submit();
  }
</script>
<form name='rightForm' method='post'>
<table class='border'>
<tr>
  <th class='border' style='text-align:left;'><b>Default access right:</th>
  <td class='border'><select name='db_right'>
<?
  foreach($rights as $key => $value) {
    echo "<option value='".$key."'";
    if ($key == $db_right) echo " selected";
    echo ">".$value["description"]."</option>";
  }
?>
  </select></td>
</tr>
</table>
<br>
<table class='border'>
<tr>
  <th class='border'>Name</th>
  <th class='border'>Full Name</th>
  <th class='border'>eMail</th>
<? foreach ($rights as $key => $value) echo "<th class='border'>".$value["name"]."</th>"; ?>
</tr>
<?
  $r_manage = r_MANAGE();
  $current_user = uid();
  foreach($ul as $user_id => $user) {
    echo "<tr class='border'>\r";
    echo "<td class='border'>".$user["name"]."</td>\r";
    echo "<td class='border'>".$user["full_name"]."</td>\r";
    echo "<td class='border'><a href='mailto:".$user["email"]."'>".$user["email"]."</a></td>\r";
    foreach ($rights as $key => $value) {
      if (($key < $db_info["default_right"]) || (($user_id == $db_info["user_id"]) && ($key < $r_manage))) {
        echo "<td class='border'>&nbsp;</td>\r";
      } else {
        echo "<td class='border' align='center'>";
        echo "<input type='radio' name='u".$user["id"]."' onchange='changeRights(".$user["id"].",".$key.")'";
        if ($user["right_id"] == $key) echo " checked";
        echo "></td>\r";
      }
    }
    echo "</tr>\r";
  }
?>
</table>
<br>
<input type='hidden' name='db_id' value='<?echo $db_id?>'>
<input type='hidden' name='rights'>
<input type='hidden' name='action'>
<input type='button' class='btn' value='<?echo A_UPDATE?>' onclick='updateRights()'>
</form>
<? require_once("footer.php"); ?>
