<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  define("A_UPDATE", "Update");

  $db_id = db_id() or redirect("dblist.php");
  check_MANAGE($db_id) or need_login();

  $db_info = get_db_info($db_id);
  if (!$db_info) redirect("dblist.php");
  $updated = FALSE;

  if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
    $db_info["color_text"] = strtoupper($_REQUEST["color_text"]);
    $db_info["color_border"] = strtoupper($_REQUEST["color_border"]);
    $db_info["color_bg"] = strtoupper($_REQUEST["color_bg"]);
    $db_info["color_link"] = strtoupper($_REQUEST["color_link"]);
    $db_info["th_bg"] = strtoupper($_REQUEST["th_bg"]);
    $db_info["th_text"] = strtoupper($_REQUEST["th_text"]);
    $db_info["data_view"] = $_REQUEST["data_view"];
    $db_info["note_view"] = $_REQUEST["note_view"];
    $db_info["image_view"] = $_REQUEST["image_view"];
    if ($action == A_UPDATE) {
      $updated = db_update_info($db_info);
      $db_info = get_db_info($db_id);
    }
  }

  require_once("header.php");
  require_once("menu.php");
  require_once("manage_menu.php");
  require_once("color.php");

  show_error();
  if ($updated) echo "<b>Information updated</b><br><br>";
?>
<script language='JavaScript'>
  function updateAppearance() {
    document.appearance_form.action.value = '<?echo A_UPDATE?>';
    document.appearance_form.submit();
  }
</script>
<b>Database:</b> <?echo escape_html_str($db_info["db_name"])?><br>
<b>Description:</b> <?echo escape_html_str($db_info["description"])?><br><br>
<form method='post' name='appearance_form'>
<input type='hidden' name='action'>
<table class='border'>
<tr>
  <th class='border' style='text-align:left'>Backgroung color:</th>
  <td class='border'><input type='text' name='color_bg' id='color_bg' value='<?echo $db_info["color_bg"]?>' size='10'><input type='button' value='...' onclick='chooseColor("color_bg");'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Text color:</th>
  <td class='border'><input type='text' name='color_text' id='color_text' value='<?echo $db_info["color_text"]?>' size='10'><input type='button' value='...' onclick='chooseColor("color_text");'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Borders color:</th>
  <td class='border'><input type='text' name='color_border' id='color_border' value='<?echo $db_info["color_border"]?>' size='10'><input type='button' value='...' onclick='chooseColor("color_border");'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Table header text color:</th>
  <td class='border'><input type='text' name='th_text' id='th_text' value='<?echo $db_info["th_text"]?>' size='10'><input type='button' value='...' onclick='chooseColor("th_text");'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Table header background color:</th>
  <td class='border'><input type='text' name='th_bg' id='th_bg' value='<?echo $db_info["th_bg"]?>' size='10'><input type='button' value='...' onclick='chooseColor("th_bg");'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Links color:</th>
  <td class='border'><input type='text' name='color_link' id='color_link' value='<?echo $db_info["color_link"]?>' size='10'><input type='button' value='...' onclick='chooseColor("color_link");'></td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Data view:</th>
  <td class='border'>
    <select name='data_view'>
    <option value='<?echo DV_RECORD?>'<?if ($db_info["data_view"] == DV_RECORD) echo " selected"?>>One record</option>
    <option value='<?echo DV_TABLE?>'<?if ($db_info["data_view"] == DV_TABLE) echo " selected"?>>Table</option>
    </select>
  </td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Note view:</th>
  <td class='border'>
    <select name='note_view'>
    <option value='<?echo VO_DISABLED?>'<?if ($db_info["note_view"] == VO_DISABLED) echo " selected"?>>Disabled</option>
    <option value='<?echo VO_NORMAL?>'<?if ($db_info["note_view"] == VO_NORMAL) echo " selected"?>>Normal view</option>
    <option value='<?echo VO_BUTTON?>'<?if ($db_info["note_view"] == VO_BUTTON) echo " selected"?>>Button activated</option>
    </select>
  </td>
</tr>
<tr>
  <th class='border' style='text-align:left'>Image view:</th>
  <td class='border'>
    <select name='image_view'>
    <option value='<?echo VO_DISABLED?>'<?if ($db_info["image_view"] == VO_DISABLED) echo " selected"?>>Disabled</option>
    <option value='<?echo VO_NORMAL?>'<?if ($db_info["image_view"] == VO_NORMAL) echo " selected"?>>Normal view</option>
    <option value='<?echo VO_BUTTON?>'<?if ($db_info["image_view"] == VO_BUTTON) echo " selected"?>>Button activated</option>
    </select>
  </td>
</tr>
</table>
<br><input type='button' class='btn' value='<?echo A_UPDATE?>' onclick='updateAppearance()'><br>
</form>
<? require_once("footer.php"); ?>
