<?
  $ERROR = array();

  $RID = uniqid("");

  function add_error($message) {
    global $ERROR;
    $ERROR[] = $message;
  }

  function show_error() {
    global $ERROR;
    if (count($ERROR) > 0) {
      echo "<center><div style='color:red; border:solid 2px red; width:33%; text-align:left; padding:10px; margin:20px;'>";
      echo "<b>ERROR".((count($ERROR) > 1) ? "S" : "").":</b>";
      echo "<ul style='list-style-type: disc; margin-left: 2em; padding-left: 0em; margin-top:2px; margin-bottom:2px;'>";
      foreach ($ERROR as $key => $value) echo "<li>$value</li>";
      echo "</ul></div></center>";
    }
  }

  function has_error() {
    global $ERROR;
    return (count($ERROR) > 0);
  }

  function validate_email($email) {
    return ereg("^.*@.*\\..*$", $email);
  }

  function password_generator($min = 10, $max = 15) {
    //$min - minimum length of password
    //$max - maximum length of password
    $pwd = ""; // generated password
    for ($i = 0; $i < mt_rand($min, $max); $i++) {
      $num = mt_rand(48, 122);
      if (($num > 97 && $num < 122))
        $pwd .= chr($num);
      else if (($num > 65 && $num < 90))
        $pwd .= chr($num);
      else if (($num > 48 && $num < 57))
        $pwd .= chr($num);
      else if ($num == 95)
        $pwd .= chr($num);
      else
        $i--;
    }
    //return "123123";
    return $pwd;
  }

  function redirect($url) {
    header("Location: $url");
    exit;
  }

  function escape_sql_str($str) {
    return mysql_escape_string($str);
  }


  function __replace_callback($elements) {
    if ($elements[1] != "") {
      return "<a href='mailto:".$elements[0]."'>".$elements[0]."</a>";
    } elseif (strtolower($elements[4]) == "www.") {
      return "<a href='http://".$elements[0]."' target='_blank'>".$elements[0]."</a>";
    } else {
      return "<a href='".$elements[0]."' target='_blank'>".$elements[0]."</a>";
    }
  }

  function escape_html_str($str) {
    if (trim($str) == "") {
      return "&nbsp;";
    }
    $str = htmlspecialchars($str);
    $pat = "/(([\\w\\-\\.]+@)[\\w\\-\\.]+)|((http[s]?:\\/\\/|ftp:\\/\\/|www\\.)[\\w\\-\\.\\/\\?\\&\\%\\=]+)/i";
    $str = preg_replace_callback($pat, "__replace_callback", $str);
    return $str;
  }

  function timestamp2date($timestamp) {
    $y = substr($timestamp, 0, 4);
    $m = substr($timestamp, 4, 2);
    $d = substr($timestamp, 6, 2);
    $h = substr($timestamp, 8, 2);
    $n = substr($timestamp, 10, 2);
    $s = substr($timestamp, 12, 2);
    return mktime($h, $n, $s, $m, $d, $y);
  }

  function log_msg($msg) {
    global $RID;
    $dt = date("Y-m-d H:i:s");
    $fname = LOG_PATH."debug.log";
    error_log("[$dt][$RID] $msg\r\n", 3, $fname);
  }

  function sqldate2str($sql_date) {
    if (substr($sql_date, 0, 4) > 2035) $sql_date = "2035".substr($sql_date, 4);
    return date("d-M-Y", strtotime($sql_date));
  }

  function date_input($prefix, $date = FALSE) {
    $month_array = array("01" => "Jan", "02" => "Feb", "03" => "Mar", "04" => "Apr",
                         "05" => "May", "06" => "Jun", "07" => "Jul", "08" => "Aug",
                         "09" => "Sep", "10" => "Oct", "11" => "Nov", "12" => "Dec");
    if (!$date) {
      $d = $m = $y = "";
    } else {
      list($y, $m, $d) = split("-", $date); //split("-", date("Y-m-d", $date));
    }

    echo "<input type='text' name='{$prefix}_day' maxlength='2' value='$d' style='width:2em'> - ";
    echo "<select name='{$prefix}_month'>";
    if (!$date) echo "<option value='0'></option>";
    foreach ($month_array as $num => $name) {
      echo "<option value='$num'";
      if ($m == $num) echo " selected";
      echo ">$name</option>";
    }
    echo "</select> - ";
    echo "<input type='text' name='{$prefix}_year' maxlength='4' value='$y' style='width:4em'>";
  }

  function show_menu($menu) {
    $is_first = TRUE;
    echo "<b>";
    foreach($menu as $key => $value) {
      if (!$is_first) echo "&nbsp|&nbsp";
      echo "<a href='".$value["url"]."'>".$value["text"]."</a>";
      $is_first = FALSE;
    }
    echo "</b>\r";
  }

  function extractURL($str) {
    $ret = array();
    if (preg_match_all("/((http[s]?:\/\/[\w\-]+)|(www))(\.[\w\-]+)+(\/\S*)?/i", $str, $matches)) {
      foreach($matches[0] as $idx => $item) {
        if ($matches[3][$idx])
          $ret[count($ret)] = "http://".$item;
        else
          $ret[count($ret)] = $item;
      }
    }
    if (preg_match_all("/[\w\-\_\.]+@[\w-]+(\.[\w\-]+)+/i", $str, $matches)) {
      foreach($matches[0] as $item) $ret[count($ret)] = "mailto:$item";
    }
    return (count($ret) == 0) ? FALSE : $ret;
  }


?>
