<?
  require_once("config.inc.php");
  require_once("security.inc.php");
  require_once("db_util.inc.php");
  require_once("util.inc.php");

  define("FILTER_TABLE", "`filter`");

  // seek direction
  define("REC_FIRST", -2);
  define("REC_PREV",  -1);
  define("REC_CUR",    0);
  define("REC_NEXT",   1);
  define("REC_LAST",   2);

  // data_view options
  define("DV_RECORD", 0);
  define("DV_TABLE",  1);

  // note/image viewing option
  define("VO_DISABLED", 0);
  define("VO_NORMAL",   1);
  define("VO_BUTTON",   2);

  // filter type
  define("FT_ALL", "all");
  define("FT_ANY", "any");

  // filter condition type
  define("CT_CONTAINS", "contains");
  define("CT_BETWEEN",  "between");
  define("CT_EQUAL",   "equal");

  // get id of last used database
  function db_id($new_id = NULL) {
    $id = FALSE;
    if (isset($new_id)) {
      $id = $_SESSION["db_id"] = $new_id;
    } else {
      if (isset($_REQUEST["db_id"]) && is_numeric($_REQUEST["db_id"])) {
        $id = $_SESSION["db_id"] = $_REQUEST["db_id"];
      } elseif (isset($_SESSION["db_id"])) {
        $id = $_SESSION["db_id"];
      }
    }
    return $id;
  }

  function create_user($name, $full_name, $email, $global_right = 0) {
    if (!preg_match("/^[\w]{3,}$/i", $name)) {
      add_error("Invalid login name");
      return false;
    }
    if (!validate_email($email)) {
      add_error("Invalid e-mail address");
      return false;
    }
    $conn = db_connect();
    $sql = "select id from `users` where name='".escape_sql_str($name)."'";
    if (db_fetch_row(db_query($sql, $conn))) {
      add_error("User $name already registered");
      return false;
    }
    $sql = "select id from `users` where email = '".escape_sql_str($email)."'";
    if (db_fetch_row(db_query($sql, $conn))) {
      add_error("User with e-mail $email already registered");
      return false;
    }
    $password = password_generator();
    if (strlen(trim($full_name)) == 0) $full_name = $name;
    $sql = "insert into `users` (name, password, full_name, email, global_right, active, registration_date, expiration_date) ".
           "values ('".escape_sql_str($name)."', '".escape_sql_str($password)."', '".
           escape_sql_str($full_name)."', '".escape_sql_str($email)."', $global_right, 1, now(), date_add(now(), interval 3 month))";
    db_query($sql, $conn);

    if (!mail($email, "registration confirmation", "name: $name\rpassword: $password")) {
      $sql = "delete from `users` where name='".escape_sql_str($name)."'";
      db_query($sql, $conn);
      add_error("Count not send e-mail to $email");
      return false;
    }

/*
    $user_id = mysql_insert_id($conn);
    if (!mkdir(USER_PATH.$name, 0777)) {
      return false;
    }
    $f = fopen(USER_PATH.$name."/index.php", "w");
    fwrite($f, "<?php\r\n");
    fwrite($f, "require_once('../../inc/db.inc.php');\r\n");
    fwrite($f, "db_id(get_preffered_db($user_id));\r\n");
    fwrite($f, "header('Location: ../../dbview.php');\r\n");
    fwrite($f, "?>\r\n");
    fclose($f);
*/
    return true;
  }

  function get_preffered_db($user_id) {
    $sql = "select id from `databases` where owner = $user_id";
    $row = db_fetch_row(db_query($sql, $conn));
    return (isset($row)) ? $row[id] : -1;
  }

  function update_user($user_id, $password, $full_name, $email, $active = NULL, $global_right = NULL, $expiration_date = NULL, $max_db_count = NULL) {
    $password = trim($password);
    if (!validate_email($email)) {
      add_error("Invalid e-mail address");
      return FALSE;
    }
    $conn = db_connect();
    $sql = "select id from `users` where id = '$user_id'";
    if (!db_fetch_row(db_query($sql, $conn))) {
      add_error("User not found");
      return FALSE;
    }
    $sql = "select id from `users` where id <> '$user_id' and email = '".escape_sql_str($email)."'";
    if (db_fetch_row(db_query($sql, $conn))) {
      add_error("User with e-mail $email already registered");
      return FALSE;
    }
    if (strlen(trim($full_name)) == 0) $full_name = $name;
    $sql = "update `users` set ".
           "full_name = '".escape_sql_str($full_name)."', ".
           "email = '".escape_sql_str($email)."'";
    if (strlen($password) > 0) $sql .= ", password = '".escape_sql_str($password)."'";
    if (isset($active)) $sql .= ", active = '$active'";
    if (isset($global_right)) $sql .= ", global_right = '$global_right'";
    if (isset($expiration_date)) $sql .= ", expiration_date = '$expiration_date'";
    if (isset($max_db_count)) $sql .= ", max_db_count = '$max_db_count'";
    $sql .= " where id = '$user_id'";
    db_query($sql, $conn);
    return TRUE;
  }

  function get_user_info($user_id = NULL) {
    if (!isset($user_id)) $user_id = uid();
    $sql = "select sql_cache id, name, password, email, full_name, global_right, active, registration_date, expiration_date, max_db_count ".
           "from `users` where id = $user_id";
    $row = db_fetch_row(db_query($sql));
    if (!$row) return false;
    return $row;
  }

  function get_user_info_by_name($name) {
    $sql = "select id, name, password, email, full_name, global_right, active, registration_date, expiration_date ".
           "from `users` where name = '".escape_sql_str($name)."'";
    $row = db_fetch_row(db_query($sql));
    if (!$row) return false;
    return $row;
  }

  function get_users_array() {
    $sql = "select id, name, password, email, full_name, global_right, active, registration_date, expiration_date ".
           "from   `users` ".
           "order  by name";
    $res = db_query($sql);
    $ul = array();
    while ($row = db_fetch_row($res)) {
      $u = array();
      foreach ($row as $name => $value) $u[$name] = $value;
      $ul[$row["id"]] = $u;
    }
    return $ul;
  }

  function get_db_owner_info($db_id) {
    $sql = "select u.id, u.name, u.password, u.full_name, u.email, u.active, u.registration_date, u.expiration_date ".
           "from `users` u, `databases` db ".
           "where db.owner = u.id and db.id = $db_id";
    $row = db_fetch_row(db_query($sql));
    if (!$row) return false;
    return $row;
  }

  function get_db_array() {
    $sql = "select d.id as db_id, d.name as db_name, u.id as user_id, u.name as user_name, u.full_name, d.description as description ".
           "from `databases` as d, `users` as u ".
           "where u.id = d.owner ".
           "order by d.name";
    $res = db_query($sql);
    $db_array = array();
    while ($row = db_fetch_row($res)) {
      if (check_MANAGE($row["db_id"])) {
//        $a = array();
//        log_msg("====== ".$row["db_id"]);
//        foreach ($row as $name => $value) {
//          log_msg("  $name => `$value`");
//          $a[$name] = $value;
//        }
        $db_array[$row["db_id"]] = $row;
      }
    }
    return $db_array;
  }

  function get_db_info($db_id) {
    $sql = "select sql_cache d.id as db_id, d.name as db_name, u.id as user_id, u.name as user_name, u.full_name, \r\n".
           "       d.description, r.right_id, d.default_right, d.color_bg, d.color_text, d.color_border, d.color_link, \r\n".
           "       d.color_th_text as th_text, d.color_th_bg as th_bg, d.data_view, d.note_view, d.image_view \r\n".
           "from `databases` as d, `users` as u \r\n".
           "left join `db_user_rights` as r on r.db_id = d.id and r.user_id = ".uid()." \r\n".
           "where u.id = d.owner and d.id = $db_id";
    $row = db_fetch_row(db_query($sql));
    if ($row)
      return $row;
    else
      return FALSE;
  }

  function db_toggle_visible($db_id, $field_id) {
    $sql = "update `db_fields` set visible = not(visible) where db_id = '$db_id' and id = '$field_id'";
    db_query($sql);
  }

  function db_update_info($inf) { //, $db_id, $name, $description, $owner, $right_id) {
    $conn = db_connect();
    $sql = "select count(*) from `databases` where name = '".escape_sql_str($inf["db_name"])."' and ".
           "owner = '".$inf["user_id"]."' and id <> '".$inf["db_id"]."'";
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row[0] > 0) {
      add_error("Database '".$inf["db_name"]."' already exist");
      return FALSE;
    }
    $sql = "update `databases` set ".
           "owner = '".$inf["user_id"]."', ".
           "name = '".escape_sql_str($inf["db_name"])."', ".
           "description = '".escape_sql_str($inf["description"])."', ".
           "default_right = '".$inf["default_right"]."', ".
           "color_bg = '".escape_sql_str($inf["color_bg"])."', ".
           "color_text = '".escape_sql_str($inf["color_text"])."', ".
           "color_border = '".escape_sql_str($inf["color_border"])."', ".
           "color_link = '".escape_sql_str($inf["color_link"])."', ".
           "color_th_text = '".escape_sql_str($inf["th_text"])."', ".
           "color_th_bg = '".escape_sql_str($inf["th_bg"])."', ".
           "data_view = '".escape_sql_str($inf["data_view"])."', ".
           "note_view = '".escape_sql_str($inf["note_view"])."', ".
           "image_view = '".escape_sql_str($inf["image_view"])."' ".
           "where id = '".$inf["db_id"]."'";
    db_query($sql, $conn);
    return TRUE;
  }

  function create_db($db_name, $description, $right_id, $fields) {
    $db_name = trim($db_name);
    if (strlen($db_name) == 0) add_error("Missing database name");
    if (count($fields) == 0) add_error("At least one field required");
    // check empty field names and field names duplication
    for ($i = 0; $i < count($fields); $i++) {
      $fields[$i] = trim($fields[$i]);
      if (strlen($fields[$i]) == 0)  add_error("Empty field name isn't allowed");
      for ($j = $i + 1; $j < count($fields); $j++) {
        if (strcasecmp($fields[$i], $fields[$j]) == 0) {
          add_error("Field name '$fields[$i]' is duplicated");
        }
      }
    }
    if (has_error()) return FALSE;
    $conn = db_connect();
    $sql = "select u.max_db_count, count(db.id) as db_count ".
           "from `users` as u ".
           "left join `databases` as db on db.owner = u.id ".
           "where u.id = '".uid()."' and u.active = 1 ".
           "group by u.max_db_count";
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row) {
      if ($row["db_count"] >= $row["max_db_count"]) {
        add_error("Maximum number of databases exceeded");
      }
    } else {
      add_error("Could not create database for unregistered or blocked user");
      return FALSE;
    }

    $sql = "select count(*) from `databases` where name = '".escape_sql_str($db_name)."' and owner = ".uid();
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row[0] > 0) {
      add_error("Database '$db_name' already exist");
      return false;
    }
    $sql = "insert into `databases` (owner, name, description, default_right) values (".uid().", '".
           escape_sql_str($db_name)."', '".escape_sql_str($description)."', $right_id)";
    db_query($sql, $conn);
    $sql = "select LAST_INSERT_ID()";
    $row = db_fetch_row(db_query($sql, $conn));
    $db_id = $row[0];
    $pos = 0;
    foreach ($fields as $key => $val) {
      $pos++;
      $sql = "insert into `db_fields` (db_id, position, name) values ($db_id, $pos, '".escape_sql_str($val)."')";
      db_query($sql, $conn);
    }
    $sql = "insert into `db_user_rights` (db_id, user_id, right_id) values ($db_id, ".uid().", ".r_MANAGE().")";
    db_query($sql, $conn);
    return $db_id;
  }

  function drop_db($db_id) {
    $dir = opendir(IMAGE_PATH);
    while (FALSE !== ($file = readdir($dir))) {
      if (preg_match("/^".$db_id."\-\d+\.\w+$/", $file)) {
        unlink(IMAGE_PATH.$file);
      }
    }
    closedir($dir);

    $conn = db_connect();
    $sql = "delete from `db_values` where db_id = '$db_id'";
    db_query($sql, $conn);
    $sql = "delete from `db_ext_values` where db_id = '$db_id'";
    db_query($sql, $conn);
    $sql = "delete from `db_user_rights` where db_id = '$db_id'";
    db_query($sql, $conn);
    $sql = "delete from `db_fields` where db_id = '$db_id'";
    db_query($sql, $conn);
    $sql = "delete from `databases` where id = '$db_id'";
    db_query($sql, $conn);
  }

  function drop_db_field($db_id, $field_id) {
    $conn = db_connect();
    $sql = "select count(*) from `db_fields` where db_id = '$db_id'";
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row[0] == 1) {
      add_error("Could not drop a sole field");
      return FALSE;
    }
    $sql = "delete from `db_values` where db_id = '$db_id' and field_id = '$field_id'";
    db_query($sql, $conn);
    $sql = "delete from `db_fields` where db_id = '$db_id' and id = '$field_id'";
    db_query($sql, $conn);
    return TRUE;
  }

  function add_db_field($db_id, $name) {
    $name = trim($name);
    if (strlen($name) == 0) {
      add_error("Field name required");
      return FALSE;
    }
    $conn = db_connect();
    $sql = "select count(*) from `db_fields` where db_id = '$db_id' and name = '".escape_sql_str($name)."'";
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row[0] > 0) {
      add_error("Field '$name' already exists");
      return FALSE;
    }
    $sql = "select max(position) + 1 from `db_fields` where db_id = '$db_id'";
    $row = db_fetch_row(db_query($sql, $conn));
    if (isset($row[0]))
      $pos = $row[0];
    else
      $pos = 1;
    $sql = "insert into `db_fields` (db_id, visible, position, name) values ('$db_id', 1, '$pos', '".escape_sql_str($name)."')";
    db_query($sql, $conn);
    return TRUE;
  }

  function db_rename_field($db_id, $field_id, $name) {
    $name = trim($name);
    if (strlen($name) == 0) {
      add_error("Field name required");
      return FALSE;
    }
    $conn = db_connect();
    $sql = "select count(*) from `db_fields` where db_id = '$db_id' and id <> '$field_id' and name = '".escape_sql_str($name)."'";
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row[0] > 0) {
      add_error("Field '$name' already exists");
      return FALSE;
    }
    $sql = "update `db_fields` set name = '".escape_sql_str($name)."' where db_id = '$db_id' and id = '$field_id'";
    db_query($sql, $conn);
    return TRUE;
  }

  function db_add_record($db_id, $values, $memo) {
    $conn = db_connect();
    $sql = "select id from `db_fields` where db_id = '$db_id' order by id";
    $field_id = array();
    $res = db_query($sql, $conn);
    for ($i = 0; $row = db_fetch_row($res); $i++) {
      $field_id[$i] = $row[0];
    }
    $rec_id = generate_rec_id($db_id);
    $sql = "insert into db_ext_values (db_id, rec_id, note) values ('$db_id', '$rec_id', ";//null)";
    $sql .= (strlen($memo) > 0) ? "'".escape_sql_str($memo)."')" : "null)";
    db_query($sql, $conn);
    for ($i = 0; $i < min(count($field_id), count($values)); $i++) {
      $sql = "insert into `db_values` (db_id, field_id, rec_id, value) values ('$db_id', '".$field_id[$i]."', '$rec_id', '".
             escape_sql_str($values[$i])."')";
      db_query($sql, $conn);
    }
    return $rec_id;
  }

  function db_move_field_up($db_id, $field_id) {
    $conn = db_connect();
    $sql = "select position from `db_fields` where db_id = '$db_id' and id = '$field_id'";
    $row = db_fetch_row(db_query($sql, $conn));
    $cur_pos = $row[0];
    $sql = "select id from `db_fields` where db_id = '$db_id' and position < '$cur_pos' order by position desc";
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row) {
      $prev_id = $row[0];
      $sql = "select position from `db_fields` where db_id = '$db_id' and id = '$prev_id'";
      $row = db_fetch_row(db_query($sql, $conn));
      $prev_pos = $row[0];
      $sql = "update `db_fields` set position = '$prev_pos' where db_id = '$db_id' and id = '$field_id'";
      db_query($sql, $conn);
      $sql = "update `db_fields` set position = '$cur_pos' where db_id = '$db_id' and id = '$prev_id'";
      db_query($sql, $conn);
    }
  }

  function db_move_field_dn($db_id, $field_id) {
    $conn = db_connect();
    $sql = "select position from `db_fields` where db_id = '$db_id' and id = '$field_id'";
    $row = db_fetch_row(db_query($sql, $conn));
    $cur_pos = $row[0];
    $sql = "select id from `db_fields` where db_id = '$db_id' and position > '$cur_pos' order by position";
    $row = db_fetch_row(db_query($sql, $conn));
    if ($row) {
      $next_id = $row[0];
      $sql = "select position from `db_fields` where db_id = '$db_id' and id = '$next_id'";
      $row = db_fetch_row(db_query($sql, $conn));
     $next_pos = $row[0];
      $sql = "update `db_fields` set position = '$next_pos' where db_id = '$db_id' and id = '$field_id'";
      db_query($sql, $conn);
      $sql = "update `db_fields` set position = '$cur_pos' where db_id = '$db_id' and id = '$next_id'";
      db_query($sql, $conn);
    }
  }

  function set_image_name($db_id, $rec_id, $name) {
    $sql = "update `db_ext_values` set image = '".escape_sql_str($name)."' where db_id = '$db_id' and rec_id = '$rec_id'";
    db_query($sql);
  }

  function remove_image($db_id, $rec_id, $update_db = TRUE) {
    $sql = "select image from `db_ext_values` where db_id = '$db_id' and rec_id = '$rec_id'";
    if ($update_db) $sql .= " ";
    $row = db_fetch_row(db_query($sql));
    if ($update_db) {
      $sql = "update `db_ext_values` set image = NULL where db_id = $db_id and rec_id = $rec_id";
      db_query($sql);
    }
    if (($row) && (isset($row["image"]))) {
      unlink(IMAGE_PATH.$row["image"]);
    }
  }

  function remove_record($db_id, $rec_id) {
    remove_image($db_id, $rec_id, FALSE);
    $sql = "delete from `db_values` where db_id = $db_id and rec_id = $rec_id";
    db_query($sql);
    $sql = "delete from `db_ext_values` where db_id = $db_id and rec_id = $rec_id";
    db_query($sql);
  }

  function get_db_header($db_id, $visible_only = TRUE) {
    static $cache = array();
    if (!isset($cache[$db_id])) {
      $sql = "select id, name, visible from `db_fields` where db_id = $db_id order by position";
      $res = db_query($sql);
      while ($row = db_fetch_row($res)) {
        $cache[$db_id][$row["id"]] = array("name" => $row["name"], "visible" => $row["visible"]);
      }
    }
    $head = array();
    foreach ($cache[$db_id] as $f_id => $value) {
      if ((!$visible_only) || ($value["visible"]))
        $head[$f_id] = &$value["name"];
    }
    if (count($head) > 0)
      return $head;
    else
      return FALSE;
  }

  function get_record_array($db_id, $page = 1, $lines_per_page = 20) {
    $offset = ($page - 1) * $lines_per_page;
    $head = get_db_header($db_id);
    $sql = "select ev.rec_id, ev.date_time, ev.note, ev.image";
    foreach ($head as $f_id => $f_name) {
      $sql .= ", v$f_id.value as field$f_id";
    }
    $sql .= "\r\nfrom   `db_ext_values` as ev\r\n";
    foreach ($head as $f_id => $f_name) {
      $sql .= "       left join `db_values` as v$f_id on v$f_id.db_id = $db_id and ev.rec_id = v$f_id.rec_id and v$f_id.field_id = $f_id\r\n";
    }
    $sql .= "where  ev.db_id = $db_id\r\n".
            "order  by ev.rec_id\r\n".
            "limit  $offset, $lines_per_page";
    $res = db_query($sql);
    $record_array = array();
    while ($row = db_fetch_row($res)) {
      $a = array();
      $a["rec_id"] = $row["rec_id"];
      foreach ($head as $f_id => $f_name) {
        $a["field$f_id"] = $row["field$f_id"];
      }
      $a["date_time"] = $row["date_time"];
      $a["note"] = $row["note"];
      $a["image"] = $row["image"];
      $record_array[$row["rec_id"]] = $a;
    }
    return $record_array;
  }

  function get_db_record($db_id, $rec_id) {
    $head = get_db_header($db_id);
    $groups = array();
    $n = 0;
    foreach ($head as $f_id => $f_name) {
      $i = floor($n / 30);
      if (!isset($groups[$i])) {
        $groups[$i] = array("name" => "", "join" => "");
      }
      $groups[$i]["name"] .= ", v$f_id.value as field$f_id";
      $groups[$i]["join"] .= "left join `db_values` as v$f_id on v$f_id.db_id = ev.db_id and v$f_id.rec_id = ev.rec_id and v$f_id.field_id = '$f_id'\r\n";
      $n++;
    }

    $sql = "select ev.rec_id, ev.date_time, ev.note, ev.image\r\n".
           "from   `db_ext_values` as ev\r\n".
           "where  ev.db_id = '$db_id' and\r\n".
           "       ev.rec_id = '$rec_id'\r\n".
           "limit  1";
    $row = db_fetch_row(db_query($sql));
    if (!$row) return FALSE;
    $ret = array();
    $ret["rec_id"] = $row["rec_id"];
    $ret["date_time"] = $row["date_time"];
    $ret["note"] = $row["note"];
    $ret["image"] = $row["image"];

    foreach ($groups as $grp) {
      $sql = "select ev.rec_id".$grp["name"]."\r\n".
             "from   `db_ext_values` as ev\r\n".$grp["join"].
             "where  ev.db_id = '$db_id' and ev.rec_id = '$rec_id'\r\n".
             "limit  1";
      $row = db_fetch_row(db_query($sql));
      if ($row) {
        foreach ($row as $name => $value) {
          if (strncmp($name, "field", 5) == 0) {
            $ret[$name] = (isset($value)) ? $value : "";
          }
        }
      }
    }
    return $ret;
  }

  function get_db_users_array($db_id) {
    $sql = "select u.id, u.name, u.full_name, u.email, r.right_id ".
           "from `users` as u, `db_user_rights` as r ".
           "where r.db_id = '$db_id' and u.id = r.user_id ".
           "order by u.name";
    $users = array();
    $res = db_query($sql);
    while ($row = db_fetch_row($res)) {
      $users[$row["id"]] = $row;
    }
    return $users;
  }

  function db_update_users_rights($db_id, $db_default_right, $rights) {
    $conn = db_connect();
    $sql = "update `databases` set default_right = '$db_default_right' where id = '$db_id'";
    db_query($sql, $conn);
    if (isset($rights) && (count($rights) > 0)) {
      foreach($rights as $user_id => $right_id) {
        $sql = "select count(*) from `db_user_rights` where db_id = '$db_id' and user_id = '$user_id'";
        $row = db_fetch_row(db_query($sql, $conn));
        if ($row[0] > 0)
          $sql = "update `db_user_rights` set right_id = '$right_id' where db_id = '$db_id' and user_id = '$user_id'";
        else
          $sql = "insert into `db_user_rights` (db_id, user_id, right_id) values ('$db_id', '$user_id', '$right_id')";
        db_query($sql, $conn);
      }
    }
    return TRUE;
  }

  function make_sql_filter($filter) {
    $with_vals = FALSE;
    $t = $filter["filter_type"];
    $from = "`db_ext_values` as ev\r\n";
    $where = "";
    $n = 0;
    foreach ($filter["fields"] as $value) {
      $key = $value["field_id"];
      if ($where && ($filter["filter_type"] == FT_ALL))
        $where .= " and ";
      elseif ($where && ($filter["filter_type"] == FT_ANY))
        $where .= " or ";
      if (is_numeric($key)) {
        $where .= "v$n.rec_id is not null";
        if ($value["cond"] == CT_CONTAINS) {
          $from .= "left join `db_values` as v$n on v$n.db_id = ev.db_id and v$n.rec_id = ev.rec_id and v$n.field_id = $key and v$n.value like '%".escape_sql_str($value["value1"])."%'\r\n";
        } elseif ($value["cond"] == CT_BETWEEN) {
          $from .= "left join `db_values` as v$n on v$n.db_id = ev.db_id and v$n.rec_id = ev.rec_id and v$n.field_id = $key and v$n.value+0 between '".escape_sql_str($value["value1"])."' and '".escape_sql_str($value["value2"])."' and v$n.value rlike '^ *[\\+\\-]?[0123456789\\.\\,]'\r\n";
        } elseif ($value["cond"] == CT_EQUAL) {
          $from .= "left join `db_values` as v$n on v$n.db_id = ev.db_id and v$n.rec_id = ev.rec_id and v$n.field_id = $key and v$n.value = '".escape_sql_str($value["value1"])."'\r\n";
        }
        $with_vals = TRUE;
      } elseif ($key == "note") {
        if ($value["cond"] == CT_CONTAINS) {
          $where .= "ev.note like '%".escape_sql_str($value["value1"])."%'";
        } elseif ($value["cond"] == CT_BETWEEN) {
          $where .= "ev.note between '".escape_sql_str($value["value1"])."' and '".escape_sql_str($value["value2"])."'";
        } elseif ($value["cond"] == CT_EQUAL) {
          $where .= "ev.note = '".escape_sql_str($value["value1"])."'";
        }
      } elseif ($key == "record_id") {
        if ($value["cond"] == CT_CONTAINS) {
          $where .= "ev.rec_id like '%".escape_sql_str($value["value1"])."%'";
        } elseif ($value["cond"] == CT_BETWEEN) {
          $where .= "ev.rec_id between '".escape_sql_str($value["value1"])."' and '".escape_sql_str($value["value2"])."'";
        } elseif ($value["cond"] == CT_EQUAL) {
          $where .= "ev.rec_id = '".escape_sql_str($value["value1"])."'";
        }
      }
      $n++;
    }
    if ($where) $where = " and (".$where.")";
    return array("from" => $from, "where" => $where);
  }

  $FILTERED = FALSE;
  function create_filter_table($db_id, $sql_filter) {
    global $FILTERED;
    $FILTERED = TRUE;
    $sql = "drop table if exists ".FILTER_TABLE;
    db_query($sql);
    $sql = "create temporary table ".FILTER_TABLE." type=heap select ev.rec_id from ".$sql_filter["from"].
           "where ev.db_id = '$db_id'".$sql_filter["where"]." order by ev.rec_id";
    db_query($sql);
  }

  function get_records_count($db_id) {
    global $FILTERED;
    if ($FILTERED)
      $sql = "select count(*) from ".FILTER_TABLE;
    else
      $sql = "select count(*) from `db_ext_values` where db_id = '$db_id'";
    $row = db_fetch_row(db_query($sql));
    return $row[0];
  }

  function seek_db_record($db_id, $rec_id, $flag = REC_CUR) {
    switch ($flag) {
      case REC_FIRST:
        $sql = "select min(f.rec_id) from ".FILTER_TABLE." as f";
        break;
      case REC_PREV:
        $sql = "select max(f.rec_id) from ".FILTER_TABLE." as f where f.rec_id < '$rec_id'";
        break;
      case REC_CUR:
        $sql = "select f.rec_id from ".FILTER_TABLE." as f where f.rec_id = '$rec_id'";
        break;
      case REC_NEXT:
        $sql = "select min(f.rec_id) from ".FILTER_TABLE." as f where f.rec_id > '$rec_id'";
        break;
      case REC_LAST:
        $sql = "select max(f.rec_id) from ".FILTER_TABLE." as f";
        break;
      default:
        die("seek_db_record - invalid flag");
    }
      $row = db_fetch_row(db_query($sql));
    if (!$row || (!isset($row[0])))
      return FALSE;
    else
      return $row[0];
  }

  function generate_rec_id($db_id) {
    $sql = "select last_rec_id from `databases` where id = $db_id";
    $row = db_fetch_row(db_query($sql));
    $sql = "update `databases` set last_rec_id = last_rec_id + 1 where id = $db_id";
    db_query($sql);
    return $row["last_rec_id"] + 1;
  }

  function get_rights_array($all = FALSE) {
    $sql = "select sql_cache id, name, description from `rights` ";
    if (!$all) $sql .= "where id < 99 ";
    $sql .= "order by id";
    $a = array();
    $res = db_query($sql);
    while ($row = db_fetch_row($res)) {
      $a[$row["id"]] = $row;
    }
    return $a;
  }

  function set_right($db_id, $user_id, $right_id) {
    $conn = db_connect();
    $sql = "select right_id from `db_user_rights` where db_id = $db_id and user_id = $user_id";
    $row = db_fetch_row(db_query($sql, $conn));
    if (!$row) {
      $sql = "insert into `db_user_rights` (db_id, user_id, right_id) values ($db_id, $user_id, $right_id)";
      db_query($sql, $conn);
    } else {
      $sql = "update `db_user_rights` set right_id = $right_id where db_id = $db_id and user_id = $user_id";
      db_query($sql, $conn);
    }
  }

  function get_image_size($db_id, $rec_id, $max_width = NULL, $max_height = NULL) {
    $sql = "select image from `db_ext_values` where db_id = $db_id and rec_id = $rec_id";
    $row = db_fetch_row(db_query($sql));
    if (!$row) return FALSE;
    $path = IMAGE_PATH.$row["image"];
    $sz = getimagesize($path);
    $kw = (isset($max_width) && ($sz[0] > $max_width)) ? $max_width / $sz[0] : 1;
    $kh = (isset($max_height) && ($sz[1] > $max_height)) ? $max_height / $sz[1] : 1;
    $k = min($kw, $kh);
    $ret = array();
    $ret["_width"] = $sz[0];
    $ret["_height"] = $sz[1];
    $ret["width"] = round($sz[0] * $k);
    $ret["height"] = round($sz[1] * $k);
    $ret["zoom"] = round($k * 100);
    return $ret;
  }

  function print_db_style($db_id) {
    $sql = "select sql_cache color_bg, color_text, color_border, color_link, color_th_bg, color_th_text from `databases` where id = '$db_id'";
    list($bg, $text, $border, $link, $th_bg, $th_text) = db_fetch_row(db_query($sql));
    $fnt = "Verdana, Arial, Helvetica, sans-serif";
    echo "<style>\r";
    echo "body {background-color:$bg; color:$text; font-family:Verdana; font-size:11px;}\r";
    echo "input {color:$text; font-family: $fnt; font-size:11px;}\r";
    echo "select {color:$text; font-family: $fnt; font-size:11px;}\r";
    echo "textarea {color:$text; font-family: $fnt; font-size:11px;}\r";
    echo "input.btn {color:$text; font-family: $fnt; font-size:11px; font-weight:bold;}\r";
    echo "a {color:$link; font-family: $fnt; font-size:11px;}\r";
    echo ".border {color:$text; font-family: $fnt; font-size:11px; background-color:$bg; border-collapse:collapse; border:solid 2px $border; padding: 2px 4px;}\r";
    echo ".noborder {color:$text; font-family: $fnt; font-size:11px; background-color:$bg; border-collapse:collapse; border:none 0px $bg; padding: 2px 4px;}\r";
    echo "th.border {color:$th_text; font-family: $fnt; font-size:11px; background-color:$th_bg; border-collapse:collapse; border:solid 2px $border; padding: 2px 4px; white-space:nowrap;}\r";
    echo "th.lborder {color:$th_text; font-family: $fnt; font-size:11px; background-color:$th_bg; border-collapse:collapse; border:solid 2px $border; padding: 2px 4px; white-space:nowrap; text-align:left;}\r";
    echo "</style>\r";
  }

?>