<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  $A_ADD_RECORD    = "Add Record";
  $A_EDIT_RECORD   = "Edit Record";
  $A_DELETE_RECORD = "Delete Record";
  $A_DEL_SELECTED  = "Delete Selected";
  $LINES_PP = 25;

  $db_id = db_id() or redirect("dblist.php");
  if (!check_READ($db_id)) {
    deny_guest();
    redirect("not_allowed.php?db_id=$db_id");
  }
  $allowEdit = check_WRITE(db_id());
  if (isset($_REQUEST["action"])) {
    if ($allowEdit && ($_REQUEST["action"] == $A_DELETE_RECORD) && isset($_REQUEST["rec_id"])) {
      remove_record($db_id, $_REQUEST["rec_id"]);
    }
  }
  $head = get_db_header($db_id) or redirect("dblist.php");
  $db_info =  get_db_info($db_id);

  require_once("header.php");
  require_once("menu.php");

  if (isset($_REQUEST["filter_type"]))
    $filter_type = $_REQUEST["filter_type"];
  else
    $filter_type = FT_ALL;

  if (isset($_REQUEST["filters_count"]))
    $filters_count = $_REQUEST["filters_count"];
  else
    $filters_count = 0;

  function checkFields($i) {
    if (isset($_REQUEST["fCond$i"]) && isset($_REQUEST["ffield$i"])) {
      if (($_REQUEST["fCond$i"] == CT_CONTAINS) || ($_REQUEST["fCond$i"] == CT_EQUAL)) {
        if (isset($_REQUEST["fvalue1_$i"])) {
          return $_REQUEST["ffield$i"] != "" && $_REQUEST["fvalue1_$i"] != "";
        } else {
          return false;
        }
      } elseif ($_REQUEST["fCond$i"] == CT_BETWEEN) {
        if (isset($_REQUEST["fvalue1_$i"]) && isset($_REQUEST["fvalue2_$i"])) {
          return $_REQUEST["ffield$i"] != "" && $_REQUEST["fvalue1_$i"] != "" && $_REQUEST["fvalue2_$i"] != "";
        } else {
          return false;
        }
      }
    }
    return false;
  }

  function print_paginator($page, $pages_count) {
    if ($pages_count < 2) return;
    $p1 = 1;
    $p2 = $pages_count;
    if ($pages_count > 20) {
      $p1 = max(1, $page - 3);
      $p2 = min($pages_count, $p1 + 6);
    }
    echo "<b>Page: </b>";
    if ($p1 > 1) {
      echo "&nbsp;<a href='javascript:setPage(1);'>[1]</a>&nbsp;";
      echo "&nbsp;...&nbsp;";
    }
    for ($i = $p1; $i <= $p2; $i++) {
      if ($i == $page) {
        echo "&nbsp;<b>[$i]</b>&nbsp;";
      } else {
        echo "&nbsp;<a href='javascript:setPage($i);'>[$i]</a>&nbsp;";
      }
    }
    if ($p2 < $pages_count) {
      echo "&nbsp;...&nbsp;";
      echo "&nbsp;<a href='javascript:setPage($pages_count);'>[$pages_count]</a>&nbsp;";
    }
    echo "<br><br>";
  }

  $filters = array("filter_type" => $filter_type, "fields" => array());
  for ($i = 0; $i < $filters_count; $i++) {
    if (checkFields($i)) {
      $filters["fields"][$i] = array(
        "field_id" => $_REQUEST["ffield$i"],
        "cond" => $_REQUEST["fCond$i"],
        "value1" => $_REQUEST["fvalue1_$i"],
        "value2" => $_REQUEST["fvalue2_$i"]
      );
    }
  }

  $sql_filter = make_sql_filter($filters);
  create_filter_table($db_id, $sql_filter);

  $rec_count = get_records_count($db_id);
  $pages_count = ceil($rec_count / $LINES_PP);
  if (isset($_REQUEST["page"])) {
    $page = $_REQUEST["page"];
  } elseif (isset($_SESSION["page_".db_id()])) {
    $page = $_SESSION["page_".db_id()];
  } else {
    $page = 1;
  }
  $page = min($page, $pages_count);
  $_SESSION["page_".db_id()] = $page;
?>
<script language='JavaScript'>

  var fCount = 0;
  var opts = [['', '--- SELECT ---'], <? foreach ($head as $f_id => $f_name) echo "[$f_id, '$f_name'], "; ?>['note', 'Note'], ['record_id', 'Record ID']];
  var conds = ['<?echo CT_CONTAINS?>', '<?echo CT_BETWEEN?>', '<?echo CT_EQUAL?>'];

  function addRecord() {
    window.location.href = "record_add.php";
  }

  function editRecord(rec_id) {
    window.location.href = "record_edit.php?rec_id=" + rec_id;
  }

  function delRecord(rec_id) {
    if (confirm('Are you sure you want to delete record?')) {
      document.viewForm.filters_count.value = fCount;
      document.viewForm.action.value = "<?echo $A_DELETE_RECORD?>";
      document.viewForm.rec_id.value = rec_id;
      document.viewForm.submit();
    }
  }

  function delFilter() {
    if (fCount > 0) {
      fCount--;
      d = document.getElementById("dd" + fCount);
      d.parentNode.removeChild(d);
    }
  }

  function clearFilter() {
    while (fCount > 0) delFilter();
  }

  function setFilter() {
    document.viewForm.page.value = '1';
    document.viewForm.filters_count.value = fCount;
    document.viewForm.submit();
  }

  function setPage(page) {
    document.viewForm.page.value = page;
    document.viewForm.filters_count.value = fCount;
    document.viewForm.submit();
  }

</script>
<b>Database:</b> <?echo escape_html_str($db_info["db_name"])?><br>
<b>Description:</b> <?echo escape_html_str($db_info["description"])?><br>
<b>Records:</b> <?echo $rec_count?><br><br>

<form name='viewForm' method='post'>
<input type='hidden' name='db_id' value='<?echo $db_id?>'>
<input type='hidden' name='filters_count' value='<?echo $filters_count?>'>
<input type='hidden' name='action'>
<input type='hidden' name='page' value='<?echo $page?>'>
<input type='hidden' name='rec_id'>

<?include("filter.inc.php")?>
<br>
<?
  if ($allowEdit) {
?>
<input type='button' class='btn' value='Add record' title='Add new record' onclick='addRecord()'><br><br>
<?
  }
  print_paginator($page, $pages_count);
?>
<table class='noborder' style='white-space:wrap;' nowrap>
<?
  echo "<tr>";
  if ($allowEdit) {
    echo "<th class='noborder'><br></th>";
  }
  echo "<th class='border'>ID</th>";
  foreach ($head as $f_id => $f_name) {
    echo "<th class='border'>$f_name</th>";
  }
  if ($db_info["image_view"] != VO_DISABLED) {
    echo "<th class='border'>Image</th>";
  }
  if ($db_info["note_view"] != VO_DISABLED) {
    echo "<th class='border'>Note</th>";
  }
  echo "</tr>\r\n";
  $sql = "select ev.rec_id, ev.date_time, ev.note, ev.image";
  foreach ($head as $f_id => $f_name) {
    $sql .= ", v$f_id.value as field$f_id";
  }
  $sql .= "\r\nfrom ".FILTER_TABLE." as f, `db_ext_values` as ev\r\n";
  foreach ($head as $f_id => $f_name) {
    $sql .= "       left join `db_values` as v$f_id on v$f_id.db_id = '$db_id' and ev.rec_id = v$f_id.rec_id and v$f_id.field_id = $f_id\r\n";
  }
  $sql .= "where ev.db_id='$db_id' and ev.rec_id=f.rec_id\r\n".
          "limit ".($page - 1) * $LINES_PP.", $LINES_PP";

  $res = db_query($sql);
  while ($row = db_fetch_row($res)) {
    $rec_id = $row["rec_id"];
    echo "<tr>";
    if ($allowEdit) {
      echo "<td class='border' style='white-space:nowrap;'>";
      echo "<input type='button' class='btn' value='Edit' onclick='editRecord($rec_id);'>";
      echo "<input type='button' class='btn' value='Del' onclick='delRecord($rec_id);'>";
      echo "</td>";
    }
    echo "<td class='border' align='center'>$rec_id</td>";
    foreach ($head as $f_id => $f_name) {
      echo "<td class='border'>".escape_html_str($row["field".$f_id])."</td>";
    }

    if ($db_info["image_view"] != VO_DISABLED) {
      echo "<td class='border' align='center'>";
      if (isset($row["image"]))
        echo "<a href='user_images/".$row["image"]."' target='_blank'>VIEW<a>";
      else
        echo "<br>";
      echo "</td>";
    }
    if ($db_info["note_view"] != VO_DISABLED) {
      echo "<td class='border' align='center'>";
      if (isset($row["note"]))
        echo "<a href='note_view.php?rec_id=$rec_id' target='_blank'>VIEW<a>";
      else
        echo "<br>";
      echo "</td>";
    }
    echo "</tr>\r\n";
  }
?>
</table>
<br>
<? print_paginator($page, $pages_count); ?>
</form>
<? require_once("footer.php"); ?>
