<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  define("A_FIRST", "go_first");
  define("A_PREV", "go_prev");
  define("A_CURR", "go_curr");
  define("A_NEXT", "go_next");
  define("A_LAST", "go_last");
  define("A_DELETE_RECORD", "del_record");

  $db_id = db_id() or redirect("dblist.php");
  if (!check_READ($db_id)) {
    deny_guest();
    redirect("not_allowed.php?db_id=$db_id");
  }

  $head = get_db_header($db_id) or redirect("dblist.php");
  $db_info =  get_db_info($db_id);
  $allowEdit = check_WRITE(db_id());

  require_once("header.php");
  require_once("menu.php");
  
  if (isset($_REQUEST["filter_type"]))
    $filter_type = $_REQUEST["filter_type"];
  else
    $filter_type = FT_ALL;

  if (isset($_REQUEST["filters_count"]))
    $filters_count = $_REQUEST["filters_count"];
  else
    $filters_count = 0;

  if (isset($_REQUEST["action"]) && ($_REQUEST["action"] == A_DELETE_RECORD) && $allowEdit) {
    remove_record($db_id, $_REQUEST["rec_id"]);
  }

  function checkFields($i) {
    if (isset($_REQUEST["fCond$i"]) && isset($_REQUEST["ffield$i"])) {
      if (($_REQUEST["fCond$i"] == CT_CONTAINS) || ($_REQUEST["fCond$i"] == CT_EQUAL)){
        if (isset($_REQUEST["fvalue1_$i"])) {
          return $_REQUEST["ffield$i"] != "" && $_REQUEST["fvalue1_$i"] != "";
        } else {
          return false;
        }
      } elseif ($_REQUEST["fCond$i"] == CT_BETWEEN) {
        if (isset($_REQUEST["fvalue1_$i"]) && isset($_REQUEST["fvalue2_$i"])) {
          return $_REQUEST["ffield$i"] != "" && $_REQUEST["fvalue1_$i"] != "" && $_REQUEST["fvalue2_$i"] != "";
        } else {
          return false;
        }
      }
    }
    return false;
  }

  $filters = array("filter_type" => $filter_type, "fields" => array());
  for ($i = 0; $i < $filters_count; $i++) {
    if (checkFields($i)) {
      $filters["fields"][$i] = array(
        "field_id" => $_REQUEST["ffield$i"],
        "cond" => $_REQUEST["fCond$i"],
        "value1" => $_REQUEST["fvalue1_$i"],
        "value2" => $_REQUEST["fvalue2_$i"]
      );
    }
  }

  $sql_filter = make_sql_filter($filters);
  create_filter_table($db_id, $sql_filter);

  $rec_count = get_records_count($db_id);
  if ($rec_count == 0) {
    $first_rec_id = 0;
    $last_rec_id = 0;
    $rec_id = 0;
  } else {
    $first_rec_id = seek_db_record($db_id, 0, REC_FIRST, $sql_filter);
    $last_rec_id = seek_db_record($db_id, 0, REC_LAST, $sql_filter);
    if (!isset($_SESSION["rec_id_$db_id"])) $_SESSION["rec_id_$db_id"] = $first_rec_id;
    $rec_id = &$_SESSION["rec_id_$db_id"];
    $r = seek_db_record($db_id, $rec_id, REC_CUR, $sql_filter);
    if ($r === FALSE) {
      $r = seek_db_record($db_id, $rec_id, REC_NEXT, $sql_filter);
      if ($r === FALSE) {
        $r = seek_db_record($db_id, $rec_id, REC_PREV, $sql_filter);
        if ($r === FALSE) $r = $first_rec_id;
      }
    }
    $rec_id = $r;

    if (isset($_REQUEST["action"])) {
      $action = $_REQUEST["action"];
      if ($action == A_FIRST) {
        $rec_id = $first_rec_id;
      } elseif ($action == A_PREV) {
        $rec_id = seek_db_record($db_id, $rec_id, REC_PREV, $sql_filter);
      } elseif ($action == A_CURR) {
        // do nothing
      } elseif ($action == A_NEXT) {
        $rec_id = seek_db_record($db_id, $rec_id, REC_NEXT, $sql_filter);
      } elseif ($action == A_LAST) {
        $rec_id = $last_rec_id;
      }
      $_SESSION["rec_id_$db_id"] = &$rec_id;
    }
  }
  $rec = get_db_record($db_id, $rec_id);

?>
<script language='JavaScript'>

  var fCount = 0;
  var opts = [['', '--- SELECT ---'], <? foreach ($head as $f_id => $f_name) echo "[$f_id, '$f_name'], "; ?>['note', 'Note'], ['record_id', 'Record ID']];
  var conds = ['<?echo CT_CONTAINS?>', '<?echo CT_BETWEEN?>', '<?echo CT_EQUAL?>'];

  function seekRecord(rec) {
    document.viewForm.filters_count.value = fCount;
    document.viewForm.action.value = rec;
    document.viewForm.submit();
  }

  function addRecord() {
    window.location.href = "record_add.php";
  }

  function editRecord() {
    window.location.href = "record_edit.php";
  }

  function delRecord(rec_id) {
    if (confirm('Are you sure you want to delete record?')) {
      document.viewForm.filters_count.value = fCount;
      document.viewForm.action.value = "<?echo A_DELETE_RECORD?>";
      document.viewForm.rec_id.value = rec_id;
      document.viewForm.submit();
    }
  }

  function delFilter() {
    if (fCount > 0) {
      fCount--;
      d = document.getElementById("dd" + fCount);
      d.parentNode.removeChild(d);
    }
  }

  function clearFilter() {
    while (fCount > 0) delFilter();
  }

  function setFilter() {
    document.viewForm.filters_count.value = fCount;
    seekRecord('<?echo A_FIRST?>');
  }

</script>

<b>Database:</b> <?echo escape_html_str($db_info["db_name"])?><br>
<b>Description:</b> <?echo escape_html_str($db_info["description"])?><br><br>

<table border='0' cellpadding='0' cellspacing='0'>
<tr>
<td valign='top'>
<form name='viewForm' method='post'>
<input type='hidden' name='db_id' value='<?echo $db_id?>'>
<input type='hidden' name='filters_count' value='<?echo $filters_count?>'>
<input type='hidden' name='rec_id' value='<?echo $rec_id?>'>
<input type='hidden' name='action'>
<input type='button' class='btn' value=' |<< ' title='First record' onclick='seekRecord("<?echo A_FIRST?>")' <?if ($rec_id == $first_rec_id) echo "disabled"?>>
<input type='button' class='btn' value='  <  ' title='Previous record' onclick='seekRecord("<?echo A_PREV?>")' <?if ($rec_id <= $first_rec_id) echo "disabled"?>>
<input type='button' class='btn' value='  &#9679;  ' title='Refresh'  onclick='seekRecord("<?echo A_CURR?>")'>
<input type='button' class='btn' value='  >  ' title='Next record' onclick='seekRecord("<?echo A_NEXT?>")' <?if ($rec_id >= $last_rec_id) echo "disabled"?>>
<input type='button' class='btn' value=' >>| ' title='Last record' onclick='seekRecord("<?echo A_LAST?>")' <?if ($rec_id == $last_rec_id) echo "disabled"?>>
<? if ($allowEdit) { ?>
&nbsp;&nbsp;&nbsp;&nbsp;
<input type='button' class='btn' value='Edit' title='Edit current record' onclick='editRecord()' <? if (!$rec) echo "disabled"?>>
<input type='button' class='btn' value='Add' title='Add new record' onclick='addRecord()'>
<input type='button' class='btn' value='Delete' title='Delete current record' onclick='delRecord(<?echo $rec_id?>)' <? if (!$rec) echo "disabled"?>>
<? } ?>
<br><br>
<?include("filter.inc.php")?>
</form>
<? if (!$rec) {?>
<b>No records found</b>
<? } else { ?>
<b>Count: </b><?echo $rec_count?>
&nbsp;&nbsp;&nbsp;&nbsp;
<b>Record ID:</b> <?echo $rec["rec_id"]?>
&nbsp;&nbsp;&nbsp;&nbsp;
<b>Created:</b> <?echo date("d-M-Y H:i", timestamp2date($rec["date_time"]))?>
<br><br>
<table class='border'>
<?
  foreach ($head as $f_id => $f_name) {
    echo "<tr>";
    echo "<th class='lborder'><b>$f_name:</b>&nbsp;</th>";
    echo "<td class='border' style='width:400px'>";
    echo escape_html_str($rec["field$f_id"]);
    echo "</td>";
    echo "</tr>\r";
  }
?>
</table>
</td>
<td width='20'>&nbsp;</td>
<td valign='top'>
<?
  if (($db_info["image_view"] == VO_NORMAL) && $rec["image"]) {
   $sz = get_image_size($db_id, $rec["rec_id"], 300, 200);
?>
  <table class='border' style='width:300px;'>
  <tr><th class='lborder'>Image:</th></tr>
  <tr><td class='border' style='vertical-align:middle; text-align:center;'>
    <a href='user_images/<?echo $rec["image"]?>' target='_blank'>
    <image src='user_images/<?echo $rec["image"]?>' width='<?echo $sz["width"]?>' height='<?echo $sz["height"]?>'
    border='1' title='Size: <?echo $sz["_width"]?>x<?echo $sz["_height"]?> Zoom: <?echo $sz["zoom"]?>%'>
    </a>
  </td></tr>
  </table>
  <br><br>
<?
  } elseif (($db_info["image_view"] == VO_BUTTON) && $rec["image"]) {
?>
    <input type='button' class='btn' value='View image' onclick='window.open("user_images/<?echo $rec["image"]?>");'>
    <br><br>
<?
  }
  if (($db_info["note_view"] == VO_NORMAL) && isset($rec["note"])) {
?>
  <table class='border' style='width:300px;'>
  <tr><th class='lborder'>Note:</th></tr>
  <tr><td class='border' style='width:300px; height:200px; vertical-align:top;'>
    <iframe style='width:100%; height:100%; border-width:0;' frameborder='0' src='note_view.php?rec_id=<?echo $rec_id?>'></iframe>
  </td></tr>
  </table>
<?
  } elseif (($db_info["note_view"] == VO_BUTTON) && isset($rec["note"])) {
?>
  <input type='button' class='btn' value='View note' onclick='window.open("note_view.php?rec_id=<?echo $rec_id?>");'>
  <br><br>
<?
  }
?>
</td>
</tr>
</table>
<?
  }
?>
<? require_once("footer.php"); ?>
