var curItem = null;

function setColor(color) {
  curItem.value = color;
  closeColorSelector();
}

function showColor(color) {
  var obj = document.getElementById('colorValue').childNodes[0];
  obj.nodeValue = color;
}

function getRealLeft(el) {
  var xPos = el.offsetLeft;
  var tempEl = el.offsetParent;
  while (tempEl != null) {
    xPos += tempEl.offsetLeft;
    tempEl = tempEl.offsetParent;
  }
  return xPos;
}

function getRealTop(el) {
  var yPos = el.offsetTop;
  var tempEl = el.offsetParent;
  while (tempEl != null) {
    yPos += tempEl.offsetTop;
    tempEl = tempEl.offsetParent;
  }
  return yPos;
}

function chooseColor(id) {
  showColor('#------');
  curItem = document.getElementById(id);
  var cs = document.getElementById('colorSelector');
  cs.style.top = (getRealTop(curItem)) + 'px';
  cs.style.left = (getRealLeft(curItem) + curItem.offsetWidth + 55) + 'px';
  cs.style.visibility = 'visible';
}

function closeColorSelector() {
  var cs = document.getElementById('colorSelector');
  cs.style.visibility = 'hidden';
}

function initColor() {
  var color =  new Array(
    new Array('#ffffff', '#ffcccc', '#ffcc99', '#ffff99', '#ffffcc', '#99ff99', '#99ffff', '#ccffff', '#ccccff', '#ffccff'),
    new Array('#cccccc', '#ff6666', '#ff9966', '#ffff66', '#ffff33', '#66ff99', '#33ffff', '#66ffff', '#9999ff', '#ff99ff'),
    new Array('#c0c0c0', '#ff0000', '#ff9900', '#ffcc66', '#ffff00', '#33ff33', '#66cccc', '#33ccff', '#6666cc', '#cc66cc'),
    new Array('#999999', '#cc0000', '#ff6600', '#ffcc33', '#ffcc00', '#33cc00', '#00cccc', '#3366ff', '#6633ff', '#cc33cc'),
    new Array('#666666', '#990000', '#cc6600', '#cc9933', '#999900', '#009900', '#339999', '#3333ff', '#6600cc', '#993399'),
    new Array('#333333', '#660000', '#993300', '#996633', '#666600', '#006600', '#336666', '#000099', '#333399', '#663366'),
    new Array('#000000', '#330000', '#663300', '#663333', '#333300', '#003300', '#003333', '#000066', '#330099', '#330033'));
  var str = "<table class='border'>" +
            "<tr>" +
            "<th class='border' colspan='" + (color[0].length - 1) + "' style='font-size:10px;' id='colorValue'>&nbsp;</th>" +
            "<th class='border' style='font-size:10px; cursor:pointer;' onclick='closeColorSelector();'>X</th>" +
            "</tr>";
  for (x = 0; x < color.length; x++) {
    str += "<tr>\r\n";
    for (y = 0; y < color[x].length; y++) {
      var c = new String(color[x][y]).toUpperCase();
      str += "<td class='noborder' style='width:17px; height:17px; padding:0px; background-color:" + c + "; cursor:pointer;' onclick='setColor(\"" + c + "\")' onmouseover='showColor(\"" + c + "\")'>";
      str += "<br>";
      str += "</td>\r\n";
    }
    str += "</tr>\r\n";
  }
  str += "</table>\r\n";
  document.write(str);
//  var cs = document.getElementById('colorSelector');
//  cs.innerHTML = str;
//  alert(str);
}

//init();