<?
  require_once("inc/security.inc.php");
  require_once("inc/util.inc.php");
  require_once("inc/db_util.inc.php");
  require_once("inc/db.inc.php");

  deny_guest();

  define("A_ADD_FIELD", "Add");
  define("A_DEL_FIELD", "Remove");
  define("A_CREATE_DB", "Create Database");

  db_id(FALSE);
  $db_name = "";
  $description = "";
  $right_id = r_NONE();
  $fields = array();
  $action = "";

  if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
    $db_name = $_REQUEST["db_name"];
    $description = $_REQUEST["description"];
    $right_id = $_REQUEST["right_id"];

    for ($i = 0; $i < $_REQUEST["fields_count"]; $i++) {
      $fields[$i] = $_REQUEST["field_$i"];
    }

    if ($action == A_ADD_FIELD) {
      $field_name = trim($_REQUEST["new_field_name"]);
      if (strlen($field_name) == 0) {
        add_error("New filed name required");
      } else {
        $found = false;
        foreach ($fields as $n) {
          if (strcasecmp($field_name, $n) == 0) {
            $found = true;
            add_error("Field name duplicated");
            break;
          }
        }
        if (!$found) {
          $fields[count($fields)] = $field_name;
        }
      }
    } else if ($action == A_DEL_FIELD) {
      array_splice($fields, $_REQUEST["field_id"], 1);
    } else if ($action == A_CREATE_DB) {
      $db_id = create_db($db_name, $description, $right_id, $fields);
      if ($db_id) redirect("manage_main.php?db_id=$db_id");
    }
  }

  $rights = get_rights_array();

  require_once("header.php");
  require_once("menu.php");
  show_error();
?>
<script language='JavaScript'>
  function delField(id) {
    document.db_form.field_id.value = id;
    return true;
  }
</script>
<br><br>
<form method='post' name='db_form' id='db_form'>
<input type='hidden' name='fields_count' value='<?echo count($fields)?>'>
<input type='hidden' name='field_id'>
<table class='border'>
<tr>
  <td class='border'><b>Database name:</td>
  <td class='border'><input type='text' name='db_name' value='<?echo $db_name?>'></td>
</tr>
<tr>
  <td class='border'><b>Description:</td>
  <td class='border'><input type='text' name='description' value='<?echo $description?>'></td>
</tr>
<tr>
  <td class='border'><b>Dafault access right:</td>
  <td class='border'><select name='right_id'>
<?
  foreach($rights as $key => $value) {
    echo "<option value='".$key."'";
    if ($key == $right_id) echo " selected";
    echo ">".$value["description"]."</option>";
  }
?>
  </select></td>
</tr>
</table>
<br>
<table class='border'>
<tr>
  <td class='border' colspan='2'><b>Fields:</b></td>
</tr>
<?
  for ($i = 0; $i < count($fields); $i++) {
?>
<tr>
  <td class='border'><input type='text' name='field_<?echo $i?>' value='<?echo $fields[$i]?>' style='width:300px'></td>
  <td class='border'><input type="submit" class='btn' name="action" value='<?echo A_DEL_FIELD?>' onclick='return delField(<?echo $i?>);'></td>
</tr>
<?
  }
?>
<tr>
  <td class='border' colspan='2'>
    New field name: <input type='text' name='new_field_name'>
    <input type='submit' class='btn' name='action' value='<?echo A_ADD_FIELD?>'>
  </td>
</tr>
</table>
<br>
<input type='submit' class='btn' name='action' value='<?echo A_CREATE_DB?>'>
</form>
<script language='JavaScript'>
  document.db_form.db_name.focus();
</script>
<? require_once("footer.php"); ?>
