<?php
// Boosty's ASCIIArtist (http://www.sebastian-r.de/asciiart/)
// exe.php
// This script is called by the settings form (index.html)
// and starts the ASCIIArtist accordingly

// Load ASCIIArtist class file
require ('ASCIIArtist.php');
?>
<html>
<head>
    <title>Boosty's ASCIIArtist</title>
</head>
<body>
<div align="center">
<?php
// Image location submitted?
if (empty($_REQUEST['image'])) {
    echo '<p style="font-family: Verdana, sans-serif; font-size: 11px;">Error: No image location specified.</p>';
} else {
    // OK, let's get it on!
    
    // Create an ASCIIArtist object
    $ASCIIArtist = &new ASCIIArtist;
    
    // Set the given image file location (will return false if an error occurs)
    if (!$ASCIIArtist->setFile($_REQUEST['image'])) {
        // An error occured!
        echo $ASCIIArtist->getHTMLErrors();
    } else {
        // Flip horizontally?
        if ($_REQUEST['flip_h']) {
           $flip_h = true;
        } else {
            $flip_h = false;
        }
        
        // Flip vertically?
        if ($_REQUEST['flip_v']) {
            $flip_v = true;
        } else {
            $flip_v = false;
        }
        
        // Set the CSS as desired
        $ASCIIArtist->setImageCSS('
            color           : '.$_REQUEST['color'].';
            background-color: transparent;
            font-size       : '.$_REQUEST['font-size'].'px;
            font-family     : "Courier New", Courier, mono;
            line-height     : '.$_REQUEST['line-height']."px;
            letter-spacing  : ".$_REQUEST['letter-spacing'].'px;
        ');
        
        // Convert the image        
        $ASCIIArtist->renderHTMLImage($_REQUEST['mode'], $_REQUEST['resolution'], $_REQUEST['fixed_char'], $flip_h, $flip_v);
    
        // Print converted image as HTML
        echo $ASCIIArtist->getHTMLImage();
        
        // Show the original image aswell
        echo '<br><p style="font-family: Verdana, sans-serif; font-size: 11px;">Original Image:<br><img src="'.$_REQUEST['image'].'" height="'.$ASCIIArtist->getImageHeight().'" width="'.$ASCIIArtist->getImageWidth().'" alt="'.$_REQUEST['image'].', '.$ASCIIArtist->getImageWidth().' x '.$ASCIIArtist->getImageHeight().' px"></p>';
    }
}
?>
<p style="font-family: Verdana, sans-serif; font-size: 11px;">Powered by <a href="http://www.sebastian-r.de/asciiart/">Boosty's ASCIIArtist</a></p>
</div>
</body>
</html>
