#!/usr/bin/perl
###########################
#    name: decyphile	  #
#     author: jasper 	  #
# 	 aim_bot 	  #
# 	  v3.4	 	  #
# jasper@wintermarket.org #
###########################
#  These are special characters 
#  that you you can use in
#  allmost every aspect of
#  decyphile.
#
#%n - replaced with remote screenname
#%t - replaced with local time
#%d - replaced with local date
#%r - replaced with random number (1-9999)
#%s - replaced with random text (a-zA-Z0-9[]_-^{})
############################
#File last edited: 10/4/02 7:03PM
use strict;
use Net::AIM;
require 'evnts.lib';

##################
#bot configuration
my $screenname = shift || "BOT_SN"; #replace with your screenname
my $pass = shift || "PASSWORD"; #replace with screennames password
my $redirect = shift || 1; #redirect all messages bot receives to master (1=true,0=false)
my $chat = 1; #enable/disable automatic chat messages (1=true,0=false)
my $smart_resp = shift || 1; #enable smart responses (1=true,0=false)
my $away = 0; #set bot as always away (1=true,0=false)
my $away_msg = "Decyphile Bot is currently away!"; #bots away message (if away)
my $spare_bot = "Decyphilev34"; #Bot you will have user use if normal bot is warned to much
my $warning_lvl = 50; #warning level bot should stop responding at
my $log_path = "../logs"; #where to log everything; leave blank for no logging


if ($screenname eq '?') { &help(); } #display help
my $DEBUG = 0;
my $aim = new Net::AIM;
$aim->debug(1) if ($DEBUG);
my $ver = "Decyphile AIM Bot v3.4 :ActiveAgent:";

print "$ver Written By: Jasper <jasper\@wintermarket.org>\n\nInitializing NET::AIM...\n";

$aim->newconn(  Screenname => $screenname,
	 	Password => $pass,
	 	AutoReconnect => 1
	 	) or die "Can't Connect! Please Check your Internet Connection!\n";
my $conn = $aim->getconn();
print "NET::AIM Initialized!\n";

####################
#handler subroutines
print "Setting Up Handler Routines...\n";
$conn->set_handler('error',    \&on_error);
$conn->set_handler('im_in',    \&on_im);
$conn->set_handler('nick',    \&on_nick);
$conn->set_handler('eviled',    \&on_eviled);
$conn->set_handler('config',    \&on_config);
$conn->set_handler('chat_join',    \&on_chat_join);
$conn->set_handler('chat_left',    \&on_chat_left);
$conn->set_handler('chat_in',    \&on_chat);
$conn->set_handler('chat_invite',    \&on_chat_invite);
print "Handler Routine Setup Complete!\nStarting Bot!\n";
if ($redirect == 1) { $aim->set('redirect', &get_master()); }
if ($away == 1) { $aim->set('away_always',1); $aim->set('away_msg',$away_msg); }
$aim->set('smart_resp',$smart_resp);
$aim->set('my_name',$screenname);
$aim->set('chat_onoff',$chat);
$aim->set('version',$ver);
$aim->set('spare_bot',$spare_bot);
$aim->set('warn_lvl',$warning_lvl);
$aim->set('auto_join',"Bot");
$aim->set('log_path',$log_path);
$aim->start;


