#!/usr/bin/perl
use strict; 
#---------------------------------------------------------------------#
# mojo_bounce_handler.pl
# For instructions, see the pod of this file. try:
#  pod2text ./mojo_bounce_handler.pl | less
#---------------------------------------------------------------------#
# Required:

#Change! the lib paths
use lib qw(

 /home/account/www/cgi-bin/mojo
 /home/account/www/cgi-bin/mojo/MOJO
 /home/account/www/cgi-bin/mojo/MOJO/perllib
  

/usr/local/lib/perl5/site_perl/5.8.0/mach
/usr/local/lib/perl5/site_perl/5.8.0
/usr/local/lib/perl5/site_perl
/usr/local/lib/perl5/5.8.0/BSDPAN
/usr/local/lib/perl5/5.8.0/mach
/usr/local/lib/perl5/5.8.0

); 

	
my $Server   = '';
my $Username = ''; 
my $Password = '';

#---------------------------------------------------------------------#
# Optional:

my $Log; 

my $MessagesAtOnce = 100; 
 

my $Rules = [
{	

over_quota => {
					Examine => {
						Message_Fields => {
							Action                 => [qw(failed)],
							Status                 => [qw(5.2.2)],
						   'Final-Recipient_regex' => [(qr/RFC822/)], 
						   'Diagnostic-Code_regex' => [(qr/552|exceeded storage allocation|over quota|mailbox full/)],
							
						},
						
						Data => { 
							Email => 'is_valid', 
							List  => 'is_valid',
						}
						},
						Action => { 
							mail_list_owner => 'over_quota_message', 
						}
					}
},

{
yahoo_over_quota => {
					Examine => {
						Message_Fields => {
							Action                 => [qw(failed)],
							Status                 => [qw(5.0.0)],
						   'Remote-MTA_regex'      => [(qr/yahoo.com/)], 
						   'Final-Recipient_regex' => [(qr/RFC822/)], 
						   'Diagnostic-Code_regex' => [(qr/over quota/)],
							
						},
						Data => { 
							Email => 'is_valid', 
							List  => 'is_valid',
						}
						},
						Action => { 
							mail_list_owner => 'over_quota_message', 
						}
					}
},


{ 
	# AOL, apple.com, mac.com, altavista.net, pobox.com...  
	delivery_error_550 => { 
					Examine => {
						Message_Fields => {
							Action                =>  [qw(failed)],
							Status                =>  [qw(5.1.1)],
						   'Final-Recipient_regex' => [(qr/RFC822/)], 
						   'Diagnostic-Code_regex' => [(qr/SMTP\; 550|550 MAILBOX NOT FOUND|550 5\.1\.1 unknown or illegal alias|550 5\.1\.1(.*?)User unknown/)], 
					},
					Data => { 
							Email => 'is_valid', 
							List  => 'is_valid',
						}
					},
					Action => { 
							unsubscribe_bounced_email => 'from_list', 
							#mail_list_owner => 'user_unknown_message', 
					}
				}
},

{ 
	# Yahoo!
	delivery_error_554 => { 
					Examine => {
						Message_Fields => {
							Action                =>  [qw(failed)],
							Status                =>  [qw(5.0.0)],
						   'Diagnostic-Code_regex' => [(qr/554 delivery error/)], 
					},
					Data => { 
							Email => 'is_valid', 
							List  => 'is_valid',
							}
					},
					Action => { 
							unsubscribe_bounced_email => 'from_list', 
							#mail_list_owner => 'user_unknown_message', 
					}
				}
},





{
qmail_user_unknown => { 
					Examine => { 
						Message_Fields => { 
							Status      => [qw(5.x.y)], 
							Guessed_MTA => [qw(Qmail)],  
						}, 
						Data => { 
							Email       => 'is_valid',
							List        => 'is_valid', 
						}
					},
						Action => { 
							unsubscribe_bounced_email => 'from_list', 
					} 
				}
}, 

{
exim_user_unknown => { 
					Examine => { 
						Message_Fields => { 
							Status      => [qw(5.x.y)], 
							Guessed_MTA => [qw(Exim)],  
						}, 
						Data => { 
							Email       => 'is_valid',
							List        => 'is_valid', 
						}
					},
						Action => { 
							unsubscribe_bounced_email => 'from_list', 
						}, 
					}
}, 


{
# note! this should really make no sense, but I believe this is a bounce....
aol_user_unknown => {
					Examine => {
						Message_Fields => {
						   
							Status => [qw(2.0.0)],
							Action => [qw(failed)],
							'Reporting-MTA_regex'   => [(qr/aol\.com/)], 
						    'Final-Recipient_regex' => [(qr/RFC822/)], 
						    'Diagnostic-Code_regex' => [(qr/250 OK/)], # no for real, everything's "OK" #
							
					},
					Data => { 
						Email => 'is_valid', 
						List  => 'is_valid',
					}
					},
					Action => { 
						unsubscribe_bounced_email => 'from_list', 
						#mail_list_owner => 'user_unknown_message', 
					},
					}
},	






{ 



unknown_bounce_type => {
					Examine => { 
						Data => { 
							Email => 'is_valid', 
							List  => 'is_valid', 
						},
					}, 
					Action => { 
						mail_list_owner => 'unknown_bounce_type_message', 
					}
					
					}
},


{
email_not_found => {
					Examine => { 
						Data => { 
							Email => 'is_invalid', 
							List  => 'is_valid', 
						},
					}, 
					Action => { 
						mail_list_owner => 'email_not_found_message', 
					}
					
					}
},

#{
#who_knows => { 
#				Examine => {
#					Message_Fields => {},	
#				}, 
#				Action  => {append_message_to_file => $Log},
#			},
#},

]; 

use MOJO::Config; 

my $Bounce_Handler_Name = 'Mystery Girl'; 

my $Over_Quota_Subject = "Bounce Handler - warning user over quota";
my $Over_Quota_Message = qq{
Hello, This is $Bounce_Handler_Name, the bounce handler for $PROGRAM_NAME 

I received a message and it needs your attention. It seems
that the user, [subscriber_email] is over their email quota. 

This is probably a * temporary * problem, but if the problem persists,
you may want to unbsubscribe this address. 

I've attached what I was sent, if you're curious (or bored, what have you).  

You can remove this address from your list by clicking this link: 

[list_unsubscribe_link]

Below is the nerdy diagnostic report: 
-----------------------------------------------------------------------
[report]
-----------------------------------------------------------------------

- $Bounce_Handler_Name

}; 


my $User_Unknown_Subject = "Bounce Handler - warning user doesn't exist";
my $User_Unknown_Message = qq{
Hello, This is $Bounce_Handler_Name, the bounce handler for $PROGRAM_NAME 

I received a message and it needs your attention. It seems
that the user, [subscriber_email] doesn't exist, was deleted 
from the system, kicked the big can, etc. 

This is probably a * permanent * problem and I suggest you unsubscribe the
email address, but I'll let you have the last judgement. 

I've attached what I was sent, if you're curious (or bored, what have you).  

You can remove this address from your list by clicking this link: 

[list_unsubscribe_link]

Below is the nerdy diagnostic report: 
-----------------------------------------------------------------------
[report]
-----------------------------------------------------------------------

- $Bounce_Handler_Name

}; 

my $Email_Not_Found_Subject = "Bounce Handler - warning";
my $Email_Not_Found_Message = qq{
Hello, This is $Bounce_Handler_Name, the bounce handler for $PROGRAM_NAME 

I received a message and it needs your attention. The message was
bounced, but I cannot find the email associated with the bounce. 

Either I can't understand the bounced report, or there's a bug
in my sourcecode. Internet time is lighting fast and I fear I
may already be reduced to wasted 1's and 0's, *sigh*. 

I've attached what I was sent, if you're curious (or bored, what have you).  

Below is the nerdy diagnostic report: 
-----------------------------------------------------------------------
[report]
-----------------------------------------------------------------------

- $Bounce_Handler_Name

}; 


my $Email_Unknown_Bounce_Type_Subject = "Bounce Handler - warning";
my $Email_Unknown_Bounce_Type_Message = qq{
Hello, This is $Bounce_Handler_Name, the bounce handler for $PROGRAM_NAME 

I received a message and it needs your attention. The message was
bounced, but I dont know for what reason.

Either I can't understand the bounced report, or there's a bug
in my sourcecode. Internet time is lighting fast and I fear I
may already be reduced to wasted 1's and 0's, *sigh*. 

I've attached what I was sent, if you're curious (or bored, what have you).  

You can remove this address from your list by clicking this link: 

[list_unsubscribe_link]

Below is the nerdy diagnostic report: 
-----------------------------------------------------------------------
[report]
-----------------------------------------------------------------------

- $Bounce_Handler_Name

}; 



#---------------------------------------------------------------------#
# Nothing else to be configured.                                      #


my $App_Version = '.8';

use MOJO::App::Guts; 
use MOJO::Mail::Send; 
use MOJO::MailingList::Subscribers; 
use MOJO::MailingList::Settings; 

use Net::POP3;
use MIME::Parser;
use MIME::Entity; 
use Getopt::Long; 


my $parser = new MIME::Parser; 

my $Remove_List = {}; 
 
my $debug = 0; 

my $help = 0;
my $test; 
my $server; 
my $username; 
my $password; 
my $verbose = 0; 
my $log; 
my $Have_Log = 0; 
my $messages = 0; 

my $version; 


GetOptions("help"       => \$help, 
		   "test=s"     => \$test, 
		   "server=s"   => \$server, 
		   "username=s" => \$username, 
		   "password=s" => \$password, 
		   "verbose"    => \$verbose, 
		   "log=s"      => \$log,
		   "messages=i" => \$messages, 
		   "version"    => \$version,  
			); 		
&main; 

sub main { 
	
	
	&init; 
	
	if($help == 1){ 
		show_help(); 
	}elsif(defined($test) && $test ne 'bounces'){
		test_script(); 
	}elsif(defined($version)){ 
		&version(); 
	}
	
	
	print "Making POP3 Connection...\n" if $verbose; 
	
	my $pop          = Net::POP3->new($Server);
	my $messagecount = $pop->login($Username,$Password);

	if((defined($messagecount)) || ($messagecount == 0)){ 
		print "POP3 Connection worked!\n" if $verbose; 
		
		if($verbose){
			print "Mailbox is empty, no bounces to handle.\n\n" if $messagecount == 0; 
		}	
				
		my $i; 
	
		my $end = $messagecount; 
		   $end = $MessagesAtOnce if $MessagesAtOnce < $end; 
		
		for($i = 1; $i <= $end; $i++){ 
					
			my $message = join('', @{$pop->get($i)});
			parse_bounce(-message => $message); 
			
			$pop->delete($i) if ! $debug; 
			
		} 
		
	}		
	
	$pop->quit(); 
	remove_bounces($Remove_List) if ! $debug; 
	&close_log; 
}




sub init { 

	$Server         = $server   if $server;
	$Username       = $username if $username; 
	$Password       = $password if $password; 
	$Log            = $log      if $log; 
    $MessagesAtOnce = $messages if $messages > 0; 
    
 
	if($test){
		$debug = 1 if $test eq 'bounces'; 
	}
	
	$verbose = 1 if $debug == 1; 
	
	# init a hashref of hashrefs
	# for unsub optimization 
	my @a_Lists = MOJO::App::Guts::available_lists(); 
 	foreach(@a_Lists){ 
 		$Remove_List->{$_} = {}; 
 	}
 	
	open_log($Log); 
} 

			



sub parse_bounce { 
	my %args = (-message => undef, @_); 
				
	my $message = $args{-message}; 
	 
	my ($email, $list, $diagnostics);
	
	   $parser->output_to_core(1);
	my $entity; 
	
	eval { $entity = $parser->parse_data($message) };
	
	if(!$entity){ 
		warn "No MIME entity found, this message could be garbage, skipping"; 
	}else{ 
			
		if($verbose){ 
			print '-' x 72 . "\n"; 
			$entity->dump_skeleton; 
			print '-' x 72 . "\n"; 
		} 
		
		($list, $email, $diagnostics) = generic_parse($entity); 	
		
		if((!$list) || (!$email)){ 
			($list, $email, $diagnostics) = parse_for_qmail($entity); 
		} 
		
		if((!$list) || (!$email)){ 
			($list, $email, $diagnostics) = parse_for_exim($entity); 
		}
		
			#small hack, turns, %2 into, '-'
		$list =~ s/\%2d/\-/g;
		
		
		print generate_nerd_report($list, $email, $diagnostics) if $verbose;  
			my $rule = find_rule_to_use($list, $email, $diagnostics); 
			print "\nUsing Rule: $rule\n\n" if $verbose; 	

		if(!$debug){ 
			carry_out_rule($rule, $list, $email, $diagnostics, $message); 
		} 
	}
}




sub carry_out_rule { 
	
	my ($title, $list, $email, $diagnostics, $message) = @_; 
	my $actions = {};
	
	my $i = 0;
	foreach my $rule(@$Rules){ 
		if((keys %$rule)[0] eq $title){ 
			$actions = $Rules->[$i]->{$title}->{Action}; # wooo that was fun.
		}
		$i++;
	}

	#my $actions = $Rules->{$rule}->{Action}; 
	
	
	foreach my $action(keys %$actions){ 
		if($action eq 'unsubscribe_bounced_email'){ 
			unsubscribe_bounced_email($list, $email, $diagnostics, $actions->{$action}); 
		}elsif($action eq 'mail_list_owner'){
			mail_list_owner($list, $email, $diagnostics, $actions->{$action}, $message);
		}elsif($action eq 'append_message_to_file'){
			append_message_to_file($list, $email, $diagnostics, $actions->{$action}, $message);		
		}elsif($action eq 'default'){
			default_action($list, $email, $diagnostics, $actions->{$action}, $message);
		}else{ 
			warn "unknown rule trying to be carried out, ignoring"; 
		}
		log_action($list, $email, $diagnostics, "$action $actions->{$action}");
	}
}




sub default_action { 
	warn "Parsing... really didn't work. Ignoring and deleting bounce."; 
} 



sub unsubscribe_bounced_email {

	my ($list, $email, $diagnostics, $action) = @_; 
	my @delete_list; 
	
	if($action eq 'from_list'){ 
		$delete_list[0] = $list; 
	}elsif($action eq 'from_all_lists'){ 
		@delete_list = MOJO::App::Guts::available_lists(); 
	}else{ 
		warn "unknown action: '$action', no unsubscription will be made from this email!"; 
	}
	
	foreach(@delete_list){ 
		$Remove_List->{$_}->{$email} = 1;
		print "$email to be deleted off of: '$_'\n" if $verbose; 
	} 
		
}




sub mail_list_owner { 

	my ($list, $email, $diagnostics, $action, $message) = @_; 
	my $Body; 
	my $Subject; 
	
	if($action eq 'over_quota_message'){ 
		$Body    = $Over_Quota_Message; 
		$Subject = $Over_Quota_Subject;  
	}elsif($action eq 'user_unknown_message'){ 
		$Body    = $User_Unknown_Message; 
		$Subject = $User_Unknown_Subject;  
	}elsif($action eq 'email_not_found_message'){ 
		$Body    = $Email_Not_Found_Message; 
		$Subject = $Email_Not_Found_Subject;  
	}elsif($action eq 'unknown_bounce_type_message'){ 
		$Body    = $Email_Unknown_Bounce_Type_Subject; 
		$Subject = $Email_Unknown_Bounce_Type_Message; 		
	}else{ 
		warn "There's been a misconfiguration somewhere, $Bounce_Handler_Name is about to die..., ";
		warn "AAGGGGH!";
	}
	
		my $ls = MOJO::MailingList::Settings->new(-List => $list); 
		my $lh = MOJO::MailingList::Subscribers->new(-List => $list); 
		
	
	my $li = $ls->get; 
	
	my ($sub_status, $sub_errors) = $lh->subscription_check(-Email => $email); 
	
	
	# A little sanity check... 
	if($email eq $li->{admin_email}){ 
		warn "Bounce is from bounce handler, stopping '$action'"; 
	
	}elsif(($sub_errors->{subscribed} != 1) &&   (($action eq 'user_unknown_message') || ($action eq 'over_quota_message')) ){ 
		warn "parsed message contains an email that's not even subscribed. No reason to tell list owner";
	}else{ 
	
		my $report     = generate_nerd_report($list, $email, $diagnostics); 
		my $unsub_link = MOJO::App::Guts::unsubscribe_link(-email   => $email,
														   -list    => $list,  
														   -make_pin => 1);
															
		$Body =~ s/\[report\]/$report/; 
		$Body =~ s/\[list_unsubscribe_link\]/$unsub_link/g; 
		$Body = MOJO::App::Guts::interpolate_string(-String      => $Body, 		
													-List_Db_Ref => $li, 
													-Email       => $email); 		
		
		my $mh = MOJO::Mail::Send->new($li); 
	 
		
		my $msg = MIME::Entity->build(To      => $li->{mojo_email}, 
									  From    => $li->{admin_email},
									  Subject => $Subject,
									  Type    => 'multipart/mixed',
									  );
									  
									   
			$msg->attach(Type        => 'text/plain', 
						 Disposition => 'inline', 
						 Data        => $Body); 
											 
			$msg->attach(Type        => 'message/rfc822', 
						Disposition  => "attachment",
						Data         => $message); 
		
		$mh->send(
				  # Trust me on these :) 
				  $mh->return_headers($msg->stringify_header),
				  Body => $msg->stringify_body
				 );

		print "mail for $action on its way!\n" if $verbose; 
	}	

} 


sub append_message_to_file { 

	
	my ($list, $email, $diagnostics, $action, $message) = @_; 
	print "Appending Email to '$action'\n" if $verbose; 
			
	open(APPENDLOG, ">>$action") or die $!; 
	print APPENDLOG $message; 
	close(APPENDLOG) or die $!; 


}





sub generate_nerd_report { 
	my ($list, $email, $diagnostics) = @_;
	my $report; 
	$report = "List: $list\nEmail: $email\n\n"; 
	
	foreach(keys %$diagnostics){ 
		$report .= "$_: " . $diagnostics->{$_} . "\n"; 
	}	
	
	return $report; 
}




my $ir = 0;

sub find_rule_to_use { 
	my ($list, $email, $diagnostics) = @_;
	
	RULES: for ($ir = 0; $ir <= $#$Rules; $ir++){ 
		my $rule = $Rules->[$ir];  
		my $title = (keys %$rule)[0]; 
		
		next if $title eq 'default'; 
		my $match = {}; 
		my $examine = $Rules->[$ir]->{$title}->{Examine}; 
		
		my $message_fields = $examine->{Message_Fields};
		my %ThingsToMatch; 
		
		
		foreach my $m_field(keys %$message_fields){ 
			my $is_regex   = 0; 
			my $real_field = $m_field; 
			$ThingsToMatch{$m_field} = 0; 
			
			if($m_field =~ m/_regex$/){ 
				$is_regex = 1; 
				$real_field = $m_field; 
				$real_field =~ s/_regex$//;  
			}
			
			MESSAGEFIELD: foreach my $pos_match(@{$message_fields->{$m_field}}){ 
				if($is_regex == 1){ 
					if($diagnostics->{$real_field} =~ m/$pos_match/){ 	
						$ThingsToMatch{$m_field} = 1;
						next MESSAGEFIELD;
					}				
				}else{ 
				
					if($diagnostics->{$real_field} eq $pos_match){ 	
						$ThingsToMatch{$m_field} = 1;
						next MESSAGEFIELD;
					}
				
				}
			}	
			
		}

		# If we miss one, the rule doesn't work, 
		# All or nothin', just like life. 
		
		foreach(keys %ThingsToMatch){ 
			if($ThingsToMatch{$_} == 0){
				next RULES; 
			}
		}

   
	    if(keys %{$examine->{Data}}){ 
	    	if($examine->{Data}->{Email}){ 
	    	 	my $valid_email = 0; 
	    	 	my $email_match; 
	    	 	if(MOJO::App::Guts::check_for_valid_email($email) == 0){
	    	 			$valid_email = 1; 
	    	 	}
	    	 	if((($examine->{Data}->{Email} eq 'is_valid')   && ($valid_email == 1)) ||
				   (($examine->{Data}->{Email} eq 'is_invalid') && ($valid_email == 0))){
	    	 		$email_match = 1; 
	    	 	}else{ 
	    	 		next RULES;
	    	 	} 
	   		}
	   		
	   		if($examine->{Data}->{List}){ 
	    	 	my $valid_list = 0; 
	    	 	my $list_match; 
	    	 	if(MOJO::App::Guts::check_if_list_exists(-List=>$list) != 0){
	    	 		$valid_list = 1; 
	    	 	}
	    	 	if((($examine->{Data}->{List} eq 'is_valid')   && ($valid_list == 1)) ||
				   
				
				   (($examine->{Data}->{List} eq 'is_invalid') && ($valid_list == 0))){
	    	 		$list_match = 1;  
	    	 	}else{ 
	    	 		next RULES;
	    	 	}	 
	   		}
	    }
		return $title; 
	}
	return 'default'; 
}




sub generic_parse { 
	my $entity = shift; 
	my ($email, $list); 
	my $diag = {}; 

	($email, $diag) = find_delivery_status($entity); 	
	$list = generic_body_parse_for_list($entity); 
	
	$email = MOJO::App::Guts::strip($email);
	$email =~ s/^\<|\>$//g if $email;  
	$list  = MOJO::App::Guts::strip($list) if $list; 
	return ($list, $email, $diag); 
}




sub find_delivery_status { 
	my $entity = shift; 
	my @parts = $entity->parts; 
	my $email; 
	my $diag = {}; 
		
	if(!@parts){ 
		if($entity->head->mime_type eq 'message/delivery-status'){ 
			($email, $diag) = generic_delivery_status_parse($entity); 
	    	return ($email, $diag); 
		} 
	}else{ 
		my $i;
		foreach $i (0 .. $#parts) {
	    	my $part = $parts[$i];
			($email, $diag) = find_delivery_status($part); 
			if(($email) && (keys %$diag)){ 
				return ($email, $diag); 
			}
		}
	}
} 




sub generic_delivery_status_parse { 
	my $entity = shift; 
	my $diag = {}; 
	my $email; 
	
		# sanity check
		#if($delivery_status_entity->head->mime_type eq 'message/delivery-status'){ 	
			my $body = $entity->bodyhandle;
			my @lines;
			my $IO; 
			my %bodyfields;
			if($IO = $body->open("r")){ # "r" for reading.  
				while (defined($_ = $IO->getline)){ 
					if ($_ =~ m/\:/){ 
						my ($k, $v) = split(':', $_);
						chomp($v); 
						#$bodyfields{$k} = $v;
						$diag->{$k} = $v; 
					}
				} 
				$IO->close;
			}
			
			my ($rfc, $remail) = split(';', $diag->{'Final-Recipient'});
			
			$email = $remail; 
			
			#}
	
		foreach(keys %$diag){ 
			$diag->{$_} = MOJO::App::Guts::strip($diag->{$_}); 
		}
		
	return ($email, $diag); 
}




sub generic_body_parse_for_list { 

	my $entity = shift; 
	my $list; 
	
	
	my @parts = $entity->parts; 
	if(!@parts){ 
		if($entity->head->mime_type =~ /text/){ 
			$list = $entity->head->get('List', 0); 
			if(!$list){ 
				$list = find_list_from_unsub_list($entity); 
			}
			return $list if $list; 
		}
	}else{ 
		my $i; 
		foreach $i (0 .. $#parts) {
	    	my $part = $parts[$i];
			$list = generic_body_parse_for_list($part);
			if($list){ 
				return $list; 
			}
		}
	}	
}




sub find_list_from_unsub_list { 
	my $entity = shift; 
	my $list; 		
	my $body = $entity->bodyhandle; 
	my $IO; 
	
	if($IO = $body->open("r")){ # "r" for reading.  
		while (defined($_ = $IO->getline)){ 
			chomp($_); 
			if($_ =~ m/^List\:(.*?)$/){ 
				#yeah, sometimes the headers are in the body of
				#an attached message. Go figure. 
				$list = $1; 
			}elsif($_ =~ m/(.*?)\?l\=(.*?)\&f\=u\&e\=/){ 
				$list = $2;
			}elsif($_ =~ m/(.*?)\?f\=u\&l\=(.*?)\&e\=/){ 
				$list = $2; 	
			} 
		}
	} 
	
	$IO->close;	
	return $list; 
}




sub parse_for_qmail {

	# When I'm bored
	# => http://cr.yp.to/proto/qsbmf.txt
	# => http://mikoto.sapporo.iij.ad.jp/cgi-bin/cvsweb.cgi/fmlsrc/fml/lib/Mail/Bounce/Qmail.pm
	
	my $entity = shift;	
	my ($email, $list); 
	my $diag = {}; 
	my @parts = $entity->parts; 
	
	
	my $state       = 0;
	my $pattern     = 'Hi. This is the';
	my $end_pattern = '--- Undelivered message follows ---';
	my ($addr, $reason);
		
	if(!@parts){ 
		my $body = $entity->bodyhandle; 
		my $IO;
		if($body){ 
			if($IO = $body->open("r")){ # "r" for reading.  
				while (defined($_ = $IO->getline)){ 
					my $data = $_;
					
					if ($data =~ /$pattern/)     { $state = 1;}
					if ($data =~ /$end_pattern/) { $state = 0;}
	
	
					if ($state == 1) {
						$data =~ s/\n/ /g;
						if ($data =~ /\<(\S+\@\S+)\>:\s*(.*)/) {
							($addr, $reason) = ($1, $2);
							$diag->{Action} = $reason;
						
							my $status = '5.x.y';
							if ($data =~ /\#(\d+\.\d+\.\d+)/) {
								$status = $1;
							}elsif ($data =~ /\s+(\d{3})\s+/) {
								my $code = $1;
								$status  = '5.x.y' if $code =~ /^5/;
								$status  = '4.x.y' if $code =~ /^4/;
							
								$diag->{Action} = $code; 
							}
							$email          = $addr; 
							$diag->{Status} = $status; 
							
						}
					}
				}
			}
			
			$diag->{Guessed_MTA} = 'Qmail'; 
			$list = generic_body_parse_for_list($entity);
			return ($list, $email, $diag); 
		}else{ 
			# no body part to parse
			return (undef, undef, {});
		}
	}else{ 
		# I don't know!
		return (undef, undef, {});
	} 
}



sub parse_for_exim { 

my $entity = shift;	
	my ($email, $list); 
	my $diag = {}; 
	
	my @parts = $entity->parts;
	if(!@parts){ 
		if($entity->head->mime_type =~ /text/){ 
			# Yeah real hard. Bring it onnnn!
			if($entity->head->get('X-Failed-Recipients', 0)){ 
				$email = $entity->head->get('X-Failed-Recipients', 0);
				$email =~ s/\n//; 
				$email = trim($email); 
				
				$list  = generic_body_parse_for_list($entity);
				
				$diag->{Status}         = '5.x.y'; 
				$diag->{Guessed_MTA}    = 'Exim'; 
				return ($list, $email, $diag);
			}else{ 
				return (undef, undef, {});
			} 
			
		}else{ 
			return (undef, undef, {});
		}
	}else{ 
		# no body part to parse
		return (undef, undef, {});
	}	  
} 



sub remove_bounces { 

	
	my $report = shift; 
	foreach my $list(keys %$report){ 
		
		my $lh = MOJO::MailingList::Subscribers->new(-List => $list); 
		# removing them all at once 
		# optimization and it won't thrash a plain text list
		
 
		
		$lh->remove_from_list(-Email_List => [keys %{$report->{$list}}]);		# As a Fuck son, you sucked.
		
		
		# Bang Bang Baby, The Bigger The Better.
		# Bang Bang Baby, The Bigger The Better.
		# Bang Bang Baby, The Bigger The Better.
		# Bang Bang Baby, The Bigger The Better.
		# You aint a baby no more baby 
		# You aint no bigger than before baby 
		# I'll rub that cheap black off your lips baby 
		# so take a swallow as i spit baby 


	} 
}




sub test_script { 
	
	$verbose = 1; 
	
	my @files_to_test; 
	
	if($test eq 'pop3'){ 
		test_pop3(); 
	}elsif(-d $test){ 
		@files_to_test = dir_list($test); 
	}elsif(-f $test){ 
		push(@files_to_test, $test); 
	}
	
	my $i = 1; 
	foreach my $testfile(@files_to_test){ 
		print "test #$i: $testfile\n" . '-' x 60 . "\n"; 
		parse_bounce(-message => openfile($testfile)); 
		++$i; 
	} 
	exit; 

}




sub test_pop3 { 
	my $pop = Net::POP3->new($Server);
	my $messagecount = $pop->login($Username,$Password);
		
	if(($messagecount ne '') && ($messagecount >= 0)){ 
		print "POP3 Login succeeded.\n"; 
		print "Message count: $messagecount \n\n"; 
	}else{ 
		print "POP3 login failed.\n"; 
	} 
}




sub version { 

	#heh, subversion, wild. 
	print "$Bounce_Handler_Name Version: $App_Version\n"; 
	print "$PROGRAM_NAME Version: $VER\n\n"; 
	exit; 
	
} 



sub dir_list { 
	my $dir = shift; 
	my $file; 
	my @files; 
	opendir(DIR, $dir) or die "$!"; 
	while(defined($file = readdir DIR) ) { 
		next if        $file =~ /^\.\.?$/;
		$file =~ s(^.*/)();
		 if(-f $dir . '/' . $file ){  
			push(@files, $dir . '/' . $file);
		} 
	
	}
	closedir(DIR); 
	return @files; 
} 




sub openfile { 
	my $file = shift; 
	my $data = shift; 
	
	open(FILE, "<$file") or die "$!"; 
	{
		local $/ = undef;
		$data = <FILE>; 
	}
	close(FILE); 
	return $data; 
} 



sub open_log { 
	my $log = shift; 
	
	if($log){ 
		open(BOUNCELOG, ">>$log") or warn "Can't open bounce log! $!"; 	
		$Have_Log = 1; 
		return 1; 
	}
}




sub log_action { 

	my ($list, $email, $diagnostics, $action) = @_; 
	my $time = scalar(localtime());
	if($Have_Log){ 
		my $d; 
		foreach(keys %$diagnostics){ 
			$d .= $_ .': ' . $diagnostics->{$_} . ', ';
		}
		print BOUNCELOG "[$time]\t$list\t$action\t$email\t$d\n";
	} 
	
}




sub close_log{ 
	if($Have_Log){ 
		close(BOUNCELOG); 
	}
}




sub show_help { 
print q{ 

arguments: 
-----------------------------------------------------------
--help                 		
--verbose
--test ('bounces' | 'pop3'|filename | dirname)
--server           server
--username         username
--password         password
--log              filename
--version
-----------------------------------------------------------
for instructions, try:

pod2text ./mojo_bounce_handler.pl | less

-----------------------------------------------------------

};
	exit; 
} 




sub trim { 
my $string = shift || undef; 
	if($string){ 
		$string =~ s/^\s+//o;
		$string =~ s/\s+$//o;
		return $string;
	}else{ 
		return undef; 
	}
}


=pod

=head1 NAME

Mystery Girl - A Bounce Handler For Mojo Mail

=head1 DESCRIPTION

Mystery Girl intelligently handles bounces from Mojo Mail list messages. 
Each message is first B<parsed>. The parsed email will then be B<examined> 
and an B<action> will be taken. The examination and action are set in
a collection of B<rules>.  These rules can be tweaked, added, removed
and generally mucked about with. 

=head1 REQUIREMENTS

It's best to get all these requirements in order before you begin. 

=over

=item * Mojo Mail 2.8.5 or higher. 

=item * MIME::Tools

You'll need the MIME-tools collection of Perl Modules. You can grab it here: 

http://search.cpan.org/author/ERYQ/MIME-tools-5.411a/

Installation instructions should be included. 

=item * An Email Address and Mailbox

You need a free email address to use this bounce handler. The email
address needs to be used only for this bounce handler, nothing
else - NO exceptions. It wouldn't be pretty.

One address will work for all lists in a Mojo Mail installation

You need to be able to retreive email from this address using the POP3
protocol. The chances of that are pretty good. 

=item * Ability to set Cron Jobs. 

You need to be able to set scheduled tasks, or cron jobs to use the
bounce handler. If you don't know if you do have this feature available
you, ask your sys admin. 

=item * A Command Line

It really helps if you have ssh or telnet access to your hosting
account. Testing would be much easier. 

=back

=head1 Configuration

There's a few things you need to configure in this script, they're all
at the top. 

=over

=item * Change the lib path 

Since the bounce handler is going to be run via a command line, you
need to explicitly state where both your path to the regular Perl libs
are, and the Mojo Mail libraries are. For example: 


 use lib qw(
 /home/myaccount/www/cgi-bin/mojo
 /home/myaccount/www/cgi-bin/mojo/MOJO
 /home/myaccount/www/cgi-bin/mojo/MOJO/perllib
 
 
 /usr/local/lib/perl5/site_perl/5.8.0/mach
 /usr/local/lib/perl5/site_perl/5.8.0
 /usr/local/lib/perl5/site_perl
 /usr/local/lib/perl5/5.8.0/BSDPAN
 /usr/local/lib/perl5/5.8.0/mach
 /usr/local/lib/perl5/5.8.0
 ); 

If you don't know where your Perl library is, trying running this via
the command line: 

 perl -e 'print $_ ."\n" foreach @INC'; 


=item * POP3 server information. 

You need to change the B<$Server>, B<$Username> and B<$Password> variables
to reflect the permissions for the email address you're going to use
for the bounce handler. 

=back

As far as required changes, that's it. We'll get to interesting
optional things further down the line. 

=head1 Installation

=head2 Setting up the script.

The script itself is a command line tool. This is not a CGI script, do 
not even attempt to call it from a web browser. You'll receive an error, 
each time, I promise. This isn't an error in the script, it's an error
in the operator. 

As such, B<Do not> put this script in your cgi-bin. I would just make a
directory in your home directory and place the script that. If you've
set up Mojo Mail as outlined in the Magic Book, you may want to make
another directory in the .mojo_files directory, called .scripts, and 
install this script in there. 

chmod 755 mojo_bounce_handler.pl 

That's it as far as installation of the script. 

=head1 Running the script

Since this program is a command line tool, you execute it via a
command line. Again, this is not a CGI script. B<bold> I<Underlined>. 
Running the program without any arguments will 
have it check the mailbox for bounces, parse the messages and handle 
the bounces. ie: 

 prompt>./mojo_bounce_handler.pl

I suggest before you do that, you test the mojo_bounce_handler.pl. 

=head2 Testing

You can pass the B<--test> argument to mojo_bounce_handler.pl to make
sure everything is workings as it should. The B<--test> argument needs to 
take one of a few paramaters: 

=over

=item * pop3

 prompt>./mojo_bounce_handler.pl --test pop3

This will test only your POP3 login. If it's successful, it'll return 
the number of messages waiting: 

 prompt>./mojo_bounce_handler.pl --test pop3
 POP3 Login succeeded.
 Message count: 5 

If the login failed, you'll get back a message that reads: 

 prompt>./mojo_bounce_handler.pl --test pop3
 POP3 login failed.

=item * filename or directory

if you pass an argument that's a filename, mojo_bounce_handler.pl 
will attempt to parse that file as if it's a bounced message. If you
pass a directory as an argument, mojo_bounce_handler.pl will attempt
to parse all the files in that directory as if they were bounced 
messages. 

mojo_bounce_handler.pl won't act on these test messages, but will do
everything until that point. You'll get back a verbose message of the
going's on of the script: 
 
 prompt> perl mojo_bounce_handler.pl  --test message8.txt 
 test #1: message8.txt
 ------------------------------------------------------------
 ------------------------------------------------------------------------
 Content-type: multipart/report
 Effective-type: multipart/report
 Body-file: NONE
 Subject: Returned mail: see transcript for details
 Num-parts: 3
 --
     Content-type: text/plain
     Effective-type: text/plain
     Body-file: NONE
     --
     Content-type: message/delivery-status
     Effective-type: message/delivery-status
     Body-file: NONE
     --
     Content-type: message/rfc822
     Effective-type: message/rfc822
     Body-file: NONE
     Num-parts: 1
     --
         Content-type: text/plain
         Effective-type: text/plain
         Body-file: NONE
         Subject: Simoni Creative - Mojo Mail Mailing List Confirmation
         --
 ------------------------------------------------------------------------
 List: skazat_design_newsletter
 Email: de4est@centurytel.net    
 
 Last-Attempt-Date: Sun, 13 Apr 2003 20
 Action: failed
 Status: 5.1.1
 Diagnostic-Code: SMTP; 550 5.1.1 <de4est@centurytel.net>... User unknown
 Final-Recipient: RFC822; de4est@centurytel.net
 Remote-MTA: DNS; [209.142.136.158]
 
 Using Rule: default

The first chunk of output is a skeleton of the bounced message. If it looks 
similar to what's above, you most likely gave the bounce handler a real email
message. 

After that, will be listed the findings of the bounce handler. 
The List and Email address will be listed, followed by some diagnostic
code. 

The last thing printed out is the rule, and we'll get to that shortly. 

=item * bounces

Setting the test argument to B<bounces> will actually perform the
test on any live bounce email messages in the mailbox. 
You'll see similar output that you would if you were testing a file.

=back


=head1 Setting The Schedule 

You could run mojo_bounce_handler.pl every now and again from the
command line,  but you'd get very sick of it and I spent an entire
weekend in May to write this script to be lazy. 

To accomplish that, you want to set this script to execute via a con
or scheduled, job. Here's what a theoretical cron tab for this script
may look like: 

 0  1   *   *  * /usr/bin/perl /home/myaccount/mojo_scripts/mojo_bounce_handler.pl >/dev/null 2>&1
  
This will run the script every day around 1am. You can run this script
as often as you want, just be logical. I wouldn't run this script every five
minutes, that's a bit overkill.

Different hosts may have a control panel to set up crontabs, my host
gives me the pleasure of the B<contrab> command. I type in: 

 prompt> crontab -e

and am launched into my favorite text editor to type in the crontab.  

=head1 Telling Mojo Mail to use the Bounce Handler. 

You're going to know have to tell Mojo Mail explicitly that you want
bounces to go to the bounce handler. The first step is to set the 
B<Mojo List Administrator> to your bounce email. You set this in the
list control panel, under B<Change List Information>

Once you do that, you need to tell Mojo Mail that you want the correct
headers in your list messages to say, "use the admin address for bounces"

Usually, this means that the B<Return-path> header needs to be set. 
There are a few ways to accomplish this, some more preferable than others. 

=over

=item * Setup using SMTP (prefered)

If you're using SMTP sending, I almost guaruntee that this will work for you. 

In the list control panel, go to: B<Sending Options -> SMTP settings>
and check the box labeled: B<Set the Sender of SMTP mailings to the 
list administration email address> 

=item * Setup using the Sendmail Command

Your results will be mixed with this method, but it's worth a shot: 

=over

=item * Technique 1: The -f flag

In the list control panel, go to B<Sending Options -> Advanced> and 
check: B<Add the Sendmail '-f' flag when sending messages ...>

This I<should> set the sending to the admin email, and in turn, set the
B<Return-Path> header. 

=item * Technique 2: Return-Path header

If that doesn't work, you can try to set the B<Return-Path> header 
explicitly. Go to: B<Sending Options -> Advanced> and check: 
B<Print the 'Return-Path header in all list emails> This is generally
a very bad, and stupid idea to do, but I've had great luck with it
when the MTA is Qmail. I think Qmail allows you to do this. Go Qmail. 

=item * Technique 3: Errors-To header

The Errors-To header seems to have been created just for this task, but
it's actually a B<deprecated> header, so use with caution. For it to do
anything, you need to configure Sendmail to actually see the Errors-To 
header. I don't recommend using this header, but if all else fails, go
to: B<Sending Options -> Advanced> and check: 
B<Print the 'Errors-To' header in all list emails>

=back

To test out any of these configurations, Send yourself a test message
and view the source of the message itself, in your mail reader. In the
mail headers, you should see the B<Return-Path> header: 

 Return-Path: <mojobounce@myhost.com>
 Delivered-To: justin@myhost.com
 Received: (qmail 75721 invoked from network); 12 May 2003 04:50:01 -0000
 Received: from myhost.com (208.10.44.140)
   by hedwig.myhost.com with SMTP; 12 May 2003 04:50:01 -0000
 Date:Sun, 11 May 2003 23:50:01 -0500
 From:justin <justin@myhost.com>
 Subject:Test, Test, Test
 To:justin@myhost.com
 Sender:mojobounce@myhost.com
 Reply-To:justin <justin@myhost.com>
 Precedence:list
 Content-type:text/plain; charset=iso-8859-1

Notice that the first line has the B<Return-Path> header, correctly
putting my bounce email address. My List Owner address, 
justin@myhost.com still occupies the To: and Reply-To headers, so 
whoever replies to my message will reply to me, not the bounce handler.


Once you've dialed in your list to use the bounce handler, you should
be all set. 

=head1 Optional Fun Things

There's a slew of optional arguments you can give to this script: 

=over

=item * pop3 server params: --server --username --password

You can pass the POP3 server params to the script via these options. 
The arguments passed will writeover any set in the script. This comes
in handy if, say, you're not comfortable putting the POP3 password in
the script itself. You may be crafty and have the password saved in
a more secure location and created a wrapper script that then calls
this script - I'll leave that to your imagination. 

But anyways: 


 prompt>./mojo_bounce_handler \
  --server mail.myhost.com\
  --username mojobounce\
  --password secretgodmoney

 All three of these options are optional and you can use them with 
 any of the tests, discussed above. 

=item * --verbose

passing the --verbose parameter is like giving this script some 
coffee.  Similar to what you'd see if you ran the script using: 

 prompt>./mojo_bounce_handler --test bounces
 
But bounce handling will go through to completion. 

=item * --help

Obligory help text printed out. Written as geeky as possible. 

=item * --version

WIll print out both the version of Mystery Girl and also of Mojo Mail. 
Good for debugging. Looks like this: 

 Mystery Girl version: .7
 Mojo Mail version: 2.8.5


=item * --log

If you pass a filename to the script, it'll write a log of the action
it takes per email. A log entry looks much like this: 

 [Sun May 11 16:57:23 2003]      justin  unsubscribe_bounced_email from_list \
     fdsafsa890sadf89@hotmail.com     Status: 5.x.y, Action: ,

The format is: 

 time \t list \t action \t email \t diagnostics

If you don't want to pass the log each time, you can set a log in the
B<$Log> variable.

=item * --messages

I decided that it would be silly to run mojo_bounce_handler.pl by 
blindly trying to handle every bounced message that may be waiting
for it every time its run. Perhaps you have a list that created 1,000
bounces (not unheard of), rummaging through 1,000 messages may take time, 
so instead, I encourage you to set how many messages should be looked
at every time the script is run. 

I like to use this as a final test; I can test one real message towards
completion and make sure everything is OK. 

If you do want to handle, say 1000 messages at a day, I would suggest to
set the number of messages it handles to something like 100 and set your
cronjob to run 10 times, perhaps 15 minutes apart. Your call, though. 

=head2 Rules, Rule! 

mojo_bounce_handler.pl figures out what to do with the bounce messages
receives by consulting a group of rules. These rules are highly configurable, 
so if you need to change the behavior of this script, you don't have to 
change the code. 


These rules are stored in the B<$Rules> hashref. An example rule:

 {
 user_unknown => {
	 Examine => {
		Message_Fields => {
			Status => [qw(5.1.1 550 5.x.y)]
		},
		Data => { 
			Email => 'is_valid', 
			List  => 'is_valid',
		}
	},
	Action => { 
		unsubscribe_bounced_email => 'from_list', 
	},
}

B<user_unknown> is the title of the rule -  just a label, nothing else.

B<Examine> holds a set of parameters that the handler looks at when
trying to figure out what to do with a bounced message. This example
has a B<Message_Fields> entry and inside that, a B<Status> entry. The
B<Status> entry holds a list of status codes. The ones in shown there
all correspond to hard bounces; the mailbox probably doesn't exist. 
B<Examine> also holds a B<Data> entry, which holds the B<Email> or B<List> 
entries, or both. Their values are either 'is_valid', or 'is_invalid'. 

So, to sum this all up, this rule will match a message that has B<Status:> 
B<Message Field> contaning a user unknown error code, B<(5.1.1, etc). The message
also has to be parsed to have found a valid email and list name. 

Pretty Slick, eh? 

If this all matches, the B<Action> is... acted upon. In this case, the 
email will be unsubscribed from the list. We could tell the bounce handler
to unsubscribe the message from all the lists that Mojo Mail handles, since, hey, 
if the email address isn't valid anymore, why wait for your other lists to find out? 
Changing B<from_list>, to B<from_all_lists> will do the trick. 

I could change the line: 

 unsubscribe_bounced_email => 'from_list', 

to: 

 mail_list_owner => 'user_unknown_message'

This will, instead of deleting the email automatically, send a message 
to the list owner, stating that, "Hey, the message bounced, what do you
want to do?" 

Another example: 

 {
 over_quota => {
	 Examine => {
		Message_Fields => {
			Status => [qw(5.2.2)]
		},
		Data => { 
			Email => 'is_valid', 
			List  => 'is_valid',
		}
	},
	Action => { 
		mail_list_owner => 'over_quota_message', 
	},
 }                    

This time, I created a list for messages that get bounced because the
mailbox is full. This is still considered a hard bounce, but I don't
want the subscriber removed because they haven't check their inbox 
during the week. In this case, the B<Action> has been set to: 

 mail_list_owner => 'over_quota_message', 

Which will do what it sounds like, it'll mail the list owner a message
explaining the circumstances. 

Here's a schematic of all the different things you can do: 

 {
 rule_name => {
	 Examine => {
		Message_Fields => {
			Status               => qw([    ]), 
			Last-Attempt-Date    => qw([    ]), 
			Action               => qw([    ]), 
			Status               => qw([    ]), 
			Diagnostic-Code      => qw([    ]), 
			Final-Recipient      => qw([    ]), 
			Remote-MTA           => qw([    ]), 
			# etc, etc, etc
			
		},
		Data => { 
			Email => 'is_valid' | 'is_invalid' 
			List  => 'is_valid' | 'is_invalid' 
		}
	},
	Action => { 
			   mail_list_owner           => 'user_unknown_message', 
			   mail_list_owner           => 'email_not_found_message', 
			   mail_list_owner           => 'over_quota_message', 
			   unsubscribe_bounced_email => 'from_list' | 'from_all_lists',
	},
 },	

Mystery Girl also supports the use of regular expressions for matching any of the 
Message_Fields. To tell the parser that you're using a regular exspression, make the Message_Field key end in '_regex': 

 'Final-Recipient_regex' => [(qr/RFC822/)], 

Setting rules is sort of the super advanced part of the configuration,
but it may come in handy. 


=head1 FAQs

=over

=item * Does the bounce handler differentiate between "hard' bounces and 'soft' bounces?

Yes. Because of the Rules, you can set what happens, depending on what 
type of bounce you receive. By default, the bounce handler is set up to
automatically remove bounces because the email address is invalid, and
email you alerting you of a bounce if the bounce is because a email box
is full. 

You cannot say, "After x amount of bounces, just remove from the list." 
The reson behind this is the subscription database only holds the email
address and doesn't support any other fields. I'm working on that. 

=item * I keep getting, 'permission denied' errors, what's wrong?

It's very possible that Mystery Girl can't read your subscription database or the list settings database. This is because Mojo Mail may be running under the webserver's username, usually, B<nobody>, and not what Mystery Girl is running under, usually your account username. 

You'll need to do a few things: 

=over

=item * Change the permissions of the list subscription and settings databases

You'll most likely need to change the permissions of these files to, '777'. PlainText subscription databases have the format of B<listshortname.list> and are usually located where you set the B<$FILES> Config file variable. .List settings Databases have the format of B<mj-listshortname> and are usually located in the same location.

=item * Change the $FILE_CHMOD variable

So you don't need to change the permissions of the list files for every new list you create, set the $FILE_CMOD Config variable to 0777:
	
 $FILE_CHMOD = 0777; 

Notice there are no quotes around 0777. 

=back


=item * I found a bug in this program, what do I do? 

Report it to the bug tracker: 

http://sourceforge.net/tracker/?group_id=13002&atid=113002

=item * I keep getting this bounced message, but Mystery Girl isn't handling it, what do I do? 

You'll most likely have to make a new rule for it. If you want, attach a copy of the bounced message to the bug tracker: 

http://sourceforge.net/tracker/?group_id=13002&atid=113002

And we'll see if we can't get that kind of bounce in a new version.

=item * What's up with the name, Mystery Girl?

It's from a I<Yeah Yeah Yeahs> song: B<Mystery Girl>. A bounce handler
is sort of a mysterious tool, making decisions for you and a mysterious
girl just seems to be one full of power and allusion. The song itself 
is about rejecting a guy that just doesn't make it anymore, 
so that gives a good metaphor to  a bounced mail, in a slightly weird, 
nerdy, nerdy, nerdy... artsy way.   

When the bounce handler emails a list owner, you can do nothing but
answer back to it. Yeah Yeah Yeah. 

B<(colophon)> 

Actually, the lyrics I'm thinking of aren't from the song, Mystery Girl, but from the song, "Bang!" off of the YYY's self titled release. Mystery Girl
is the next song on that album.  The song after that is one called,
"Art Star", which is what I am in the daytime! The next song is 
called, "Miles Away", which is where you probably are to me. All this
in, "Our Time" (the last song) See? it's like this was all written in
the stars. 

http://yeahyeahyeahs.com

=back

=head1 History

=over

=item * .8 - 6/26/03

The new Exim and Qmail rules weren't really working. 

...


Why not? Well, Mystery Girl really didn't know about anything * but * the "Status" and "Action" Message Fields. Furthermore, I didn't follow my own scheme for the bounce rules and put Qmail and Exim as a scalar, not an array ref. 

So, now Mystery Girl knows about the Guessed_MTA message field, and should know about every other one as well. 

If you were having trouble having your own rules work, above is why. Everything should be patched up and fixed. The new code is actually half the size and works much better. Go... stuff!

Furthermore, I've changed the format of the rules, The Rules themselves are a array ref, instead of a hash ref, which means that the rules are tried in order. 

I've also added regular expression function to Examine, if you have a message field, say, Status, that you want to do a regular expression on, you can say this: 

 Status_regex => [(qr/^5(\.0\.0|\.1\.1)$/)], 

instead of: 

 Status => [qw(5.0.0 5.1.1)];

This version was introduced in Mojo Mail 2.8.8, it should work for any version of Mojo Mail from 2.8.5 on. 

=item * .7 - 6/5/03


Exim support has been added. 

Thanks to Tracy Gibson (sf: tntmom5) and Adam Henry hank _at_ marinar.com for the exim reports. 

I also added a separate rule for both qmail and Exim, since both
don't produce real status codes, just '5.x.y' or '4.x.y', you may, for some reason, 
treat these as special cases. 

I also added a new flag, B<--version>, so you can report just exactly 
what version you have of the proggy. 




=item * .6 - 5/22/03


Ok, I need sleep. Fixed a mispelling in a method call on guess what line? 
440? 

THAT is fixed. No even amusingly funny comments about 
how this script should work now. 


I<It is a common experience that a problem difficult at night is resolved in the  morning after a committee of sleep has worked on it. > 

- B<John Steinbeck> 


I also took the -w flag off, since it was creating some line noise i'll deal with
sooner than later. 

=item * .5 - 5/21/03

Fixed another stupid bug. (line 440) 

Script should work now

should 

work...

=item * .4 - 5/21/03

see that note in .2 that said it "should" work? Well, it didn't, 
since the change wasn't applied. Now it is. 

No for real. 


=item * .3 - 5/20/03 

Removed some list debug code. 
Fix fix from yesterday
( released with 2.8.6 as well) 

=item * .2 - 5/19/03

The script should work... now. 
Tweaked the rules a bit to be more lenient. 
Edited the docs a bit
First inclusion into main Mojo Mail distro ( 2.8.6 )

=item * .1 - 5/11/03

Initial Release .1

=back


=head1 To Do

Perhaps think about making filters specifically for Postfix. 
They seem to have their own way of doing things, like Qmail. 

Add onto that custom a filter for AOL/Compuserve/Netscape

=head1 Thanks

Thanks to: Jake Ortman Henry Hughes for some prelim bounce examples.

Thanks to Eryq ( http://www.zeegee.com ) for the amazing MIME-tools
collection. It's a gnarly group of modules. 

=head1 COPYRIGHT

Copyright (c) 1999 - 2003 Justin Simoni 
me@justinsimoni.com
http://justinsimoni.com 
All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Parts of this script were swiped from Mail::Bounce::Qmail module, fetched from here: 

http://mikoto.sapporo.iij.ad.jp/cgi-bin/cvsweb.cgi/fmlsrc/fml/lib/Mail/Bounce/Qmail.pm

The copyright of that code stated: 

Copyright (C) 2001,2002,2003 Ken'ichi Fukamachi
All rights reserved. This program is free software; you can
redistribute it and/or modify it under the same terms as Perl itself.

Thanks Ken'ichi

=cut
