package MOJO::Template::Widgets;

use lib qw(./ ../ ./mojo ../mojo ./MOJO ../MOJO); 

use MOJO::Config; 
use MOJO::App::Guts; 
use CGI; 
my $q = new CGI; 

require Exporter; 
@ISA    = qw(Exporter); 
@EXPORT = qw( 

list_popup_menu
list_popup_login_form
text_box_login_form

 );

use strict; 
use vars qw( @EXPORT );


=pod

=head1 Name

MOJO::Template::Widgets

=head1 Description

Holds commonly used HTML 'widgets'

=head1 Subroutines

=cut


=pod

=head2 list_popup_menu

returns a popup menu holding all the list names as labels and 
list shortnames as values

=cut

sub list_popup_menu { 
	my %args = (-show_hidden => 0,
				-name        => 'list',
			    @_); 
	my $labels = {}; 
	
	foreach my $list( available_lists() ){
		my %li = open_database(-List => $list);
		next if $args{-show_hidden} == 0 && $li{hide_list} eq '1'; 
		$labels->{$list} = $li{list_name};
	}
	my @opt_labels = sort { uc($labels->{$a}) cmp uc($labels->{$b}) } keys %$labels;
	
	
	return $q->popup_menu( -name    => $args{-name}, 
						  '-values' => [@opt_labels],
						   -labels   => $labels,
						   -style    => 'width:200px'); 
}

sub list_login_form { 
	my %args = (-list => undef, @_); 
	my $list = $args{-list}; 
	

	my $r = ''; 
	
	$r .= $q->start_form(-action => $S_MOJO_URL, -method => 'POST'); 
	$r .= qq{
		
		<h3>Enter Your List Control Panel</h3>
		<p>You will need to know your List Password to access your control panel.</p>
		 <table align="center" cellpadding="5"> 
		  <tr> 
		   <td> 
			&nbsp;
		   </td> 
		  <td> 
		   <p>Type in your  <strong>List Password</strong></p>
		  </td> 
		 </tr> 
		 <tr> 
		  <td> 
		   <p>&nbsp;
		   <input type="hidden" name="admin_list" value="$list" />
		 </p> 
		</td> 
		<td> 
		 <table> 
		  <tr> 
		   <td> 
			<p> 
			 <input type="password" name=admin_password size=8>
			 <input type=hidden name=flavor value="login">
			 <input type="hidden" name="process" value="true">
			</p> 
		   </td> 
		   <td> 
			<input type="submit" style='$STYLE{default_submit}' value="Login">
		   </td> 
		  </tr> 
		</table> 
		</td> 
		</tr>
		</table> 
		</p>
		</form> 
	
	};
	return $r; 




}
sub list_popup_login_form { 
	
	my $r = ''; 
	
	$r .= $q->start_form(-action => $S_MOJO_URL, -method => 'POST'); 
	$r .= qq{
		
		<h3>Enter Your List Control Panel</h3>
		<p>You will need to know your List Password to access your control panel.</p>
		 <table align="center" cellpadding="5"> 
		  <tr> 
		   <td> 
			<p><strong>Select</strong> your list:</p> 
		   </td> 
		  <td> 
		   <p>Type in your  <strong>List Password</strong></p>
		  </td> 
		 </tr> 
		 <tr> 
		  <td> 
		   <p>
		
		}; 
	
		$r .= list_popup_menu(-name   	   => 'admin_list', 
				   		      -show_hidden => 1);
		$r .= qq{ 
		 
		 </p> 
		</td> 
		<td> 
		 <table> 
		  <tr> 
		   <td> 
			<p> 
			 <input type="password" name=admin_password size=8>
			 <input type=hidden name=flavor value="login">
			 <input type="hidden" name="process" value="true">
			</p> 
		   </td> 
		   <td> 
			<input type="submit" style='$STYLE{default_submit}' value="Login">
		   </td> 
		  </tr> 
		</table> 
		</td> 
		</tr>
		</table> 
		</p>
		</form> 
	
	};
	return $r; 

}




sub text_box_login_form { 

	my $r = '';
	

	$r .= $q->start_form(-action => $S_MOJO_URL, -method => 'POST'); 
	$r .= qq{
	
	<h3>Enter Your List Control Panel</h3>
	<p>You will need to know your List Shortname and List Password to access your control panel.</p>
	 <table align="center" cellpadding="5"> 
	  <tr> 
	   <td> 
		<p>Type in your <br /><strong>List Shortname:</strong></p> 
	   </td> 
	  <td> 
	   <p>Type in your  <br /><strong>List Password:</strong></p>
	  </td> 
	 </tr> 
	 <tr> 
	  <td> 
	   <p>
		<input type="text" name=admin_list size=8>
	 </p> 
	</td> 
	<td> 
	 <table> 
	  <tr> 
	   <td> 
		<p> 
		 <input type="password" name=admin_password size=8>
		 <input type=hidden name=flavor value="login">
		 <input type="hidden" name="process" value="true">
		</p> 
	   </td> 
	   <td> 
		<input type="submit" style='$STYLE{default_submit}' value="Login">
	   </td> 
	  </tr> 
	</table> 
	</td> 
	</tr>
	</table> 
	</p>
	</form> 
	};



	return $r; 
	

}












1;




=pod

=head1 COPYRIGHT

Copyright (c) 1999 - 2003 Justin Simoni 
me@justinsimoni.com
http://justinsimoni.com 
All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=cut
