package MOJO::MailingList::Subscribers;

use lib qw(./ ../ ../../ ../../MOJO ../../perllib);

use MOJO::Config; 

if (eval "require MOJO::MailingList::Subscribers::$DB_TYPE") {
	use base "MOJO::MailingList::Subscribers::$DB_TYPE";
	return 1;
}else{ 
	die("cannot find 'MOJO::MailingList::Subscribers::$DB_TYPE', $!");
}

=pod

=head1 NAME

MOJO::MailingList::Subscribers

This module inherites everything from a Child Module, via @ISA, shared methods
should be placed in here.




=head1 Methods


=over

=item subscription_check

	my ($status, $errors) =  $lh->subscription_check(-Email => $email); 

returns a $status (1 or 0) and a hashref of %$errors. If there are any 
errors, the $status will be 0, it's a nice shorthand though. 


=cut





sub subscription_check { 
	require MOJO::App::Guts; 
	my $self = shift; 
	my %args = (-Email => undef, @_);	
	my $email = $args{-Email};
	my $list  = $self->{fields}->{-List}; 
	my %errors = ();
	my $status = 1; 
		
	
	$errors{no_list} = 1 if MOJO::App::Guts::check_if_list_exists(-List=>$list,)     == 0;
				
	return (0, \%errors) if $errors{no_list} == 1;
	
	my %list_info = MOJO::App::Guts::open_database(-List=>$list);
		
	$errors{invalid_email} = 1 if MOJO::App::Guts::check_for_valid_email($email)           == 1;
	$errors{subscribed}    = 1 if $self->check_for_double_email(-Email => $email)     == 1; 
	$errors{closed_list}   = 1 if $list_info{closed_list}                             == 1; 
	
	if(($errors{invalid_email} != 1) && ($list_info{mx_check} == 1)){ 
		require Email::Valid;
		eval {
			unless(Email::Valid->address(-address => $email,
										 -mxcheck => 1)) {
				$errors{mx_lookup_failed}   = 1;
			};
		warn "mx check error: $@" if $@;
  		}; 
	}

	
	if($list_info{black_list} eq "1"){
		$errors{blacklisted} = 1 if $self->check_for_double_email(-Email => $email, 
																  -Type  => "black_list")  == 1; 
	}
	
	
	foreach(keys %errors){ 
		$status = 0 if $errors{$_} == 1;
		last;
	}
	
	return ($status, \%errors); 
	

}


=pod

=item subscription_check_xml

	my ($xml, $status, $errors) =  $lh->subscription_check_xml(-Email => $email); 

Same as B<subscription_check> but also returns an XML document describing the same 
thing.

=cut


sub subscription_check_xml { 

	my $self = shift; 
	my %args = @_; 
	my ($status, $errors) = $self->subscription_check(%args); 
	my $xml; 
	
	$xml .= '<subscription>';
	$xml .= '<email>'.$args{-Email}.'</email>'; 
	$xml .= '<status>'.$status.'</status>';
	$xml .= '<errors>'; 
	foreach(keys %$errors){ 
		$xml .= '<error>'. $_ . '</error>'; 
	}
	$xml .= '</errors>'; 
	$xml .= '</subscription>'; 
	return ($xml, $status, $errors); 
}

sub write_plaintext_list { 
	
	require MOJO::App::Guts; 
	
	my $self = shift; 
	my %args = (-Type => 'list', 
	            @_); 
	
	my $type     = $args{-Type};
	my $path     = $TMP; 
	my $tmp_id   = MOJO::App::Guts::message_id();
	my $ln       = $self->{fields}->{-List}; 
	my $tmp_file = $path . '/' . $ln . '.' . $type . '.' . $tmp_id; 
	
	open(TMP_LIST, ">$tmp_file") or die $!;		  
		$self->print_out_list(-Type => $args{-Type}, 
							  -FH   => \*TMP_LIST);
	close(TMP_LIST); 
	return $tmp_file;

}

1;

__END__

=pod

=head1 SEE ALSO

MOJO::MailingList::Subscribers::Subscribers::PlainText

=cut

