package MOJO::MailingList::Settings::Db; 
use strict; 

use lib qw(./ ../ ../../ ../../../ ./../../MOJO ../../perllib); 

use AnyDBM_File; 
use Fcntl qw(
O_WRONLY 
O_TRUNC 
O_CREAT 
O_CREAT 
O_RDWR
O_RDONLY
LOCK_EX
LOCK_SH 
LOCK_NB); 
use Carp; 


use MOJO::Config; 
use MOJO::App::Guts;  # For now, my dear. 


sub new {
	my $class = shift;
	my %args = (-List => undef,
				-new_list => 0,  
					@_); 
	   my $self = {};			     
       bless $self, $class;
       $self->{new_list} = $args{-new_list};
	   $self->_init(\%args); 
	   return $self;
}




sub _init  { 
    my ($self, $args) = @_; 
    if($self->{new_list} != 1){ 
    	croak('BAD List name "' . $args->{-List} . '" ' . $!) if $self->_list_name_check($args->{-List}) == 0; 
	}else{ 
		$self->{name} = $args->{-List}; 
	}
}




sub _list_name_check { 
	my ($self, $n) = @_; 
		$n = $self->_trim($n);
	return 0 if !$n; 
	return 0 if $self->_list_exists($n) == 0;  
	$self->{name} = $n;
	return 1; 
}




sub _list_exists { 
	my ($self, $n)  = @_; 
	return MOJO::App::Guts::check_if_list_exists(-List => $n);
} 





sub _trim { 
	my ($self, $s) = @_;
	return MOJO::App::Guts::strip($s);
}




sub _safe_path { 
	my ($self, $p) = @_; 
	return MOJO::App::Guts::make_safer($p);

}




sub _open_db { 
	my $self = shift; 
	tie %{$self->{DB_HASH}}, "AnyDBM_File", $self->_db_filename,  O_RDWR|O_CREAT, $FILE_CHMOD  or die 'couldn\'t tie '. $self->_db_filename . ' for reading: ' .$!; 
}




sub _raw_db_hash { 
	my $self = shift; 
	$self->_lock_db;	
	$self->_open_db; 
	my %RAW_DB_HASH = %{$self->{DB_HASH}};
	$self->{RAW_DB_HASH} = {%RAW_DB_HASH};
	$self->_close_db;
	$self->_unlock_db; 	
}




sub _db_filename { 
	my $self = shift;
	my $fn = $self->{name}; 	
	   $fn =~ s/ /_/g; 
	   $fn = $FILES . '/mj-' . $self->{name};  
	   #untaint 
	   $fn = $self->_safe_path($fn); 
	   $fn =~ /(.*)/; 
	   $fn = $1;
	   return $fn;
}




sub _close_db { 
	my $self = shift; 
	untie %{$self->{DB_HASH}};
}




sub _format_settings { 
	# I don't like this at all. 
	
	my ($self, $ls) = @_; 
	  for($ls->{subscribed_message},
		  $ls->{unsubscribed_message},
		  $ls->{confirmation_message},
		  $ls->{mailing_list_message},
		  $ls->{not_allowed_to_post_message},
		  $ls->{html_confirmation_message},
		  $ls->{html_unsub_confirmation_message},
		  $ls->{html_subscribed_message},
		  $ls->{html_unsubscribed_message},
		  $ls->{unsub_confirmation_message}
		  ){ 
			$_ =~ s/\[list_name\]/$ls->{list_name}/g;
			$_ =~ s/\[list_info\]/$ls->{info}/g;
			$_ =~ s/\[list_privacy_policy\]/$ls->{private_policy}/g;
			$_ =~ s/\[list_owner_email\]/$ls->{mojo_email}/g;
			$_ =~ s/\[list_admin_email\]/$ls->{admin_email}/g; 
			$_ =~ s/\[mojo_url\]/$MOJO_URL/g; 
		}
	return $ls;
}




sub _munge_for_Config_Vars { 
	my ($self, $li) = @_; 
	
	$li->{subscribed_message}              ||=   $SUBSCRIBED_MESSAGE; 
	$li->{unsubscribed_message}            ||=   $UNSUBSCRIBED_MESSAGE; 
	$li->{confirmation_message}            ||=   $CONFIRMATION_MESSAGE;
	$li->{unsub_confirmation_message}      ||=   $UNSUB_CONFIRMATION_MESSAGE;
	$li->{mailing_list_message}            ||=   $MAILlING_LIST_MESSAGE;
	$li->{mailing_list_message_html}       ||=   $MAILlING_LIST_MESSAGE_HTML;
	$li->{not_allowed_to_post_message}     ||=   $NOT_ALLOWED_TO_POST_MESSAGE; 
	$li->{html_confirmation_message}       ||=   $HTML_CONFIRMATION_MESSAGE;
	$li->{html_unsub_confirmation_message} ||=   $HTML_UNSUB_CONFIRMATION_MESSAGE;
	$li->{html_subscribed_message}         ||=   $HTML_SUBSCRIBED_MESSAGE;
	$li->{html_unsubscribed_message}       ||=   $HTML_UNSUBSCRIBED_MESSAGE;
	$li->{send_archive_message}            ||=   $SEND_ARCHIVED_MESSAGE;
	$li->{send_archive_message_html}       ||=   $HTML_SEND_ARCHIVED_MESSAGE;
	$li->{invite_message_text}             ||=   $TEXT_INVITE_MESSAGE;
	$li->{invite_message_html}             ||=   $HTML_INVITE_MESSAGE;	
	# i guess this is here because it goes well with the above 2
	$li->{invite_message_subject}	       ||= $li->{list_name} . ' Invitation';
			
	return $li; 
}





sub _munge_charset { 
	my ($self, $li) = @_; 
	my $charset_info = $li->{charset};
	my @labeled_charsets = split(/\s/, $charset_info); 
	return $labeled_charsets[$#labeled_charsets];      

}




sub get { 
	my $self = shift; 
	my %args = (-Format => "raw", @_); 

	$self->_raw_db_hash;
	
	my $ls                   = $self->{RAW_DB_HASH}; 
	  
	  	
	  
	   $ls                   = $self->_munge_for_Config_Vars($ls); 
	   $ls->{charset_value}  = $self->_munge_charset($ls);
	   $ls->{admin_email}  ||= $ls->{mojo_email}; 
	
	if(!exists($ls->{list_name})){ 
		$ls->{list_name} = $ls->{list}; 
		$ls->{list_name} =~ s/_/ /g;
	}
	
	
	%$ls = (%LIST_SETUP_DEFAULTS, %$ls);		
	%$ls = (%$ls, %LIST_SETUP_OVERRIDES);
		
	$ls  = $self->_format_settings($ls) if $args{-Format} eq "replaced";
	return $ls; 
}





sub save { 
 	my ($self, $new_settings) = @_;
	my $fault = 1;	
	if($new_settings){ 
 		$self->_open_db; 
		my %RAW_DB_HASH = %{$self->{DB_HASH}};
		my %merge_info  = (%RAW_DB_HASH, %$new_settings); 
		
		%{$self->{DB_HASH}} = %merge_info; 
		
		unless(defined($self->{DB_HASH}->{admin_menu})){ 
			require MOJO::Template::Widgets::Admin_Menu; 
			$self->{DB_HASH}->{admin_menu} = MOJO::Template::Widgets::Admin_Menu::create_save_set();
		}
		unless(defined($self->{DB_HASH}->{cipher_key})){ 
			require MOJO::Security::Password; 
			$self->{DB_HASH}->{cipher_key} = MOJO::Security::Password::make_cipher_key();
		}
		
		$self->_close_db; 
		return 1; 
     }
     return 1;
} 




sub _lock_db { 
	my $self = shift; 
	sysopen(DB_SAFETYLOCK, $self->_lockfile_name,  O_RDWR|O_CREAT, $FILE_CHMOD) 
		or die "Mojo Mail $VER Error - Cannot open list lock file " . $self->_lockfile_name . " - $!";
		{
			my $sleep_count = 0; 
			{ 
				flock DB_SAFETYLOCK, LOCK_EX | LOCK_NB and last; 
				sleep 1;
				redo if ++$sleep_count < 11; 		
				die "Mojo Mail $VER Warning: Server is way too busy to open list db file," . $self->_lockfile_name . " -   $!\n";
		}
	}
}




sub _unlock_db { 
	my $self = shift; 
	close(DB_SAFETYLOCK);
	unlink($self->_lockfile_name) or warn "couldn't delete lock file: '$TMP/".$self->{name}."_settingsdb.lock' - $!";
}




sub _lockfile_name { 
	my $self = shift;
	my $fn =  $self->_safe_path("$TMP/".$self->{name}."_settingsdb.lock");	
	$fn =~ /(.*)/;
	$fn = $1; 
	return $fn; 
} 







1;