package MOJO::MailingList::Schedules::MLDb; 
use strict; 

use lib qw( ../../ ../../../ ../../../MOJO ../../perllib); 

use Fcntl qw(
O_WRONLY 
O_TRUNC 
O_CREAT 
O_CREAT 
O_RDWR
O_RDONLY
LOCK_EX
LOCK_SH 
LOCK_NB);

use MLDBM qw(AnyDBM_File Storable);

use MOJO::Config; 
use MOJO::App::Guts;  # For now, my dear. 




sub new {
	my $class = shift;
	my %args = (-List => undef,
					@_); 
	   my $self = {};			     
       bless $self, $class;
	   $self->_init(\%args); 
	   return $self;
}



sub _init  { 
    my ($self, $args) = @_; 
    
    	die ('BAD List name "' . $args->{-List} . '" ') if $self->_list_name_check($args->{-List}) == 0; 
		#$self->{DB_HASH} = {};
		$self->{name} = $args->{-List}; 
			
		$self->_lock_db;	
		$self->_open_db;
}





sub _list_name_check { 
	my ($self, $n) = @_; 
		$n = $self->_trim($n);
	return 0 if !$n; 
	return 0 if $self->_list_exists($n) == 0;  
	$self->{name} = $n;
	return 1; 
}




sub _list_exists { 
	my ($self, $n)  = @_; 
	return MOJO::App::Guts::check_if_list_exists(-List => $n);
} 





sub _trim { 
	my ($self, $s) = @_;
	return MOJO::App::Guts::strip($s);
}




sub _safe_path { 
	my ($self, $p) = @_; 
	return MOJO::App::Guts::make_safer($p);

}




sub _open_db { 
	my $self = shift; 
	my $dbm = tie %{$self->{DB_HASH}}, 'MLDBM',  $self->_db_filename, O_CREAT|O_RDWR, $FILE_CHMOD or die 'couldn\'t tie '. $self->_db_filename . ' for reading: ' .$!; 
    
}




sub _close_db { 
	my $self = shift; 
	untie %{$self->{DB_HASH}};
}



sub _db_filename { 
	my $self = shift;
	my $fn = $self->{name}; 	
	   $fn =~ s/ /_/g; 
	   $fn = $FILES . '/mj-' . $self->{name} . '-schedules';  
	  #$fn = $FILES . '/test';
	   #untaint 
	   $fn = $self->_safe_path($fn); 
	   $fn =~ /(.*)/; 
	   $fn = $1;
	   return $fn;
}




sub _lock_db { 
	my $self = shift; 
	sysopen(DB_SCHEDULE_SAFETYLOCK, $self->_lockfile_name,  O_RDWR|O_CREAT, $FILE_CHMOD) 
		or die "Mojo Mail $VER Error - Cannot open list lock file " . $self->_lockfile_name . " - $!";
		{
			my $sleep_count = 0; 
			{ 
				flock DB_SCHEDULE_SAFETYLOCK, LOCK_EX | LOCK_NB and last; 
				sleep 1;
				redo if ++$sleep_count < 11; 		
				die "Mojo Mail $VER Warning: Server is way too busy to open list schedule db file," . $self->_lockfile_name . " -   $!\n";
		}
	}
}




sub save_record { 
	my $self = shift; 
	
	my %args = (-key  => undef, 
				-mode => 'append', 
				-data => {},
				@_,
			   ); 
			   
	my $key = $args{-key}; 
	$key = $self->new_key if ! $key; 		   
	
	if($args{-mode} eq 'append'){ 
		if(exists $self->{DB_HASH}->{$key}){ 
			my $tmp = $self->{DB_HASH}->{$key};
			%$tmp = (%$tmp, %{$args{-data}}); 
			$self->{DB_HASH}->{$key} = $tmp; 
		}else{ 
			$self->{DB_HASH}->{$key} = $args{-data}; 
		}
	}else{ 
		$self->{DB_HASH}->{$key} = $args{-data}; 
	}
	
	return $key; 
	

} 




sub get_record { 

	my $self = shift; 
	my $key   = shift;
	return $self->{DB_HASH}->{$key};

} 




sub record_keys { 
	my $self = shift; 
	return sort {$a <=> $b} keys %{$self->{DB_HASH}}; 
	
} 


sub remove_record { 
	my $self = shift; 
	my $key  = shift;
	$self->{DB_HASH}->{$key} = undef, 
	delete($self->{DB_HASH}->{$key}); 
} 


sub new_key { 
	my $self = shift; 
	return time; 
}



sub _unlock_db { 
	my $self = shift; 
	if(-e $self->_lockfile_name){
		close(DB_SCHEDULE_SAFETYLOCK);
		unlink($self->_lockfile_name) or warn "couldn't delete lock file: '" .$self->_lockfile_name ."' - $!";
	}
}




sub _lockfile_name { 
	my $self = shift;
	my $fn =  $self->_safe_path("$TMP/".$self->{name}."_schedulesdb.lock");	
	$fn =~ /(.*)/;
	$fn = $1; 
	return $fn; 
} 



sub DESTROY { 
	my $self = shift; 
	   $self->_close_db; 
	   $self->_unlock_db; 
}




1; 
