package MOJO::MailingList::Schedules; 
use strict; 

use lib qw(./ ../ ../../ ../../MOJO ../perllib); 

use MOJO::Config;
use MOJO::App::Guts; 
use MOJO::MailingList::Settings;
use base "MOJO::MailingList::Schedules::MLDb";





sub run_schedules { 
	my $self = shift; 
	
	my %args = (-test    => undef, 
				-verbose => undef,
					       @_); 
	
	my $r = ''; 
				
	my $time        = time;
	
	$r .= "\n" . '-' x 72 . "\nRunning Schedule For: " . $self->{name} . "\n";
	$r .=  "Current time is: " . $self->printable_date($time) . "\n";

	my @record_keys = $self->record_keys(); 
	

		$r .=  "    No schedules to run.\n" if ( !@record_keys);
	foreach my $rec_key(@record_keys){																#for all our schedules - 
		
		my $mail_status = {};
		my $checksums   = {};
			
		my $mailing_schedule  = $self->mailing_schedule($rec_key);
		my $rec               = $self->get_record($rec_key); 
		my $run_this_schedule = 0;	
		$r .=  "\n    Examining Schedule: '" . $rec->{message_name} . "'\n";
		
		if($rec->{active} ==1){													 							#first things first, is this schedule even active?
		
			$r .=  "    '" . $rec->{message_name} . "' is active -  \n";
			
			$rec->{last_schedule_run} = $time if ! $rec->{last_schedule_run};								# This must be your first time, don't be nervous; tee hee!
			
			$r .=  "        Schedule last checked:     " .   $self->printable_date($rec->{last_schedule_run}) . "\n";
			
			if($mailing_schedule->[0]){ 
				$r .=  "        Next mailing should be on: " . $self->printable_date($mailing_schedule->[0]) . "\n";
			}
			CHECKSCHEDULE: foreach my $s_time(@$mailing_schedule){
				
				if(($s_time <= $time) && ($s_time > $rec->{last_schedule_run})){								# Nothing in the future, mind.		
																			   		   							# Nothing before we need to. 
						$r .=  "            '" . $rec->{message_name} . "' scheduled to run now! \n";
						$run_this_schedule = 1;
						last CHECKSCHEDULE; 															# run only the last schedule, lest we bombard a hapless list. 						 
				}
			}
		}else{ 
			$r .=  "        '" . $rec->{message_name} . "' is inactive. \n";
		}
		
		if($run_this_schedule == 1){ 
			if($args{-test} == 1){ 		
				($mail_status, $checksums) = $self->send_scheduled_mailing(
																		   -key   => $rec_key, 
																		   -test  => 1, 
																		   -hold  => 1,
																		  ); 								
			}else{ 				
				 ($mail_status, $checksums) = $self->send_scheduled_mailing(
																			-key  => $rec_key, 
																			-test => $rec->{only_send_to_list_owner},
																			-hold => 1, 
																			); 
				if(! keys %$mail_status){ 
					$rec->{last_mailing} = $time;																# remember we sent the message at this time;  						
				}
			}			
		}
		
		
		
		if(! $args{-test}){ 
		     $rec->{active}            = 0 if ! $mailing_schedule->[0];
		 	 $rec->{last_schedule_run} = $time;		
		 	 
			 if(keys %$checksums){ 
			 		$rec->{PlainText_ver}->{checksum} = $checksums->{PlainText_checksum};
			 		$rec->{HTML_ver}->{checksum}      = $checksums->{HTML_checksum};			 	
			 }	
			
			$self->save_record(-key => $rec_key, -data => $rec, -mode => 'append');											# save the changes we've made to the record.			
		
			$rec = $self->get_record($rec_key); 
			
		} 
	
		if(keys %$mail_status){
			$r .=  "\n            ***    Scheduled Mailing Not Sent, Reason(s):    ***\n";
			$r .=   '                - ' .  MOJO::App::Guts::pretty($_) . "\n" foreach keys %$mail_status;
			$r .=  "\n";
			
		}
	}
	
	 
	
	
	
	$r .= '-' x 72 . "\n";
	
	$self->send_held_messages; 
	
	return $r; 
	
	
}




sub send_held_messages { 

	my $self = shift; 
	foreach my $held(@{$self->{held_mailings}}){ 
		my $obj     = $held->{-obj}; 
		my $message = $held->{-message}; 
		$obj->bulk_send(%$message); 
	}


} 





sub send_scheduled_mailing { 
	
	my $self = shift; 
	
	my %args = (-key  => undef, 
				-test => 0,
				-hold => 0,  
				@_); 
				
	die "no key!" if ! $args{-key}; 
	
	my ($send_flags, $checksums, $message) = $self->build_email(-key => $args{-key});
	
	
	if(! keys %$send_flags){ 
	
		my $ls = MOJO::MailingList::Settings->new(-List => $self->{name}); 

		my $list_info = $ls->get(); 
		
		require MOJO::Mail::Send; 

		my $mh = MOJO::Mail::Send->new($list_info); 		   
		   $mh->bulk_test(1) if $args{-test} == 1;    
		   
		   if($args{-hold} == 1){ 
		   		push(@{$self->{held_mailings}}, {-obj => $mh, -message => $message}); 
		   }else{ 
		   		$mh->bulk_send(%$message);
	   	   }
	}   
	   return ($send_flags, $checksums); 
	   
}





sub build_email { 

	my $self = shift; 
	my %args = (-key => undef, 
				@_); 
				
	die "no key!" if ! $args{-key}; 				

	my $record = $self->get_record($args{-key});
	
	require MIME::Lite; 
	
	my $send_flags = {}; 
	
	
	my ($pt_flags,   $pt_checksum,   $pt_headers,   $PlainText_ver) = $self->create_text_ver(-record => $record, -type => 'PlainText'); 
	my ($html_flags, $html_checksum, $html_headers, $HTML_ver)      = $self->create_text_ver(-record => $record, -type => 'HTML'); 
	
	
	$send_flags->{PlainText_ver_undefined}  = 1 if (! $PlainText_ver)	&&	($record->{PlainText_ver}->{only_send_if_defined}) == 1;
	$send_flags->{HTML_ver_undefined}       = 1 if (! $HTML_ver)	    &&	($record->{HTML_ver}->{only_send_if_defined})      == 1;
	
	
	%$send_flags = (%$send_flags, %$pt_flags, %$html_flags); 
	
	my $msg; 
	
	
	if($PlainText_ver && $HTML_ver){ 
		$msg = MIME::Lite->new(Type => 'multipart/alternative');

	}elsif($PlainText_ver){ 

	}elsif($HTML_ver){ 

	}else{ 
		$msg = MIME::Lite->new(Type    =>'multipart/mixed'); 
	}
					
	if($PlainText_ver && $HTML_ver){ 
		$msg->attach(
					  Type => 'text/plain', 
					  Data => $PlainText_ver, 
					); 
				$msg->attach(
				 Type => 'text/html', 
				 Data => $HTML_ver,
				 );  
				      	
					
	}elsif($PlainText_ver){ 
		$msg = MIME::Lite->new(
					  Type => 'text/plain', 
					  Data => $PlainText_ver, 
					);  	
					
	}elsif($HTML_ver){ 
		$msg = MIME::Lite->new(
					 Type => 'text/html', 
					 Data => $HTML_ver,
				     );  
	}

	foreach my $att(@{$record->{attachments}}){ 
		$msg->attach(
					 Type        => $self->find_mime_type($att), 
					 Path        => $att->{attachment_filename}, 
					 Disposition => $att->{attachment_disposition}
					); 
	} 
	
	
	$msg->replace('X-Mailer' =>"");
	    
	
	my $ls = MOJO::MailingList::Settings->new(-List => $self->{name}); 
	
	my $list_info = $ls->get(); 
	
	require MOJO::Mail::Send; 
	my $mh = MOJO::Mail::Send->new($list_info); 
	my %headers = $mh->return_headers($msg->header_as_string());	
	
	
	$pt_headers->{foo} = 'bar'; 
	$html_headers->{foo} = 'bar'; 
	
	my $return = {};
	
	   $return = { 
	   			  %headers, 
	             
	              To        =>  '"'. MOJO::App::Guts::escape_for_sending($list_info->{list_name}) .'" <'. $list_info->{mojo_email} .'>', 
			      Subject   =>  $record->{message_subject},       		
			     
			      %$pt_headers, 
			      %$html_headers, 
			      
			      Body      => $msg->body_as_string,
			   }; 
			  
	return ($send_flags, {PlainText_checksum => $pt_checksum, HTML_checksum => $html_checksum}, $return); 
}




sub create_text_ver { 
	my $self = shift; 
	
	my %args = (-record => {},
				-type   => undef,  
				@_); 
	die "no record! $!"		unless keys %{$args{-record}}; 
	die "no type!   $!"		unless $args{-type}; 	

	my $record  = $args{-record}; 
	my $type    = $args{-type};
	my $headers = {};
	my $data = undef;
	
	my $create_flags = {}; 
	 
	
	if($record->{$type . '_ver'}->{source} eq 'from_file'){ 
		$data = $self->from_file($record->{$type . '_ver'}->{file});
	}elsif($record->{$type . '_ver'}->{source} eq 'from_url'){ 
		$data = $self->from_url($record->{$type . '_ver'}->{url}); 
	}elsif($record->{$type . '_ver'}->{source} eq 'from_text'){ 
		$data = $record->{$type . '_ver'}->{text}; 
	}
	
	if($data){ 
		
		my $we_gotta_virgin = $self->virgin_check($record->{$type . '_ver'}->{checksum}, \$data); 
		
		my $checksum = $self->create_checksum(\$data);
		
		unless($we_gotta_virgin){  #mmmm, virgin...
			if($record->{$type . '_ver'}->{only_send_if_diff} == 1){ # mmmm different...
				$create_flags->{$type . '_ver_same_as_last_mailing'} = 1; 
			}
		} 
		
		$data = MOJO::App::Guts::strip($data); 
		if($record->{$type . '_ver'}->{use_email_template} == 1){ 
			$data = $self->apply_template(-type => $args{-type}, -data => $data,); 	
		}
		$data = $self->parse_in_list_info(-type => $args{-type}, -data => $data, );
	
		($headers, $data) = $self->grab_headers($data) if $record->{$type . '_ver'}->{grab_headers_from_message} == 1;
		 
		 #$headers->{foo} = 'bar'; 
		 
		return ($create_flags, $checksum, $headers, $data); 
	
	}else{  
		return ({},{}, undef), 	
	}	
	
}




sub  from_file { 

	my $self = shift; 
	my $fn   = shift; 	
	die "no filename!" if ! $fn; 
	
	my $data = undef; 
	
	open(FH, "<$fn") or return undef; 	
	{ 
		local $/ = undef; 
		$data = <FH>
	}	
	close(FH); 
	return $data; 
}




sub from_url { 

	my $self = shift; 
	my $url  = shift; 
	die "no url! $!" if ! $url; 
	
	my $data = undef; 
	require LWP::Simple; 
	$data = LWP::Simple::get($url); 
	
	return $data; 
	
}




sub apply_template { 
	my $self = shift; 
	my %args = (-data => undef, 
				-type => undef, 
				@_); 

	die "no data! $!" if ! $args{-data}; 
	die "no type! $!" if ! $args{-type}; 

	my $data = $args{-data}; 
	
	my $ls = MOJO::MailingList::Settings->new(-List => $self->{name}); 
	my $list_info = $ls->get(); 

	my $new_data; 
	
	if($args{-type} eq 'PlainText'){ 
		$new_data = $list_info->{mailing_list_message};
	}else{ 
		$new_data = $list_info->{mailing_list_message_html};
	}
	
	$new_data =~ s/\[message_body\]/$data/g;
	
	return $new_data; 
	
}




sub parse_in_list_info { 

	my $self = shift; 
	my %args = (-data => undef, 
				-type => undef, 
					@_); 
 
 	die "no data! $!" if ! $args{-data}; 
 	die "no type! $!" if ! $args{-type}; 
 	
 	my $data = $args{-data}; 
 	
 	my $ls = MOJO::MailingList::Settings->new(-List => $self->{name}); 
	my $list_info = $ls->get();
	
 	$data = MOJO::App::Guts::interpolate_string(-String      => $data, 
								                -List_Db_Ref => $list_info);
	
	my $s_link = MOJO::App::Guts::subscribe_link(-list   => $self->{name},
							                     -email  => '[email]', 
							                     -pin    => '[pin]');
	
	my $us_link = MOJO::App::Guts::unsubscribe_link(-list   => $self->{name},
							                        -email  => '[email]', 
						 	                        -pin    => '[pin]');

	$data =~ s/\[plain_list_subscribe_link\]/$s_link/g;	
	$data =~ s/\[plain_list_unsubscribe_link\]/$us_link/g;
	
	if($args{-type} eq 'HTML'){ 
		my $s_link  =  "<a href=\"$s_link\">$s_link</a>";
		my $us_link =  "<a href=\"$us_link\">$us_link</a>";

	}
	
	$data =~ s/\[list_subscribe_link\]/$s_link/g;	
	$data =~ s/\[list_unsubscribe_link\]/$us_link/g;

	return $data; 

}





sub create_checksum { 

	my $self = shift; 
	my $data = shift; 

	use Digest::MD5 qw(md5_hex); # Reminder: Ship with Digest::Perl::MD5....
	
	if($] >= 5.008){
		require Encode;
		my $cs = md5_hex(Encode::encode_utf8($$data));
		return $cs;
	}else{ 			
		my $cs = md5_hex($$data);
		return $cs;
	}
} 




sub virgin_check { 

	my $self = shift; 
	my $cs   = shift; 
	
	my $data_ref = shift;
	
	
	my $cmp_cs = $self->create_checksum($data_ref);

	#	warn 'comparing: ' . $cmp_cs . ' with: ' . $cs; 
	
	return 1 if ! $cs; 
	(($cmp_cs eq $cs) ? (return 0) : (return 1)); 
	
}




sub grab_headers { 

	my $self = shift; 
	my $data = shift; 
	
	$data =~ m/(.*?)\n\n(.*)/s; 
	
	my $headers = $1; 
	my $body    = $2;
	
	#init a new %hash
	my %headers;
	
	# split.. logically
	my @logical_lines = split /\n(?!\s)/, $headers;
	 
		# make the hash
		foreach my $line(@logical_lines) {
			  my ($label, $value) = split(/:\s*/, $line, 2);
			  $headers{$label} = $value;
			}
	
	return (\%headers, $body); 
}




sub find_mime_type { 
	my $self = shift; 
	my $att  = shift; 
	
	die "no attachment! $! " if ! $att; 
		
	my $mime_type = 'AUTO'; 
	
	if ($att->{attachment_mimetype} =~ m/auto/){ 
		my $file_ending = $att->{attachment_filename};
		
		require MIME::Types; 
		require MIME::Type;
	
		if(($MIME::Types::VERSION >= 1.005) && ($MIME::Type::VERSION >= 1.005)){ 
			$file_ending =~ s/^\.//; 
			my $mimetypes = MIME::Types->new;
			my MIME::Type $attachment_type  = $mimetypes->mimeTypeOf($file_ending);
			$mime_type = $attachment_type;
		}else{ 
			# Alright, we're going to have to figure this one ourselves...
			if(exists($MIME_TYPES{'.'.lc($file_ending)})) {  
				$mime_type = $MIME_TYPES{'.'.lc($file_ending)};
			}else{ 
				# Drat! all hope is lost! Abandom ship!
				$mime_type = $DEFAULT_MIME_TYPE; 
			}
		}
	}else{ 
		$mime_type = $att->{attachment_mimetype};
	}		

	$mime_type = 'AUTO' if(! $mime_type); 
	
	return $mime_type; 
}




sub mailing_schedule { 
	my $self = shift; 
	my $key = shift; 
	my $today_is = time; 
	
	die "no key $!" if ! $key;
	 
	my $r             = $self->get_record($key); 
	my $sched_mailing = $r->{mailing_date}; 
	
	if($r->{repeat_mailing} != 1){ 		
		return [$r->{mailing_date}] if $r->{mailing_date} > $r->{last_schedule_run};  # not right now, when we last try to run the schdule.
		return []; 
	}else{ 
		return [$r->{mailing_date}] if $r->{repeat_times} < 1;
		
		my $timespan = 0; 		   
		   $timespan = 60                 if $r->{repeat_label}  eq 'minutes'; 	
		   $timespan = 60 * 60            if $r->{repeat_label}  eq 'hours'; 
		   $timespan = 60 * 60 * 24       if $r->{repeat_label}  eq 'days';
		   $timespan = 60 * 60 * 24 * 30  if $r->{repeat_label}  eq 'months';		   
		   $timespan = 60 * 60 * 24 * 265 if $r->{repeat_label}  eq 'years';	
		   
		if($r->{repeat_times}){ 
			$timespan = ($timespan * $r->{repeat_times});
		}
		
		my $i = 0; 		   
		my @mailing_times;# = ($r->{mailing_date}); 
		   @mailing_times   =  ($r->{mailing_date}) if $r->{mailing_date} > $r->{last_schedule_run}; 
		
		$r->{repeat_number}     = 1000      if $r->{repeat_number} eq 'indefinite';  
		
		
		$r->{last_schedule_run} = $today_is if ! $r->{last_schedule_run};
		$r->{repeat_number}     = 0         if ! $r->{repeat_number};
		   
		if($r->{repeat_number} eq 'indefinite'){
			# yeah, we *could* find each and every time a mailing should
			# go out, until... inifinity, but come now. 
			# This will just find the next time a mailing should go out. 
			
			my $i = 1; 
			while($i == 1){ 
				$sched_mailing = ($sched_mailing + $timespan); 
				if($sched_mailing > $r->{last_schedule_run}){ 
					push(@mailing_times, $sched_mailing); 
					$i = 0;
				}
			}	
					
		}else{
			for($i = 0; $i <= $r->{repeat_number}; $i++){ 
				$sched_mailing = ($sched_mailing + $timespan); 		   		
				push(@mailing_times, $sched_mailing) if $sched_mailing > $r->{last_schedule_run};  	
			}
		}
		
		return \@mailing_times; 
	}
} 




sub printable_date { 
	
	my $self = shift; 
	my $date = shift; 
	
	my %mail_month_values = (
	0  => 'January', 
	1  => 'February', 
	2  => 'March', 
	3  => 'April', 
	4  => 'May', 
	5  => 'June',
	6  => 'July', 
	7  => 'August', 
	8  => 'September', 
	9  => 'October', 
	10 => 'November', 
	11 => 'December', 
	); 
	
	
	
	my %mail_day_values = (
	
	1  => '1st', 
	2  => '2nd', 
	3  => '3rd', 
	4  => '4th', 
	5  => '5th',
	6  => '6th', 
	7  => '7th', 
	8  => '8th', 
	9  => '9th', 
	10 => '10th', 
	11 => '11th',
	12 => '12th', 
	13 => '13th', 
	14 => '14th', 
	15 => '15th', 
	16 => '16th', 
	17 => '17th', 
	18 => '18th', 
	19 => '19th', 
	20 => '20th', 
	21 => '21st', 
	22 => '22nd', 
	23 => '23rd', 
	24 => '24th', 
	25 => '25th', 
	26 => '26th', 
	27 => '27th', 
	28 => '28th', 
	29 => '29th', 
	30 => '30th', 
	31 => '31st',
	); 
	
	my %mail_minute_values = (
	0 => '00',
	1 => '01', 
	2 => '02',
	3 => '03',
	4 => '04',
	5 => '05',
	6 => '06',
	7 => '07',
	8 => '08',
	9 => '09',
	); 


	
	
		#  0    1    2     3     4    5     6     7     8
	my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($date);
		
	my $ending = 'am'; 
	
	if($hour > 12){ 
		$hour -= 12; 
		$ending = 'pm';
	}
	
	$min = '0' . $min if $min < 10; 
	$hour = 12 if $hour == 0; 
	return $mail_month_values{$mon} . ' ' . $mail_day_values{$mday} . ' ' . ($year + 1900) . ' - ' . $hour . ':' . $min . ' '. $ending; 


} 





1;