#!/usr/bin/perl 




use strict; 



=pod

=head1 NAME simple_multiple_subscribe.cgi

=head1 DESCRIPTION

Allow people to subscribe to more than one list at once


This is a complete (but bare bones) example on how to create a form with a 
bunch of checkboxes that will allow people to subscribe to more than one 
list at a time. Upload multiple_subscribe.cgi to your mojo directory and
chmod 755 it. 


=head2 @lists


change what's in @lists to reflect what lists you want people to subscribe to, 
Example, if I wanted people to have a choice of subscribing to 'The Justin List' 
and 'The Dan List', I would put inside the array:

                my @lists = ('The Justin List', 'The Dan List'); 

=cut

my @lists = ('foo', 'bar', 'batz'); 

=head2 use lib

look for the needed Mojo Libraries, we're assuming that you're putting 
in the same directory as the mojo.cgi script itself, if not you'll need 
change the below to reflect where the mojo directory is 
example: use lib '/usr/home/justin/public_html/cgi-bin/mojo'; 

=cut

use lib './'; 

# load in the CGI.pm library for shortcuts 
use CGI qw(:standard html3); 

# load in the Guts of Mojo for the dirty work
use MOJO::App::Guts; 
use MOJO::MailingList::Subscribers;

# create a new CGI object
my $input = CGI -> new(); 

# retrieve some variables from the form
my $email           = $input -> param('email'); 
my $process         = $input -> param('process'); 
my @subscribe_lists = $input -> param('list');


unless($process){ 

# create the initial form
print header(); 
print h1("sign up to my lists!"), 
      hr(), 
      start_form(-action => 'multiple_subscribe.cgi', -method => 'POST'), 
      
      p('Choose what lists you want to subscribe to:', br(), 
      checkbox_group(-name      => 'list', 
       				 -values    => \@lists, 
       				 -linebreak =>'true',
       				 )), 
      
      p('Your email address:', br(), 
      textfield(-name=> 'email')),
      hidden(-name => 'process', -value => 'true'), 
      p(submit('signup!')), 
      endform();   


}else{ 

	my $verify_address = check_for_valid_email($email); 
	# check_for_valid_email() will check to see if $email is really
	# a valid email address It'll return 0 if its valid, 1 if its invalid. 
	if($verify_address == 0){ 
	#If we have a valid email address...	
	foreach(@subscribe_lists ){ 
		next if (check_if_list_exists(-List => $_) == 0);
		my $mojo_list = $_;
		# replace this with the real name of your list 
		my $lh = MOJO::MailingList::Subscribers->new(-List=>$mojo_list); 
		my $dbl_check  = $lh->check_for_double_email(-List=>$mojo_list, 
		                      		                 -Email => $email);
		# check to see if the address is already in the list
		# returns 0 if its isn't 1 if it is
		if($dbl_check < 1){ 
		    	# if its not in the list already... 
		        $lh->add_to_email_list(-List => $mojo_list, 
		                               -Email_Ref => [$email]);  
		        # add it to the list
		} 
	} 
}
    # tell them they did a super job!
	print header(); 
	print h1("Thank You!"), 
	      hr(), 
	      p('Thanks for subscribing to my lists!');  




}

=pod

=head1 COPYRIGHT 

Copyright (c) 1999 - 2003 Justin Simoni 
me@justinsimoni.com
http://justinsimoni.com 
All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


=cut
